# ns-mash.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/sim/hm/ns-mash.tcl,v 1.5 2002/02/03 04:16:36 lim Exp $

proc gettimeofday args {
	global ns
	return [$ns now]
}

proc random args {
	return [ns-random $args]
}

proc after args {
	global ns
	set t [lindex $args 0]
	if { $t == "cancel" } {
		$ns cancel [lindex $args 1]
		return 0
	} else {
		set now [$ns now]
		return [$ns at [expr $now+$t/1000.] [lindex $args 1]]
	}
}

Class MashSimulator -superclass Simulator

MashSimulator instproc session { spec delay } {
	$self instvar sessions_
	if ![info exists sessions_($spec)] {
		set sessions_($spec) [new NsSession $delay]
	}
	return $sessions_($spec)
}

Class NsSession

NsSession instproc init { delay } {
	$self next

	$self instvar delay_ members_
	set delay_ $delay
	set members_ ""
}

NsSession instproc join { mgr } {
	$self instvar members_
	lappend members_ $mgr
}

NsSession instproc leave { mgr } {
	$self instvar members_
	set i [lsearch -exact $members_ $mgr]
	set members_ [lreplace $members_ $i $i]
}

NsSession instproc send { caller msg } {
	$self instvar delay_
	after $delay_ "$self dosend $caller {$msg}"
}

NsSession instproc dosend { from msg } {
	$self instvar members_
	set i [lsearch -exact $members_ $from]
	set tlist [lreplace $members_ $i $i]
	foreach m $tlist {
		$m recv $from $msg [string length {$msg}]
	}
}

Class CoordBus
CoordBus instproc send msg {
}

CoordBus instproc init { chan } {
}

#FIXME
Class CoordBus/MBP -superclass CoordBus

set uniqpid 0

Class Process
Process instproc init args {
	$self instvar host_ pid_
	set host_ [lindex $args 0]
	global uniqpid
	set pid_ $uniqpid
	incr uniqpid
	eval $self next [lrange $args 1 end]
#$self log "spawn $pid_@$host_"
}
