/*
 * color-gray.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1994-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/render/color-gray.cc,v 1.11 2002/02/03 04:15:14 lim Exp $";
#endif

#include <stdlib.h>
#include <stdio.h>
#ifndef _WIN32
#   include <X11/Xlib.h>
#   include <X11/Xutil.h>
#endif /* _WIN32 */
#include "renderer-window.h"
#include "color-pseudo.h"
#include "bsd-endian.h"
#include "vw.h"

class GrayColorModel : public ColorModel {
public:
	~GrayColorModel();
};

class GrayColorClass : public TclClass {
public:
	GrayColorClass() : TclClass("Colormodel/PseudoColor/8/Gray") {}
	TclObject* create(int /* argc */, const char*const* /* argv */) {
		return (new GrayColorModel());
	}
} matcher_gray;

GrayColorModel::~GrayColorModel()
{
	/*FIXME*/
}

class GrayWindowRenderer;

typedef void (GrayWindowRenderer::*GrayMethod)(const u_char*, u_int,
					       u_int, u_int, u_int) const;

class GrayWindowRenderer : public PseudoWindowRenderer {
public:
	GrayWindowRenderer(VideoWindow* vw, int decimation,
			   int heuristics, const u_short* graylut) :
		PseudoWindowRenderer(vw, decimation, heuristics, graylut) { }
	void render(const u_char* frm, int off, int x, int w, int h) {
		(this->*method_)(frm, off, x, w, h);
	}
protected:
	virtual void update();
	virtual void disable() {method_ = &PseudoWindowRenderer::dither_null; }
	GrayMethod method_;
};

static class GrayRendererClass : public TclClass {
public:
	GrayRendererClass() : TclClass("Renderer/PseudoColor/8/Gray") {}
	TclObject* create(int argc, const char*const* argv) {
		if (argc != 8)
			abort();
		GrayColorModel* cm = (GrayColorModel*)
			TclObject::lookup(argv[4]);
		VideoWindow* vw = VideoWindow::lookup(argv[5]);
		int decimation = atoi(argv[6]);
		int heuristics = atoi(argv[7]);
		return (new GrayWindowRenderer(vw, decimation, heuristics, cm->graylut()));
	}
} grayrenderer_class;

void GrayWindowRenderer::update()
{
	if (scale_ > 0)
		method_ = &GrayWindowRenderer::dither_gray_down;
	else if (scale_ < 0)
		method_ = &GrayWindowRenderer::dither_gray_up;
	else
		method_ = &GrayWindowRenderer::dither_gray;
}
