/*
 * mplug.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MASH_MPLUG_H
#define MASH_MPLUG_H

#include "cc-api/np-plugin.h"
#include "rpi.h"
#include "mplug-config.h"


class MPlugInstance : public PluginInstance {
public:
	MPlugInstance(NPMIMEType mimeType, NPP instance, uint16 mode,
		      int16 argc, const char *const *argn,
		      const char *const *argv);
	virtual ~MPlugInstance();

	long SendData(int32 offset, int32 len, void *buffer);
	NPError StreamDone(NPError reason);

protected:
	uint16 mode() { return mode_; }
	NPBool NotifyReconfigure(uint32 width, uint32 height);

	virtual NPError NewWindow(NPWindow *npWindow);
	virtual NPError ReconfigureWindow(NPWindow *npWindow);
	virtual NPError DeleteWindow() = 0;
	virtual const char *GetDisplay(NPWindow *npWindow) = 0;
	virtual unsigned long GetWindowHandle() = 0;

private:
	PluginStream* CreateStream(NPMIMEType type, NPStream *stream,
				   NPBool seekable, uint16 *stype);

	NPError SetWindow(NPWindow* window);
	NPBool  NewProcess(NPWindow *npWindow);
	NPBool  NotifyStreamData(int32 len, void *buffer);
	NPBool  NotifyURL(const char *url);

	RPI rpi_;
	char *mimeType_;
	uint16 mode_;
	int16 argc_;
	char **argn_;
	char **argv_;
	char *url_;
	char *data_;
	int32 dataLen_;  /* negative dataLen_ implies I've finished receiving
			  * all the data */

	static MPlugConfiguration *GetConfig() {
		if (!config_) config_ = new MPlugConfiguration();
		return config_;
	}

	static MPlugConfiguration *config_;
	friend class PluginInstance;
};


class MPlugStream : public PluginStream {
public:
	MPlugStream(MPlugInstance *plugin, NPStream *stream)
		: PluginStream(stream), plugin_(plugin) { }
	~MPlugStream() { }

	virtual long Write(int32 offset, int32 len, void *buffer)
	{ return plugin_->SendData(offset, len, buffer); }
	virtual NPError Destroy(NPError reason)
	{ return plugin_->StreamDone(reason); }

private:
	MPlugInstance *plugin_;
};



inline PluginStream*
MPlugInstance::CreateStream(NPMIMEType /*type*/, NPStream *stream,
			    NPBool /*seekable*/, uint16 * /*stype*/)
{
	MPlugStream *mplugStream = new MPlugStream(this, stream);
	if (mplugStream) {
		NotifyURL(stream->url);
	}
	return mplugStream;
}



#if defined(XP_UNIX)

#include "unix/mplug-unix.h"
#define MPLUG_INSTANCE_CLASS UnixMPlugInstance

#elif defined(XP_WIN)

#include "win32/mplug-win32.h"
#define MPLUG_INSTANCE_CLASS Win32MPlugInstance

#endif


#endif /* MASH_MPLUG_H */

