/*
 * mtrace.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/misc/mtrace.cc,v 1.15 2002/02/03 04:11:42 lim Exp $
 */

#include "mtrace.h"


#ifdef MTRACE
#include <stdio.h>

#ifndef WIN32
#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <unistd.h>
#endif

MTraceObject *mtrace=NULL;


static class MTraceObjectClass : public TclClass {
public:
	MTraceObjectClass() : TclClass("MTrace") { }
	TclObject *create(int /*argc*/, const char*const* /*argv*/) {
		if (mtrace!=NULL) return mtrace;
		else {
			mtrace = new MTraceObject;
			return mtrace;
		}
	}
} mtraceObjectClass;


int
MTraceObject::command(int argc, const char *const* argv)
{
	// set_flag is_set reset_flag
	Tcl &tcl = Tcl::instance();

        if (!strcmp(argv[1], "trace")) {
                MTrace_t flag= (MTrace_t)strtoul(argv[2], NULL, 10);
                if (IsSet(flag)) {
                        fprintf(stderr, argv[3]);
                        fprintf(stderr, "\n");
                }
                return TCL_OK;
        } else if (argc==3) {
		// set_flag, is_set, reset_flag

		// the arg is 0xfoo where foo is a hex number
		u_int32_t flag;
		int nConverted = sscanf(argv[2] + 2, "%x", &flag);
		if (nConverted==0) {
			tcl.resultf("Illegal flag specified for MTrace::%s",
				    argv[1]);
			return TCL_ERROR;
		}
		if (strcmp(argv[1], "set_flag")==0) {
			SetFlag(flag);
			return TCL_OK;
		} else if (strcmp(argv[1], "reset_flag")==0) {
			ResetFlag(flag);
			return TCL_OK;
		} else if (strcmp(argv[1], "is_set")==0) {
			tcl.resultf("%d", IsSet(flag));
			return TCL_OK;
		}
	}

	return TclObject::command(argc, argv);
}

void
MTraceObject::Print(const char *fmt, ...)
{
	va_list ap=NULL;
	va_start(ap,fmt);
	vfprintf(stderr, fmt, ap);
}

MLogObject::MLogObject(uid_t uid) : logfile_(NULL)
{

#ifndef MAXNAMELEN
#ifndef MAXHOSTNAMELEN
        const int cMaxNL = 256;
#else  //!MAXHOSTNAMELEN
        const int cMAXNL = MAXHOSTNAMELEN;
#endif //!MAXHOSTNAMELEN
#else  // !MAXNAMELEN
        const int cMAXNL = MAXNAMELEN;
#endif // !MAXNAMELEN

        char szLFN[cMAXNL+25];
        char szHost[cMAXNL];
        int ret=gethostname(szHost, cMAXNL);
        char* pDot = strchr(szHost, '.');
        if (pDot!=NULL) *pDot='\0';
        if (ret==-1) {
                fprintf(stderr, "cannot get hostname");
                abort();
        }
        if (uid==0) {
                uid = getuid();
        }
#ifndef WIN32
        sprintf(szLFN, "/tmp/%s-%lx.log", szHost, (unsigned long)uid);
#else
        char *szTmpDir = getenv("TMP");
        if (!szTmpDir) szTmpDir = getenv("TEMP");
        if (!szTmpDir) szTmpDir = ".";
        sprintf(szLFN, "%s\\%s-%lx.log", getenv("TMP"), szHost,
		(unsigned long)uid);
#endif
        openLog(szLFN);
}

void
MLogObject::openLog(const char* szLFN) {
        if (logfile_) {
                closeLog();
        }
        logfile_ = fopen(szLFN, "w+"); // note the truncation
        if (!logfile_) {
                fprintf(stderr, "cannot open logfile:%s", szLFN);
                abort();
        }
}

void
MLogObject::print(const char* fmt, ...)
{
	if (logfile_==NULL) return;
        timeval tp;
        gettimeofday(&tp, NULL);
        fprintf(logfile_, "%4ld %6ld ", (long) tp.tv_sec % 10000,
		(long) tp.tv_usec);
        va_list ap=NULL;
        va_start(ap, fmt);
        vfprintf(logfile_, fmt, ap);
        fprintf(logfile_, "\n");
        fflush(logfile_);        // want it to be stable
}


#endif
