/*
 * mosaic.cc --
 *
 *      A Mosaic effect
 *
 * Copyright (c) 1993-2001 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* @(#) $Header: /usr/mash/src/repository/mash/mash-1/fx/effects/mosaic.cc,v 1.1 2002/02/07 04:18:19 chema Exp $ */


#include <dvmbasic.h>
#include <dvmbytegeom.h>


#include "mosaic.h"



MosaicEffect::MosaicEffect(int decimation) 
	: EffectModule(3, decimation)
{
	size0_.value = 0.4;
	size1_.value = 0.4;
	xpos0_.value = 0.05;
	xpos1_.value = 0.55;
	ypos0_.value = 0.3;
	ypos1_.value = 0.3;

	return;
}



int MosaicEffect::command(int argc, const char*const* argv)
{
	return (EffectModule::command(argc, argv));
}



void MosaicEffect::trigger_effect (Uncompressed* input)
{
	// step 1: output = input
	output_->byte_copy(input);

	// step 2: output = shrinked(buffer[0])
	ByteImage *buf0_l = buffer_[0]->lum_;
	ByteImage *buf0_cr = buffer_[0]->cr_;
	ByteImage *buf0_cb = buffer_[0]->cb_;
	ByteImage *out_l = output_->lum_;
	ByteImage *out_cr = output_->cr_;
	ByteImage *out_cb = output_->cb_;
	float bw = buffer_[0]->w_;
	float bh = buffer_[0]->h_;
	// luma affine transformation constants
	float la = size0_.value;
	float lb = 0.0;
	float lc = bw * xpos0_.value;
	float ld = 0.0;
	float le = size0_.value;
	float lf = bh * ypos0_.value;
	// chroma affine transformation constants
	float ca = (la * buffer_[0]->css_h_) / output_->css_h_;
	float cb = lb;
	float cc = lc / output_->css_h_;
	float cd = ld;
	float ce = (le * buffer_[0]->css_v_) / output_->css_v_;
	float cf = lf / output_->css_v_;
	ByteAffine (buf0_l, out_l, la, lb, lc, ld, le, lf);
	ByteAffine (buf0_cr, out_cr, ca, cb, cc, cd, ce, cf);
	ByteAffine (buf0_cb, out_cb, ca, cb, cc, cd, ce, cf);

	// step 3: output = shrinked(buffer1)
	ByteImage *buf1_l = buffer_[1]->lum_;
	ByteImage *buf1_cr = buffer_[1]->cr_;
	ByteImage *buf1_cb = buffer_[1]->cb_;
	bw = buffer_[1]->w_;
	bh = buffer_[1]->h_;
	// luma affine transformation constants
	la = size1_.value;
	lb = 0.0;
	lc = bw * xpos1_.value;
	ld = 0.0;
	le = size1_.value;
	lf = bh * ypos1_.value;
	// chroma affine transformation constants
	ca = (la * buffer_[1]->css_h_) / output_->css_h_;
	cb = lb;
	cc = lc / output_->css_h_;
	cd = ld;
	ce = (le * buffer_[1]->css_v_) / output_->css_v_;
	cf = lf / output_->css_v_;
	ByteAffine (buf1_l, out_l, la, lb, lc, ld, le, lf);
	ByteAffine (buf1_cr, out_cr, ca, cb, cc, cd, ce, cf);
	ByteAffine (buf1_cb, out_cb, ca, cb, cc, cd, ce, cf);

	// deliver the frame to the next system
	deliver_frame();
	return;
}

