/*
 * decoder-lpc.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1995-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/audio/decoder-lpc.cc,v 1.7 2002/02/03 03:10:46 lim Exp $";

#include "decoder.h"
#include "controller.h"
extern "C" {
#include "lpc.h"
}
#include "pktbuf.h"

class LPCDecoder : public PCM_Decoder {
    public:
	LPCDecoder();
	virtual void recv(pktbuf*);
    private:
	lpcstate_t rstate_;
};

static class LPCDecoderClass : public TclClass {
    public:
	LPCDecoderClass() : TclClass("Module/AudioDecoder/LPC") {}
	TclObject* create(int /* argc */, const char*const* /* argv */) {
		return (new LPCDecoder);
	};
} lpc_decoder_class;

LPCDecoder::LPCDecoder()
{
	memset(&rstate_, 0, sizeof(rstate_));
}

void LPCDecoder::recv(pktbuf* pb)
{
	const struct rtphdr* rh = (rtphdr*)pb->dp;
	const u_int8_t* frame = (u_int8_t*)(rh + 1);
	int len = pb->len - sizeof(*rh);
	if (active()) {
		if (len >= LPCRECSIZE && len <= int(8*LPCRECSIZE)) {
			u_char wrkbuf[AUDIO_FRAMESIZE*8];
			u_char* wp = wrkbuf;
			int outlen = 0;
			for (const u_char* ep = frame + len; frame < ep;
			     wp += framesize_, frame += LPCRECSIZE) {
				NTOHS(((lpcparams_t *)frame)->period);
				lpc_synthesize(wp, (lpcparams_t*)frame, &rstate_);
				outlen += framesize_;
			}
			consume_samples(rh, wrkbuf, outlen);
		}
	}
	pb->release();
}
