/*
 * audio-oss-stereo.cc --
 *
 *      Stereo audio driver for OSS.  A hack used only by qm.
 *
 * Copyright (c) 1991-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Full Duplex audio module for the new sound driver and full duplex
 * cards. Luigi Rizzo, from original sources supplied by Amancio Hasty.
 *
 * This includes some enhancements:
 * - limit the maximum size of the playout queue to approx 4 frames;
 *   this is necessary if the write channel is slower than expected;
 *   the fix is based on two new ioctls, AIOGCAP and AIONWRITE,
 *   but the code should compile with the old driver as well.
 * - use whatever format is available from the card (included split
 *   format e.g. for the sb16);
 */

#ifdef __FreeBSD__
    /* included for __FreeBSD_version */
#   include <sys/param.h>
#   if (__FreeBSD_version >= 400000)
#       include <sys/soundcard.h>
#   else
#       include <machine/soundcard.h>
#   endif
#else
#   include <sys/soundcard.h>
#endif

#include <fcntl.h>
#include "audio-oss.h"
#include "mulaw.h"
#include "Tcl.h"

#define ULAW_ZERO 0x7f

class OSSStereoAudio : public OSSAudio {
    public:
	OSSStereoAudio();
	virtual void Obtain();
};

static class OSSStereoAudioClass : public TclClass {
public:
        OSSStereoAudioClass() : TclClass("Audio/OSSStereo") {}
        TclObject* create(int, const char*const*) {
	    return (new OSSStereoAudio);

        }
} oss_audio_class;

OSSStereoAudio::OSSStereoAudio() : OSSAudio()
{
}

void
OSSStereoAudio::Obtain()
{
  // this obtains it in mono mode
  OSSAudio::Obtain();

  // FIXME - is it ok to make it stereo after we have notified observers?

  int result;
  int i = 1;
  result = ioctl(fd_, SNDCTL_DSP_STEREO, &i);
  if(i != 1)
  {
    printf("OSSStereoAudio::Obtain: error: sndctl_dsp_stereo set i to %d\n", i);
  }
  if(result == -1)
  {
    printf("OSSStereoAudio::Obtain: error setting dsp_stereo\n");
  }
/*
  else
  {
    printf("OSSStereoAudio::Obtain: successfully set dsp_stereo\n");
  }
*/

//  printf("ossStereoAudio::obtain() done\n");
}

