/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * @test
 * @summary Verify that throwException() can throw an exception
 * @library /testlibrary
 * @modules java.base/jdk.internal.misc
 *          java.management
 * @run main ThrowException
 */

import jdk.test.lib.*;
import jdk.internal.misc.Unsafe;
import static jdk.test.lib.Asserts.*;

public class ThrowException {
    public static void main(String args[]) throws Exception {
        Unsafe unsafe = Utils.getUnsafe();
        try {
            unsafe.throwException(new TestException());
        } catch (Throwable t) {
            if (t instanceof TestException) {
                return;
            }
            throw t;
        }
        throw new RuntimeException("Did not throw expected TestException");
    }
    static class TestException extends Exception {}
}
