
#line 1 "hb-ot-shape-complex-indic-machine.rl"
/*
 * Copyright © 2011,2012  Google, Inc.
 *
 *  This is part of HarfBuzz, a text shaping library.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE COPYRIGHT HOLDER HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * THE COPYRIGHT HOLDER SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE COPYRIGHT HOLDER HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * Google Author(s): Behdad Esfahbod
 */

#ifndef HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH
#define HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH

#include "hb-private.hh"


#line 36 "hb-ot-shape-complex-indic-machine.hh"
static const unsigned char _indic_syllable_machine_trans_keys[] = {
        8u, 8u, 1u, 16u, 8u, 13u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u,
        7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 4u, 8u,
        6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u,
        4u, 8u, 6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u,
        4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 8u, 8u, 1u, 16u, 8u, 13u,
        5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u,
        7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u,
        6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u,
        4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u,
        4u, 14u, 4u, 14u, 8u, 8u, 1u, 16u, 8u, 13u, 5u, 8u, 5u, 7u, 7u, 7u,
        5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u,
        7u, 7u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u,
        6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u,
        4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 8u, 8u, 1u, 16u,
        8u, 13u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u,
        5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 4u, 8u, 6u, 6u, 16u, 16u,
        4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u,
        16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u,
        4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 5u, 8u, 4u, 14u, 4u, 14u, 5u, 8u,
        5u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u, 5u, 7u, 7u, 7u, 5u, 8u,
        5u, 7u, 7u, 7u, 8u, 8u, 1u, 16u, 8u, 13u, 4u, 8u, 6u, 6u, 16u, 16u,
        4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u, 16u, 16u, 4u, 8u, 6u, 6u,
        16u, 16u, 8u, 8u, 1u, 18u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u,
        3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u,
        3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 5u, 14u, 5u, 14u,
        5u, 10u, 9u, 10u, 9u, 9u, 9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 3u, 13u,
        3u, 10u, 5u, 10u, 3u, 10u, 3u, 13u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u,
        3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u,
        5u, 14u, 3u, 14u, 1u, 16u, 4u, 14u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u,
        1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u,
        1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u,
        1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u,
        3u, 17u, 3u, 17u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u,
        4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u,
        4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 5u, 14u, 5u, 14u, 5u, 10u,
        9u, 10u, 9u, 9u, 9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 3u, 13u, 3u, 10u,
        5u, 10u, 3u, 10u, 3u, 13u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u,
        4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u,
        3u, 14u, 1u, 16u, 4u, 14u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u,
        1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u,
        1u, 16u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u,
        3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 4u, 14u, 1u, 16u,
        3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u,
        3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u,
        3u, 17u, 3u, 17u, 4u, 17u, 5u, 14u, 5u, 14u, 5u, 10u, 9u, 10u, 9u, 9u,
        9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 3u, 13u, 3u, 10u, 5u, 10u, 3u, 10u,
        3u, 13u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u,
        3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 1u, 16u,
        4u, 14u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u,
        3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u,
        3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u,
        1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 4u, 14u, 3u, 17u, 4u, 14u,
        3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u,
        3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 1u, 16u,
        3u, 17u, 3u, 17u, 4u, 17u, 5u, 14u, 5u, 14u, 5u, 10u, 9u, 10u, 9u, 9u,
        9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 3u, 13u, 3u, 10u, 5u, 10u, 3u, 10u,
        3u, 13u, 3u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u,
        3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 1u, 16u,
        4u, 14u, 3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u,
        3u, 17u, 3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u,
        3u, 17u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 3u, 17u,
        1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 1u, 16u, 3u, 17u, 1u, 17u, 3u, 17u,
        1u, 17u, 4u, 14u, 5u, 10u, 9u, 10u, 9u, 9u, 9u, 10u, 9u, 10u, 9u, 9u,
        5u, 10u, 1u, 16u, 3u, 17u, 3u, 17u, 4u, 17u, 3u, 17u, 3u, 17u, 1u, 16u,
        3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 14u, 4u, 14u,
        5u, 14u, 3u, 14u, 4u, 14u, 5u, 14u, 3u, 13u, 3u, 10u, 5u, 10u, 3u, 10u,
        3u, 13u, 1u, 16u, 3u, 10u, 5u, 10u, 5u, 10u, 9u, 10u, 9u, 9u, 9u, 10u,
        9u, 10u, 9u, 9u, 5u, 10u, 0
};

static const char _indic_syllable_machine_key_spans[] = {
        1, 16, 6, 4, 3, 1, 4, 3,
        1, 4, 3, 1, 4, 3, 1, 5,
        1, 1, 5, 1, 1, 5, 1, 1,
        5, 1, 1, 11, 11, 11, 11, 11,
        11, 11, 11, 11, 11, 1, 16, 6,
        4, 3, 1, 4, 3, 1, 4, 3,
        1, 4, 3, 1, 5, 1, 1, 5,
        1, 1, 5, 1, 1, 5, 1, 1,
        11, 11, 11, 11, 11, 11, 11, 11,
        11, 11, 1, 16, 6, 4, 3, 1,
        4, 3, 1, 4, 3, 1, 4, 3,
        1, 5, 1, 1, 5, 1, 1, 5,
        1, 1, 5, 1, 1, 11, 11, 11,
        11, 11, 11, 11, 11, 11, 1, 16,
        6, 4, 3, 1, 4, 3, 1, 4,
        3, 1, 4, 3, 1, 5, 1, 1,
        5, 1, 1, 5, 1, 1, 5, 1,
        1, 11, 11, 11, 11, 11, 11, 11,
        11, 11, 11, 11, 4, 11, 11, 4,
        3, 4, 3, 1, 4, 3, 1, 4,
        3, 1, 1, 16, 6, 5, 1, 1,
        5, 1, 1, 5, 1, 1, 5, 1,
        1, 1, 18, 15, 15, 14, 16, 15,
        15, 14, 16, 15, 15, 14, 16, 15,
        15, 14, 16, 15, 15, 14, 10, 10,
        6, 2, 1, 2, 2, 1, 6, 11,
        8, 6, 8, 11, 12, 12, 11, 10,
        12, 11, 10, 12, 11, 10, 12, 11,
        10, 12, 16, 11, 15, 15, 16, 16,
        16, 16, 16, 15, 15, 16, 16, 16,
        16, 16, 15, 15, 16, 16, 16, 16,
        16, 15, 15, 16, 16, 16, 16, 16,
        15, 15, 15, 15, 14, 16, 15, 15,
        14, 16, 15, 15, 14, 16, 15, 15,
        14, 16, 15, 15, 14, 10, 10, 6,
        2, 1, 2, 2, 1, 6, 11, 8,
        6, 8, 11, 12, 12, 11, 10, 12,
        11, 10, 12, 11, 10, 12, 11, 10,
        12, 16, 11, 15, 15, 16, 16, 16,
        16, 16, 15, 15, 16, 16, 16, 16,
        16, 15, 15, 16, 16, 16, 16, 16,
        15, 15, 16, 16, 16, 16, 11, 16,
        15, 15, 14, 16, 15, 15, 14, 16,
        15, 15, 14, 16, 15, 15, 14, 16,
        15, 15, 14, 10, 10, 6, 2, 1,
        2, 2, 1, 6, 11, 8, 6, 8,
        11, 12, 12, 11, 10, 12, 11, 10,
        12, 11, 10, 12, 11, 10, 12, 16,
        11, 15, 15, 16, 16, 16, 16, 16,
        15, 15, 16, 16, 16, 16, 16, 15,
        15, 16, 16, 16, 16, 16, 15, 15,
        16, 16, 16, 16, 16, 11, 15, 11,
        15, 15, 14, 16, 15, 15, 14, 16,
        15, 15, 14, 16, 15, 15, 14, 16,
        15, 15, 14, 10, 10, 6, 2, 1,
        2, 2, 1, 6, 11, 8, 6, 8,
        11, 12, 12, 11, 10, 12, 11, 10,
        12, 11, 10, 12, 11, 10, 12, 16,
        11, 15, 15, 16, 16, 16, 16, 16,
        15, 15, 16, 16, 16, 16, 16, 15,
        15, 16, 16, 16, 16, 16, 15, 15,
        16, 16, 16, 16, 16, 15, 17, 15,
        17, 11, 6, 2, 1, 2, 2, 1,
        6, 16, 15, 15, 14, 15, 15, 16,
        12, 11, 10, 12, 11, 10, 12, 11,
        10, 12, 11, 10, 11, 8, 6, 8,
        11, 16, 8, 6, 6, 2, 1, 2,
        2, 1, 6
};

static const short _indic_syllable_machine_index_offsets[] = {
        0, 2, 19, 26, 31, 35, 37, 42,
        46, 48, 53, 57, 59, 64, 68, 70,
        76, 78, 80, 86, 88, 90, 96, 98,
        100, 106, 108, 110, 122, 134, 146, 158,
        170, 182, 194, 206, 218, 230, 232, 249,
        256, 261, 265, 267, 272, 276, 278, 283,
        287, 289, 294, 298, 300, 306, 308, 310,
        316, 318, 320, 326, 328, 330, 336, 338,
        340, 352, 364, 376, 388, 400, 412, 424,
        436, 448, 460, 462, 479, 486, 491, 495,
        497, 502, 506, 508, 513, 517, 519, 524,
        528, 530, 536, 538, 540, 546, 548, 550,
        556, 558, 560, 566, 568, 570, 582, 594,
        606, 618, 630, 642, 654, 666, 678, 680,
        697, 704, 709, 713, 715, 720, 724, 726,
        731, 735, 737, 742, 746, 748, 754, 756,
        758, 764, 766, 768, 774, 776, 778, 784,
        786, 788, 800, 812, 824, 836, 848, 860,
        872, 884, 896, 908, 920, 925, 937, 949,
        954, 958, 963, 967, 969, 974, 978, 980,
        985, 989, 991, 993, 1010, 1017, 1023, 1025,
        1027, 1033, 1035, 1037, 1043, 1045, 1047, 1053,
        1055, 1057, 1059, 1078, 1094, 1110, 1125, 1142,
        1158, 1174, 1189, 1206, 1222, 1238, 1253, 1270,
        1286, 1302, 1317, 1334, 1350, 1366, 1381, 1392,
        1403, 1410, 1413, 1415, 1418, 1421, 1423, 1430,
        1442, 1451, 1458, 1467, 1479, 1492, 1505, 1517,
        1528, 1541, 1553, 1564, 1577, 1589, 1600, 1613,
        1625, 1636, 1649, 1666, 1678, 1694, 1710, 1727,
        1744, 1761, 1778, 1795, 1811, 1827, 1844, 1861,
        1878, 1895, 1912, 1928, 1944, 1961, 1978, 1995,
        2012, 2029, 2045, 2061, 2078, 2095, 2112, 2129,
        2146, 2162, 2178, 2194, 2210, 2225, 2242, 2258,
        2274, 2289, 2306, 2322, 2338, 2353, 2370, 2386,
        2402, 2417, 2434, 2450, 2466, 2481, 2492, 2503,
        2510, 2513, 2515, 2518, 2521, 2523, 2530, 2542,
        2551, 2558, 2567, 2579, 2592, 2605, 2617, 2628,
        2641, 2653, 2664, 2677, 2689, 2700, 2713, 2725,
        2736, 2749, 2766, 2778, 2794, 2810, 2827, 2844,
        2861, 2878, 2895, 2911, 2927, 2944, 2961, 2978,
        2995, 3012, 3028, 3044, 3061, 3078, 3095, 3112,
        3129, 3145, 3161, 3178, 3195, 3212, 3229, 3241,
        3258, 3274, 3290, 3305, 3322, 3338, 3354, 3369,
        3386, 3402, 3418, 3433, 3450, 3466, 3482, 3497,
        3514, 3530, 3546, 3561, 3572, 3583, 3590, 3593,
        3595, 3598, 3601, 3603, 3610, 3622, 3631, 3638,
        3647, 3659, 3672, 3685, 3697, 3708, 3721, 3733,
        3744, 3757, 3769, 3780, 3793, 3805, 3816, 3829,
        3846, 3858, 3874, 3890, 3907, 3924, 3941, 3958,
        3975, 3991, 4007, 4024, 4041, 4058, 4075, 4092,
        4108, 4124, 4141, 4158, 4175, 4192, 4209, 4225,
        4241, 4258, 4275, 4292, 4309, 4326, 4338, 4354,
        4366, 4382, 4398, 4413, 4430, 4446, 4462, 4477,
        4494, 4510, 4526, 4541, 4558, 4574, 4590, 4605,
        4622, 4638, 4654, 4669, 4680, 4691, 4698, 4701,
        4703, 4706, 4709, 4711, 4718, 4730, 4739, 4746,
        4755, 4767, 4780, 4793, 4805, 4816, 4829, 4841,
        4852, 4865, 4877, 4888, 4901, 4913, 4924, 4937,
        4954, 4966, 4982, 4998, 5015, 5032, 5049, 5066,
        5083, 5099, 5115, 5132, 5149, 5166, 5183, 5200,
        5216, 5232, 5249, 5266, 5283, 5300, 5317, 5333,
        5349, 5366, 5383, 5400, 5417, 5434, 5450, 5468,
        5484, 5502, 5514, 5521, 5524, 5526, 5529, 5532,
        5534, 5541, 5558, 5574, 5590, 5605, 5621, 5637,
        5654, 5667, 5679, 5690, 5703, 5715, 5726, 5739,
        5751, 5762, 5775, 5787, 5798, 5810, 5819, 5826,
        5835, 5847, 5864, 5873, 5880, 5887, 5890, 5892,
        5895, 5898, 5900
};

static const short _indic_syllable_machine_indicies[] = {
        1, 0, 2, 3, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 2, 0, 1, 0, 0, 0, 0,
        4, 0, 5, 5, 6, 1, 0, 7,
        7, 6, 0, 6, 0, 8, 8, 9,
        1, 0, 10, 10, 9, 0, 9, 0,
        11, 11, 12, 1, 0, 13, 13, 12,
        0, 12, 0, 14, 14, 15, 1, 0,
        16, 16, 15, 0, 15, 0, 17, 0,
        0, 0, 1, 0, 18, 0, 19, 0,
        20, 14, 14, 15, 1, 0, 21, 0,
        22, 0, 23, 11, 11, 12, 1, 0,
        24, 0, 25, 0, 26, 8, 8, 9,
        1, 0, 27, 0, 28, 0, 29, 5,
        5, 6, 1, 0, 0, 0, 0, 0,
        29, 0, 29, 5, 5, 6, 1, 0,
        0, 0, 0, 30, 29, 0, 31, 5,
        5, 6, 1, 0, 0, 0, 0, 0,
        31, 0, 31, 5, 5, 6, 1, 0,
        0, 0, 0, 32, 31, 0, 33, 5,
        5, 6, 1, 0, 0, 0, 0, 0,
        33, 0, 33, 5, 5, 6, 1, 0,
        0, 0, 0, 34, 33, 0, 35, 5,
        5, 6, 1, 0, 0, 0, 0, 0,
        35, 0, 35, 5, 5, 6, 1, 0,
        0, 0, 0, 36, 35, 0, 37, 5,
        5, 6, 1, 0, 0, 0, 0, 0,
        37, 0, 37, 5, 5, 6, 1, 0,
        0, 0, 0, 38, 37, 0, 40, 39,
        41, 42, 39, 39, 39, 39, 39, 39,
        39, 39, 39, 39, 39, 39, 39, 41,
        39, 40, 39, 39, 39, 39, 43, 39,
        44, 44, 45, 40, 39, 46, 46, 45,
        39, 45, 39, 47, 47, 48, 40, 39,
        49, 49, 48, 39, 48, 39, 50, 50,
        51, 40, 39, 52, 52, 51, 39, 51,
        39, 53, 53, 54, 40, 39, 55, 55,
        54, 39, 54, 39, 56, 39, 39, 39,
        40, 39, 57, 39, 58, 39, 59, 53,
        53, 54, 40, 39, 60, 39, 61, 39,
        62, 50, 50, 51, 40, 39, 63, 39,
        64, 39, 65, 47, 47, 48, 40, 39,
        66, 39, 67, 39, 68, 44, 44, 45,
        40, 39, 39, 39, 39, 39, 68, 39,
        68, 44, 44, 45, 40, 39, 39, 39,
        39, 69, 68, 39, 70, 44, 44, 45,
        40, 39, 39, 39, 39, 39, 70, 39,
        70, 44, 44, 45, 40, 39, 39, 39,
        39, 71, 70, 39, 72, 44, 44, 45,
        40, 39, 39, 39, 39, 39, 72, 39,
        72, 44, 44, 45, 40, 39, 39, 39,
        39, 73, 72, 39, 74, 44, 44, 45,
        40, 39, 39, 39, 39, 39, 74, 39,
        74, 44, 44, 45, 40, 39, 39, 39,
        39, 75, 74, 39, 76, 44, 44, 45,
        40, 39, 39, 39, 39, 39, 76, 39,
        76, 44, 44, 45, 40, 39, 39, 39,
        39, 77, 76, 39, 79, 78, 80, 81,
        78, 78, 78, 78, 78, 78, 78, 78,
        78, 78, 78, 78, 78, 80, 78, 79,
        78, 78, 78, 78, 82, 78, 83, 83,
        84, 79, 78, 86, 86, 84, 85, 84,
        85, 87, 87, 88, 79, 78, 89, 89,
        88, 78, 88, 78, 90, 90, 91, 79,
        78, 92, 92, 91, 78, 91, 78, 93,
        93, 94, 79, 78, 95, 95, 94, 78,
        94, 78, 96, 78, 78, 78, 79, 78,
        97, 78, 98, 78, 99, 93, 93, 94,
        79, 78, 100, 78, 101, 78, 102, 90,
        90, 91, 79, 78, 103, 78, 104, 78,
        105, 87, 87, 88, 79, 78, 106, 78,
        107, 78, 108, 83, 83, 84, 79, 78,
        78, 78, 78, 78, 108, 78, 108, 83,
        83, 84, 79, 78, 78, 78, 78, 109,
        108, 78, 110, 83, 83, 84, 79, 78,
        78, 78, 78, 78, 110, 78, 110, 83,
        83, 84, 79, 78, 78, 78, 78, 111,
        110, 78, 112, 83, 83, 84, 79, 78,
        78, 78, 78, 78, 112, 78, 112, 83,
        83, 84, 79, 78, 78, 78, 78, 113,
        112, 78, 114, 83, 83, 84, 79, 78,
        78, 78, 78, 78, 114, 78, 114, 83,
        83, 84, 79, 78, 78, 78, 78, 115,
        114, 78, 116, 83, 83, 84, 79, 78,
        78, 78, 78, 78, 116, 78, 118, 117,
        119, 120, 117, 117, 117, 117, 117, 117,
        117, 117, 117, 117, 117, 117, 117, 119,
        117, 118, 117, 117, 117, 117, 121, 117,
        122, 122, 123, 118, 117, 124, 124, 123,
        117, 123, 117, 125, 125, 126, 118, 117,
        127, 127, 126, 117, 126, 117, 128, 128,
        129, 118, 117, 130, 130, 129, 117, 129,
        117, 131, 131, 132, 118, 117, 133, 133,
        132, 117, 132, 117, 134, 117, 117, 117,
        118, 117, 135, 117, 136, 117, 137, 131,
        131, 132, 118, 117, 138, 117, 139, 117,
        140, 128, 128, 129, 118, 117, 141, 117,
        142, 117, 143, 125, 125, 126, 118, 117,
        144, 117, 145, 117, 146, 122, 122, 123,
        118, 117, 117, 117, 117, 117, 146, 117,
        146, 122, 122, 123, 118, 117, 117, 117,
        117, 147, 146, 117, 148, 122, 122, 123,
        118, 117, 117, 117, 117, 117, 148, 117,
        148, 122, 122, 123, 118, 117, 117, 117,
        117, 149, 148, 117, 150, 122, 122, 123,
        118, 117, 117, 117, 117, 117, 150, 117,
        150, 122, 122, 123, 118, 117, 117, 117,
        117, 151, 150, 117, 152, 122, 122, 123,
        118, 117, 117, 117, 117, 117, 152, 117,
        152, 122, 122, 123, 118, 117, 117, 117,
        117, 153, 152, 117, 154, 122, 122, 123,
        118, 117, 117, 117, 117, 117, 154, 117,
        154, 122, 122, 123, 118, 117, 117, 117,
        117, 155, 154, 117, 116, 83, 83, 84,
        79, 78, 78, 78, 78, 156, 116, 78,
        86, 86, 84, 1, 0, 114, 83, 83,
        84, 157, 0, 0, 0, 0, 0, 114,
        0, 114, 83, 83, 84, 157, 0, 0,
        0, 0, 158, 114, 0, 159, 159, 160,
        1, 0, 7, 7, 160, 0, 161, 161,
        162, 157, 0, 163, 163, 162, 0, 162,
        0, 164, 164, 165, 157, 0, 166, 166,
        165, 0, 165, 0, 167, 167, 168, 157,
        0, 169, 169, 168, 0, 168, 0, 157,
        0, 170, 171, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        170, 0, 157, 0, 0, 0, 0, 172,
        0, 173, 0, 0, 0, 157, 0, 174,
        0, 175, 0, 176, 167, 167, 168, 157,
        0, 177, 0, 178, 0, 179, 164, 164,
        165, 157, 0, 180, 0, 181, 0, 182,
        161, 161, 162, 157, 0, 183, 0, 184,
        0, 186, 185, 188, 189, 190, 191, 192,
        193, 84, 79, 194, 195, 196, 196, 156,
        197, 198, 199, 200, 201, 187, 203, 204,
        205, 206, 6, 1, 207, 208, 202, 202,
        38, 209, 202, 202, 210, 202, 211, 204,
        212, 212, 6, 1, 207, 208, 202, 202,
        202, 209, 202, 202, 210, 202, 204, 212,
        212, 6, 1, 207, 208, 202, 202, 202,
        209, 202, 202, 210, 202, 213, 202, 202,
        202, 19, 214, 202, 1, 207, 208, 202,
        202, 202, 215, 202, 213, 202, 216, 217,
        218, 219, 6, 1, 207, 208, 202, 202,
        36, 220, 202, 202, 210, 202, 221, 217,
        222, 222, 6, 1, 207, 208, 202, 202,
        202, 220, 202, 202, 210, 202, 217, 222,
        222, 6, 1, 207, 208, 202, 202, 202,
        220, 202, 202, 210, 202, 223, 202, 202,
        202, 19, 224, 202, 1, 207, 208, 202,
        202, 202, 215, 202, 223, 202, 225, 226,
        227, 228, 6, 1, 207, 208, 202, 202,
        34, 229, 202, 202, 210, 202, 230, 226,
        231, 231, 6, 1, 207, 208, 202, 202,
        202, 229, 202, 202, 210, 202, 226, 231,
        231, 6, 1, 207, 208, 202, 202, 202,
        229, 202, 202, 210, 202, 232, 202, 202,
        202, 19, 233, 202, 1, 207, 208, 202,
        202, 202, 215, 202, 232, 202, 234, 235,
        236, 237, 6, 1, 207, 208, 202, 202,
        32, 238, 202, 202, 210, 202, 239, 235,
        240, 240, 6, 1, 207, 208, 202, 202,
        202, 238, 202, 202, 210, 202, 235, 240,
        240, 6, 1, 207, 208, 202, 202, 202,
        238, 202, 202, 210, 202, 241, 202, 202,
        202, 19, 242, 202, 1, 207, 208, 202,
        202, 202, 215, 202, 241, 202, 243, 244,
        245, 246, 6, 1, 207, 208, 202, 202,
        30, 247, 202, 202, 210, 202, 248, 244,
        249, 249, 6, 1, 207, 208, 202, 202,
        202, 247, 202, 202, 210, 202, 244, 249,
        249, 6, 1, 207, 208, 202, 202, 202,
        247, 202, 202, 210, 202, 19, 250, 202,
        1, 207, 208, 202, 202, 202, 215, 202,
        251, 251, 202, 1, 207, 208, 202, 202,
        202, 215, 202, 252, 202, 202, 253, 207,
        208, 202, 207, 208, 202, 254, 202, 207,
        255, 202, 207, 256, 202, 207, 202, 252,
        202, 202, 202, 207, 208, 202, 257, 202,
        258, 259, 202, 1, 207, 208, 202, 202,
        4, 202, 3, 202, 251, 251, 202, 1,
        207, 208, 202, 251, 251, 202, 1, 207,
        208, 202, 257, 202, 251, 251, 202, 1,
        207, 208, 202, 257, 202, 258, 251, 202,
        1, 207, 208, 202, 202, 4, 202, 19,
        202, 260, 260, 6, 1, 207, 208, 202,
        202, 202, 215, 202, 261, 28, 262, 263,
        9, 1, 207, 208, 202, 202, 202, 215,
        202, 28, 262, 263, 9, 1, 207, 208,
        202, 202, 202, 215, 202, 262, 262, 9,
        1, 207, 208, 202, 202, 202, 215, 202,
        264, 25, 265, 266, 12, 1, 207, 208,
        202, 202, 202, 215, 202, 25, 265, 266,
        12, 1, 207, 208, 202, 202, 202, 215,
        202, 265, 265, 12, 1, 207, 208, 202,
        202, 202, 215, 202, 267, 22, 268, 269,
        15, 1, 207, 208, 202, 202, 202, 215,
        202, 22, 268, 269, 15, 1, 207, 208,
        202, 202, 202, 215, 202, 268, 268, 15,
        1, 207, 208, 202, 202, 202, 215, 202,
        270, 19, 251, 271, 202, 1, 207, 208,
        202, 202, 202, 215, 202, 19, 251, 271,
        202, 1, 207, 208, 202, 202, 202, 215,
        202, 251, 272, 202, 1, 207, 208, 202,
        202, 202, 215, 202, 19, 202, 251, 251,
        202, 1, 207, 208, 202, 202, 202, 215,
        202, 2, 3, 202, 202, 19, 250, 202,
        1, 207, 208, 202, 202, 202, 215, 202,
        2, 202, 244, 249, 249, 6, 1, 207,
        208, 202, 202, 202, 247, 202, 243, 244,
        249, 249, 6, 1, 207, 208, 202, 202,
        202, 247, 202, 202, 210, 202, 243, 244,
        245, 249, 6, 1, 207, 208, 202, 202,
        30, 247, 202, 202, 210, 202, 241, 202,
        273, 202, 260, 260, 6, 1, 207, 208,
        202, 202, 202, 215, 202, 241, 202, 241,
        202, 202, 202, 251, 251, 202, 1, 207,
        208, 202, 202, 202, 215, 202, 241, 202,
        241, 202, 202, 202, 251, 274, 202, 1,
        207, 208, 202, 202, 202, 215, 202, 241,
        202, 241, 202, 273, 202, 251, 251, 202,
        1, 207, 208, 202, 202, 202, 215, 202,
        241, 202, 241, 3, 202, 202, 19, 242,
        202, 1, 207, 208, 202, 202, 202, 215,
        202, 241, 202, 234, 235, 240, 240, 6,
        1, 207, 208, 202, 202, 202, 238, 202,
        202, 210, 202, 234, 235, 236, 240, 6,
        1, 207, 208, 202, 202, 32, 238, 202,
        202, 210, 202, 232, 202, 275, 202, 260,
        260, 6, 1, 207, 208, 202, 202, 202,
        215, 202, 232, 202, 232, 202, 202, 202,
        251, 251, 202, 1, 207, 208, 202, 202,
        202, 215, 202, 232, 202, 232, 202, 202,
        202, 251, 276, 202, 1, 207, 208, 202,
        202, 202, 215, 202, 232, 202, 232, 202,
        275, 202, 251, 251, 202, 1, 207, 208,
        202, 202, 202, 215, 202, 232, 202, 232,
        3, 202, 202, 19, 233, 202, 1, 207,
        208, 202, 202, 202, 215, 202, 232, 202,
        225, 226, 231, 231, 6, 1, 207, 208,
        202, 202, 202, 229, 202, 202, 210, 202,
        225, 226, 227, 231, 6, 1, 207, 208,
        202, 202, 34, 229, 202, 202, 210, 202,
        223, 202, 277, 202, 260, 260, 6, 1,
        207, 208, 202, 202, 202, 215, 202, 223,
        202, 223, 202, 202, 202, 251, 251, 202,
        1, 207, 208, 202, 202, 202, 215, 202,
        223, 202, 223, 202, 202, 202, 251, 278,
        202, 1, 207, 208, 202, 202, 202, 215,
        202, 223, 202, 223, 202, 277, 202, 251,
        251, 202, 1, 207, 208, 202, 202, 202,
        215, 202, 223, 202, 223, 3, 202, 202,
        19, 224, 202, 1, 207, 208, 202, 202,
        202, 215, 202, 223, 202, 216, 217, 222,
        222, 6, 1, 207, 208, 202, 202, 202,
        220, 202, 202, 210, 202, 216, 217, 218,
        222, 6, 1, 207, 208, 202, 202, 36,
        220, 202, 202, 210, 202, 213, 202, 279,
        202, 260, 260, 6, 1, 207, 208, 202,
        202, 202, 215, 202, 213, 202, 213, 202,
        202, 202, 251, 251, 202, 1, 207, 208,
        202, 202, 202, 215, 202, 213, 202, 213,
        202, 202, 202, 251, 280, 202, 1, 207,
        208, 202, 202, 202, 215, 202, 213, 202,
        213, 202, 279, 202, 251, 251, 202, 1,
        207, 208, 202, 202, 202, 215, 202, 213,
        202, 213, 3, 202, 202, 19, 214, 202,
        1, 207, 208, 202, 202, 202, 215, 202,
        213, 202, 203, 204, 212, 212, 6, 1,
        207, 208, 202, 202, 202, 209, 202, 202,
        210, 202, 203, 204, 205, 212, 6, 1,
        207, 208, 202, 202, 38, 209, 202, 202,
        210, 202, 282, 283, 284, 285, 45, 40,
        286, 287, 281, 281, 77, 288, 281, 281,
        289, 281, 290, 283, 291, 285, 45, 40,
        286, 287, 281, 281, 281, 288, 281, 281,
        289, 281, 283, 291, 285, 45, 40, 286,
        287, 281, 281, 281, 288, 281, 281, 289,
        281, 292, 281, 281, 281, 58, 293, 281,
        40, 286, 287, 281, 281, 281, 294, 281,
        292, 281, 295, 296, 297, 298, 45, 40,
        286, 287, 281, 281, 75, 299, 281, 281,
        289, 281, 300, 296, 301, 301, 45, 40,
        286, 287, 281, 281, 281, 299, 281, 281,
        289, 281, 296, 301, 301, 45, 40, 286,
        287, 281, 281, 281, 299, 281, 281, 289,
        281, 302, 281, 281, 281, 58, 303, 281,
        40, 286, 287, 281, 281, 281, 294, 281,
        302, 281, 304, 305, 306, 307, 45, 40,
        286, 287, 281, 281, 73, 308, 281, 281,
        289, 281, 309, 305, 310, 310, 45, 40,
        286, 287, 281, 281, 281, 308, 281, 281,
        289, 281, 305, 310, 310, 45, 40, 286,
        287, 281, 281, 281, 308, 281, 281, 289,
        281, 311, 281, 281, 281, 58, 312, 281,
        40, 286, 287, 281, 281, 281, 294, 281,
        311, 281, 313, 314, 315, 316, 45, 40,
        286, 287, 281, 281, 71, 317, 281, 281,
        289, 281, 318, 314, 319, 319, 45, 40,
        286, 287, 281, 281, 281, 317, 281, 281,
        289, 281, 314, 319, 319, 45, 40, 286,
        287, 281, 281, 281, 317, 281, 281, 289,
        281, 320, 281, 281, 281, 58, 321, 281,
        40, 286, 287, 281, 281, 281, 294, 281,
        320, 281, 322, 323, 324, 325, 45, 40,
        286, 287, 281, 281, 69, 326, 281, 281,
        289, 281, 327, 323, 328, 328, 45, 40,
        286, 287, 281, 281, 281, 326, 281, 281,
        289, 281, 323, 328, 328, 45, 40, 286,
        287, 281, 281, 281, 326, 281, 281, 289,
        281, 58, 329, 281, 40, 286, 287, 281,
        281, 281, 294, 281, 330, 330, 281, 40,
        286, 287, 281, 281, 281, 294, 281, 331,
        281, 281, 332, 286, 287, 281, 286, 287,
        281, 333, 281, 286, 334, 281, 286, 335,
        281, 286, 281, 331, 281, 281, 281, 286,
        287, 281, 336, 281, 337, 338, 281, 40,
        286, 287, 281, 281, 43, 281, 42, 281,
        330, 330, 281, 40, 286, 287, 281, 330,
        330, 281, 40, 286, 287, 281, 336, 281,
        330, 330, 281, 40, 286, 287, 281, 336,
        281, 337, 330, 281, 40, 286, 287, 281,
        281, 43, 281, 58, 281, 339, 339, 45,
        40, 286, 287, 281, 281, 281, 294, 281,
        340, 67, 341, 342, 48, 40, 286, 287,
        281, 281, 281, 294, 281, 67, 341, 342,
        48, 40, 286, 287, 281, 281, 281, 294,
        281, 341, 341, 48, 40, 286, 287, 281,
        281, 281, 294, 281, 343, 64, 344, 345,
        51, 40, 286, 287, 281, 281, 281, 294,
        281, 64, 344, 345, 51, 40, 286, 287,
        281, 281, 281, 294, 281, 344, 344, 51,
        40, 286, 287, 281, 281, 281, 294, 281,
        346, 61, 347, 348, 54, 40, 286, 287,
        281, 281, 281, 294, 281, 61, 347, 348,
        54, 40, 286, 287, 281, 281, 281, 294,
        281, 347, 347, 54, 40, 286, 287, 281,
        281, 281, 294, 281, 349, 58, 330, 350,
        281, 40, 286, 287, 281, 281, 281, 294,
        281, 58, 330, 350, 281, 40, 286, 287,
        281, 281, 281, 294, 281, 330, 351, 281,
        40, 286, 287, 281, 281, 281, 294, 281,
        58, 281, 330, 330, 281, 40, 286, 287,
        281, 281, 281, 294, 281, 41, 42, 281,
        281, 58, 329, 281, 40, 286, 287, 281,
        281, 281, 294, 281, 41, 281, 323, 328,
        328, 45, 40, 286, 287, 281, 281, 281,
        326, 281, 322, 323, 328, 328, 45, 40,
        286, 287, 281, 281, 281, 326, 281, 281,
        289, 281, 322, 323, 324, 328, 45, 40,
        286, 287, 281, 281, 69, 326, 281, 281,
        289, 281, 320, 281, 352, 281, 339, 339,
        45, 40, 286, 287, 281, 281, 281, 294,
        281, 320, 281, 320, 281, 281, 281, 330,
        330, 281, 40, 286, 287, 281, 281, 281,
        294, 281, 320, 281, 320, 281, 281, 281,
        330, 353, 281, 40, 286, 287, 281, 281,
        281, 294, 281, 320, 281, 320, 281, 352,
        281, 330, 330, 281, 40, 286, 287, 281,
        281, 281, 294, 281, 320, 281, 320, 42,
        281, 281, 58, 321, 281, 40, 286, 287,
        281, 281, 281, 294, 281, 320, 281, 313,
        314, 319, 319, 45, 40, 286, 287, 281,
        281, 281, 317, 281, 281, 289, 281, 313,
        314, 315, 319, 45, 40, 286, 287, 281,
        281, 71, 317, 281, 281, 289, 281, 311,
        281, 354, 281, 339, 339, 45, 40, 286,
        287, 281, 281, 281, 294, 281, 311, 281,
        311, 281, 281, 281, 330, 330, 281, 40,
        286, 287, 281, 281, 281, 294, 281, 311,
        281, 311, 281, 281, 281, 330, 355, 281,
        40, 286, 287, 281, 281, 281, 294, 281,
        311, 281, 311, 281, 354, 281, 330, 330,
        281, 40, 286, 287, 281, 281, 281, 294,
        281, 311, 281, 311, 42, 281, 281, 58,
        312, 281, 40, 286, 287, 281, 281, 281,
        294, 281, 311, 281, 304, 305, 310, 310,
        45, 40, 286, 287, 281, 281, 281, 308,
        281, 281, 289, 281, 304, 305, 306, 310,
        45, 40, 286, 287, 281, 281, 73, 308,
        281, 281, 289, 281, 302, 281, 356, 281,
        339, 339, 45, 40, 286, 287, 281, 281,
        281, 294, 281, 302, 281, 302, 281, 281,
        281, 330, 330, 281, 40, 286, 287, 281,
        281, 281, 294, 281, 302, 281, 302, 281,
        281, 281, 330, 357, 281, 40, 286, 287,
        281, 281, 281, 294, 281, 302, 281, 302,
        281, 356, 281, 330, 330, 281, 40, 286,
        287, 281, 281, 281, 294, 281, 302, 281,
        302, 42, 281, 281, 58, 303, 281, 40,
        286, 287, 281, 281, 281, 294, 281, 302,
        281, 295, 296, 301, 301, 45, 40, 286,
        287, 281, 281, 281, 299, 281, 281, 289,
        281, 295, 296, 297, 301, 45, 40, 286,
        287, 281, 281, 75, 299, 281, 281, 289,
        281, 292, 281, 358, 281, 339, 339, 45,
        40, 286, 287, 281, 281, 281, 294, 281,
        292, 281, 292, 281, 281, 281, 330, 330,
        281, 40, 286, 287, 281, 281, 281, 294,
        281, 292, 281, 292, 281, 281, 281, 330,
        359, 281, 40, 286, 287, 281, 281, 281,
        294, 281, 292, 281, 292, 281, 358, 281,
        330, 330, 281, 40, 286, 287, 281, 281,
        281, 294, 281, 292, 281, 76, 44, 44,
        45, 40, 281, 281, 281, 281, 281, 76,
        281, 292, 42, 281, 281, 58, 293, 281,
        40, 286, 287, 281, 281, 281, 294, 281,
        292, 281, 282, 283, 291, 285, 45, 40,
        286, 287, 281, 281, 281, 288, 281, 281,
        289, 281, 361, 191, 362, 362, 84, 79,
        194, 195, 360, 360, 360, 197, 360, 360,
        200, 360, 191, 362, 362, 84, 79, 194,
        195, 360, 360, 360, 197, 360, 360, 200,
        360, 363, 360, 360, 360, 98, 364, 360,
        79, 194, 195, 360, 360, 360, 365, 360,
        363, 360, 366, 367, 368, 369, 84, 79,
        194, 195, 360, 360, 115, 370, 360, 360,
        200, 360, 371, 367, 372, 372, 84, 79,
        194, 195, 360, 360, 360, 370, 360, 360,
        200, 360, 367, 372, 372, 84, 79, 194,
        195, 360, 360, 360, 370, 360, 360, 200,
        360, 373, 360, 360, 360, 98, 374, 360,
        79, 194, 195, 360, 360, 360, 365, 360,
        373, 360, 375, 376, 377, 378, 84, 79,
        194, 195, 360, 360, 113, 379, 360, 360,
        200, 360, 380, 376, 381, 381, 84, 79,
        194, 195, 360, 360, 360, 379, 360, 360,
        200, 360, 376, 381, 381, 84, 79, 194,
        195, 360, 360, 360, 379, 360, 360, 200,
        360, 382, 360, 360, 360, 98, 383, 360,
        79, 194, 195, 360, 360, 360, 365, 360,
        382, 360, 384, 385, 386, 387, 84, 79,
        194, 195, 360, 360, 111, 388, 360, 360,
        200, 360, 389, 385, 390, 390, 84, 79,
        194, 195, 360, 360, 360, 388, 360, 360,
        200, 360, 385, 390, 390, 84, 79, 194,
        195, 360, 360, 360, 388, 360, 360, 200,
        360, 391, 360, 360, 360, 98, 392, 360,
        79, 194, 195, 360, 360, 360, 365, 360,
        391, 360, 393, 394, 395, 396, 84, 79,
        194, 195, 360, 360, 109, 397, 360, 360,
        200, 360, 398, 394, 399, 399, 84, 79,
        194, 195, 360, 360, 360, 397, 360, 360,
        200, 360, 394, 399, 399, 84, 79, 194,
        195, 360, 360, 360, 397, 360, 360, 200,
        360, 98, 400, 360, 79, 194, 195, 360,
        360, 360, 365, 360, 401, 401, 360, 79,
        194, 195, 360, 360, 360, 365, 360, 402,
        360, 360, 403, 194, 195, 360, 194, 195,
        360, 404, 360, 194, 405, 360, 194, 406,
        360, 194, 360, 402, 360, 360, 360, 194,
        195, 360, 407, 360, 408, 409, 360, 79,
        194, 195, 360, 360, 82, 360, 81, 360,
        401, 401, 360, 79, 194, 195, 360, 401,
        401, 360, 79, 194, 195, 360, 407, 360,
        401, 401, 360, 79, 194, 195, 360, 407,
        360, 408, 401, 360, 79, 194, 195, 360,
        360, 82, 360, 98, 360, 410, 410, 84,
        79, 194, 195, 360, 360, 360, 365, 360,
        411, 107, 412, 413, 88, 79, 194, 195,
        360, 360, 360, 365, 360, 107, 412, 413,
        88, 79, 194, 195, 360, 360, 360, 365,
        360, 412, 412, 88, 79, 194, 195, 360,
        360, 360, 365, 360, 414, 104, 415, 416,
        91, 79, 194, 195, 360, 360, 360, 365,
        360, 104, 415, 416, 91, 79, 194, 195,
        360, 360, 360, 365, 360, 415, 415, 91,
        79, 194, 195, 360, 360, 360, 365, 360,
        417, 101, 418, 419, 94, 79, 194, 195,
        360, 360, 360, 365, 360, 101, 418, 419,
        94, 79, 194, 195, 360, 360, 360, 365,
        360, 418, 418, 94, 79, 194, 195, 360,
        360, 360, 365, 360, 420, 98, 401, 421,
        360, 79, 194, 195, 360, 360, 360, 365,
        360, 98, 401, 421, 360, 79, 194, 195,
        360, 360, 360, 365, 360, 401, 422, 360,
        79, 194, 195, 360, 360, 360, 365, 360,
        98, 360, 401, 401, 360, 79, 194, 195,
        360, 360, 360, 365, 360, 80, 81, 360,
        360, 98, 400, 360, 79, 194, 195, 360,
        360, 360, 365, 360, 80, 360, 394, 399,
        399, 84, 79, 194, 195, 360, 360, 360,
        397, 360, 393, 394, 399, 399, 84, 79,
        194, 195, 360, 360, 360, 397, 360, 360,
        200, 360, 393, 394, 395, 399, 84, 79,
        194, 195, 360, 360, 109, 397, 360, 360,
        200, 360, 391, 360, 423, 360, 410, 410,
        84, 79, 194, 195, 360, 360, 360, 365,
        360, 391, 360, 391, 360, 360, 360, 401,
        401, 360, 79, 194, 195, 360, 360, 360,
        365, 360, 391, 360, 391, 360, 360, 360,
        401, 424, 360, 79, 194, 195, 360, 360,
        360, 365, 360, 391, 360, 391, 360, 423,
        360, 401, 401, 360, 79, 194, 195, 360,
        360, 360, 365, 360, 391, 360, 391, 81,
        360, 360, 98, 392, 360, 79, 194, 195,
        360, 360, 360, 365, 360, 391, 360, 384,
        385, 390, 390, 84, 79, 194, 195, 360,
        360, 360, 388, 360, 360, 200, 360, 384,
        385, 386, 390, 84, 79, 194, 195, 360,
        360, 111, 388, 360, 360, 200, 360, 382,
        360, 425, 360, 410, 410, 84, 79, 194,
        195, 360, 360, 360, 365, 360, 382, 360,
        382, 360, 360, 360, 401, 401, 360, 79,
        194, 195, 360, 360, 360, 365, 360, 382,
        360, 382, 360, 360, 360, 401, 426, 360,
        79, 194, 195, 360, 360, 360, 365, 360,
        382, 360, 382, 360, 425, 360, 401, 401,
        360, 79, 194, 195, 360, 360, 360, 365,
        360, 382, 360, 382, 81, 360, 360, 98,
        383, 360, 79, 194, 195, 360, 360, 360,
        365, 360, 382, 360, 375, 376, 381, 381,
        84, 79, 194, 195, 360, 360, 360, 379,
        360, 360, 200, 360, 375, 376, 377, 381,
        84, 79, 194, 195, 360, 360, 113, 379,
        360, 360, 200, 360, 373, 360, 427, 360,
        410, 410, 84, 79, 194, 195, 360, 360,
        360, 365, 360, 373, 360, 373, 360, 360,
        360, 401, 401, 360, 79, 194, 195, 360,
        360, 360, 365, 360, 373, 360, 373, 360,
        360, 360, 401, 428, 360, 79, 194, 195,
        360, 360, 360, 365, 360, 373, 360, 373,
        360, 427, 360, 401, 401, 360, 79, 194,
        195, 360, 360, 360, 365, 360, 373, 360,
        373, 81, 360, 360, 98, 374, 360, 79,
        194, 195, 360, 360, 360, 365, 360, 373,
        360, 366, 367, 372, 372, 84, 79, 194,
        195, 360, 360, 360, 370, 360, 360, 200,
        360, 366, 367, 368, 372, 84, 79, 194,
        195, 360, 360, 115, 370, 360, 360, 200,
        360, 363, 360, 429, 360, 410, 410, 84,
        79, 194, 195, 360, 360, 360, 365, 360,
        363, 360, 363, 360, 360, 360, 401, 401,
        360, 79, 194, 195, 360, 360, 360, 365,
        360, 363, 360, 363, 360, 360, 360, 401,
        430, 360, 79, 194, 195, 360, 360, 360,
        365, 360, 363, 360, 363, 360, 429, 360,
        401, 401, 360, 79, 194, 195, 360, 360,
        360, 365, 360, 363, 360, 363, 81, 360,
        360, 98, 364, 360, 79, 194, 195, 360,
        360, 360, 365, 360, 363, 360, 116, 83,
        83, 84, 79, 431, 431, 431, 431, 156,
        116, 431, 190, 191, 362, 362, 84, 79,
        194, 195, 360, 360, 360, 197, 360, 360,
        200, 360, 116, 83, 83, 84, 79, 431,
        431, 431, 431, 431, 116, 431, 433, 434,
        435, 436, 123, 118, 437, 438, 432, 432,
        155, 439, 432, 432, 440, 432, 441, 434,
        436, 436, 123, 118, 437, 438, 432, 432,
        432, 439, 432, 432, 440, 432, 434, 436,
        436, 123, 118, 437, 438, 432, 432, 432,
        439, 432, 432, 440, 432, 442, 432, 432,
        432, 136, 443, 432, 118, 437, 438, 432,
        432, 432, 444, 432, 442, 432, 445, 446,
        447, 448, 123, 118, 437, 438, 432, 432,
        153, 449, 432, 432, 440, 432, 450, 446,
        451, 451, 123, 118, 437, 438, 432, 432,
        432, 449, 432, 432, 440, 432, 446, 451,
        451, 123, 118, 437, 438, 432, 432, 432,
        449, 432, 432, 440, 432, 452, 432, 432,
        432, 136, 453, 432, 118, 437, 438, 432,
        432, 432, 444, 432, 452, 432, 454, 455,
        456, 457, 123, 118, 437, 438, 432, 432,
        151, 458, 432, 432, 440, 432, 459, 455,
        460, 460, 123, 118, 437, 438, 432, 432,
        432, 458, 432, 432, 440, 432, 455, 460,
        460, 123, 118, 437, 438, 432, 432, 432,
        458, 432, 432, 440, 432, 461, 432, 432,
        432, 136, 462, 432, 118, 437, 438, 432,
        432, 432, 444, 432, 461, 432, 463, 464,
        465, 466, 123, 118, 437, 438, 432, 432,
        149, 467, 432, 432, 440, 432, 468, 464,
        469, 469, 123, 118, 437, 438, 432, 432,
        432, 467, 432, 432, 440, 432, 464, 469,
        469, 123, 118, 437, 438, 432, 432, 432,
        467, 432, 432, 440, 432, 470, 432, 432,
        432, 136, 471, 432, 118, 437, 438, 432,
        432, 432, 444, 432, 470, 432, 472, 473,
        474, 475, 123, 118, 437, 438, 432, 432,
        147, 476, 432, 432, 440, 432, 477, 473,
        478, 478, 123, 118, 437, 438, 432, 432,
        432, 476, 432, 432, 440, 432, 473, 478,
        478, 123, 118, 437, 438, 432, 432, 432,
        476, 432, 432, 440, 432, 136, 479, 432,
        118, 437, 438, 432, 432, 432, 444, 432,
        480, 480, 432, 118, 437, 438, 432, 432,
        432, 444, 432, 481, 432, 432, 482, 437,
        438, 432, 437, 438, 432, 483, 432, 437,
        484, 432, 437, 485, 432, 437, 432, 481,
        432, 432, 432, 437, 438, 432, 486, 432,
        487, 488, 432, 118, 437, 438, 432, 432,
        121, 432, 120, 432, 480, 480, 432, 118,
        437, 438, 432, 480, 480, 432, 118, 437,
        438, 432, 486, 432, 480, 480, 432, 118,
        437, 438, 432, 486, 432, 487, 480, 432,
        118, 437, 438, 432, 432, 121, 432, 136,
        432, 489, 489, 123, 118, 437, 438, 432,
        432, 432, 444, 432, 490, 145, 491, 492,
        126, 118, 437, 438, 432, 432, 432, 444,
        432, 145, 491, 492, 126, 118, 437, 438,
        432, 432, 432, 444, 432, 491, 491, 126,
        118, 437, 438, 432, 432, 432, 444, 432,
        493, 142, 494, 495, 129, 118, 437, 438,
        432, 432, 432, 444, 432, 142, 494, 495,
        129, 118, 437, 438, 432, 432, 432, 444,
        432, 494, 494, 129, 118, 437, 438, 432,
        432, 432, 444, 432, 496, 139, 497, 498,
        132, 118, 437, 438, 432, 432, 432, 444,
        432, 139, 497, 498, 132, 118, 437, 438,
        432, 432, 432, 444, 432, 497, 497, 132,
        118, 437, 438, 432, 432, 432, 444, 432,
        499, 136, 480, 500, 432, 118, 437, 438,
        432, 432, 432, 444, 432, 136, 480, 500,
        432, 118, 437, 438, 432, 432, 432, 444,
        432, 480, 501, 432, 118, 437, 438, 432,
        432, 432, 444, 432, 136, 432, 480, 480,
        432, 118, 437, 438, 432, 432, 432, 444,
        432, 119, 120, 432, 432, 136, 479, 432,
        118, 437, 438, 432, 432, 432, 444, 432,
        119, 432, 473, 478, 478, 123, 118, 437,
        438, 432, 432, 432, 476, 432, 472, 473,
        478, 478, 123, 118, 437, 438, 432, 432,
        432, 476, 432, 432, 440, 432, 472, 473,
        474, 478, 123, 118, 437, 438, 432, 432,
        147, 476, 432, 432, 440, 432, 470, 432,
        502, 432, 489, 489, 123, 118, 437, 438,
        432, 432, 432, 444, 432, 470, 432, 470,
        432, 432, 432, 480, 480, 432, 118, 437,
        438, 432, 432, 432, 444, 432, 470, 432,
        470, 432, 432, 432, 480, 503, 432, 118,
        437, 438, 432, 432, 432, 444, 432, 470,
        432, 470, 432, 502, 432, 480, 480, 432,
        118, 437, 438, 432, 432, 432, 444, 432,
        470, 432, 470, 120, 432, 432, 136, 471,
        432, 118, 437, 438, 432, 432, 432, 444,
        432, 470, 432, 463, 464, 469, 469, 123,
        118, 437, 438, 432, 432, 432, 467, 432,
        432, 440, 432, 463, 464, 465, 469, 123,
        118, 437, 438, 432, 432, 149, 467, 432,
        432, 440, 432, 461, 432, 504, 432, 489,
        489, 123, 118, 437, 438, 432, 432, 432,
        444, 432, 461, 432, 461, 432, 432, 432,
        480, 480, 432, 118, 437, 438, 432, 432,
        432, 444, 432, 461, 432, 461, 432, 432,
        432, 480, 505, 432, 118, 437, 438, 432,
        432, 432, 444, 432, 461, 432, 461, 432,
        504, 432, 480, 480, 432, 118, 437, 438,
        432, 432, 432, 444, 432, 461, 432, 461,
        120, 432, 432, 136, 462, 432, 118, 437,
        438, 432, 432, 432, 444, 432, 461, 432,
        454, 455, 460, 460, 123, 118, 437, 438,
        432, 432, 432, 458, 432, 432, 440, 432,
        454, 455, 456, 460, 123, 118, 437, 438,
        432, 432, 151, 458, 432, 432, 440, 432,
        452, 432, 506, 432, 489, 489, 123, 118,
        437, 438, 432, 432, 432, 444, 432, 452,
        432, 452, 432, 432, 432, 480, 480, 432,
        118, 437, 438, 432, 432, 432, 444, 432,
        452, 432, 452, 432, 432, 432, 480, 507,
        432, 118, 437, 438, 432, 432, 432, 444,
        432, 452, 432, 452, 432, 506, 432, 480,
        480, 432, 118, 437, 438, 432, 432, 432,
        444, 432, 452, 432, 452, 120, 432, 432,
        136, 453, 432, 118, 437, 438, 432, 432,
        432, 444, 432, 452, 432, 445, 446, 451,
        451, 123, 118, 437, 438, 432, 432, 432,
        449, 432, 432, 440, 432, 445, 446, 447,
        451, 123, 118, 437, 438, 432, 432, 153,
        449, 432, 432, 440, 432, 442, 432, 508,
        432, 489, 489, 123, 118, 437, 438, 432,
        432, 432, 444, 432, 442, 432, 442, 432,
        432, 432, 480, 480, 432, 118, 437, 438,
        432, 432, 432, 444, 432, 442, 432, 442,
        432, 432, 432, 480, 509, 432, 118, 437,
        438, 432, 432, 432, 444, 432, 442, 432,
        442, 432, 508, 432, 480, 480, 432, 118,
        437, 438, 432, 432, 432, 444, 432, 442,
        432, 442, 120, 432, 432, 136, 443, 432,
        118, 437, 438, 432, 432, 432, 444, 432,
        442, 432, 433, 434, 436, 436, 123, 118,
        437, 438, 432, 432, 432, 439, 432, 432,
        440, 432, 188, 189, 190, 191, 510, 362,
        84, 79, 194, 195, 196, 196, 156, 197,
        360, 188, 200, 360, 203, 511, 205, 206,
        6, 1, 207, 208, 202, 202, 38, 209,
        202, 202, 210, 202, 213, 189, 190, 191,
        512, 513, 84, 157, 514, 515, 202, 196,
        156, 516, 202, 213, 200, 202, 116, 517,
        517, 84, 157, 207, 208, 202, 202, 156,
        518, 202, 519, 202, 202, 520, 514, 515,
        202, 514, 515, 202, 254, 202, 514, 521,
        202, 514, 522, 202, 514, 202, 519, 202,
        202, 202, 514, 515, 202, 523, 3, 360,
        360, 401, 430, 360, 79, 194, 195, 360,
        360, 360, 365, 360, 523, 360, 524, 367,
        525, 526, 84, 157, 514, 515, 202, 202,
        158, 370, 202, 202, 200, 202, 527, 367,
        528, 528, 84, 157, 514, 515, 202, 202,
        202, 370, 202, 202, 200, 202, 367, 528,
        528, 84, 157, 514, 515, 202, 202, 202,
        370, 202, 202, 200, 202, 524, 367, 528,
        528, 84, 157, 514, 515, 202, 202, 202,
        370, 202, 202, 200, 202, 524, 367, 525,
        528, 84, 157, 514, 515, 202, 202, 158,
        370, 202, 202, 200, 202, 213, 202, 279,
        116, 529, 529, 160, 157, 207, 208, 202,
        202, 202, 518, 202, 213, 202, 530, 184,
        531, 532, 162, 157, 514, 515, 202, 202,
        202, 533, 202, 184, 531, 532, 162, 157,
        514, 515, 202, 202, 202, 533, 202, 531,
        531, 162, 157, 514, 515, 202, 202, 202,
        533, 202, 534, 181, 535, 536, 165, 157,
        514, 515, 202, 202, 202, 533, 202, 181,
        535, 536, 165, 157, 514, 515, 202, 202,
        202, 533, 202, 535, 535, 165, 157, 514,
        515, 202, 202, 202, 533, 202, 537, 178,
        538, 539, 168, 157, 514, 515, 202, 202,
        202, 533, 202, 178, 538, 539, 168, 157,
        514, 515, 202, 202, 202, 533, 202, 538,
        538, 168, 157, 514, 515, 202, 202, 202,
        533, 202, 540, 175, 541, 542, 202, 157,
        514, 515, 202, 202, 202, 533, 202, 175,
        541, 542, 202, 157, 514, 515, 202, 202,
        202, 533, 202, 541, 541, 202, 157, 514,
        515, 202, 202, 202, 533, 202, 543, 202,
        544, 545, 202, 157, 514, 515, 202, 202,
        172, 202, 171, 202, 541, 541, 202, 157,
        514, 515, 202, 541, 541, 202, 157, 514,
        515, 202, 543, 202, 541, 541, 202, 157,
        514, 515, 202, 543, 202, 544, 541, 202,
        157, 514, 515, 202, 202, 172, 202, 523,
        171, 360, 360, 98, 364, 360, 79, 194,
        195, 360, 360, 360, 365, 360, 523, 360,
        547, 546, 548, 548, 546, 186, 549, 550,
        546, 548, 548, 546, 186, 549, 550, 546,
        551, 546, 546, 552, 549, 550, 546, 549,
        550, 546, 553, 546, 549, 554, 546, 549,
        555, 546, 549, 546, 551, 546, 546, 546,
        549, 550, 546, 0
};

static const short _indic_syllable_machine_trans_targs[] = {
        178, 200, 207, 209, 210, 4, 213, 5,
        7, 216, 8, 10, 219, 11, 13, 222,
        14, 16, 17, 199, 19, 20, 221, 22,
        23, 218, 25, 26, 215, 224, 228, 232,
        235, 239, 242, 246, 249, 253, 256, 178,
        279, 286, 288, 289, 41, 292, 42, 44,
        295, 45, 47, 298, 48, 50, 301, 51,
        53, 54, 278, 56, 57, 300, 59, 60,
        297, 62, 63, 294, 303, 307, 311, 314,
        318, 321, 325, 328, 332, 336, 178, 357,
        364, 366, 367, 78, 370, 178, 79, 81,
        373, 82, 84, 376, 85, 87, 379, 88,
        90, 91, 356, 93, 94, 378, 96, 97,
        375, 99, 100, 372, 381, 385, 389, 392,
        396, 399, 403, 406, 410, 178, 437, 444,
        446, 447, 114, 450, 115, 117, 453, 118,
        120, 456, 121, 123, 459, 124, 126, 127,
        436, 129, 130, 458, 132, 133, 455, 135,
        136, 452, 461, 465, 469, 472, 476, 479,
        483, 486, 490, 493, 414, 498, 509, 152,
        512, 154, 515, 155, 157, 518, 158, 160,
        521, 161, 524, 526, 527, 166, 167, 523,
        169, 170, 520, 172, 173, 517, 175, 176,
        514, 178, 532, 178, 179, 258, 337, 339,
        413, 415, 359, 360, 416, 412, 494, 495,
        384, 530, 178, 180, 182, 36, 257, 202,
        203, 255, 227, 181, 35, 183, 251, 1,
        184, 186, 34, 250, 248, 185, 33, 187,
        244, 188, 190, 32, 243, 241, 189, 31,
        191, 237, 192, 194, 30, 236, 234, 193,
        29, 195, 230, 196, 198, 28, 229, 226,
        197, 27, 212, 0, 201, 206, 178, 204,
        205, 208, 2, 211, 3, 214, 6, 24,
        217, 9, 21, 220, 12, 18, 223, 15,
        225, 231, 233, 238, 240, 245, 247, 252,
        254, 178, 259, 261, 73, 334, 281, 282,
        335, 306, 260, 72, 262, 330, 38, 263,
        265, 71, 329, 327, 264, 70, 266, 323,
        267, 269, 69, 322, 320, 268, 68, 270,
        316, 271, 273, 67, 315, 313, 272, 66,
        274, 309, 275, 277, 65, 308, 305, 276,
        64, 291, 37, 280, 285, 178, 283, 284,
        287, 39, 290, 40, 293, 43, 61, 296,
        46, 58, 299, 49, 55, 302, 52, 304,
        310, 312, 317, 319, 324, 326, 331, 333,
        178, 338, 109, 340, 408, 75, 341, 343,
        108, 407, 405, 342, 107, 344, 401, 345,
        347, 106, 400, 398, 346, 105, 348, 394,
        349, 351, 104, 393, 391, 350, 103, 352,
        387, 353, 355, 102, 386, 383, 354, 101,
        369, 74, 358, 363, 178, 361, 362, 365,
        76, 368, 77, 371, 80, 98, 374, 83,
        95, 377, 86, 92, 380, 89, 382, 388,
        390, 395, 397, 402, 404, 409, 411, 178,
        178, 417, 419, 146, 145, 439, 440, 492,
        464, 418, 420, 488, 111, 421, 423, 144,
        487, 485, 422, 143, 424, 481, 425, 427,
        142, 480, 478, 426, 141, 428, 474, 429,
        431, 140, 473, 471, 430, 139, 432, 467,
        433, 435, 138, 466, 463, 434, 137, 449,
        110, 438, 443, 178, 441, 442, 445, 112,
        448, 113, 451, 116, 134, 454, 119, 131,
        457, 122, 128, 460, 125, 462, 468, 470,
        475, 477, 482, 484, 489, 491, 147, 496,
        497, 511, 500, 501, 529, 148, 505, 499,
        504, 502, 503, 506, 507, 150, 510, 508,
        149, 151, 513, 153, 174, 163, 516, 156,
        171, 519, 159, 168, 522, 162, 165, 525,
        164, 528, 178, 531, 177, 534, 535, 533,
        538, 178, 536, 537
};

static const char _indic_syllable_machine_trans_actions[] = {
        1, 0, 2, 2, 2, 0, 2, 0,
        0, 2, 0, 0, 2, 0, 0, 2,
        0, 0, 0, 2, 0, 0, 2, 0,
        0, 2, 0, 0, 2, 2, 2, 2,
        2, 2, 2, 2, 2, 2, 2, 3,
        0, 2, 2, 2, 0, 2, 0, 0,
        2, 0, 0, 2, 0, 0, 2, 0,
        0, 0, 2, 0, 0, 2, 0, 0,
        2, 0, 0, 2, 2, 2, 2, 2,
        2, 2, 2, 2, 2, 2, 4, 0,
        2, 2, 2, 0, 2, 5, 0, 0,
        2, 0, 0, 2, 0, 0, 2, 0,
        0, 0, 2, 0, 0, 2, 0, 0,
        2, 0, 0, 2, 2, 6, 2, 6,
        2, 6, 2, 6, 2, 7, 0, 2,
        2, 2, 0, 2, 0, 0, 2, 0,
        0, 2, 0, 0, 2, 0, 0, 0,
        2, 0, 0, 2, 0, 0, 2, 0,
        0, 2, 2, 2, 2, 2, 2, 2,
        2, 2, 2, 2, 6, 0, 8, 0,
        2, 0, 2, 0, 0, 2, 0, 0,
        2, 0, 2, 2, 2, 0, 0, 2,
        0, 0, 2, 0, 0, 2, 0, 0,
        2, 9, 0, 12, 2, 2, 6, 2,
        13, 13, 0, 0, 2, 2, 6, 2,
        6, 2, 14, 2, 2, 0, 2, 0,
        0, 2, 2, 2, 0, 2, 2, 0,
        2, 2, 0, 2, 2, 2, 0, 2,
        2, 2, 2, 0, 2, 2, 2, 0,
        2, 2, 2, 2, 0, 2, 2, 2,
        0, 2, 2, 2, 2, 0, 2, 2,
        2, 0, 2, 0, 0, 0, 15, 0,
        0, 2, 0, 2, 0, 2, 0, 0,
        2, 0, 0, 2, 0, 0, 2, 0,
        2, 2, 2, 2, 2, 2, 2, 2,
        2, 16, 2, 2, 0, 2, 0, 0,
        2, 2, 2, 0, 2, 2, 0, 2,
        2, 0, 2, 2, 2, 0, 2, 2,
        2, 2, 0, 2, 2, 2, 0, 2,
        2, 2, 2, 0, 2, 2, 2, 0,
        2, 2, 2, 2, 0, 2, 2, 2,
        0, 2, 0, 0, 0, 17, 0, 0,
        2, 0, 2, 0, 2, 0, 0, 2,
        0, 0, 2, 0, 0, 2, 0, 2,
        2, 2, 2, 2, 2, 2, 2, 2,
        18, 6, 0, 6, 6, 0, 6, 2,
        0, 6, 2, 6, 0, 6, 6, 6,
        2, 0, 6, 2, 6, 0, 6, 6,
        6, 2, 0, 6, 2, 6, 0, 6,
        6, 6, 2, 0, 6, 2, 6, 0,
        6, 0, 0, 0, 19, 0, 0, 2,
        0, 2, 0, 2, 0, 0, 2, 0,
        0, 2, 0, 0, 2, 0, 2, 2,
        2, 2, 2, 2, 2, 2, 2, 20,
        21, 2, 2, 0, 0, 0, 0, 2,
        2, 2, 2, 2, 0, 2, 2, 0,
        2, 2, 2, 0, 2, 2, 2, 2,
        0, 2, 2, 2, 0, 2, 2, 2,
        2, 0, 2, 2, 2, 0, 2, 2,
        2, 2, 0, 2, 2, 2, 0, 2,
        0, 0, 0, 22, 0, 0, 2, 0,
        2, 0, 2, 0, 0, 2, 0, 0,
        2, 0, 0, 2, 0, 2, 2, 2,
        2, 2, 2, 2, 2, 2, 0, 0,
        8, 2, 0, 0, 2, 0, 2, 0,
        0, 0, 0, 8, 8, 0, 8, 8,
        0, 0, 2, 0, 0, 0, 2, 0,
        0, 2, 0, 0, 2, 0, 0, 2,
        0, 2, 23, 2, 0, 0, 0, 0,
        0, 24, 0, 0
};

static const char _indic_syllable_machine_to_state_actions[] = {
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 10, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0
};

static const char _indic_syllable_machine_from_state_actions[] = {
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 11, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0
};

static const short _indic_syllable_machine_eof_trans[] = {
        1, 1, 1, 1, 1, 1, 1, 1,
        1, 1, 1, 1, 1, 1, 1, 1,
        1, 1, 1, 1, 1, 1, 1, 1,
        1, 1, 1, 1, 1, 1, 1, 1,
        1, 1, 1, 1, 1, 40, 40, 40,
        40, 40, 40, 40, 40, 40, 40, 40,
        40, 40, 40, 40, 40, 40, 40, 40,
        40, 40, 40, 40, 40, 40, 40, 40,
        40, 40, 40, 40, 40, 40, 40, 40,
        40, 40, 79, 79, 79, 79, 86, 86,
        79, 79, 79, 79, 79, 79, 79, 79,
        79, 79, 79, 79, 79, 79, 79, 79,
        79, 79, 79, 79, 79, 79, 79, 79,
        79, 79, 79, 79, 79, 79, 118, 118,
        118, 118, 118, 118, 118, 118, 118, 118,
        118, 118, 118, 118, 118, 118, 118, 118,
        118, 118, 118, 118, 118, 118, 118, 118,
        118, 118, 118, 118, 118, 118, 118, 118,
        118, 118, 118, 79, 1, 1, 1, 1,
        1, 1, 1, 1, 1, 1, 1, 1,
        1, 1, 1, 1, 1, 1, 1, 1,
        1, 1, 1, 1, 1, 1, 1, 1,
        1, 186, 0, 203, 203, 203, 203, 203,
        203, 203, 203, 203, 203, 203, 203, 203,
        203, 203, 203, 203, 203, 203, 203, 203,
        203, 203, 203, 203, 203, 203, 203, 203,
        203, 203, 203, 203, 203, 203, 203, 203,
        203, 203, 203, 203, 203, 203, 203, 203,
        203, 203, 203, 203, 203, 203, 203, 203,
        203, 203, 203, 203, 203, 203, 203, 203,
        203, 203, 203, 203, 203, 203, 203, 203,
        203, 203, 203, 203, 203, 203, 203, 203,
        203, 203, 282, 282, 282, 282, 282, 282,
        282, 282, 282, 282, 282, 282, 282, 282,
        282, 282, 282, 282, 282, 282, 282, 282,
        282, 282, 282, 282, 282, 282, 282, 282,
        282, 282, 282, 282, 282, 282, 282, 282,
        282, 282, 282, 282, 282, 282, 282, 282,
        282, 282, 282, 282, 282, 282, 282, 282,
        282, 282, 282, 282, 282, 282, 282, 282,
        282, 282, 282, 282, 282, 282, 282, 282,
        282, 282, 282, 282, 282, 282, 282, 282,
        282, 361, 361, 361, 361, 361, 361, 361,
        361, 361, 361, 361, 361, 361, 361, 361,
        361, 361, 361, 361, 361, 361, 361, 361,
        361, 361, 361, 361, 361, 361, 361, 361,
        361, 361, 361, 361, 361, 361, 361, 361,
        361, 361, 361, 361, 361, 361, 361, 361,
        361, 361, 361, 361, 361, 361, 361, 361,
        361, 361, 361, 361, 361, 361, 361, 361,
        361, 361, 361, 361, 361, 361, 361, 361,
        361, 361, 361, 361, 361, 432, 361, 432,
        433, 433, 433, 433, 433, 433, 433, 433,
        433, 433, 433, 433, 433, 433, 433, 433,
        433, 433, 433, 433, 433, 433, 433, 433,
        433, 433, 433, 433, 433, 433, 433, 433,
        433, 433, 433, 433, 433, 433, 433, 433,
        433, 433, 433, 433, 433, 433, 433, 433,
        433, 433, 433, 433, 433, 433, 433, 433,
        433, 433, 433, 433, 433, 433, 433, 433,
        433, 433, 433, 433, 433, 433, 433, 433,
        433, 433, 433, 433, 433, 433, 361, 203,
        203, 203, 203, 203, 203, 203, 203, 203,
        203, 361, 203, 203, 203, 203, 203, 203,
        203, 203, 203, 203, 203, 203, 203, 203,
        203, 203, 203, 203, 203, 203, 203, 203,
        203, 361, 547, 547, 547, 547, 547, 547,
        547, 547, 547
};

static const int indic_syllable_machine_start = 178;
static const int indic_syllable_machine_first_final = 178;
static const int indic_syllable_machine_error = -1;

static const int indic_syllable_machine_en_main = 178;


#line 36 "hb-ot-shape-complex-indic-machine.rl"



#line 96 "hb-ot-shape-complex-indic-machine.rl"


#define found_syllable(syllable_type) \
  HB_STMT_START { \
    if (0) fprintf (stderr, "syllable %d..%d %s\n", last, p+1, #syllable_type); \
    for (unsigned int i = last; i < p+1; i++) \
      info[i].syllable() = (syllable_serial << 4) | syllable_type; \
    last = p+1; \
    syllable_serial++; \
    if (unlikely (syllable_serial == 16)) syllable_serial = 1; \
  } HB_STMT_END

static void
find_syllables (hb_buffer_t *buffer)
{
  unsigned int p, pe, eof, ts HB_UNUSED, te HB_UNUSED, act HB_UNUSED;
  int cs;
  hb_glyph_info_t *info = buffer->info;

#line 1382 "hb-ot-shape-complex-indic-machine.hh"
        {
        cs = indic_syllable_machine_start;
        ts = 0;
        te = 0;
        act = 0;
        }

#line 117 "hb-ot-shape-complex-indic-machine.rl"


  p = 0;
  pe = eof = buffer->len;

  unsigned int last = 0;
  unsigned int syllable_serial = 1;

#line 1399 "hb-ot-shape-complex-indic-machine.hh"
        {
        int _slen;
        int _trans;
        const unsigned char *_keys;
        const short *_inds;
        if ( p == pe )
                goto _test_eof;
_resume:
        switch ( _indic_syllable_machine_from_state_actions[cs] ) {
        case 11:
#line 1 "NONE"
        {ts = p;}
        break;
#line 1413 "hb-ot-shape-complex-indic-machine.hh"
        }

        _keys = _indic_syllable_machine_trans_keys + (cs<<1);
        _inds = _indic_syllable_machine_indicies + _indic_syllable_machine_index_offsets[cs];

        _slen = _indic_syllable_machine_key_spans[cs];
        _trans = _inds[ _slen > 0 && _keys[0] <=( info[p].indic_category()) &&
                ( info[p].indic_category()) <= _keys[1] ?
                ( info[p].indic_category()) - _keys[0] : _slen ];

_eof_trans:
        cs = _indic_syllable_machine_trans_targs[_trans];

        if ( _indic_syllable_machine_trans_actions[_trans] == 0 )
                goto _again;

        switch ( _indic_syllable_machine_trans_actions[_trans] ) {
        case 2:
#line 1 "NONE"
        {te = p+1;}
        break;
        case 15:
#line 87 "hb-ot-shape-complex-indic-machine.rl"
        {te = p+1;{ found_syllable (consonant_syllable); }}
        break;
        case 17:
#line 88 "hb-ot-shape-complex-indic-machine.rl"
        {te = p+1;{ found_syllable (vowel_syllable); }}
        break;
        case 22:
#line 89 "hb-ot-shape-complex-indic-machine.rl"
        {te = p+1;{ found_syllable (standalone_cluster); }}
        break;
        case 24:
#line 90 "hb-ot-shape-complex-indic-machine.rl"
        {te = p+1;{ found_syllable (symbol_cluster); }}
        break;
        case 19:
#line 91 "hb-ot-shape-complex-indic-machine.rl"
        {te = p+1;{ found_syllable (broken_cluster); }}
        break;
        case 12:
#line 92 "hb-ot-shape-complex-indic-machine.rl"
        {te = p+1;{ found_syllable (non_indic_cluster); }}
        break;
        case 14:
#line 87 "hb-ot-shape-complex-indic-machine.rl"
        {te = p;p--;{ found_syllable (consonant_syllable); }}
        break;
        case 16:
#line 88 "hb-ot-shape-complex-indic-machine.rl"
        {te = p;p--;{ found_syllable (vowel_syllable); }}
        break;
        case 21:
#line 89 "hb-ot-shape-complex-indic-machine.rl"
        {te = p;p--;{ found_syllable (standalone_cluster); }}
        break;
        case 23:
#line 90 "hb-ot-shape-complex-indic-machine.rl"
        {te = p;p--;{ found_syllable (symbol_cluster); }}
        break;
        case 18:
#line 91 "hb-ot-shape-complex-indic-machine.rl"
        {te = p;p--;{ found_syllable (broken_cluster); }}
        break;
        case 20:
#line 92 "hb-ot-shape-complex-indic-machine.rl"
        {te = p;p--;{ found_syllable (non_indic_cluster); }}
        break;
        case 1:
#line 87 "hb-ot-shape-complex-indic-machine.rl"
        {{p = ((te))-1;}{ found_syllable (consonant_syllable); }}
        break;
        case 3:
#line 88 "hb-ot-shape-complex-indic-machine.rl"
        {{p = ((te))-1;}{ found_syllable (vowel_syllable); }}
        break;
        case 7:
#line 89 "hb-ot-shape-complex-indic-machine.rl"
        {{p = ((te))-1;}{ found_syllable (standalone_cluster); }}
        break;
        case 9:
#line 90 "hb-ot-shape-complex-indic-machine.rl"
        {{p = ((te))-1;}{ found_syllable (symbol_cluster); }}
        break;
        case 4:
#line 91 "hb-ot-shape-complex-indic-machine.rl"
        {{p = ((te))-1;}{ found_syllable (broken_cluster); }}
        break;
        case 5:
#line 1 "NONE"
        {       switch( act ) {
        case 1:
        {{p = ((te))-1;} found_syllable (consonant_syllable); }
        break;
        case 5:
        {{p = ((te))-1;} found_syllable (broken_cluster); }
        break;
        case 6:
        {{p = ((te))-1;} found_syllable (non_indic_cluster); }
        break;
        }
        }
        break;
        case 8:
#line 1 "NONE"
        {te = p+1;}
#line 87 "hb-ot-shape-complex-indic-machine.rl"
        {act = 1;}
        break;
        case 6:
#line 1 "NONE"
        {te = p+1;}
#line 91 "hb-ot-shape-complex-indic-machine.rl"
        {act = 5;}
        break;
        case 13:
#line 1 "NONE"
        {te = p+1;}
#line 92 "hb-ot-shape-complex-indic-machine.rl"
        {act = 6;}
        break;
#line 1536 "hb-ot-shape-complex-indic-machine.hh"
        }

_again:
        switch ( _indic_syllable_machine_to_state_actions[cs] ) {
        case 10:
#line 1 "NONE"
        {ts = 0;}
        break;
#line 1545 "hb-ot-shape-complex-indic-machine.hh"
        }

        if ( ++p != pe )
                goto _resume;
        _test_eof: {}
        if ( p == eof )
        {
        if ( _indic_syllable_machine_eof_trans[cs] > 0 ) {
                _trans = _indic_syllable_machine_eof_trans[cs] - 1;
                goto _eof_trans;
        }
        }

        }

#line 126 "hb-ot-shape-complex-indic-machine.rl"

}

#endif /* HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH */
