/*
 * Copyright (c) 2018, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


/*
 * @test
 *
 * @summary converted from VM Testbase nsk/jvmti/unit/FollowReferences/followref004.
 * VM Testbase keywords: [quick, jpda, jvmti, noras, feature_jdk6_jpda, vm6]
 * VM Testbase readme:
 * DESCRIPTION
 *     The test excersizes FollowReferences() function. The following checks are performed:
 *     * user_data points to the data supplied to FollowReferences()
 *     * all tagged objects has been iterated
 *     A mesh of objects of all nearly kinds is created by nsk.jvmti.FollowRefObjects class.
 *     TODO:
 *       - implement reference kind checking
 *       - add ProtectionDomain and Signers classes to the mesh
 *       - compare object sizes
 * COMMENTS
 *
 * @library /vmTestbase
 *          /test/lib
 * @build ExecDriver
 *      nsk.jvmti.unit.FollowReferences.followref004
 * @run main/othervm/native PropertyResolvingWrapper ExecDriver --java
 *      "-agentlib:followref004=-waittime=5 -verbose"
 *      nsk.jvmti.unit.FollowReferences.followref004
 */

