/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractPlayer;
import com.sun.media.sound.MixerSequencer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

/*
 * Exception performing whole class analysis ignored.
 */
class MixerSequencer
extends AbstractPlayer
implements Sequencer {
    private static final int MIDI_TYPE_0 = 0;
    private static final int MIDI_TYPE_1 = 1;
    private static final int MIDI_TYPE_2 = 2;
    static final MixerSequencerInfo info = new MixerSequencerInfo(null);
    private static Sequencer.SyncMode[] masterSyncModes = new Sequencer.SyncMode[]{Sequencer.SyncMode.INTERNAL_CLOCK};
    private static Sequencer.SyncMode[] slaveSyncModes = new Sequencer.SyncMode[]{Sequencer.SyncMode.NO_SYNC};
    private static Sequencer.SyncMode masterSyncMode = Sequencer.SyncMode.INTERNAL_CLOCK;
    private static Sequencer.SyncMode slaveSyncMode = Sequencer.SyncMode.NO_SYNC;
    private long timeStamp = -1L;
    private Sequence sequence = null;
    private byte[] midiData = null;
    private boolean runningInEngine = false;
    private boolean newSequenceStarted = false;
    private long tick = -1L;
    private float tempoInBPM = -1.0f;
    private float tempoInMPQ = -1.0f;
    private float tempoFactor = -1.0f;
    private boolean running = false;
    private boolean recording = false;
    private boolean sequenceChanged = false;
    private long startTime = 0L;
    private long startMillisecondTime = 0L;
    private long lastTempoChangeTime = 0L;
    private long lastTempoChangeTick = 0L;
    private long recordTempoInMPQ = 500000L;
    private long startTick = 0L;
    private float divisionType = 0.0f;
    private int resolution = 0;
    private SequencerReceiver sequencerReceiver = null;
    private Vector recordingTracks = new Vector();
    private Vector metaEventListeners = new Vector();
    private Vector controllerEventListeners = new Vector();

    protected MixerSequencer() throws MidiUnavailableException {
        super((MidiDevice.Info)info);
    }

    public synchronized void setSequence(Sequence sequence) throws InvalidMidiDataException {
        if (!this.isOpen()) {
            throw new IllegalStateException("Cannot set sequence until sequencer has been opened");
        }
        int[] nArray = MidiSystem.getMidiFileTypes(sequence);
        if (nArray.length == 0) {
            throw new InvalidMidiDataException("Unsupported sequence: " + sequence);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            MidiSystem.write(sequence, nArray[0], byteArrayOutputStream);
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            throw new InvalidMidiDataException("Unable to get file stream from sequence: " + sequence);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            this.setSequence(byteArrayInputStream);
            this.sequence = sequence;
        }
        catch (IOException iOException) {
            throw new InvalidMidiDataException("Failed to load sequence: " + sequence);
        }
    }

    public synchronized void setSequence(InputStream inputStream) throws IOException, InvalidMidiDataException {
        int n;
        if (!this.isOpen()) {
            throw new IllegalStateException("Cannot set sequence until sequencer has been opened");
        }
        MidiFileFormat midiFileFormat = MidiSystem.getMidiFileFormat(inputStream);
        int n2 = midiFileFormat.getType();
        if (n2 == 2) {
            throw new InvalidMidiDataException("Unsupported file type: " + n2 + ". Only type 0 and type 1 MIDI files are supported.");
        }
        if (this.id != 0L) {
            this.stop();
            this.implClose();
            try {
                this.implOpen();
            }
            catch (MidiUnavailableException midiUnavailableException) {
                // empty catch block
            }
        }
        this.midiData = this.getBytesFromFileStream(inputStream, midiFileFormat);
        if (this.midiData == null || this.midiData.length == 0) {
            throw new IOException("Failed to read data from stream.");
        }
        if (n2 == 0 || n2 == 1) {
            this.id = this.nOpenMidiSequencer(this.midiData, this.midiData.length);
            if (this.id == 0L) {
                this.id = this.nOpenRmfSequencer(this.midiData, this.midiData.length);
            }
        }
        if (this.id == 0L) {
            throw new InvalidMidiDataException("Failed to load sequence");
        }
        for (n = 0; n < this.channels.length; ++n) {
            this.channels[n].setId(this.id);
        }
        this.connectToInternalSynth();
        if (this.tempoFactor != -1.0f) {
            this.setTempoFactor(this.tempoFactor);
        }
        for (n = 0; n < this.controllerEventListeners.size(); ++n) {
            ControllerVectorElement controllerVectorElement = (ControllerVectorElement)this.controllerEventListeners.elementAt(n);
            for (int i = 0; i < controllerVectorElement.controllers.length; ++i) {
                this.nAddControllerEventCallback(this.id, controllerVectorElement.controllers[i]);
            }
        }
    }

    public Sequence getSequence() {
        if (this.sequence == null && this.midiData != null && this.midiData.length > 0) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.midiData);
            try {
                this.sequence = MidiSystem.getSequence(byteArrayInputStream);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.sequence;
    }

    public synchronized void start() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        if (this.id == 0L) {
            return;
        }
        if (this.running) {
            return;
        }
        if (this.sequenceChanged) {
            try {
                this.setSequence(this.sequence);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                // empty catch block
            }
            this.sequenceChanged = false;
        }
        this.running = true;
        if (!this.newSequenceStarted) {
            this.nStartSequencer(this.id);
            this.newSequenceStarted = true;
            if (this.tick != -1L) {
                this.setTickPosition(this.tick);
            }
            if (this.tempoInBPM != -1.0f) {
                this.setTempoInBPM(this.tempoInBPM);
            }
            if (this.tempoInMPQ != -1.0f) {
                this.setTempoInMPQ(this.tempoInMPQ);
            }
        } else {
            if (this.tick != -1L) {
                this.setTickPosition(this.tick);
            } else if (!this.runningInEngine) {
                this.setMicrosecondPosition(0L);
            }
            this.nResumeSequencer(this.id);
        }
        this.runningInEngine = true;
        this.callbackSongStart();
    }

    public synchronized void stop() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        this.stopRecording();
        if (this.id == 0L) {
            return;
        }
        if (!this.running) {
            return;
        }
        this.implStop();
        this.callbackSongStop();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void startRecording() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        this.recording = true;
        this.divisionType = this.sequence.getDivisionType();
        this.resolution = this.sequence.getResolution();
        this.startTime = System.currentTimeMillis();
        this.startMillisecondTime = this.getMicrosecondPosition() / 1000L;
        this.startTick = 0L;
        this.lastTempoChangeTime = 0L;
        this.lastTempoChangeTick = this.startTick;
        this.recordTempoInMPQ = (long)this.getTempoInMPQ();
        this.start();
        this.startMillisecondTime = this.getMicrosecondPosition() / 1000L;
    }

    public void stopRecording() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        if (this.recording) {
            this.sequenceChanged = true;
        }
        this.recording = false;
    }

    public boolean isRecording() {
        return this.recording;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordEnable(Track track, int n) {
        if (!this.findTrack(track)) {
            throw new IllegalArgumentException("Track does not exist in the current sequence");
        }
        Vector vector = this.recordingTracks;
        synchronized (vector) {
            RecordingTrack recordingTrack = RecordingTrack.get((Vector)this.recordingTracks, (Track)track);
            if (recordingTrack != null) {
                recordingTrack.channel = n;
            } else {
                this.recordingTracks.addElement(new RecordingTrack(track, n));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordDisable(Track track) {
        Vector vector = this.recordingTracks;
        synchronized (vector) {
            RecordingTrack recordingTrack = RecordingTrack.get((Vector)this.recordingTracks, (Track)track);
            if (recordingTrack != null) {
                this.recordingTracks.removeElement(recordingTrack);
            }
        }
    }

    private boolean findTrack(Track track) {
        boolean bl = false;
        if (this.sequence != null) {
            Track[] trackArray = this.sequence.getTracks();
            for (int i = 0; i < trackArray.length; ++i) {
                if (track != trackArray[i]) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public float getTempoInBPM() {
        if (this.id == 0L || !this.newSequenceStarted) {
            if (this.tempoInBPM != -1.0f) {
                return this.tempoInBPM;
            }
            if (this.tempoInMPQ != -1.0f) {
                return 6.0E7f / this.tempoInMPQ;
            }
            if (this.id == 0L) {
                return 0.0f;
            }
        }
        return this.nGetTempoInBPM(this.id);
    }

    public void setTempoInBPM(float f) {
        if (this.id == 0L || !this.newSequenceStarted) {
            this.tempoInBPM = f;
            this.tempoInMPQ = -1.0f;
            return;
        }
        this.nSetTempoInBPM(this.id, (int)f);
        this.tempoInBPM = -1.0f;
        this.tempoInMPQ = -1.0f;
    }

    public float getTempoInMPQ() {
        if (this.id == 0L || !this.newSequenceStarted) {
            if (this.tempoInMPQ != -1.0f) {
                return this.tempoInMPQ;
            }
            if (this.tempoInBPM != -1.0f) {
                return 6.0E7f / this.tempoInBPM;
            }
            if (this.id == 0L) {
                return 0.0f;
            }
        }
        return this.nGetTempoInMPQ(this.id);
    }

    public void setTempoInMPQ(float f) {
        if (this.id == 0L || !this.newSequenceStarted) {
            this.tempoInMPQ = f;
            this.tempoInBPM = -1.0f;
            return;
        }
        this.nSetTempoInMPQ(this.id, (int)f);
        this.tempoInBPM = -1.0f;
        this.tempoInMPQ = -1.0f;
    }

    public void setTempoFactor(float f) {
        if (this.id == 0L) {
            if (f > 0.0f) {
                this.tempoFactor = f;
            }
            return;
        }
        this.nSetMasterTempo(this.id, f);
        this.tempoFactor = -1.0f;
    }

    public float getTempoFactor() {
        if (this.id == 0L) {
            if (this.tempoFactor != -1.0f) {
                return this.tempoFactor;
            }
            return 0.0f;
        }
        return this.nGetMasterTempo(this.id);
    }

    public long getTickLength() {
        if (this.id == 0L) {
            return 0L;
        }
        return this.nGetSequenceTickLength(this.id) / 64L;
    }

    public synchronized long getTickPosition() {
        if (this.id == 0L) {
            return 0L;
        }
        return this.nGetSequencerTickPosition(this.id) / 64L;
    }

    public synchronized void setTickPosition(long l) {
        if (this.id == 0L) {
            return;
        }
        if (!this.running) {
            this.tick = l * 64L;
        } else {
            this.nSetSequencerTickPosition(this.id, l * 64L);
            this.tick = -1L;
        }
    }

    public long getMicrosecondLength() {
        if (this.id == 0L) {
            return 0L;
        }
        return this.nGetSequenceMicrosecondLength(this.id);
    }

    public long getMicrosecondPosition() {
        if (this.id == 0L) {
            return 0L;
        }
        return this.nGetSequencerMicrosecondPosition(this.id);
    }

    public void setMicrosecondPosition(long l) {
        if (this.id == 0L) {
            return;
        }
        this.nSetSequencerMicrosecondPosition(this.id, l);
        this.tick = -1L;
    }

    public void setMasterSyncMode(Sequencer.SyncMode syncMode) {
    }

    public Sequencer.SyncMode getMasterSyncMode() {
        return masterSyncMode;
    }

    public Sequencer.SyncMode[] getMasterSyncModes() {
        Sequencer.SyncMode[] syncModeArray = new Sequencer.SyncMode[masterSyncModes.length];
        System.arraycopy(masterSyncModes, 0, syncModeArray, 0, masterSyncModes.length);
        return syncModeArray;
    }

    public void setSlaveSyncMode(Sequencer.SyncMode syncMode) {
    }

    public Sequencer.SyncMode getSlaveSyncMode() {
        return slaveSyncMode;
    }

    public Sequencer.SyncMode[] getSlaveSyncModes() {
        Sequencer.SyncMode[] syncModeArray = new Sequencer.SyncMode[slaveSyncModes.length];
        System.arraycopy(slaveSyncModes, 0, syncModeArray, 0, slaveSyncModes.length);
        return syncModeArray;
    }

    protected int getTrackCount() {
        Sequence sequence = this.getSequence();
        if (sequence != null) {
            return this.sequence.getTracks().length;
        }
        return 0;
    }

    public void setTrackMute(int n, boolean bl) {
        if (this.id == 0L || n < 0 || n >= this.getTrackCount()) {
            return;
        }
        this.nSetTrackMute(this.id, n, bl);
    }

    public boolean getTrackMute(int n) {
        if (this.id == 0L || n < 0 || n >= this.getTrackCount()) {
            return false;
        }
        return this.nGetTrackMute(this.id, n);
    }

    public void setTrackSolo(int n, boolean bl) {
        if (this.id == 0L || n < 0 || n >= this.getTrackCount()) {
            return;
        }
        this.nSetTrackSolo(this.id, n, bl);
    }

    public boolean getTrackSolo(int n) {
        if (this.id == 0L || n < 0 || n >= this.getTrackCount()) {
            return false;
        }
        return this.nGetTrackSolo(this.id, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMetaEventListener(MetaEventListener metaEventListener) {
        Vector vector = this.metaEventListeners;
        synchronized (vector) {
            if (!this.metaEventListeners.contains(metaEventListener)) {
                this.metaEventListeners.addElement(metaEventListener);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetaEventListener(MetaEventListener metaEventListener) {
        Vector vector = this.metaEventListeners;
        synchronized (vector) {
            this.metaEventListeners.removeElement(metaEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] addControllerEventListener(ControllerEventListener controllerEventListener, int[] nArray) {
        Vector vector = this.controllerEventListeners;
        synchronized (vector) {
            int n;
            ControllerVectorElement controllerVectorElement = null;
            boolean bl = false;
            for (n = 0; n < this.controllerEventListeners.size(); ++n) {
                controllerVectorElement = (ControllerVectorElement)this.controllerEventListeners.elementAt(n);
                if (!controllerVectorElement.listener.equals(controllerEventListener)) continue;
                ControllerVectorElement.access$100((ControllerVectorElement)controllerVectorElement, (int[])nArray);
                bl = true;
                break;
            }
            if (!bl) {
                controllerVectorElement = new ControllerVectorElement(this, controllerEventListener, nArray, null);
                this.controllerEventListeners.addElement(controllerVectorElement);
            }
            if (this.id != 0L) {
                for (n = 0; n < nArray.length; ++n) {
                    this.nAddControllerEventCallback(this.id, nArray[n]);
                }
            }
            return ControllerVectorElement.access$300((ControllerVectorElement)controllerVectorElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] removeControllerEventListener(ControllerEventListener controllerEventListener, int[] nArray) {
        Vector vector = this.controllerEventListeners;
        synchronized (vector) {
            ControllerVectorElement controllerVectorElement = null;
            boolean bl = false;
            for (int i = 0; i < this.controllerEventListeners.size(); ++i) {
                controllerVectorElement = (ControllerVectorElement)this.controllerEventListeners.elementAt(i);
                if (!controllerVectorElement.listener.equals(controllerEventListener)) continue;
                ControllerVectorElement.access$400((ControllerVectorElement)controllerVectorElement, (int[])nArray);
                bl = true;
                break;
            }
            if (!bl) {
                return new int[0];
            }
            if (nArray == null) {
                this.controllerEventListeners.removeElement(controllerVectorElement);
                return new int[0];
            }
            return ControllerVectorElement.access$300((ControllerVectorElement)controllerVectorElement);
        }
    }

    public long getTimeStamp() {
        return this.getMicrosecondPosition();
    }

    public void setTimeStamp(long l) {
    }

    public synchronized Receiver getReceiver() throws MidiUnavailableException {
        if (this.sequencerReceiver == null) {
            this.sequencerReceiver = new SequencerReceiver(this);
        }
        return this.sequencerReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void implClose() {
        this.implStop();
        super.implClose();
        this.sequence = null;
        this.running = false;
        this.newSequenceStarted = false;
        while (this.runningInEngine) {
            MixerSequencer mixerSequencer = this;
            synchronized (mixerSequencer) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void implOpen() throws MidiUnavailableException {
        this.openInternalSynth();
    }

    protected void implStop() {
        this.nPauseSequencer(this.id);
        this.running = false;
    }

    protected void sendMetaEvents(MetaMessage metaMessage) {
        eventDispatcher.sendAudioEvents(metaMessage, this.metaEventListeners);
    }

    protected void sendControllerEvents(ShortMessage shortMessage, int n) {
        Vector<ControllerEventListener> vector = new Vector<ControllerEventListener>();
        block0: for (int i = 0; i < this.controllerEventListeners.size(); ++i) {
            ControllerVectorElement controllerVectorElement = (ControllerVectorElement)this.controllerEventListeners.elementAt(i);
            for (int j = 0; j < controllerVectorElement.controllers.length; ++j) {
                if (controllerVectorElement.controllers[j] != n) continue;
                vector.addElement(controllerVectorElement.listener);
                continue block0;
            }
        }
        eventDispatcher.sendAudioEvents(shortMessage, vector);
    }

    private long calculateTickPosition(long l) {
        if (this.divisionType == 0.0f) {
            long l2 = l - this.lastTempoChangeTime;
            long l3 = l2 >= 0L ? this.lastTempoChangeTick + l2 * (long)this.resolution * 1000L / this.recordTempoInMPQ : l * (long)this.resolution * 1000L / this.recordTempoInMPQ;
            return l3;
        }
        return (long)((float)l * this.divisionType * (float)this.resolution / 1000.0f);
    }

    protected byte[] getBytesFromFileStream(InputStream inputStream, MidiFileFormat midiFileFormat) throws IOException {
        byte[] byArray;
        if (inputStream == null) {
            throw new IOException("Stream is null");
        }
        long l = midiFileFormat.getByteLength();
        if (l != -1L) {
            byArray = new byte[(int)l];
            if ((long)inputStream.read(byArray) != l) {
                throw new IOException("Read failure: expected " + l + " bytes");
            }
        } else {
            int n = 2048;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            int n2 = n;
            byte[] byArray2 = new byte[n2];
            int n3 = 0;
            int n4 = 0;
            while (true) {
                if ((n4 = inputStream.read(byArray2, 0, n2)) == -1) {
                    if (n3 != 0) break;
                    throw new IOException("No data found in stream");
                }
                dataOutputStream.write(byArray2, 0, n4);
                n3 += n4;
                Thread.currentThread();
                Thread.yield();
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void callbackSongEnd() {
        this.implStop();
        this.runningInEngine = false;
        Object object = this;
        synchronized (object) {
            this.notifyAll();
        }
        object = new MetaMessage();
        try {
            ((MetaMessage)object).setMessage(47, new byte[0], 0);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
        this.sendMetaEvents((MetaMessage)object);
    }

    private void callbackSongStart() {
    }

    private void callbackSongStop() {
    }

    private void callbackMetaEvent(int n, int n2, int n3, byte[] byArray) {
        MetaMessage metaMessage = new MetaMessage();
        try {
            metaMessage.setMessage(n, byArray, n2);
            this.sendMetaEvents(metaMessage);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    private void callbackControllerEvent(int n, int n2, int n3, int n4) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(176 + n, n3, n4);
            this.sendControllerEvents(shortMessage, n3);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    protected native long nOpenMidiSequencer(byte[] var1, int var2);

    protected native long nOpenRmfSequencer(byte[] var1, int var2);

    protected native void nStartSequencer(long var1);

    protected native void nPauseSequencer(long var1);

    protected native void nResumeSequencer(long var1);

    protected native void nAddControllerEventCallback(long var1, int var3);

    protected native long nGetSequencerTickPosition(long var1);

    protected native long nSetSequencerTickPosition(long var1, long var3);

    protected native long nGetSequencerMicrosecondPosition(long var1);

    protected native long nSetSequencerMicrosecondPosition(long var1, long var3);

    protected native int nGetTempoInBPM(long var1);

    protected native int nSetTempoInBPM(long var1, int var3);

    protected native int nGetTempoInMPQ(long var1);

    protected native int nSetTempoInMPQ(long var1, int var3);

    protected native float nGetMasterTempo(long var1);

    protected native float nSetMasterTempo(long var1, float var3);

    protected native void nSetTrackMute(long var1, int var3, boolean var4);

    protected native boolean nGetTrackMute(long var1, int var3);

    protected native void nSetTrackSolo(long var1, int var3, boolean var4);

    protected native boolean nGetTrackSolo(long var1, int var3);

    protected native long nGetSequenceTickLength(long var1);

    protected native long nGetSequenceMicrosecondLength(long var1);

    static /* synthetic */ boolean access$500(MixerSequencer mixerSequencer) {
        return mixerSequencer.recording;
    }

    static /* synthetic */ boolean access$600(MixerSequencer mixerSequencer) {
        return mixerSequencer.running;
    }

    static /* synthetic */ long access$700(MixerSequencer mixerSequencer, long l) {
        return mixerSequencer.calculateTickPosition(l);
    }

    static /* synthetic */ long access$800(MixerSequencer mixerSequencer) {
        return mixerSequencer.startMillisecondTime;
    }

    static /* synthetic */ long access$900(MixerSequencer mixerSequencer) {
        return mixerSequencer.startTime;
    }

    static /* synthetic */ Vector access$1000(MixerSequencer mixerSequencer) {
        return mixerSequencer.recordingTracks;
    }
}

