/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_VARIABLES_MANAGER_P_H
#define _GTLCORE_VARIABLES_MANAGER_P_H

namespace llvm {
  class Value;
}

namespace GTLCore {
  class ScopedName;
  class String;
  class VariableNG;
  namespace AST {
    class Statement;
  }
  /**
   * @internal
   * The variable manager is a class that manages the variable of a function
   * when parsing code.
   * @ingroup GTLCore
   */
  class VariablesManager {
    public:
      VariablesManager();
      ~VariablesManager();
      VariableNG* getVariable( const ScopedName&  ) const;
      bool hasVariableInCurrentContext( const ScopedName&  ) const;
      void setNameSpace( const String& _nameSpace);
      void declareParameter( const ScopedName& , VariableNG* );
      void declareVariable( const ScopedName& , VariableNG* );
      void declareConstant( const ScopedName& , VariableNG* );
      void startContext();
      void endContext();
      void reset();
      AST::Statement* garbageCollectCurrentContext() const;
      AST::Statement* garbageCollectEverything( ) const;
    private:
      struct Context;
      struct Private;
      Private* const d;
  };
}

#endif
