/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_TYPESMANAGER_P_H
#define _GTLCORE_TYPESMANAGER_P_H

#include "GTLCore/TypesManager.h"
#include "GTLCore/Type.h"

#include <map>

namespace GTLCore {
  /**
   * @internal
   * 
   * @ingroup GTLCore
   */
  struct TypesManager::Private {
    std::map< GTLCore::String, const GTLCore::Type*> knownTypes;
    static std::map< const GTLCore::Type*, const GTLCore::Type*> knownArrays;
    static std::map< const GTLCore::Type*, std::map< int, const GTLCore::Type* > > knownVectors;
    /**
      * @param name the name of the type
      * @return true if the name given as argument is the name of a known type
      *         for this manager
      */
    bool isKnownType(const GTLCore::String& name) const;
    const GTLCore::Type* createStructure( const GTLCore::String& name, const std::vector<GTLCore::Type::StructDataMember>& members);
  };
}

#endif
