/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_METADATA_GROUP_H_
#define _GTLCORE_METADATA_GROUP_H_

#include <GTLCore/Metadata/Entry.h>

namespace OpenShiva {
  class Metadata;
}

namespace GTLCore {
  namespace Metadata {
    /**
     * @ingroup GTLCore_Metadata
     */
    class Group : public Entry {
        friend class Factory;
        friend class ParameterEntry;
        friend class OpenShiva::Metadata;
        Group( const GTLCore::String& _name, const std::list< const Entry* >& _entries);
        virtual ~Group();
      public:
        const Entry* entry( const GTLCore::String& _name ) const;
        const std::list< const Entry* >& entries() const;
        const GTLCore::String& label() const;
        virtual const Group* asGroup() const;
      private:
        struct Private;
        Private* const d;
    };
  }
}

#endif
