/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_MACROS_H_
#define _GTLCORE_MACROS_H_

/**
 * The GTL_DEPRECATED macro can be used to trigger compile-time warnings when a deprecated
 * functions are used.
 * 
 * For non-inline functions, the macro has to be inserted at the end of the declaration like in :
 * @code
 * DeprecatedConstructor() GTL_DEPRECATED;
 * void deprecatedFunction() const GTL_DEPRECATED;
 * @endcode
 * 
 * For inline functions, the macro has to be inserted before the declartion but after virtual or
 * static keywoard, like in :
 * @code
 * GTL_DEPRECATED void deprecatedInline() { ... }
 * virtual GTL_DEPRECATED int depreactedInline() { ... }
 * static GTL_DEPRECATED char* deprecatedInline() { ... }
 * @endcode
 * 
 * You can declare a class or struct to be deprecated :
 * @code
 * class GTL_DEPRECATED deprecatedClass { };
 * struct GTL_DEPRECATED deprecatedStruct { };
 * @endcode
 * 
 * @ingroup GTLCore
 */

#if defined(__GNUC__) && !defined(__INTEL_COMPILER) && (__GNUC__ - 0 > 3 || (__GNUC__ - 0 == 3 && __GNUC_MINOR__ - 0 >= 2))
#  define GTL_DEPRECATED __attribute__ ((__deprecated__))
#elif defined(_MSC_VER) && (_MSC_VER >= 1300)
#  define GTL_DEPRECATED __declspec(deprecated)
#else
#  define GTL_DEPRECATED
#endif

#endif
