/*
 *  Copyright (c) 2007-2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_COMPILER_BASE_H_
#define _GTLCORE_COMPILER_BASE_H_

#include <list>
#include <GTLCore/String.h>

namespace GTLCore {
  class ConvertCenter;
  class ErrorMessage;
  class Function;
  class ScopedName;
  class TypesManager;
  class Type;
  class ModuleData;
  namespace AST {
    class Expression;
  }
  /**
   * @internal
   * Base class for compilers, it provides some basic information/functionnalities to the \ref ParserBase
   * @ingroup GTLCore
   */
  class CompilerBase {
    public:
      CompilerBase();
      virtual ~CompilerBase();
    public:
      void appendError( const GTLCore::ErrorMessage& msg);
      /**
       * Append the error and delete the message.
       */
      void appendError( GTLCore::ErrorMessage* );
      const std::list<GTLCore::ErrorMessage>& errorMessages() const;
      GTLCore::Function* function( const GTLCore::ScopedName&  );
      bool declareFunction( const GTLCore::ScopedName&, GTLCore::Function*);
      /**
       * 
       * @return the type manager used for compilation
       */
      virtual GTLCore::TypesManager* typesManager() = 0;
      /**
       * @return the \ref ConvertCenter used for compilation
       */
      ConvertCenter* convertCenter();
    public:
      virtual GTLCore::AST::Expression* standardConstant( const GTLCore::String& _name ) = 0;
    protected:
      void appendErrors( const std::list<GTLCore::ErrorMessage>& _msgs);
      void setModuleName( const GTLCore::String& moduleName);
      const GTLCore::String& moduleName() const;
       /// List of functions which are not visible in the generated module (like functions coming from an imported module, or standard library functions, and that should be removed at the end of compilation
      std::list<GTLCore::Function*>& functionsToDelete();
    protected:
      // Standard library function generation
      void createStdLibFunction(const String& _name, const String& _symbolName, const Type* retType, int count, ...);
      void setModuleData( ModuleData* moduleData );
    private:
      struct Private;
      Private* const d;
  };
  
}

#endif
