/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_BUFFER_IMAGE_H_
#define _GTLCORE_BUFFER_IMAGE_H_

#include <GTLCore/AbstractImage.h>

namespace OpenCTL {
  class Program;
}

namespace GTLCore {
  class Buffer;
  /**
   * This is an implementation of \ref AbstractImage which can be used with any \ref GTLCore::Buffer .
   *
   * @ingroup GTLCore
   */
  class BufferImage : public AbstractImage {
    public:
      /**
       * @param _width width of the image
       * @param _height height of the image
       * @param _buffer the buffer giving access to the image data (\ref BufferImage takes
       *                ownership of the \ref GTLCore::Buffer )
       * @param _pixelDescription the description of the pixel stored in the buffer
       * 
       * It is expected that (_width * _height * _pixelDescription.bitsSize() / 8) == _buffer->size()
       */
      BufferImage( int _width, int _height, GTLCore::Buffer* _buffer, const GTLCore::PixelDescription& _pixelDescription );
      ~BufferImage();
    public:
      virtual char* data( int _x, int _y );
      virtual const char* data( int _x, int _y ) const;
      /**
       * @return the width of the image
       */
      int width() const;
      /**
       * @return the height of the image
       */
      int height() const;
      AbstractImage::ConstIterator* createIterator() const;
      AbstractImage::Iterator* createIterator();
    protected:
      int lineWidth() const;
      const GTLCore::Buffer* buffer() const;
    private:
      GTLCore::Buffer* buffer();
    private:
      struct Private;
      Private* const d;
  };
}

#endif
