/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "OpenCTL/compiler/Compiler.h"
#include "OpenCTL/compiler/ParserNG.h"
#include "GTLCore/AST/Tree.h"
#include "GTLCore/AST/BinaryExpression.h"

class TestParserNGExpression : public GTLTest::Case {
  public:
    TestParserNGExpression() : GTLTest::Case("Expression") {}
    virtual void runTest()
    {
      std::istringstream iss(" const int v = 3 + 4 / 2; \n const int v2 = 3 / 4 + 2;");
      OpenCTL::LexerNG lng(&iss);
      OpenCTL::ParserNG png( 0, &lng );
      AST::Tree* tree = png.parse();
      GTL_ASSERT( tree );
      GTLTEST_CHECK_EQUAL( tree->globalConstantDeclarations().size() , 2);
      std::list<AST::GlobalConstantDeclaration*>::const_iterator constants_it = tree->globalConstantDeclarations().begin();
      {
        AST::GlobalConstantDeclaration* constant = *constants_it;
        GTLTEST_CHECK_EQUAL(constant->name(), GTLCore::ScopedName("", "v" ));
        AST::AdditionBinaryExpression* abe = dynamic_cast<AST::AdditionBinaryExpression*>( constant->initialiser() );
        GTL_ASSERT( abe );
        GTLTEST_CHECK( abe );
        AST::NumberExpression<int>* abe_lhs = dynamic_cast<AST::NumberExpression<int>*>( abe->leftHandSide() );
        GTL_ASSERT( abe_lhs );
        GTLTEST_CHECK( abe_lhs );
        GTLTEST_CHECK_EQUAL( abe_lhs->value(), 3 );
        AST::DivisionBinaryExpression* abe_rhs = dynamic_cast<AST::DivisionBinaryExpression*>( abe->rightHandSide() );
        GTL_ASSERT( abe_rhs);
        GTLTEST_CHECK( abe_rhs );
      }
      ++constants_it;
      {
        AST::GlobalConstantDeclaration* constant = *constants_it;
        GTLTEST_CHECK_EQUAL(constant->name(), GTLCore::ScopedName("", "v2" ));
        AST::AdditionBinaryExpression* abe = dynamic_cast<AST::AdditionBinaryExpression*>( constant->initialiser() );
        GTL_ASSERT( abe );
        GTLTEST_CHECK( abe );
        AST::DivisionBinaryExpression* abe_lhs = dynamic_cast<AST::DivisionBinaryExpression*>( abe->leftHandSide() );
        GTL_ASSERT( abe_lhs);
        GTLTEST_CHECK( abe_lhs );
        AST::NumberExpression<int>* abe_rhs = dynamic_cast<AST::NumberExpression<int>*>( abe->rightHandSide() );
        GTL_ASSERT( abe_rhs );
        GTLTEST_CHECK( abe_rhs );
        GTLTEST_CHECK_EQUAL( abe_rhs->value(), 2 );
      }
      delete tree;
    }
};

class TestParserNG : public GTLTest::Suite {
  public:
    TestParserNG() : GTLTest::Suite("ParserNG")
    {
      addCase(new TestParserNGExpression );
    }
};
