/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENCTL_LEXERNG_H_
#define _OPENCTL_LEXERNG_H_

#include <GTLCore/LexerBase_p.h>
#include <sstream>

namespace GTLCore {
  class Token;
}

namespace OpenCTL {
  class Compiler;
  /**
   * This class defines a lexer for CTL.
   */
  class LexerNG : public GTLCore::LexerBase {
    public:
      /**
       * Creates a new lexer with the given stream.
       * @code
       *  std::istringstream iss(sourceCode);
       *  OpenCTL::LexerNG lng( &iss);
       * @endcode
       */
      LexerNG(std::istream* sstream);
      ~LexerNG();
      /**
       * @return the next token
       */
      GTLCore::Token nextToken();
    private:
      LexerNG(const LexerNG& rhs) : LexerBase(rhs) {}
      LexerNG& operator=(const LexerNG& ) { return *this; }
  };
  
};


#endif
