/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "GTLCore/ScopedName.h"

class TestScopedNameComparison : public GTLTest::Case {
  public:
    TestScopedNameComparison() : GTLTest::Case("Comparison")
    {
    }
    virtual void runTest()
    {
      GTLCore::ScopedName name1("bouh", "gouh");
      GTLCore::ScopedName name2("couh", "douh");
      GTLCore::ScopedName name3("bouh", "douh");
      GTLTEST_CHECK(name1 < name2);
      GTLTEST_CHECK(name3 < name1);
      GTLTEST_CHECK(name1 == name1);
      GTLTEST_CHECK(not(name1 == name2));
    }
};

class TestScopedName : public GTLTest::Suite {
  public:
    TestScopedName() : GTLTest::Suite("ScopedName")
    {
      addCase( new TestScopedNameComparison);
    }
};

