/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_ERROR_MESSAGE_H_
#define _GTLCORE_ERROR_MESSAGE_H_

#include <GTLCore/String.h>

namespace GTLCore {
  /**
   * This class contains the information about a compilation error, such as the text
   * of the error, the line of the error, and the name of the file.
   * 
   * @ingroup GTLCore
   */
  class ErrorMessage {
    public:
      /**
       * Construct a new \ref ErrorMessage
       */
      ErrorMessage( const String& errorMessage, int line = -1, const String& fileName = "");
      ErrorMessage( const ErrorMessage& );
      ErrorMessage& operator=(const ErrorMessage& rhs);
      ~ErrorMessage();
    public:
      /**
       * @return the line where the error has happen
       */
      int line() const;
      /**
       * @return the text of the error message
       */
      const String& errorMessage() const;
      /**
       * @return the file name
       */
      const String& fileName() const;
    public:
      /**
       * Set the line number
       */
      void setLine(int line);
      /**
       * Set the file name
       */
      void setFileName(const String& fileName);
    private:
      struct Private;
      Private* const d;
  };
  
}

#endif
