/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENRIJN_WRAPPER_P_H_
#define _OPENRIJN_WRAPPER_P_H_

#include <GTLFragment/Wrapper_p.h>

namespace OpenRijn {
  /**
   * @internal
   * @ingroup OpenRijn
   *
   * Wrapper of functions for Rijn.
   */
  class Wrapper : public GTLFragment::Wrapper {
    public:
      Wrapper(GTLCore::ModuleData* _moduleData, llvm::Module* module, bool loadRijnWrapperLibrary);
      virtual void fillTypesManager( GTLCore::TypesManager* _typesManager, GTLCore::ConvertCenter* _convertCenter);
    private:
      const GTLCore::Type* createBrushType(GTLCore::TypesManager* _typesManager, GTLCore::ConvertCenter* _convertCenter, const GTLCore::Type* _colorType, const GTLCore::Type* _canvasType);
      const GTLCore::Type* createPaletteType(GTLCore::TypesManager* _typesManager, GTLCore::ConvertCenter* _convertCenter, const GTLCore::Type* _brushType);
      const GTLCore::Type* createCanvasType(GTLCore::TypesManager* _typesManager, GTLCore::ConvertCenter* _convertCenter);
    private:
      struct Private;
      Private* const d;
  };
}

#endif
