/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2012 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::directionalDiffusivity

Description
    Directional finite volume mesh motion diffusivity.

SourceFiles
    directionalDiffusivity.C

\*---------------------------------------------------------------------------*/

#ifndef directionalDiffusivity_H
#define directionalDiffusivity_H

#include "uniformDiffusivity.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                           Class directionalDiffusivity Declaration
\*---------------------------------------------------------------------------*/

class directionalDiffusivity
:
    public uniformDiffusivity
{
    // Private data

        vector diffusivityVector_;


    // Private Member Functions

        //- No copy construct
        directionalDiffusivity(const directionalDiffusivity&) = delete;

        //- No copy assignment
        void operator=(const directionalDiffusivity&) = delete;


public:

    //- Runtime type information
    TypeName("directional");


    // Constructors

        //- Construct for the given fvMesh and data Istream
        directionalDiffusivity(const fvMesh& mesh, Istream& mdData);


    //- Destructor
    virtual ~directionalDiffusivity();


    // Member Functions

        //- Correct the motion diffusivity
        virtual void correct();
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
