<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
	
	-- CHANGLOG --
		
	Version		Comments
	-------		--------
	0.81		initial 0.81 release
	0.81p7		Fix to remove debug info.
	0.81p8		Fix to parse audio_lang correctly.
*/
include_once("./functions/SitePlugin.class.inc");

function parse_music_tracks($pageBuffer, $title, $disc_no)
{
	$tracks = NULL;
	
	//<b><font face="verdana, arial, helvetica" color="#CC6600">Track Listings</font></b></font>
	if(preg_match("!<b><font[^>]*>".preg_quote($title, "!")."</font></b>(.*)<hr noshade size=1>!Usi", $pageBuffer, $regs))
	{
		// Only parse for the disc number if disc_no specified
		if(!is_numeric($disc_no) || preg_match("!<b>Disc: $disc_no</b>(.*)</table>!Usi", $regs[1], $regs2))
		{
			if(preg_match_all("![0-9]+\.[\s]+(.*)<br>!Usi", is_numeric($disc_no)?$regs2[1]:$regs[1], $matches))
			{
				for ($i = 0; $i < count($matches[1]); $i++)
				{
					if(preg_match("!<a href=[^>]*>([^<]*)<img!i", $matches[1][$i], $regs3))
						$track = $regs3[1];
					else
						$track = $matches[1][$i];

					if(strlen($track)>0)
					{
						$track = html_entity_decode(strip_tags($track));
						$tracks[] = $track;
					}
				}
			}
		}
	}
	return $tracks;
}//function parse_music_tracks($pageBuffer, $title, $disc_no)

function parse_video_person_block($header, $pageBuffer)
{
	$persons = NULL;
	
	$startidx = strpos($pageBuffer, "<li><b>".$header.":</b>");
	if($startidx!==FALSE)
	{
	    $startidx += strlen("<li><b>".$header.":</b>");
		$endidx = strpos($pageBuffer, "</li>", $startidx);
		if($endidx!==FALSE)
		{
		    $personBlock = substr($pageBuffer, $startidx, $endidx-$startidx);
			if(preg_match_all("/<a href=([^>]+)>([^<]+)<\/a>/", $personBlock, $matches))
			{
				for($i=0; $i<count($matches[1]); $i++)
				{
					if(strpos($matches[2][$i], "See more")===FALSE)
					{
						$persons[] = trim(html_entity_decode(strip_tags($matches[2][$i])));
					}
				}
			}
		}
	}
	
	return $persons;
}
		
class amazonuk extends SitePlugin
{
	function amazonuk($site_type)
	{
		parent::SitePlugin($site_type);
	}
	
	function queryListing($page_no, $items_per_page, $offset, $s_item_type, $search_vars_r)
	{
		if(strlen($search_vars_r['amazukasin'])>0)
		{
			$this->addListingRow(NULL, NULL, NULL, array('amazukasin'=>$search_vars_r['amazukasin']));
			return TRUE;
		}
		else
		{
			// Get the mapped AMAZON index type
			$index_type = ifempty($this->getConfigValue('item_type_to_index_map', $s_item_type), strtolower($s_item_type));
			
			$queryUrl = 'http://www.amazon.co.uk/exec/obidos/external-search?url='.rawurlencode('index='.$index_type).'&keyword='.rawurlencode($search_vars_r['title']).'&sz='.$items_per_page.'&pg='.$page_no;
			
			$pageBuffer = $this->fetchURI($queryUrl);
		}
		
		if(strlen($pageBuffer)>0)
		{
			$amazukasin = FALSE;
			
			// check for an exact match, but not if this is second page of listings or more
			if(!$this->isPreviousPage())
			{
				if (preg_match("/ASIN: <font>(\w{10})<\/font>/", $pageBuffer, $regs))
				{
					$amazukasin = trim($regs[1]);
				}
				else if (preg_match("/ASIN: (\w{10})/", strip_tags($pageBuffer), $regs))
				{
					$amazukasin = trim($regs[1]);
				}
				else if (preg_match ("/ISBN: ([^;]+);/", strip_tags($pageBuffer), $regs)) // for books, ASIN is the same as ISBN
				{
					$amazukasin = trim($regs[1]);
				} 
			}
			
			// exact match
			if($amazukasin!==FALSE)
			{
				// single record returned
				$this->addListingRow(NULL, NULL, NULL, array('amazukasin'=>$amazukasin));
				
				return TRUE;
			}
			else
			{
				$pageBuffer = preg_replace('/[\r\n]+/', ' ', $pageBuffer);
			
				//<img src="http://ec1.images-amazon.com/images/P/B000050YLW.02._SCTHUMBZZZ_AA90_.jpg" border="0" alt="Rambo Trilogy (Three Disc Box Set)" width="90" height="90" /> </a>
				//<td class="resultCount">Showing 1 - 12 of 144 Results</td>
				//if(preg_match("/All[\s]*([0-9]+)[\s]*results for/i", $pageBuffer, $regs))
				if(preg_match("/<td class=\"resultCount\">Showing [0-9]+ - [0-9]+ of ([0-9]+) Results<\/td>/i", $pageBuffer, $regs) || 
						preg_match("/<td class=\"resultCount\">Showing ([0-9]+) Results<\/td>/i", $pageBuffer, $regs))
				{
					// store total count here.
					$this->setTotalCount($regs[1]);

					// 1 = img, 2 = href, 3 = title					
					if(preg_match_all("!<td class=\"imageColumn\" width=\"[0-9]+\">".
									".*?<img src=\"([^\"]+)\" border=\"0\" alt=\"[^\"]+\" width=\"[0-9]+\".*?".
									"<td class=\"dataColumn\">.*?".
									"<a href=\"([^\"]+)\"><span class=\"srTitle\">([^<]+)</span></a>!m", $pageBuffer, $matches))
					{
						for($i=0; $i<count($matches[0]); $i++)
						{
							
							//http://www.amazon.co.uk/First-Blood-David-Morrell/dp/0446364401/sr=1-1/qid=1157433908/ref=pd_bbs_1/104-6027822-1371911?ie=UTF8&s=books
							if(preg_match("!/dp/([^/]+)/!", $matches[2][$i], $regs))
							{
								$this->addListingRow($matches[3][$i], $matches[1][$i], NULL, array('amazukasin'=>$regs[1]));
							}
						}
					}
				}					
			}
			
			//default
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
	
	/**
	* 
	*/
	function queryItem($search_attributes_r, $s_item_type)
	{
		$pageBuffer = $this->fetchURI("http://www.amazon.co.uk/exec/obidos/ASIN/".$search_attributes_r['amazukasin']);
		$pageBuffer = preg_replace('/[\r\n]+/', ' ', $pageBuffer);
		
		//	echo $pageBuffer;
		
		// no sense going any further here.
		if(strlen($pageBuffer)==0)
			return FALSE;
		
		//Amazon.co.uk: Rambo: First Blood [1982]: DVD
		
		// The location of the title is the same for all formats.
		if(preg_match("/<title>.*Amazon\.co\.uk:(.*)<\/title>/s", $pageBuffer, $regs))
		{
			// If extra year appended, remove it and just get the title.
			if(preg_match("/(.*)\[[0-9]+\]:(.*)$/m", trim($regs[1]), $regs2))
				$title = $regs2[1];
			else if(preg_match("/(.*)\([0-9]+\)$/m", trim($regs[1]), $regs2))
				$title = $regs2[1];
			else
				$title = $regs[1];
			
			$title = str_replace("\"", "", $title);
			
			$this->addItemAttribute('title', $title);
		}
		
		//http://www.amazon.co.uk/gp/product/images/B000050YLT/ref=dp_image_text_0/026-9147519-9634865?ie=UTF8
		$imageBuffer = $this->fetchURI("http://www.amazon.co.uk/gp/product/images/".$search_attributes_r['amazukasin']);
		if($imageBuffer!==FALSE)
	    {
	        if(preg_match_all("!zoomFetchImage\(\"[^\"]+\", \"([^\"]+)\"!", $imageBuffer, $regs))
	        {
	        	$this->addItemAttribute('imageurl', $regs[1]);
	        } //<img src="http://images.amazon.com/images/P/B000FMH8RG.01._SS500_SCLZZZZZZZ_V52187861_.jpg" id="prodImage" />
	        else if(preg_match_all("!<img src=\"([^\"]+)\" id=\"prodImage\" />!", $imageBuffer, $regs))
	        {
	        	$this->addItemAttribute('imageurl', $regs[1]);	
	        }
	    }
		
		// Image src extraction block
		//<img src="http://images.amazon.com/images/P/B000050YLT.02._PE54_OU02_SCMZZZZZZZ_.jpg" alt="Rambo: First Blood Part II [1985]" border="0" height="154" width="107">
		if (preg_match_all("!\"(http://images.amazon.com/images/P/".$search_attributes_r['amazukasin']."[^\"]+)\"!", $pageBuffer, $regs))
		{
			$imageurl = NULL;
			$timageurl = NULL;

			// try for a big image first, otherwise get the smaller one.
			for($i = 0; $i < count($regs[1]); $i++)
			{
				if(strpos($regs[1][$i], "LZZZZZZ") !== FALSE)
				{
					$imageurl = $regs[1][$i];
					break;
				}

				if(strpos($regs[1][$i], "ZZZZZZZ") !== FALSE)
				{
					$timageurl = $regs[1][$i];
				}
			}

			if($imageurl == NULL && timageurl != NULL)
				$imageurl = $timageurl;

			// If still null!
			if($imageurl == NULL)
			{
				// If first image has 'THUM' in it, we have matched a thumbnail,
				// get the next one instead.
				// 'Breath Fire III' (GAME) is such a case.
				if(count($regs[1])>1 && strpos($regs[1][0],"THUM")!==FALSE)
					$imageurl = $regs[1][1];
				else
					$imageurl = $regs[1][0];
			}

			if(strlen($imageurl))
			{
				$this->addItemAttribute('imageurl', $imageurl);
			}
		}
		
		// The list price, will be on all Amazon item detail pages, so parse it
		// once here.  In the switch statement below, we can massage the coverprice
		// data, into a type specific attribute if required.
		//<td class="productLabel">RRP:</td>     <td class="listprice">�12.99 </td>
		if (preg_match("!<td.*>RRP:</td>[\s]*<td.*>�([0-9\.]*)[\s]*</td>!", $pageBuffer, $regs))
		{
			$this->addItemAttribute('listprice', $regs[1]);
		}//<td class="productLabel">Our Price:</td>     <td><b class="price">�5.97</b>
		else if (preg_match("!<td.*>Our Price:</td>[\s]*<td.*><b.*>�([0-9\.]*)</b>!", $pageBuffer, $regs))
		{
			$this->addItemAttribute('listprice', $regs[1]);
		}
		
		// Get the mapped AMAZON index type
		$index_type = ifempty($this->getConfigValue('item_type_to_index_map', $s_item_type), strtolower($s_item_type));
				
		switch($index_type)
		{
			case 'dvd-uk':
			case 'vhs-uk':
				$this->parse_amazon_video_data($search_attributes_r, $s_item_type, $pageBuffer);
				break;
			
			case 'video-games-uk':
				$this->parse_amazon_game_data($search_attributes_r, $pageBuffer);
				break;
				
			case 'books-uk':
				$this->parse_amazon_books_data($search_attributes_r, $pageBuffer);
				break;
				
			case 'music':
				$this->parse_amazon_music_data($search_attributes_r, $pageBuffer);
				break;
			
			default://Not much here, but what else can we do?
				break;
		}
		
		//echo "<pre>";
		//print_r($this->getItemData());
		//echo "</pre>";

		return TRUE;
	}
	
	function parse_amazon_game_data($search_attributes_r, $pageBuffer)
	{
		// Publisher extraction block
		if (preg_match("/<a.*>Other products by (.*)<\/a><br>/i", $pageBuffer, $regs))
		{
			$this->addItemAttribute('gamepblshr', $regs[1]);
		}
			
		// Platform extraction block
		//<b>Platform:</b> Windows 95.Windows 98.Windows 2000.Windows Me.Windows XP<br>
		if(preg_match("/<b>Platform:[\s]*<\/b>(.*)<br>/i", $pageBuffer, $regs))
		{
			$platform = $regs[1];
			if(strpos($platform, ".") !== FALSE)
			{
				// Different combo's of windows, lets treat them all as windows.
				if(strpos($platform, "Windows")!==FALSE)
					$platform = "Windows";
			}
			$this->addItemAttribute('gamesystem', $platform);
		}
	
		//ELSPA</a> Minimum Age:</b> 15 <br>
		// Rating extraction block - For more information see:
		//  http://www.amazon.co.uk/exec/obidos/tg/browse/-/502556/202-1345170-2851025/202-1345170-2851025
		if (preg_match("/ELSPA<\/a> Minimum Age:<\/b> (.*) <br>/i", $pageBuffer, $regs))
		{
			$this->addItemAttribute('elsparated', $regs[1].'+'); // the '+' is required
		}
		
		if(preg_match("!PEGI</a> Minimum Age:</b>([^<]*)<br>!sU", $pageBuffer, $regs))
		{
			$this->addItemAttribute('pegirated', $regs[1]);
		}
		
		if ( ( $indexOf = strpos($pageBuffer, "<b>Features</b></font>")) !== FALSE && 
				($indexOf2 = strpos($pageBuffer, "</ul>", $indexOf)) !== FALSE)
		{
			if(preg_match_all("/<li>([^<]+)<\/li>/si", substr($pageBuffer, $indexOf, $indexOf2-$indexOf), $matches))
			{
				// generate a list of features
				for($i = 0; $i < count($matches[1]); $i++)
				{
					$features .= trim(html_entity_decode(strip_tags($matches[1][$i])))."\n";
				}
				
				if(strlen($features)>0)
				{
					$this->addItemAttribute('features', $features);
				}
			}
		}
	}
	
	function parse_amazon_music_data($search_attributes_r, $pageBuffer)
	{
		//<META name="description" content="Come on Over, Shania Twain, Mercury">
		if(preg_match("!<meta name=\"description\" content=\"([^\"]*)\">!i", $pageBuffer, $regs))
		{
			$contents = trim_explode(",", $regs[1]);
			if(is_array($contents) & count($contents)>=2)
			{
				// the artist is the second entry in the description.
				$this->addItemAttribute('artist', implode(", ", $contents[1]));
			}
		}
		
		if( ($sqidx = strpos($this->getItemAttribute('title'), "["))!==FALSE)
		{
			$this->addItemAttribute('comments', str_replaces(array('[',']'), array("\n",''), substr($this->getItemAttribute('title'),$sqidx)));
			$this->replaceItemAttribute('title', substr($this->getItemAttribute('title'),0,$sqidx));
		}
		
		//<b>Label:</b> <a HREF="/exec/obidos/search-handle-url/size=20&store-name=music&index=music&field-label=Mercury/026-5027435-0842841">Mercury</a><br>
		if(preg_match("!<b>Label:</b>[\s]*<a href=\"[^\"]+\">([^<]+)<\/a>!i", $pageBuffer, $regs))
		{
			$this->addItemAttribute('musiclabel', $regs[1]);
		}
		
		//<B> Audio CD </B>
		//(November 18, 2002)<br>
		if(preg_match("!<b>[\s]*Audio CD[\s]*</b>.*\(([^\)]+)\)<br>!sUi", $pageBuffer, $regs))
		{
			$this->addItemAttribute('release_dt', $regs[1]);
			if(preg_match("!([0-9]+)$!", $this->getItemAttribute('release_dt'), $regs2))
			{
				$this->addItemAttribute('year', $regs2[1]);
			}
		}
		
		if(preg_match("!<b>Number of Discs:[\s]*</b>([0-9]+)!", $pageBuffer, $regs))
		{
			$this->addItemAttribute('no_discs', $regs[1]);
		}
		
		if(is_numeric($this->getItemAttribute('no_discs')) && $this->getItemAttribute('no_discs') > 1)
		{
			for($i=0; $i<$this->getItemAttribute('no_discs'); $i++)
			{
				$cdtracks[$i] = parse_music_tracks($pageBuffer, "Track Listings", $i+1);
				if($cdtracks[$i] == NULL)
					$cdtracks[$i] = parse_music_tracks($pageBuffer, "Listen to Samples", $i+1);
			}
			
			// Now coalesce into single cdtracks array
			if(is_not_empty_array($cdtracks))
			{
				for($i=0; $i<count($cdtracks); $i++)
				{
					if(is_not_empty_array($cdtracks[$i]))
					{
						for($j=0; $j<count($cdtracks[$i]); $j++)
						{
							$this->addItemAttribute('cdtrack', $cdtracks[$i][$j]);
						}
					}
				}
			}
		}
		else
		{ 
			// one disc
			$this->addItemAttribute('cdtrack', parse_music_tracks($pageBuffer, "Track Listings", NULL));
			if($this->getItemAttribute('cdtrack') === FALSE)
				$this->addItemAttribute('cdtrack', parse_music_tracks($pageBuffer, "Listen to Samples", NULL));
		}			
	}
	
	function parse_amazon_books_data($search_attributes_r, $pageBuffer)
	{
		//<META name="description" content="The 21st Century Beauty Bible, Sarah Stacey, Josephine Fairley, Kyle Cathie Ltd">
		//<META name="description" content="Property Ladder: The Developer's Bible, Sarah Beeny, Cassell Illustrated">
		if(preg_match("!<meta name=\"description\" content=\"([^\"]*)\">!i", $pageBuffer, $regs))
		{
			$contents = trim_explode(",", $regs[1]);
			
			$authors = array();
			
			// title is first, author(s) second, publisher last
			if(is_array($contents) && count($contents)>2)
			{
				for($i=1; $i<count($contents)-1; $i++)
				{
					$authors[] = initcap($contents[$i]);
				}
				
				$this->addItemAttribute('author', implode(", ", $authors));
			}
		}
	
		if( ( $startIndex = strpos($pageBuffer, "<b>Search for books by subject:</b>") ) !== FALSE &&
				($endIndex = strpos($pageBuffer, "</form>", $startIndex) ) !== FALSE )
		{
			$subjectform = substr($pageBuffer, $startIndex, $endIndex-$startIndex);
			if(preg_match_all("/<input type=checkbox name=\"field\+subject\" value=\"([^\"]+)\">/", $subjectform, $matches))
			{
				for ($i = 0; $i < count($matches[1]); $i++)
				{
					$this->addItemAttribute('genre', $matches[1][$i]);
				}
			}
		}
		
		$startIndex = strpos($pageBuffer, '<a name="product-details">');
		if($startIndex !== FALSE)
		{
			$startIndex += strlen('<a name="product-details">');
			
			$endIndex = strpos($pageBuffer, '<p>', $startIndex);
			if($endIndex !== FALSE)
			{
				$productDetails = html_entity_decode(trim(substr($pageBuffer, $startIndex, $endIndex-$startIndex)));
				
				if(preg_match("/([0-9]+) pages/", $productDetails, $regs2))
				{
	
					$this->addItemAttribute('nb_pages', $regs2[1]);
				}
	
				if(preg_match("/\(([^\)]*[0-9]+)\)/", $productDetails, $regs2))
				{
					// All we want is the year here.
					if (preg_match("/([0-9]+)$/", $regs2[1], $regs3))
					{
						$this->addItemAttribute('pub_date', $regs3[1]);		
					}
				}
				
				//<b>Publisher:</b> Kyle Cathie Ltd
				if(preg_match("!<b>Publisher:</b>[\s]+([^$]+)$!mU", $productDetails, $regs2) || 
						preg_match("!<b>Publisher:</b>[\s]+([^;]+);!U", $productDetails, $regs2))
				{
					$this->addItemAttribute('publisher', $regs2[1]);
				}
				
				if(preg_match("!<b>ISBN:</b>$([^$]+)$!mU", $productDetails, $regs2) || 
						preg_match("!; ISBN: ([^$]+)$!mU", $productDetails, $regs2))
				{
					$this->addItemAttribute('isbn', $regs2[1]);
				}
			}
		}
		
		// Editorial reviews
		//<a href=/exec/obidos/tg/stores/detail/-/books/0747551006/reviews/202-1345170-2851025><font face="verdana, arial, helvetica" size="-1"><b>See all reviews...</b></font><br></a>
		if(preg_match("!<a href=/exec/obidos/tg/stores/detail/-/books/".$search_attributes_r['amazukasin']."/reviews/!", $pageBuffer, $regs))
		{
			$reviewPage = $this->fetchURI("http://www.amazon.co.uk/exec/obidos/tg/stores/detail/-/books/".$search_attributes_r['amazukasin']."/reviews/");
			if(strlen($reviewPage)>0)
			{
				//<b><font face="verdana, arial, helvetica" color="#CC6600">Reviews</font></b><br>
				$start = strpos($reviewPage, "Reviews</font></b><br>");
				if($start !== FALSE)
				{
					$start += strlen("Reviews</font></b><br>");
					
					$end = strpos($reviewPage, "Look for similar books by subject:", $start);
					if($end !== FALSE)
						$reviewPage = substr($reviewPage,$start,$end-$start);
					else
						$reviewPage = substr($reviewPage,$start);
					
					// If still something to parse.
					if(strlen($reviewPage)>0)
					{
						//<b>The Times of London</b><br />
						if(preg_match_all("!<b>(.*?)</b><br>(.*?)<br>!um", $reviewPage, $matches))
						{
							for($i=0; $i<count($matches[0]); $i++)
							{
								// The author, is the first match, the actual review the second one.
								$author = trim(html_entity_decode(strip_tags($matches[1][$i])));
									
								if($author != 'About the Author') // a hack!
								{
									// trim copyright notice.
									if(($copyidx = strpos($matches[2][$i], "-- <I>Copyright"))!==FALSE)
									{
										$matches[2][$i] = trim(substr($matches[2][$i],0,$copyidx));
									}
									
									$review = $matches[2][$i];
										
									// some specific fucked up review formatting to deal with!!!
									$review = preg_replace("/<p>/i", "\n\n", $review);
									$review = preg_replace("/<br>/i", "\n", $review);
									$review = str_replace("&#149;", "*", $review);
									$review = str_replace("&ndash;", "-", $review);
										
									$review = trim(html_entity_decode(strip_tags($review)));
										
									// some extra processing to try and remove as many duplicate reviews as possible
									$review = str_replace("\"", "", $review);
									$review = preg_replace("/[ \t]+/i", " ", $review);
									$review = str_replace("\n ", "\n", $review);
											
									if(strlen($author)>0 && 
											$author != 'Amazon.com' && 
											$author != 'Amazon.co.uk' && 
											$author != 'Book Info' && 
											$author != 'Product Description:')
									{
										$review .= "\n-- $author";
									}
										
									$this->addItemAttribute('blurb', $review);
								}				 
							}
						}
					}
				}
			}
		}
	}
	
	function parse_amazon_video_data($search_attributes_r, $s_item_type, $pageBuffer)
	{
		//<b>Rambo - First Blood [1982]</b>
		// Need to escape any (, ), [, ], :, ., 
		//<b class="sans">Rambo: First Blood Part II [1985] (1985)</b>
		if(preg_match("/<b.*>".preg_quote($this->getItemAttribute('title'), "/")."[\s]*\[([0-9]*)\]/s", $pageBuffer, $regs))
		{
			$this->addItemAttribute('year', $regs[1]);
		}
		else if(preg_match("/<b.*>".preg_quote($this->getItemAttribute('title'), "/")."[\s]*\(([0-9]*)\)<\/b>/s", $pageBuffer, $regs))
		{
			$this->addItemAttribute('year', $regs[1]);
		}
	
		//<img src="http://g-images.amazon.com/images/G/02/uk-video/misc/15-rating-27x21.gif" width="27" alt="15" height="21" border="0" />
		if (preg_match("/<b>Classification:<\/b>[\s]*<img src=.*? alt=\"([^\"]+)\".*?>/mi", $pageBuffer, $regs))
		{
			$this->addItemAttribute('age_rating', $regs[1]);
		}
		
		$actors = parse_video_person_block('Actors', $pageBuffer);
		if(is_array($actors))
		{
			$this->addItemAttribute('actors', implode(", ", $actors));
		}

		$directors = parse_video_person_block('Directors', $pageBuffer);
		if(is_array($directors))
		{
			$this->addItemAttribute('director', implode(", ", $directors));
		}

		//<li><b>Studio:</b>  Momentum Pictures Home Ent</li>			
		if (preg_match("!<li><b>Studio:[\s]*</b>([^<]*)</li>!", $pageBuffer, $regs))
		{
			$this->addItemAttribute('studio', $regs[1]);
		}

		if (preg_match("!<li><b>DVD Release Date:[\s]*</b>([^<]*)</li>!", $pageBuffer, $regs))
		{
			// Get year only, for now.  In the future we may add ability to
			// convert date to local date format.
			if(preg_match("/([0-9]+)$/m", $regs[1], $regs2))
			{
				$this->addItemAttribute('dvd_rel_dt', $regs2[1]);
			}
		}
		
		if (preg_match("!<li><b>Number of discs:[\s]*</b>[\s]*([0-9]+)!", $pageBuffer, $regs))
		{
			$this->addItemAttribute('no_discs', $regs[1]);
		}
		
		if (preg_match("!<li><b>Aspect Ratio:[\s]*</b>[\s]*([0-9\.]+)!", $pageBuffer, $regs))
		{
			$this->addItemAttribute('ratio', $regs[1]);
		}
		
		if (preg_match("!<li><b>Run Time:[\s]*</b>[\s]*([0-9]+)!", $pageBuffer, $regs))
		{
			$this->addItemAttribute('run_time', $regs[1]);
		}
		
		// Region extraction block
		if (preg_match("!<li><b>Region:[\s]*</b>Region ([0-9]+)!", $pageBuffer, $regs))
		{
			$this->addItemAttribute('dvd_region', $regs[1]);
		}
		
		//<li><b>Format: </b>Anamorphic, PAL, Widescreen</li>
		if (preg_match("!<li><b>Format:[\s]*</b>([^<]*)</li>!", $pageBuffer, $regs))
		{
			if (preg_match("/NTSC/", $regs[1], $regs2))
				$this->addItemAttribute('vid_format', 'NTSC');
			else
				$this->addItemAttribute('vid_format', 'PAL');
				
			if (preg_match("/Anamorphic/", $regs[1], $regs2))
				$this->addItemAttribute('anamorphic', 'Y');
		}
		
		if (preg_match("!<li><b>DVD Features:[\s]*</b><ul>(.*?)</ul>!", $pageBuffer, $regs))
		{
			//Available Subtitles, Available Audio Tracks, Main Language, Available Audio Tracks, Sub Titles, Disc Format
			if(preg_match_all("!<li>(.*?)</li>!", $regs[1], $matches))
			{
				
				$dvd_extras = '';
				for($i=0; $i<count($matches[0]); $i++)
				{
					if(preg_match("!<li>(.*?):(.*?)</li>!", $matches[0][$i], $matches2))
					{
						if($matches2[1] == 'Available Subtitles' || $matches2[1] == 'Sub Titles')
						{
							$this->addItemAttribute('subtitles', trim_explode(",", $matches2[2]));
						}
						else if($matches2[1] == 'Available Audio Tracks')
						{
							$this->addItemAttribute('audio_lang', trim_explode(",", $matches2[2]));
						}
						//else if($matches2[1][$i] == 'Main Language')
						//{
						//}
						//else if($matches2[1][$i] == 'Disc Format')
						//{
						//}
					}
					else
					{
						$dvd_extras .= $matches[1][$i] ."\n";	
					}
				}
				
				if(strlen($dvd_extras)>0)
				{
					$this->addItemAttribute('dvd_extras', $dvd_extras);
				}					
			}
		}

		if(preg_match("!http://amazon.imdb.com/title/tt([0-9]*)!", $pageBuffer, $regs))
		{
			$this->addItemAttribute('imdb_id', $regs[1]);
		}
		
		if(preg_match("!<a href=/exec/obidos/tg/stores/detail/-/dvd/".$search_attributes_r['amazukasin']."/reviews/[^>]*>Reviews</a>!", $pageBuffer, $regs))
		{
			$reviewPage = $this->fetchURI("http://www.amazon.co.uk/exec/obidos/tg/stores/detail/-/dvd/".$search_attributes_r['amazukasin']."/reviews/");
			
			if(preg_match("/<b>Amazon.co.uk Review<\/b><br>(.*)$/m", $reviewPage, $regs))
			{
				if(preg_match_all("/(.*)<p>/U", trim($regs[1]), $matches))
				{
					// save the review first.
					$this->addItemAttribute('blurb', $matches[1][0]);
					
					for($i=1; $i<count($matches[1]); $i++)
					{
						if(preg_match("!<b>Synopsis</b><br>(.*)$!m", trim($matches[1][$i]), $regs2))
						{
							$this->addItemAttribute('synopsis', $regs2[1]);
						}
						else if(preg_match("!<b>From the Back Cover</b><br>(.*)$!m", trim($matches[1][$i]), $regs2))
						{
							$this->addItemAttribute('blurb', $regs2[1]);
						}
						else if(preg_match("!<b>DVD Description</b><br>(.*)$!m", trim($matches[1][$i]), $regs2))
						{
							$this->addItemAttribute('blurb', $regs2[1]);
						}
					}
				}
			}
		}
		
		/**
		<b>Browse similar items in:</b></p>     <ul>     <li><a href="/exec/obidos/tg/browse/-/283926/ref=dp_brlad_entry/026-9147519-9634865">DVD</a> &gt; <a href="/exec/obidos/tg/browse/-/573406/ref=dp_brlad_entry/026-9147519-9634865">Categories</a> &gt; <a href="/exec/obidos/tg/browse/-/501778/ref=dp_brlad_entry/026-9147519-9634865">Action &amp; Adventure</a> &gt; <a href="/exec/obidos/tg/browse/-/501792/ref=dp_brlad_entry/026-9147519-9634865">Heroes &amp; Heroines</a>
		*/
		
		// Attempt to include data from IMDB if available - but only for DVD, VHS, etc
		// as IMDB does not work with BOOKS or CD's.
		if(is_numeric($this->getItemAttribute('imdb_id')))
		{
			$sitePlugin =& get_site_plugin_instance('imdb');
			if($sitePlugin !== FALSE)
			{
				if($sitePlugin->queryItem(array('imdb_id'=>$this->getItemAttribute('imdb_id')), $s_item_type))
				{
					// no mapping process is performed here, as no $s_item_type was provided.
					$itemData = $sitePlugin->getItemData();
					if(is_array($itemData))
	      			{
						// merge data in here.
						while(list($key,$value) = each($itemData))
						{
							if($key == 'actors')
								$this->replaceItemAttribute('actors', $value);
							else if($key == 'director')
								$this->replaceItemAttribute('director', $value);
							else if($key == 'year')
								$this->replaceItemAttribute('year', $value);
							else if($key == 'actors')
								$this->replaceItemAttribute('actors', $value);
							else if($key == 'genre')
								$this->replaceItemAttribute('genre', $value);
							else if($key == 'plot') //have to map from imdb to amazon attribute type.
								$this->addItemAttribute('blurb', $value);
							else if($key != 'age_rating' && $key != 'run_time')
								$this->addItemAttribute($key, $value);
						}
					}
				}
			}
		}
	}
}
?>