<?php
include_once("./functions/database.php");
include_once("./functions/logging.php");
include_once("./functions/listutils.php");
include_once("./functions/utils.php");
include_once("./functions/theme.php");
include_once("./functions/widgets.php");
include_once("./functions/Listing.class.inc");

/*
* A utility function which can be used to ascertain whether
* Listing checked vars are included in the $HTTP_VARS array,
* and that there is at least one processable value included.
* 
* This includes the plain checkbox column, as well as the
* 'checked_'.$check_box_name.'_list' value.
*/
function is_checked_listing_vars($HTTP_VARS, $check_box_name)
{
	if(is_not_empty_array($HTTP_VARS[$check_box_name]) || strlen(trim($HTTP_VARS['checked_'.$check_box_name.'_list']))>0)
		return TRUE;
	else
		return FALSE;
}

class HTML_Listing extends Listing
{
	// display printable link
	var $_include_printable_href = TRUE;
	var $_include_items_per_page_control = TRUE;
	var $_include_listing_footer = TRUE;
	var $_include_href_links = TRUE;
	
	// Checkbox management
	var $_check_box_name = NULL;
	var $_display_check_box_column = NULL;
	var $_check_box_count = 0;
	
	var $_no_rows_checked_msg = NULL;
	
	// between page state
	var $_cache_checked_count = 0;
	var $_checked_list_checked_count = 0;
	
	// by default the _write method automatically spools out straight out via echo()
	// command.  This setting can force it to be cached, and thus accessible via
	// the getContents() method.
	var $_buffer_output = FALSE;
	var $_buffer = NULL;
	
	// Array of all navigation controls at the top of the page.
	var $_navigate_controls;
	
	// listing row CSS class tracking
	var $rowclass = '';
	
	// What type of form navigation are we using.
	var $_header_controls_form;
	var $_footer_controls_form;
	var $_listing_form;
	
	// Array of all Op Actions that need to be displayed at the bottom of the page.
	var $_list_actions;
	
	var $_checked_list;	
	var $_session_var_list;
	
	var $_back_to_listing_text = NULL;
	
	/*
	* @param $PHP_SELF
	* @param $HTTP_VARS
	* 
	* @param $mode - 'printable' or not
	*/
	function HTML_Listing($PHP_SELF, $HTTP_VARS, $mode=NULL)
	{
		parent::Listing($PHP_SELF, $HTTP_VARS, $mode);
		
		// The item listing
		$this->_listing_form = 
				array('name'=>'listings', 
					'method'=>'POST');
		
		global $CONFIG_VARS;
		
		if($CONFIG_VARS['listings.navigation_form_method'] == 'POST')
		{
			// The Alpha list, item type, item group, etc restrictions
			$this->_header_controls_form = 
					array('name'=>'listings', 
						'method'=>'POST');
		
			// The next/previous and page_no links
			$this->_footer_controls_form = 
					array('name'=>'listings', 
						'method'=>'POST');
		}
		else if($CONFIG_VARS['listings.navigation_form_method'] == 'GET')
		{
			// The Alpha list, item type, item group, etc restrictions
			$this->_header_controls_form = 
					array('name'=>'navigate', 
						'method'=>'GET');
		
			// The next/previous and page_no links
			$this->_footer_controls_form = 
					array('name'=>'navigate', 
						'method'=>'GET');
		}
	}
	
	function setPrintableLinkVisible($boolean)
	{
		if($boolean === TRUE)//in case $boolean is not actually a boolean.
			$this->_include_printable_href = TRUE;
		else
			$this->_include_printable_href = FALSE;
	}
	
	function setItemsPerPageControlVisible($boolean)
	{
		if($boolean === TRUE)//in case $boolean is not actually a boolean.
			$this->_include_items_per_page_control = TRUE;
		else
			$this->_include_items_per_page_control = FALSE;
	}
	
	/*
	* Message to display in JavaScript alert, if No Rows are checked, and a Op Action is selected
	* which acts on Checked Items.  The default message is $LANG_VARS['no_items_checked']
	*/
	function setNoRowsCheckedMessage($message)
	{
		$this->_no_rows_checked_msg = $message;
	}
	
	function setBackToListingText($text)
	{
		$this->_back_to_listing_text = $text;
	}
	
	function setIncludeFooter($boolean)
	{
		$this->_include_listing_footer = $boolean;
	}
	
	function setIncludeHrefLinks($boolean)
	{
		$this->_include_href_links = $boolean;
	}
	
	function setBufferOutput($boolean)
	{
		$this->_buffer_output = $boolean;
	}
	
	/*
	* The $this->_http_vars['checked_'.$this->_check_box_name.'_list'] should be reset to EMPTY
	* once the update operation is performed against the list of items.
	*/
	function setCheckBoxColumnAndInitList($check_box_name, $display_check_box_column = FALSE, $session_var_list = NULL)
	{
		global $LANG_VARS;
		
		$this->_check_box_name = $check_box_name;
		$this->_display_check_box_column = $display_check_box_column;

		if($this->_check_box_name !== NULL)
		{
			if($session_var_list !== NULL)
			{
				$this->_session_var_list = $session_var_list;
			}
		
			if(strlen(trim($this->_http_vars['checked_'.$this->_check_box_name.'_list'])))
			{
				$this->_checked_list = explode(",", $this->_http_vars['checked_'.$this->_check_box_name.'_list']);
				unset($this->_http_vars['checked_'.$this->_check_box_name.'_list']);
			}
		
			if(is_array($this->_http_vars['checked_'.$this->_check_box_name]))
			{
				reset($this->_http_vars['checked_'.$this->_check_box_name]);
				while(list(,$value) = each($this->_http_vars['checked_'.$this->_check_box_name]))
				{
					if( !is_array($this->_http_vars[$this->_check_box_name]) || !in_array($value, $this->_http_vars[$this->_check_box_name]) )
					{
						if( is_array($this->_checked_list) && ($key = array_search2($value, $this->_checked_list))!==FALSE )
						{
							// Remove element
							array_splice($this->_checked_list, $key, 1);
						}
					}
				}
				unset($this->_http_vars['checked_'.$this->_check_box_name]);
			}
		
			if(is_array($this->_http_vars[$this->_check_box_name]))
			{
				reset($this->_http_vars[$this->_check_box_name]);
				while(list(,$value) = each($this->_http_vars[$this->_check_box_name]))
				{
					if( (!is_array($this->_checked_list) || !in_array($value, $this->_checked_list)) )
					{
						$this->_checked_list[] = $value;
					}
				}
				unset($this->_http_vars[$this->_check_box_name]);
			}
		}
	}
	
	/*
	* Removes checked items from internal list.
	*/
	function resetCheckedList()
	{
		$this->_checked_list = NULL;
	}
	
	function isCheckBoxColumn()
	{
		return ($this->_mode!='printable' && $this->_display_check_box_column!==FALSE && $this->_check_box_name!==NULL);
	}
	
	//
	// Getters
	//
	
	function getContents()
	{
		return $this->_buffer;
	}
	
	/*
	* Do not call before:
	* 	setCheckBoxColumnAndInitList($session_var_list)
	*/
	function getCheckedList()
	{
		return $this->_checked_list;
	}
	
	/*
	* Count of items CHECKED on current page, before page is generated, that are already
	* in the Checked List.
	* 
 	* Do not call before:
	* 	setCheckBoxColumnAndInitList($session_var_list)
	* 	
	* 	And all rows must be written out, to get an accurate value.
	*/
	function getCheckedListPageCount()
	{
		return $this->_checked_list_checked_count;
	}
	
	/**
	* Returns number of rows on the current page which are
	* in the Session var.
	*/
	function getCacheCheckedCount()
	{
		return $this->_cache_checked_count;
	}
	
	/*
	* Do not call before:
	* 	setCheckBoxColumnAndInitList($session_var_list)
	*/
	function getCheckedListCount()
	{
		if(is_array($this->_checked_list))
			return count($this->_checked_list);
		else
			return 0;
	}
	
	function getCheckBoxColumn()
	{
		return $this->_check_box_name;
	}
	
	/*
	* Number of rows with checkboxes included, whether checked or not.
	*/
	function getCheckBoxCount()
	{
		return $this->_check_box_count;
	}
	
	/*
	* @param $text
	* @param $script_url - If blank will default to $PHP_SELF
	* @param $operation 
	* @param $do_checked_test - If TRUE, will do logic to check if items are selected
	* 							in the listing.
	*/
	function addListOpAction($text, $script_uri, $operation, $do_checked_test=TRUE)
	{
		$this->_list_actions[] = array('text'=>$text, 
										'type'=>'operation',
										'script_uri'=>$script_uri,
										'operation'=>$operation,
										'do_checked_test'=>$do_checked_test);
	}
	
	function addListFieldValueAction($text, $script_uri, $operation, $field, $value)
	{
		$this->_list_actions[] = array('text'=>$text, 
										'type'=>'operation',
										'script_uri'=>$script_uri,
										'operation'=>$operation,
										'do_checked_test'=>FALSE,
										'field'=>$field,
										'value'=>$value);
	}
	
	function addListHrefAction($text, $src)
	{
		$this->_list_actions[] = array('text'=>$text, 
									'type'=>'href',
									'src'=>$src);
	}
	
	function addSelectControl($text, $fieldname, $results, $display_mask, $value=NULL, $valkey=NULL)
	{
		$this->_navigate_controls[] = array(
						'type'=>'select',
						'field'=>$fieldname,
						'block'=>"<select name=\"$fieldname\" class=\"footer\" onChange=\"restrictSubmit(this.form);\">".
									"\n<option value=\"\">- ".$text." -".
									custom_select($fieldname, 
											$results,
											$display_mask,
											'NA',
											$value,
											$valkey).
								"\n</select>");
	}
	
	/*
	* @param $toggle_options - Format should be
	* 				array('value'=>'display', 'value'=>'display')
	*/
	function addToggleControl($text, $fieldname, $value)
	{
		global $LANG_VARS;
		
		$this->_navigate_controls[] = array(
						'type'=>'toggle',
						'field'=>$fieldname,
						'block'=>"<table><tr><td align=center class=\"footer\">".
								$text.":</td></tr>".
								"<tr><td class=\"footer\" nowrap>".
									"<input type=radio class=\"footer\" name=\"$fieldname\" value=\"Y\" onclick=\"toggleSubmit(this.form); return true;\"".(strcasecmp($value, 'Y')===0?" CHECKED":"").">".$LANG_VARS['yes'].
									"&nbsp;".
									"<input type=radio class=\"footer\" name=\"$fieldname\" value=\"N\" onclick=\"toggleSubmit(this.form); return true;\"".(strcasecmp($value, 'N')===0?" CHECKED":"").">".$LANG_VARS['no'].
								"</td></tr></table>");
	}
	
	function addAlphaList($letter)
	{
		global $LANG_VARS;
	
		$buffer = "\n<i>".$LANG_VARS['alpha_listing']." </i>[&nbsp;";

		// There is an even better way to do this: foreach(range('A','Z') as $letter) -- not supported before 4.07
		foreach(array(1 => "#","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z") as $char)
		{
			if($letter == $char)
				$buffer .= "<u>$char</u>&nbsp; ";//letter chosen does not have a link.
			else
			{
				$buffer .= "<a href=\"javascript:restrictLetter(document.forms['".$this->_header_controls_form['name']."'], '$char')\" class=\"alphalist\">$char</a>&nbsp; ";
			}
		}

		// So we can reset display to everything.
		if(strlen($letter)>0)
		{
			$buffer .= "<a href=\"javascript:restrictLetter(document.forms['".$this->_header_controls_form['name']."'], '')\" class=\"alphalist\">".$LANG_VARS['all']."</a>&nbsp; ";
		}
			
		$buffer .= "]&nbsp;";
	
		$this->_navigate_controls[] = 
				array(
					'type'=>'alphalist',
					'field'=>'letter',
					'block'=>$buffer,
					'value'=>$letter
				);
	}
	
	/*
	* Do not call this function until the following methods have
	* been called:
	* 
	* These only if you want to do paging,
	*	setTotalItems($total_items)	
	* 
	* Thes only if you are supporting Checked Box handling.
	* 	setCheckBoxColumnAndInitList($name, $enable, $session_list_vars)	
	* 
	* These only if you are providing navigation control.
	*	addSelectControl($text, $fieldname, $results, $display_mask, $value=NULL, $valkey=NULL)
	*	addToggleControl($text, $fieldname, $value)
	*	addAlphaList($letter)
	*/
	function startListingImpl()
	{
		global $CONFIG_VARS;
		global $LANG_VARS;
		
		if($this->_mode == 'printable')
		{
			$this->_write("\n<table width=100% cellspacing=0 border=0><tr><td>".
					"<table width=100% cellspacing=0 border=1>");
		}
		else
		{
			if(is_array($this->_navigate_controls) || 
					is_array($this->_list_actions) ||
					$this->_include_items_per_page_control!==FALSE || 
					$this->_include_listing_footer !== FALSE)
			{
				$this->_write(get_checked_javascript());
				$this->_write(get_navigation_javascript());
			
				$this->_write("\n<form action=\"".$this->_php_self."\" name=\"".$this->_header_controls_form['name'].
							"\" method=\"".$this->_header_controls_form['method']."\">");
			
				$exclude_vars_r = array();
			
				if(is_array($this->_navigate_controls))
				{
					reset($this->_navigate_controls);
					while(list(,$control) = each($this->_navigate_controls))
					{
						$exclude_vars_r[] = $control['field'];
						if($control['type'] == 'alphalist')//only one that does not use form fields
							$this->_write("\n<input type=hidden name=\"".$control['field']."\" value=\"".$control['value']."\">");
					}
				}
					
				$this->_write("\n<table width=100% cellspacing=2 cellpadding=0 border=0>");
				$this->_write("\n<tr>");
		
				$this->_write("<td class=\"footer\">");
				if(is_array($this->_navigate_controls))
				{
					$type = NULL;
					reset($this->_navigate_controls);
					while(list(,$control) = @each($this->_navigate_controls))
					{
						if($control['type'] == 'select')
						{
							if($type != NULL && $control['type'] === $type)
								$this->_write("<br>\n");
							$type = $control['type'];
							$this->_write($control['block']);
						}
					}
				}
				$this->_write("</td>");
			
				$this->_write("<td align=right class=\"footer\">");
				if(is_array($this->_navigate_controls))
				{
					$type = NULL;
					reset($this->_navigate_controls);
					while(list(,$control) = each($this->_navigate_controls))
					{
						if($control['type'] == 'toggle')
						{
							$this->_write($control['block']);
						}
					}
				}
			
				if($this->_include_items_per_page_control !== FALSE && is_not_empty_array($CONFIG_VARS['listings.items_per_page_options']))
				{
					$exclude_vars_r[] = 'items_per_page';
				
					if(is_array($this->_navigate_controls))
					{
						$this->_write("<br>\n");
					}
				
					$this->_write($LANG_VARS['items_per_page'].": ".
							"<select name=\"items_per_page\" class=\"footer\" onChange=\"restrictSubmit(this.form);\">".
								custom_select('items_per_page', 
										$CONFIG_VARS['listings.items_per_page_options'],
										'%value%',
										'NA',
										ifempty($this->_http_vars['items_per_page'],$this->getItemsPerPage()),
										'valkey').
							"\n</select>");
				}
					
				$this->_write("</td>");
				$this->_write("\n</tr>");
			
				$this->_write("\n<tr>");
				$this->_write("<td colspan=2 class=\"footer\" align=center>");
				if(is_array($this->_navigate_controls))
				{
					$type = NULL;
					reset($this->_navigate_controls);
					while(list(,$control) = each($this->_navigate_controls))
					{
						if($control['type'] == 'alphalist')
						{
							$this->_write($control['block']);
						}
					}
				}
				$this->_write("</td>");
				$this->_write("\n</tr>");
			
				$this->_write("</table>");
			
				if($this->_header_controls_form['name'] !== $this->_listing_form['name'])
				{
					$this->_write(
						get_url_fields(
							$this->_http_vars,
							array( // required
								'page_no'=>$this->_page_no,
								'order_by'=>$this->_http_vars['order_by'],
								'sortorder'=>$this->_http_vars['sortorder'],
								'internal_link'=>'true'),
							array_merge(
								$exclude_vars_r,
								array( // exclude
									$this->_check_box_name, 
									'checked_'.$this->_check_box_name, 
									'checked_'.$this->_check_box_name.'_list')
								)
							));
	
					$this->_write("\n</form>");
			
					$this->_write("\n<form action=\"".$this->_php_self."\" name=\"".$this->_listing_form['name'].
								"\" method=\"".$this->_listing_form['method']."\">");
				}
			
				$this->_write(
					get_url_fields(
						$this->_http_vars, 
						array( // required
							'op'=>$this->_http_vars['op'],
							'page_no'=>$this->_page_no,
							'order_by'=>$this->_http_vars['order_by'],
							'sortorder'=>$this->_http_vars['sortorder'],
							'internal_link'=>'true',
						'checked_'.$this->_check_box_name.'_list'=>convert_array_to_csv_list($this->_checked_list)),
							array_merge(
								$exclude_vars_r,
							array( //exclude
								$this->_check_box_name, 
								'checked_'.$this->_check_box_name)
							)
						));
			}
			
			$this->_write("\n<table width=100% cellspacing=1 border=0>");
		}

		// take care of the checkbox here.		
		if($this->isCheckBoxColumn())
		{
			$this->addHeaderColumn(NULL, $this->_check_box_name);
		}
	}
	
	/*
	* Ensure the following methods have been called:
 	* 	setCheckBoxColumnAndInitList($name, $enable, $session_list_vars)	
	*	setTotalItems($total_items)
	* 	startListing()
	*/
	function endListingImpl($first_item=NULL, $last_item=NULL, $start_page=NULL, $end_page=NULL, $total_pages=NULL)
	{
		global $LANG_VARS;
		global $CONFIG_VARS;
		
		// Output navigation footer!
		if($this->_mode == 'printable')
		{
			$this->_write("\n</table>");
		}
		
		if($this->_include_listing_footer)
		{
			if($this->getRowCount() > 0)
			{
				$this->_write("\n<tr><td colspan=".$this->getNoOfColumns().">");
				$this->_write("\n<table width=100% cellspacing=5 border=0>");
			
				$this->_write("\n<tr><td align=left width=33% class=\"footer\">".
							replace_lang_vars(array('first_row'=>$first_item,'last_row'=>$last_item,'total'=>$this->_total_items), $LANG_VARS['page_listing_index']).
							"</td>");

				// Pages
				$this->_write("<td align=center width=33% class=\"footer\">");
				if($first_item>1 || $last_item < $this->_total_items)// Only if more than one page.
				{
					$this->_write("\n[&nbsp;");

					// Check if we need to supply << arrows.
					if($start_page > 1)
					{
						if($start_page > 10)
							$this->_write("<a href=\"javascript:gotoPage(document.forms['".$this->_footer_controls_form['name']."'], '".($start_page - 10)."');\" class=\"footer\">&lt;&lt;</a>&nbsp;");
						else
							$this->_write("<a href=\"javascript:gotoPage(document.forms['".$this->_footer_controls_form['name']."'], '1');\" class=\"footer\">&lt;&lt;</a>&nbsp;");
					}

					for($i=$start_page; $i<=$end_page; $i++)
					{
						if($i>$start_page)
							$this->_write(",&nbsp;");

						if($i == $this->_page_no)
							$this->_write("<u>$i</u>");
						else
							$this->_write("<a href=\"javascript:gotoPage(document.forms['".$this->_footer_controls_form['name']."'], '$i');\" class=\"footer\">".$i."</a>");
					}
	
					// If more than 10 pages to end.
					if($end_page < $total_pages)
					{
						$this->_write("&nbsp;<a href=\"javascript:gotoPage(document.forms['".$this->_footer_controls_form['name']."'], '".($end_page+1)."');\" class=\"footer\">&gt;&gt;</a>");
					}
	
					$this->_write("&nbsp;]".
						"\n</td>".
						"<td align=right width=33% class=\"footer\">");
	
					// A bit of a kludge, but it does work.
					if($this->_page_no>1)
						$this->_write("<a href=\"javascript:gotoPage(document.forms['".$this->_footer_controls_form['name']."'], '".($this->_page_no-1)."');\" class=\"footer\">"._theme_image("left.gif", "<=", NULL, "absmiddle")." ".$LANG_VARS['previous_page']."</a>");
					else
						$this->_write("&nbsp;");

					if($this->_page_no>1 && $this->_page_no < $total_pages)
					{
						$this->_write("&nbsp;/&nbsp;");
					}

					if($this->_page_no < $total_pages)
						$this->_write("<a href=\"javascript:gotoPage(document.forms['".$this->_footer_controls_form['name']."'], '".($this->_page_no+1)."');\" class=\"footer\">".$LANG_VARS['next_page']." "._theme_image("right.gif", "=>", NULL, "absmiddle")."</a>");
					else
						$this->_write("&nbsp;");
				}
				$this->_write("</td>");
				
				$this->_write("</tr>");
				$this->_write("</table>");
				$this->_write("\n</td></tr>");
			} // if($this->getRowCount() > 0)
			else
			{
				$this->_write("\n<tr><td align=\"center\" colspan=".$this->getNoOfColumns().">");
				$this->_write("<div class=\"error\"><b>- ".$this->_no_rows_message." -</b></div>");
				$this->_write("\n</td></tr>");
			}
		}
		
		if(is_not_empty_array($this->_list_actions))
		{
			$this->_write("\n<tr><td colspan=".$this->getNoOfColumns()." align=\"center\">");
			while(list(,$action_r) = each($this->_list_actions))
			{
				if($action_r['type'] == 'operation')
				{
					if(strlen($action_r['script_uri'])>0)
						$doOperationAction = "doOperation(this.form, '".$action_r['script_uri']."', '".$action_r['operation']."')";
					else
						$doOperationAction = "doInternalOperation(this.form, '".$action_r['operation']."')";
				
					if(strlen($action_r['field'])>0)
					{
						$doOperationAction = 'this.form[\''.$action_r['field'].'\'].value=\''.$action_r['value'].'\'; '.$doOperationAction;
					}
					
					if($action_r['do_checked_test']!==FALSE)
						$this->_write("\n<input type=\"button\" onclick=\"if(!isChecked(this.form, '".$this->_check_box_name."[]')){alert('".ifempty($this->_no_rows_checked_msg, $LANG_VARS['no_items_checked'])."');}else{".$doOperationAction.";}\" value=\"".$action_r['text']."\">");
					else
						$this->_write("\n<input type=\"button\" onclick=\"".$doOperationAction.";\" value=\"".$action_r['text']."\">");
				}
				else if($action_r['type'] == 'href')
				{
					$this->_write('<a href="'.$action_r['src'].'">'.$action_r['text'].'</a>');
				}
			}
			$this->_write("\n</td></tr>");
		}
		
		$this->_write("\n</table>");
		if($this->_mode != 'printable')
		{
			if(is_array($this->_navigate_controls) || 
					is_array($this->_list_actions) ||
					$this->_include_items_per_page_control!==FALSE || 
					$this->_include_listing_footer !== FALSE)
			{
				$this->_write("\n</form>");
			}
		}
		
		if($this->getRowCount() > 0)
		{
			if($this->_mode != 'printable' && 
					$this->_include_printable_href !== FALSE && 
					$this->getTotalItemCount() > $this->getRowCount())
			{
				$this->addHelpEntry(
					replace_lang_var("total", $this->getTotalItemCount(), $LANG_VARS['printable_version_notes']));
			}
		
			// now output the help entries.
			if(is_array($this->_help_entry_rs))
			{
				$this->_write(format_help_block($this->_help_entry_rs));
			}
		
			if($this->_mode != 'printable' && $this->_include_printable_href !== FALSE)
			{
				echo("\n<p align=center class=\"footer\"><i><a href=\"".$this->_php_self."?".
						get_url_string(
							$this->_http_vars, 
							array('mode'=>'printable'), //include
							array( //exclude
								'page_no',
								'listing_link',
								'internal_link',
								'items_per_page')).
					"\" target=_blank>"._theme_image('printable.gif', '', NULL, 'absmiddle').$LANG_VARS['printable_version']."</a></i></p>");
			}
		}//if($this->getRowCount() > 0)
	}
		
	function writeHeaderRowImpl($header_column_rs)
	{
		global $LANG_VARS;
			
		$this->_write("\n<tr>");
		for($i=0; $i<count($header_column_rs); $i++)
		{
			if($i == 0 && $header_column_rs[$i]['title'] === NULL && $header_column_rs[$i]['fieldname'] == $this->_check_box_name)
			{
				$this->_write("<td class=\"navbar\"><input type=checkbox onclick=\"doChecks(this.checked, this.form, '".$this->_check_box_name."[]');return true;\"></td>");
			}
			else
			{
				if(is_numeric($this->_header_column_rs[$i]['width']))
					$width = $this->_header_column_rs[$i]['width'];
				else if(is_numeric($this->_header_column_rs[$i]['width_percentage']))
					$width = $this->_header_column_rs[$i]['width_percentage'].'%';
				else
					$width = NULL;

				$this->_write("<td class=\"navbar\" ".($width?"width=\"$width\"":"")." nowrap>");
	
				if($this->_header_column_rs[$i]['fieldname'] !== NULL)
				{
					// Pass the opposite of $sortorder to next instance, for the header links only.
					if(strlen($this->_current_sortorder)==0 || strcasecmp($this->_current_sortorder, "desc")===0)
						$sortorder = 'ASC';
					else
						$sortorder = 'DESC';

					$column_value = '';
					// Only display the order image if current orderby matches.
					if($this->_current_orderby == $header_column_rs[$i]['fieldname'])
					{ 
						if($this->_mode != 'printable')
						{
							$column_value = "<a href=\"javascript:sortOrder(document.forms['".$this->_header_controls_form['name']."'], '".$this->_header_column_rs[$i]['fieldname']."', '".$sortorder."');\" class=\"navbar\">";
						}

						$column_value .= nl2br($header_column_rs[$i]['title']);
	
						if(strcasecmp($this->_current_sortorder, "asc")===0)
							$column_value .= '&nbsp;'._theme_image("asc_order.gif", NULL, NULL, "absmiddle");
						else if(strcasecmp($this->_current_sortorder, "desc")===0)
							$column_value .= '&nbsp;'._theme_image("desc_order.gif", NULL, NULL, "absmiddle");
					
						if($this->_mode != 'printable')
						{
							$column_value .= '</a>';
						}
					}
					else
					{
						if(strlen($this->_current_sortorder)==0)
							$this->_current_sortorder = 'ASC';

						if($this->_mode != 'printable')
						{
							// For new sort order columns, we want to sort by current sortorder instead.
							$column_value = "<a href=\"javascript:sortOrder(document.forms['".$this->_header_controls_form['name']."'], '".$header_column_rs[$i]['fieldname']."', '".$this->_current_sortorder."');\" class=\"navbar\">".$header_column_rs[$i]['title']."</a>";
						}
						else
						{
							$column_value = nl2br($header_column_rs[$i]['title']);
						}
					}
					$this->_write($column_value);
				}
				else
				{
					$this->_write(nl2br($header_column_rs[$i]['title']));
				}
				$this->_write("</td>");
			}
		}//for($i=0; $i<count($this->_header_column_rs); $i++)
		$this->_write("\n</tr>");
	}
		
	function writeRowImpl($row_column_rs, $render_row_checkbox = TRUE)
	{
		global $LANG_VARS;
		global $CONFIG_VARS;
		global $HTTP_SESSION_VARS;
		
		if($this->_toggle)
			$this->rowclass = "top";
		else
			$this->rowclass = "top2";
		
		// store a reference to the item title, if encountered for a row.
		$item_title = NULL;
		
		$this->_write("\n<tr>");
		for($i=0; $i < count($row_column_rs); $i++)
		{
			$colspan = 1;
			if( ($i+1) == count($row_column_rs)) // if this is the last for loop iteration
			{
				$colspan = ($this->getNoOfColumns() - count($row_column_rs))+1; // the _+1 is to include the current column
			}
				
			if($row_column_rs[$i]['column_type'] == 'action_links')
			{
				$this->_write(
					format_action_links(
						$row_column_rs[$i]['action_links'],
						"\n<td align=\"center\" class=\"".$this->rowclass."\" %nowrap%><font class=\"smlink\">%field%</font></td>",
						$LANG_VARS['not_applicable']));
			}
			else
			{
				switch($row_column_rs[$i]['column_type'])
				{
					case 'username':
						$this->_write('<td align="center" class="'.$this->rowclass.'"'.($colspan>1?' colspan="'.$colspan.'"':'').'>');
						$user_id = $row_column_rs[$i]['user_id'];
						$fullname = $row_column_rs[$i]['fullname'];
					
						if($user_id == $HTTP_SESSION_VARS['user_id'])
						{
							$this->_write(replace_lang_vars(array('fullname'=>str_replace(" ", "&nbsp;", $fullname), 'user_id'=>$user_id), str_replace(" ", "&nbsp;", $LANG_VARS['current_user'])));
						}
						else
						{
							$user_name = replace_lang_vars(array('fullname'=>str_replace(" ", "&nbsp;", $fullname), 'user_id'=>$user_id), $LANG_VARS['user_name']);
							if($this->_mode != 'printable' && $this->_include_href_links && $CONFIG_VARS['listing.user_email_link']!==FALSE && is_user_allowed_to_borrow($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
							{
								// if the title column has not been encountered yet, we want to find it in the rest of
								// the columns (after this one).
								if($item_title===NULL)
								{
									// lets find the title column.
									for($j=$i; $j < count($row_column_rs); $j++)
									{
										if($row_column_rs[$j]['column_type'] == 'title')
										{
											$item_r = $row_column_rs[$j]['item_record'];
											if(is_array($item_r))
												$item_title = $item_r['title'];
											break;
										}
									}
								}
								
								$this->_write("<a href=\"email.php?op=send_to_uid&uid=".$user_id."&subject=".urlencode(ifempty($item_title,$LANG_VARS['no_subject']))."&redirect_link=".urlencode(ifempty($this->_back_to_listing_text, $LANG_VARS['back_to_listing']))."&redirect_url=".urlencode($this->_php_self.'?'.get_url_string($this->_http_vars))."\" title=\"".htmlspecialchars($LANG_VARS['send_email'])."\">$user_name</a>");
							}
							else
							{
								$this->_write($user_name);
							}
						}
						$this->_write('</td>');
						break;
					
					case 'item_type_image':
						$this->_write('<td align="center" class="'.$this->rowclass.'"'.($colspan>1?' colspan="'.$colspan.'"':'').'>');
						$s_item_type = $row_column_rs[$i]['s_item_type'];
						$is_linked_item = $row_column_rs[$i]['is_linked_item'];
						
						if(!is_array($this->_item_type_rs[$s_item_type]) || strlen($this->_item_type_rs[$s_item_type]['image'])==0)
						{
							$this->_item_type_rs[$s_item_type] = fetch_item_type_r($s_item_type);

							// expand to the actual location once only.
							if(strlen($this->_item_type_rs[$s_item_type]['image'])>0)
								$this->_item_type_rs[$s_item_type]['image'] = _theme_image_src($this->_item_type_rs[$s_item_type]['image']);
							else
								$this->_item_type_rs[$s_item_type]['image'] = 'none';
							
							if(strlen($this->_item_type_rs[$s_item_type]['description'])>0)
								$this->_item_type_rs[$s_item_type]['description'] = htmlspecialchars($this->_item_type_rs[$s_item_type]['description']);
							else
								$this->_item_type_rs[$s_item_type]['description'] = NULL;
						}
		
						if(strlen($this->_item_type_rs[$s_item_type]['image'])>0 && $this->_item_type_rs[$s_item_type]['image'] != 'none')
						{
							$this->_write(
								_theme_image(
										$this->_item_type_rs[$s_item_type]['image'],
										$s_item_type,
										$this->_item_type_rs[$s_item_type]['description'],
										'absmiddle',
										's_item_type'));
						}
						else
						{
							// otherwise write the item type itself in place of the image.
							$this->_write($s_item_type);
						}
						
						if($is_linked_item)
						{
							$this->addHelpEntry($LANG_VARS['linked_item'], 'linked.gif', 'linked_item');
								
							$this->_write(
								_theme_image('linked.gif', 'L', $LANG_VARS['linked_item'], 'top'));
						}
						$this->_write('</td>');
						break;
						
					case 'theme_image':
						$this->_write('<td align="center" class="'.$this->rowclass.'"'.($colspan>1?' colspan="'.$colspan.'"':'').'>');
						if(is_array($row_column_rs[$i]['images']))
						{
							for($j=0; $j<count($row_column_rs[$i]['images']); $j++)
							{
								$this->_write(
									_theme_image(
										$row_column_rs[$i]['images'][$j]['src'], 
										htmlspecialchars($row_column_rs[$i]['images'][$j]['alt']),
										htmlspecialchars($row_column_rs[$i]['images'][$j]['title']),
										$row_column_rs[$i]['images'][$j]['align'],
										$row_column_rs[$i]['images'][$j]['type'],
										NULL,
										$row_column_rs[$i]['images'][$j]['width'],
										$row_column_rs[$i]['images'][$j]['height']));
							}
						}
						else
						{	
							$this->_write(
								_theme_image(
									$row_column_rs[$i]['src'], 
									htmlspecialchars($row_column_rs[$i]['alt']),
									htmlspecialchars($row_column_rs[$i]['title']),
									$row_column_rs[$i]['align'],
									$row_column_rs[$i]['type'],
									NULL,
									$row_column_rs[$i]['width'],
									$row_column_rs[$i]['height']));
						}
						$this->_write('</td>');
						break;
					
					case 'title':
						$this->_write('<td align="center" class="'.$this->rowclass.'"'.($colspan>1?' colspan="'.$colspan.'"':'').'>');
						$item_r = $row_column_rs[$i]['item_record'];
						$item_cover_image = $row_column_rs[$i]['item_cover_image'];
						$is_item_reviewed = $row_column_rs[$i]['is_item_reviewed'];
						$is_borrowed_or_returned = $row_column_rs[$i]['is_borrowed_or_returned'];
						
						// store a reference for the username column if defined.
						$item_title = $item_r['title'];
						
						if($this->_mode != 'printable' && $this->_include_href_links)
						{
							$item_r['title'] = 
								'<a href="item_display.php?item_id='.(is_numeric($item_r['parent_id'])?$item_r['parent_id']:$item_r['item_id']).
									'&instance_no='.$item_r['instance_no'].
									(strlen($this->_http_vars['listing_link'])>0?'&listing_link='.$this->_http_vars['listing_link']:'').
									(is_numeric($item_r['parent_id'])?'#linked_item':'').'">'.
									$item_r['title'].
								'</a>';
						}
				
						$append_to_title = '';
				
						if($is_item_reviewed)
						{
							// show star if rated - Add it to the actual title, so we can do a bit more with title masks
							$this->addHelpEntry($LANG_VARS['item_reviewed'], 'rs.gif', 'item_reviewed');
							$append_to_title .= _theme_image('rs.gif', NULL, $LANG_VARS['item_reviewed'], 'top');
						}
				
						if($is_borrowed_or_returned)
						{
							$this->addHelpEntry($LANG_VARS['youve_borrow_or_return'], 'tick.gif', 'borrow_or_return');
							$append_to_title .= _theme_image("tick.gif", NULL, $LANG_VARS['youve_borrow_or_return'], 'top'); // show tick if previously borrowed or returned.
						}
						
						$cover_image_tag = get_cover_image($item_cover_image, NULL, $CONFIG_VARS['listings.item_image_size']);
						if(strlen($cover_image_tag)>0)
						{
							$this->_write(
								"<table width=100% border=0 cellpadding=0 cellspacing=0><tr><td width=10% class=\"".$this->rowclass."\">".
								$cover_image_tag.
								"</td>".
								"<td align=\"center\" class=\"".$this->rowclass."\">".
								$item_r['title'].(strlen($append_to_title)>0?"&nbsp;".$append_to_title:"").
								"</td></tr></table>");
						}	
						else
						{
							$this->_write(
								$item_r['title'].(strlen($append_to_title)>0?"&nbsp;".$append_to_title:""));
						}
						$this->_write('</td>');
						break;
						
					case 'attribute_display_type':
						$this->_write('<td align="center" class="'.$this->rowclass.'"'.($colspan>1?' colspan="'.$colspan.'"':'').'>');
						
						$this->_write(
							ifempty(
								get_display_field(
									$row_column_rs[$i]['attribute_type'], 
									$row_column_rs[$i]['prompt'], 
									$row_column_rs[$i]['display_type'], 
									$row_column_rs[$i]['value'], 
									FALSE), // dowrap false!
								'&nbsp;'));
						$this->_write('</td>');
						break;
					
					default:
						$this->_write('<td align="center" class="'.$this->rowclass.'"'.($colspan>1?' colspan="'.$colspan.'"':'').'>');
						$value = $row_column_rs[$i]['value'];

						$column_buffer = '';
						if($value !== NULL && $i == 0 && $this->isCheckBoxColumn())
						{
						    if($render_row_checkbox!==FALSE)
						    {
								if(is_array($this->_session_var_list) && in_array($value, $this->_session_var_list))
								{
									$column_buffer .= _theme_image("gs.gif", NULL, $LANG_VARS['item_in_reserve_list'], "absmiddle");
									$this->addHelpEntry($LANG_VARS['item_in_reserve_list'], 'gs.gif', 'item_in_reserve_list');
									$this->_cache_checked_count++;
								}
								else if(is_array($this->_checked_list) && in_array($value, $this->_checked_list))
								{
									$column_buffer .= "<input type=hidden name=\"checked_".$this->_check_box_name."[]\" value=\"".$value."\">";
									$column_buffer .= "<input type=checkbox name=\"".$this->_check_box_name."[]\" value=\"".$value."\" CHECKED>";
									$this->_checked_list_checked_count++;
									$this->_check_box_count++;
								}
								else
								{
									$column_buffer .= "<input type=checkbox name=\"".$this->_check_box_name."[]\" value=\"".$value."\">";
									$this->_check_box_count++;
								}
							}
							else
							{
							    $column_buffer .= '&nbsp;';
							}
						}
						else
						{
							if(strlen($value)>0)
								$column_buffer .= $value;
							else
								$column_buffer .= '&nbsp;';
						}
						$this->_write($column_buffer);
						$this->_write('</td>');
						break;
				}
				$this->_write('</td>');
			}
		}//for($i=0; $i<count($this->_row_column_rs); $i++)
		$this->_write("\n</tr>");	
	}
	
	//
	// Hidden worker methods
	//
	
	/*
	* Hidden method to write out content
	*/
	function _write($s)
	{
		if($this->_buffer_output)
		{
			$this->_buffer .= $s;
		}
		else
		{
			echo($s);
		}
	}
}
?>
