<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/database.php");
include_once("./functions/auth.php");
include_once("./functions/logging.php");
include_once("./functions/email.php");
include_once("./functions/widgets.php");
include_once("./functions/user.php");
include_once("./functions/HTML_Listing.class.inc");

/*
* This script supports several different operations
* 
* 	$op = 'send_to_all'
* 		This will format an email email to all OpenDb users, except the currently
* 		logged in users.
* 
* 		Applicable variables:
* 			$toname - A title identifying the user group.
* 			$subject - The subject of the email
* 			$message - The message, if bypassing the email form.
* 		
* 		This operation is NOT available to a non-opendb Administrator user, and so 
* 		the $from and $fromname variables will be ignored.
* 
* 	$op = 'send_to_usertype'
* 
* 		Applicable variables:
* 			$usertype - User Type (N=Normal,A=Admin,B=Borrower,G=Guest)
* 				The $from user must be at least the type of user they are sending
* 				email to.  For instance a Normal user cannot send mail to Admin group.
* 			$toname - A title identifying the user group.
* 			$subject - The subject of the email
* 			$message - The message, if bypassing the email form.
* 
* 		This operation is NOT available to a non-opendb user, and so the $from
* 		and $fromname variables will be ignored.
* 			
* 	$op = 'send_to_uids'
* 
* 		Applicable Variables:
* 			$uids_rs - An array of userid's to send mail to.  The user trying to send
* 						email should be at least of the usertype of all the $uid's
* 						in this array variable.
* 			$subject - The subject of the email
* 			$message - The message, if bypassing the email form.
* 
* 		This operation is NOT available to a non-opendb user, and so the $from
* 		and $fromname variables will be ignored.
* 
* 	$op = 'send_to_uid'
* 
* 		Applicable Variables:
* 			$uid	 - A single UID to send email to.  The user trying to send
* 						email should be at least of the usertype of the $uid
* 						in this variable.
* 			$subject - The subject of the email
* 			$message - The message, if bypassing the email form.
* 
* 		This operation is NOT available to a non-opendb user, and so the $from
* 		and $fromname variables will be ignored.
*/

/*
* @param $to		Formatted readonly To: address information.  This will often NOT
* 					be an actual email address, but may be something like a comma
* 					delimited list of Userid's or names.
* @param $toname
* @param $from		A $from email address, which will correspond to the current user
* 					in all cases.  We no longer support using this script for non-opendb
* 					email.
* @param $fromname
* @param $subject
* @param message
* @param $HTTP_VARS - Any variables to include as hidden variables in the form.
*/
function show_email_form($to_userid, $to_fullname, $from_userid, $from_fullname, $subject, $message, $HTTP_VARS)
{
	global $LANG_VARS;
	global $PHP_SELF;
	global $CONFIG_VARS;
	
	if(strlen($to_userid)>0 && strlen($to_fullname)>0)
		$to = replace_lang_vars(array('fullname'=>$to_fullname, 'user_id'=>$to_userid), $LANG_VARS['user_name']);
	else if(strlen($to_fullname)>0)
		$to = $to_fullname;
	else if(strlen($to_userid)>0)
		$to = $to_userid;
	
	// format from
	if(strlen($from_userid)>0 && strlen($from_fullname)>0)
		$from = replace_lang_vars(array('fullname'=>$from_fullname, 'user_id'=>$from_userid), $LANG_VARS['current_user']);
	else if(strlen($from_fullname)>0)
		$from = $from_fullname;
	else if(strlen($from_userid)>0)
		$from = $from_userid;
		
	// Only if we have already been in this form.
	if($HTTP_VARS['no_message'] == 'true')
	{
		if(strlen($subject)==0)
			$error[] = array('error'=>$LANG_VARS['invalid_subject']);
		echo format_error_block($error);
	}
			
	echo("\n<table cellspacing=1 width=60% cellpadding=2 border=0>");
	echo("\n<form action=\"$PHP_SELF\" method=\"POST\">");
	
	// Indicate that we have been in this form, and have purposely left the message textarea blank.
	$HTTP_VARS['no_message'] = 'true';
	
	echo get_url_fields($HTTP_VARS, NULL, array('subject', 'message'));
	
	echo format_field($LANG_VARS['to'],NULL,$to);
	
	// Will have supplied a value for both $from and $fromname, if coming from one of the
	// operations where the user has to be logged in.
	if(strlen($from)>0)
		echo format_field($LANG_VARS['from'],NULL,$from);
	else
	{
		echo format_field($LANG_VARS['from'].($CONFIG_VARS['widgets.show_prompt_compulsory_ind']!==FALSE?_theme_image("compulsory.gif", NULL, $LANG_VARS['compulsory_field'], 'top'):""),
						NULL,
						"<input type=\"text\" name=\"from\" size=50 value=\"".htmlspecialchars($HTTP_VARS['from'])."\">");
	}
	
	echo format_field($LANG_VARS['subject'].($CONFIG_VARS['widgets.show_prompt_compulsory_ind']!==FALSE?_theme_image("compulsory.gif", NULL, $LANG_VARS['compulsory_field'], 'top'):""),
						NULL,
						"<input type=\"text\" name=\"subject\" size=50 value=\"".htmlspecialchars($subject)."\">");

	echo get_input_field("message",
				NULL, // s_attribute_type
				$LANG_VARS['message'], 
                "textarea(50,10)", //input type.
                "N", //compulsory!
                $message, // will be encoded by get_input_field function!
				TRUE);

	if($CONFIG_VARS['widgets.show_prompt_compulsory_ind']!==FALSE)
	{
		echo("\n<tr><td align=left nowrap>".
							format_help_block(array(array('img'=>'compulsory.gif', 'text'=>$LANG_VARS['compulsory_field']))).
						"</td><td>&nbsp;</td></tr>");
	}
						
	echo("<tr><td align=center><input type=submit value=\"".$LANG_VARS['send_email']."\"></td><td>&nbsp;</td></tr>");
	echo("\n</form>");
	echo("</table>");
}

/*
* This function will setup a mailto: protocol form for sending mail via the browsers 
* mailto protocol support.
* 
* @param $to	The persons email address
*/
function send_nonphp_email($to, $toname, $from, $fromname, $subject, $message)
{
	global $LANG_VARS;
	
	echo("\n<table cellspacing=1 width=60% cellpadding=2 border=0>");
	echo("\n<form action=\"mailto:".$to."\" enctype=\"text/plain\" method=\"get\">");
	
	echo format_field($LANG_VARS['to'],NULL,"&quot;".htmlspecialchars($toname)."&quot; &lt;".$to."&gt;");
	echo format_field($LANG_VARS['from'],NULL,"&quot;".htmlspecialchars($fromname)."&quot; &lt;".$from."&gt;");
	
	echo format_field($LANG_VARS['subject'],
						NULL,
						"<input type=\"text\" name=\"subject\" size=50 value=\"".htmlspecialchars($subject)."\">");

	echo get_input_field("message",
				NULL, // s_attribute_type
				$LANG_VARS['message'], 
                "textarea(50,10)", //input type.
                "N", //compulsory!
                $message, // will be encoded by get_input_field function!
				TRUE);

	echo("<td>&nbsp;</td><td align=center><input type=submit value=\"".$LANG_VARS['send_email']."\"></td>");
	echo("</tr>");
	echo("\n</form>");
	echo("</table>");
}

/*
* Will not check whether $user_id_rs contains the current users user_id.  It is expected
* that this should have already been done.
*/
function send_email_to_userids($user_id_rs, $fromemail, $fromname, $subject, $message)
{
	global $LANG_VARS;
	
	reset($user_id_rs);
	while (list(,$user_id) = each($user_id_rs))
	{
		$touser_r = fetch_user_r($user_id);
		if(is_not_empty_array($touser_r))
		{
			$result = opendb_email(fetch_user_email($touser_r['user_id']), $touser_r['fullname'], $fromemail, $fromname, $subject, $message);
			if($result===TRUE)
				$success[] = str_replace(" ", "&nbsp;", $touser_r['fullname'])." (".$user_id.")";
			else
				$errors[] = array('error'=>str_replace(" ", "&nbsp;", $touser_r['fullname'])." (".$user_id.")",'detail'=>$result);
		}
	}
	
	if(is_not_empty_array($success))
	{
		echo ("<p><div class=\"success\">".$LANG_VARS['message_sent_to'].": <ul>");
		while (list(,$touser) = each($success))
		{
			echo("<li class=\"smsuccess\">".$touser."</li>");
		}
		echo("</ul></div></p>");
	}
	
	if(is_not_empty_array($errors))
	{
		echo("<p><div class=\"error\">".$LANG_VARS['message_not_sent_to'].": <ul>".
			format_error_block($errors).
			"</ul></div></p>");
	}
}

function get_user_id_rs($user_type_rs=NULL)
{
	$user_id_rs = NULL;
	$result = fetch_user_rs($user_type_rs, 'user_id', 'ASC');
	if($result)
	{
		while ($user_r = mysql_fetch_array($result))
		{
			$user_id_rs[] = $user_r['user_id'];
		}
		mysql_free_result($result);
	}

	return $user_id_rs;
}

/**
*/
function get_user_ids_tovalue($user_id_rs)
{
	global $HTTP_SESSION_VARS;
	
	$to = "";
	if(is_not_empty_array($user_id_rs))
	{
		reset($user_id_rs);
		while(list(,$user_id) = each($user_id_rs))
		{
			// Do not include current user.
			if($user_id != $HTTP_SESSION_VARS['user_id'])
			{
				if(strlen($to)==0)
					$to = $user_id;
				else
					$to .= ", ".$user_id;
			}
		}
	}
	return $to;
}

if($CONFIG_VARS['site.enable']!==FALSE)
{
    @set_time_limit(600);
    
	session_start();
	if(is_opendb_valid_session() || $HTTP_VARS['op'] == 'send_to_site_admin')
	{
		echo _theme_header($LANG_VARS['send_email']);
		echo("<h2>"._theme_image("email.gif", "")."&nbsp;".$LANG_VARS['send_email']."</h2>");
		
		if($HTTP_VARS['op'] != 'send_to_site_admin')
		{
			$from_user_r = fetch_user_r($HTTP_SESSION_VARS['user_id']);
			$HTTP_VARS['toname'] = trim(strip_tags($HTTP_VARS['toname']));
		}
		
		// Avoid any attempts to foil required validation checks.
		$HTTP_VARS['subject'] = trim(strip_tags($HTTP_VARS['subject']));
		$HTTP_VARS['message'] = trim(strip_tags($HTTP_VARS['message']));
		
		if($CONFIG_VARS['email.use_php_mail']!==FALSE && $HTTP_VARS['op'] == 'send_to_all' && is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
		{
			// Default toname for bulk email.
			if(strlen($HTTP_VARS['toname'])==0)
			{
				$HTTP_VARS['toname'] = replace_lang_var('user_desc', $CONFIG_VARS['site.title'], $LANG_VARS['users']);
			}
			
			// If everything is provided, we can send email.
			if(strlen($HTTP_VARS['subject'])>0 && (strlen($HTTP_VARS['message'])>0 || $HTTP_VARS['no_message']=='true'))
			{
				send_email_to_userids(
						get_user_id_rs(), 
						fetch_user_email($from_user_r['user_id']), 
						$from_user_r['fullname'],
						$HTTP_VARS['subject'], 
						$HTTP_VARS['message']);
			}
			else
			{
				show_email_form(
						get_user_ids_tovalue(get_user_id_rs()),
						$HTTP_VARS['toname'],
						$from_user_r['user_id'],
						$from_user_r['fullname'],
						$HTTP_VARS['subject'],
						$HTTP_VARS['message'],
						$HTTP_VARS);
			}
		}
		else if($CONFIG_VARS['email.use_php_mail']!==FALSE && $HTTP_VARS['op'] == 'send_to_usertype' && is_usertype_valid($HTTP_VARS['usertype']) && in_array(ifempty($HTTP_VARS['usertype'],'N'), get_min_user_type_r($HTTP_SESSION_VARS['user_type'])))
		{
			// Default toname for bulk email.
			if(strlen($HTTP_VARS['toname'])==0)
				$HTTP_VARS['toname'] = replace_lang_var('user_desc', get_usertype_description($HTTP_VARS['usertype']), $LANG_VARS['users']);
				
			if(strlen($HTTP_VARS['subject'])>0 && (strlen($HTTP_VARS['message'])>0 || $HTTP_VARS['no_message']=='true'))
			{
				send_email_to_userids(
						get_user_id_rs(array($HTTP_VARS['usertype'])), 
						fetch_user_email($from_user_r['user_id']), 
						$from_user_r['fullname'], 
						$HTTP_VARS['subject'], 
						$HTTP_VARS['message']);
			}
			else
			{
				show_email_form(
						get_user_ids_tovalue(get_user_id_rs(array($HTTP_VARS['usertype']))),
						$HTTP_VARS['toname'],
						$from_user_r['user_id'],
						$from_user_r['fullname'],
						$HTTP_VARS['subject'], 
						$HTTP_VARS['message'],
						$HTTP_VARS);
			}
		}
		else if($CONFIG_VARS['email.use_php_mail']!==FALSE && $HTTP_VARS['op'] == 'send_to_uids' && (is_not_empty_array($HTTP_VARS['user_id_rs']) || strlen(trim($HTTP_VARS['checked_user_id_rs_list']))>0))
		{
			// Remove $user_id's that are above the user type of the current user.
			$filtered_user_id_rs = NULL;
			
			// If seeded from user_listing.php, we need to consolidate the list.
			if(is_not_empty_array($HTTP_VARS['checked_user_id_rs']) || strlen(trim($HTTP_VARS['checked_user_id_rs_list']))>0)
			{
				$listingObject = new HTML_Listing($PHP_SELF, $HTTP_VARS);
	
				$listingObject->setCheckBoxColumnAndInitList('user_id_rs');
				
				// The checked_user_id_rs and checked_user_id_rs_list variables
				// will be unset by the this call.
				$HTTP_VARS = $listingObject->getHttpVars();
				
				$HTTP_VARS['user_id_rs'] = $listingObject->getCheckedList();
					
				// Don't need the HTML_Listing object anymore.
				unset($listingObject);
			}
						
			reset($HTTP_VARS['user_id_rs']);
			while(list(,$uid) = each($HTTP_VARS['user_id_rs']))
			{
				if(in_array(fetch_user_type($uid), get_min_user_type_r($HTTP_SESSION_VARS['user_type'])))
				{
					$filtered_user_id_rs[] = $uid;
				}
			}
			
			if(strlen($HTTP_VARS['subject'])>0 && (strlen($HTTP_VARS['message'])>0 || $HTTP_VARS['no_message']=='true'))
			{
				send_email_to_userids(
						$filtered_user_id_rs, 
						fetch_user_email($from_user_r['user_id']), 
						$from_user_r['fullname'], 
						$HTTP_VARS['subject'], 
						$HTTP_VARS['message']);
			}
			else
			{
				show_email_form(
						get_user_ids_tovalue($filtered_user_id_rs),
						replace_lang_var('user_desc', $CONFIG_VARS['site.title'], $LANG_VARS['users']),
						$from_user_r['user_id'],
						$from_user_r['fullname'],
						$HTTP_VARS['subject'],
						$HTTP_VARS['message'],
						$HTTP_VARS);
			}
		}
		else if($HTTP_VARS['op'] == 'send_to_uid' && is_user_valid($HTTP_VARS['uid']) && is_user_allowed_to_borrow(fetch_user_type($HTTP_VARS['uid']), $HTTP_SESSION_VARS['user_type']))
		{
			// Only support NON-PHP Email functionality for single UID email.
			if($CONFIG_VARS['email.use_php_mail']===FALSE)
			{
				$touser_r = fetch_user_r($HTTP_VARS['uid']);
				send_nonphp_email(
						fetch_user_email($touser_r['user_id']), 
						$touser_r['fullname'], 
						fetch_user_email($from_user_r['user_id']), 
						$from_user_r['fullname'],
						$HTTP_VARS['subject'], 
						$HTTP_VARS['message']);
			}
			else
			{
				if(strlen($HTTP_VARS['subject'])>0 && (strlen($HTTP_VARS['message'])>0 || $HTTP_VARS['no_message']=='true'))
				{
					send_email_to_userids(
							array($HTTP_VARS['uid']), 
							fetch_user_email($from_user_r['user_id']), 
							$from_user_r['fullname'], 
							$HTTP_VARS['subject'], 
							$HTTP_VARS['message']);
				}
				else
				{
					show_email_form(
							$HTTP_VARS['uid'],
							fetch_user_name($HTTP_VARS['uid']),
							$from_user_r['user_id'],
							$from_user_r['fullname'],
							$HTTP_VARS['subject'],
							$HTTP_VARS['message'],
							$HTTP_VARS);
				}
			}
		}
		else if($HTTP_VARS['op'] == 'send_to_site_admin' && $CONFIG_VARS['email.send_to_site_admin']!==FALSE)
		{
			// Avoid any attempts to foil required validation checks.
			$HTTP_VARS['from'] = trim(strip_tags($HTTP_VARS['from']));
			$HTTP_VARS['fromname'] = trim(strip_tags($HTTP_VARS['fromname']));
		
			if($CONFIG_VARS['email.use_php_mail']===FALSE)
			{
				send_nonphp_email(
						$CONFIG_VARS['site.admin_email'], 
						$CONFIG_VARS['site.admin_name'], 
						$HTTP_VARS['from'], 
						$HTTP_VARS['fromname'], 
						$HTTP_VARS['subject'],
						$HTTP_VARS['message']);
			}
			else
			{
				// Only try to email if all the info is there, or we have been to the email form.  In the latter case we
				// are also getting the opendb_email function to test the from and subject values for us.
				if((strlen($HTTP_VARS['from'])>0 && strlen($HTTP_VARS['subject'])>0 && strlen($HTTP_VARS['message'])>0) || $HTTP_VARS['no_message'] == 'true')
				{
					$result = opendb_email(
							$CONFIG_VARS['site.admin_email'], 
							$CONFIG_VARS['site.admin_name'],
							$HTTP_VARS['from'], 
							$HTTP_VARS['fromname'], 
							$HTTP_VARS['subject'], 
							$HTTP_VARS['message']);
					
					if($result===TRUE)
					{
						echo("<p><div class=\"success\">".$LANG_VARS['message_sent_to']." ".replace_lang_var('site', $CONFIG_VARS['site.title'], $LANG_VARS['site_administrator'])."</div></p>");
					}
					else
					{
						echo format_error_block($result);
				
						// Hide the fact we might have already been into the form.
						unset($HTTP_VARS['no_message']);
						show_email_form(
							NULL, // email 
							replace_lang_var('site', $CONFIG_VARS['site.title'], $LANG_VARS['site_administrator']),
							NULL, // from_userid
							NULL, // from_fullname
							$HTTP_VARS['subject'],
							$HTTP_VARS['message'],
							$HTTP_VARS);
					}
				}
				else // Else first time into the email form.
				{
					show_email_form(
							NULL,// email 
							replace_lang_var('site', $CONFIG_VARS['site.title'], $LANG_VARS['site_administrator']), 
							NULL, // from_userid
							NULL, // from_fullname
							$HTTP_VARS['subject'],
							$HTTP_VARS['message'],
							$HTTP_VARS);
				}
			}
		}
		else
		{
			echo("<div class=\"error\">".$LANG_VARS['operation_not_available']."</div>");
		}
		
		// Always have a redirect link, for after email and also to abort email send.
		if (strlen($HTTP_VARS['redirect_link'])>0)
		{
			echo format_footer_links(array(array(url=>urldecode($HTTP_VARS['redirect_url']),text=>$HTTP_VARS['redirect_link'])));
		}
	
		echo _theme_footer();
	}
	else
	{
		// invalid login, so login instead.
		include("./login.php");
	}
}//if($CONFIG_VARS['site.enable']!==FALSE)
else
{
	echo _theme_header($LANG_VARS['site_is_disabled'], FALSE);
	echo _theme_error($LANG_VARS['site_is_disabled']);
	echo _theme_footer();
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
