<?php
/* 	Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
include_once("./functions/widgets.php");
include_once('./functions/phpthumb/phpthumb.class.php');
include_once('./functions/fileutils.php');
include_once('./functions/utils.php');

function get_image_filelist($save_dir)
{
	global $CONFIG_VARS;
	
	if(is_dir($save_dir))
	{
		// remove last slash.
		if(substr($save_dir,-1) == '/')
			$save_dir = substr($save_dir,0,-1);
			
		$filelist = array();
		// clear cached file stats.
		@clearstatcache();
		
		// will match a thumbnail format image exactly.
		$thumbnail_preg_match = str_replace('{filename}', '(.*)', $CONFIG_VARS['thumbnail.item_files_thumbnail_mask']);
		
		$handle=opendir($save_dir.'/');
		while ($file = readdir($handle))
		{
			if(!ereg("^[.]",$file) && is_file($save_dir.'/'.$file))
			{
				if(!preg_match("/".$thumbnail_preg_match."/", $file, $matches))
				{
					$file_r = parse_file($file);
					
					// only support these image types.
					if(is_thumbable_image_file(NULL, $file_r['extension']))
					{
						$thumbimgname = get_thumbnail_filename($file_r);
						
						if(!file_exists($save_dir.'/'.$thumbimgname) || 
							// if thumbnail is older than file, then redo thumbnail.
							filemtime($save_dir.'/'.$thumbimgname) < 
									filemtime($save_dir.'/'.$file_r['name'].'.'.$file_r['extension']))
						{
							$filelist[] = array(
									'file'=>$file_r['name'].'.'.$file_r['extension'], 
									'thumb'=>$thumbimgname);
						}
					}
				}
			}
		}
		closedir($handle);
		
		return $filelist;
	}
	else
	{
		return FALSE;
	}
}

function delete_thumbnails($save_dir)
{
	global $CONFIG_VARS;
	
	if(is_dir($save_dir))
	{
		// remove last slash.
		if(substr($save_dir,-1) == '/')
			$save_dir = substr($save_dir,0,-1);
			
		$filelist = array();
		
		// will match a thumbnail format image exactly.
		$thumbnail_preg_match = str_replace('{filename}', '(.*)', $CONFIG_VARS['thumbnail.item_files_thumbnail_mask']);
		
		$handle=opendir($save_dir.'/');
		while ($file = readdir($handle))
		{
			if(!ereg("^[.]",$file) && is_file($save_dir.'/'.$file))
			{
				if(preg_match("/".$thumbnail_preg_match."/", $file, $matches))
				{
					$filelist[] = $file;
				}
			}
		}
		closedir($handle);
		
		for($i=0; $i<count($filelist); $i++)
		{
			@unlink($filelist[$i]);
		}
	}
	else
	{
		return FALSE;
	}
}

/**
* 	$CONFIG_VARS['thumbnail.item_image_size'] = array(height=>'100', width=>'');
	$CONFIG_VARS['thumbnail.item_files_thumbnail_mask'] = '{filename)_T.{ext}';
	$CONFIG_VARS['item_input.item_attr_save_dir']
*/
function generate_thumbnails($save_dir, $filelist)
{
	global $CONFIG_VARS;

	if(is_not_empty_array($filelist))
	{
		$phpThumb = new phpThumb();
		$phpThumb->config_error_die_on_error = false;

		// configure the size of the thumbnail.
		if(is_array($CONFIG_VARS['thumbnail.item_image_size']))
		{
			if(is_numeric($CONFIG_VARS['thumbnail.item_image_size']['width']))
				$phpThumb->w = $CONFIG_VARS['thumbnail.item_image_size']['width'];
			else if(is_numeric($CONFIG_VARS['thumbnail.item_image_size']['height']))
				$phpThumb->h = $CONFIG_VARS['thumbnail.item_image_size']['height'];
		}
		else
		{
			$phpThumb->h = 100;
		}
		
		if(strlen($CONFIG_VARS['thumbnail.output_format'])>0)
		{
			if($CONFIG_VARS['thumbnail.output_format'] != 'jpg')
				$phpThumb->config_output_format = $CONFIG_VARS['thumbnail.output_format'];
			else
				$phpThumb->config_output_format = 'jpeg'; // 'jpg might be configured by mistake so support it.
		}
		else
		{
			// default
			$phpThumb->config_output_format = 'jpeg';
		}
		
		for($i=0; $i<count($filelist); $i++)
		{
			$phpThumb->setSourceFilename($save_dir.'/'.$filelist[$i]['file']);
			
			// generate & output thumbnail
			if ($phpThumb->GenerateThumbnail()) {
				$phpThumb->RenderToFile($save_dir.'/'.$filelist[$i]['thumb']);
				// or $phpThumb->OutputThumbnail();
			} else {
				// do something with debug/error messages
				if(is_not_empty_array($phpThumb->debugmessages))
					$filelist[$i]['errors'] = $phpThumb->debugmessages;
				else if(strlen($phpThumb->debugmessages)>0) // single array element
					$filelist[$i]['errors'][] = $phpThumb->debugmessages;
			}
		}
		
		return $filelist;
	}
	else
	{
		// no files to process
		return TRUE;
	}
}

session_start();
if(is_opendb_valid_session())
{ 
	if (is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
	{
		if($CONFIG_VARS['thumbnail.enable']!==FALSE)
		{
			if(strlen($CONFIG_VARS['item_input.item_attr_save_dir'])>0 && 
						is_dir($CONFIG_VARS['item_input.item_attr_save_dir']))
			{
				if($HTTP_VARS['op'] == 'generate')
				{
					set_time_limit(0);
					
					echo("<div class=\"colortext\">Results of generating thumbnails for <code>".$CONFIG_VARS['item_input.item_attr_save_dir']."</code> directory images:<br></div>");
						
					$return_val = generate_thumbnails($CONFIG_VARS['item_input.item_attr_save_dir'], get_image_filelist($CONFIG_VARS['item_input.item_attr_save_dir']));
					if(is_array($return_val))
					{
						echo("<br><table width=50% border=1>");
						echo("<tr><th>File</th><th>Thumbnail</th><th>Errors</th></tr>");					
						for($i=0; $i<count($return_val); $i++)
						{
							if(is_array($return_val['errors']))
								echo("<tr><td align=center>".$return_val[$i]['file']."</td><td align=center>".$return_val[$i]['thumb']."</td><td class=\"error\">".implode("\n", $return_val[$i]['errors'])."</td></tr>");
							else
								echo("<tr><td align=center>".$return_val[$i]['file']."</td><td align=center>".$return_val[$i]['thumb']."</td><td>None</td></tr>");
						}
						echo("</table>");
					}
					else if($return_val !== FALSE)
					{
						echo("<br><div class=\"error\">No images require thumbnails</div>");
					}
				}
				else
				{
					$filelist = get_image_filelist($CONFIG_VARS['item_input.item_attr_save_dir']);
					if(is_not_empty_array($filelist))
					{
						// display file list.
						echo("<div class=\"colortext\">The following <code>".$CONFIG_VARS['item_input.item_attr_save_dir']."</code> directory images require thumbnails:<br></div>");
						echo("<br><table width=50% border=1>");
						echo("<tr><th>File</th><th>Thumbnail</th></tr>");
						for($i=0; $i<count($filelist); $i++)
						{
							echo("<tr><td align=center>".$filelist[$i]['file']."</td><td align=center>".$filelist[$i]['thumb']."</td></tr>");
						}
						echo("</table>");
						
						echo("\n<br><table border=0 frameborder=0 cellspacing=1>");
						echo("\n<form name=\"main\" action=\"$PHP_SELF\" method=\"post\">");
						echo("\n<input type=\"hidden\" name=\"type\" value=\"$ADMIN_TYPE\">");
						echo("\n<input type=\"hidden\" name=\"op\" value=\"generate\">");
						echo("\n<tr><td colspan=2><input type=submit value=\"Generate Thumbnails\">");
						echo("\n</td></tr>");
						echo("\n</form>");
						echo("\n</table>");
					}
					else
					{
						echo("<div class=\"success\">No images require thumbnails</div>");
					}
				}
			}
			else
			{
				echo("<div class=\"error\">Item files directory not configured</div>");
			}
		}
		else
		{
			echo _theme_error($LANG_VARS['operation_not_available']);
		}
	}
	else
	{
		echo _theme_error($LANG_VARS['not_authorized_to_page']);
	}
}//if(is_opendb_valid_session())
?>