<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/database.php");
include_once("./functions/auth.php");
include_once("./functions/logging.php");

include_once("./functions/item_type.php");
include_once("./functions/widgets.php");
include_once("./functions/item.php");
include_once("./functions/parseutils.php");
include_once("./functions/user.php");
include_once("./functions/status_type.php");

// define page HELP ID
$_OPENDB_PAGE_HELP_ID = 'search.php';

function get_search_javascript()
{
	return '<script src="./include/search.js" language="JavaScript" type="text/javascript"></script>';
}

function get_search_javascript_arrays(&$itemTypesCount, &$itemTypeSelect, &$categorySelect, &$attrTypeSelect)
{
	$buffer = "";
	
	$itemTypeSelect = "";
	$attrTypeSelect = "";
	$arrayOfAttributes = "";
	$arrayOfCategoryTypes = "";
	$itemTypesCount=0;
	$arrayOfAttributesCount=0;

	$itemresults = fetch_item_type_rs();
	while($item_type_r = mysql_fetch_array($itemresults, MYSQL_ASSOC))
	{
		$results = fetch_item_attribute_type_rs($item_type_r['s_item_type'], 'prompt', TRUE, TRUE);
		// For the case where we have a s_item_type with no attributes associated with it!
		if($results)
		{
			while($item_attribute_type_r = mysql_fetch_array($results, MYSQL_ASSOC))
			{
				$display_type = trim($item_attribute_type_r['display_type']);
				$input_type = trim($item_attribute_type_r['input_type']);

				// Do not include any attributes with a defined s_field_type, or a input_type/display_type of hidden.
				if((strlen($display_type)>0 || strcasecmp(get_function_type($input_type), "hidden")!==0) && strcasecmp(get_function_type($display_type), "hidden")!==0 && 
							$item_attribute_type_r['s_field_type'] != 'TITLE' && $item_attribute_type_r['s_field_type'] != 'DURATION' &&
							$item_attribute_type_r['s_field_type'] != 'STATUSTYPE' && $item_attribute_type_r['s_field_type'] != 'STATUSCMNT' &&
							$item_attribute_type_r['s_field_type'] != 'CATEGORY' && $item_attribute_type_r['s_field_type'] != 'ITEM_ID')
				{
					// Only unique attributes should be added to attribute options object. 
					if(!is_array($arrayOfUniqueAttributes) || !in_array($item_attribute_type_r['s_attribute_type'], $arrayOfUniqueAttributes))
					{
						// This array, is only so we can make sure that we have unique attributes only!
						$arrayOfUniqueAttributes[] = $item_attribute_type_r['s_attribute_type'];

						// Set first item_type as default.
						$attrTypeSelect .= "\n<option value=\"".$item_attribute_type_r['s_attribute_type']."\">".$item_attribute_type_r['sat_prompt']." - ".$item_attribute_type_r['description'];
					}

					$arrayOfAttributes .= "\narrayOfAttributes[$arrayOfAttributesCount] = new LookupAttribute(\"".$item_type_r['s_item_type']."\",\"".$item_attribute_type_r['s_attribute_type']."\",\"".$item_attribute_type_r['sat_prompt']." - ".$item_attribute_type_r['description']."\");";
					$arrayOfAttributesCount++;
				}
			}
		}		

		// Get the category_attribute_type for this item_type
		$category_attribute_type = fetch_sfieldtype_item_attribute_type($item_type_r['s_item_type'], 'CATEGORY');
		
		// We need this list further down, to work out which of the lookup items are actually categories.
		$arrayOfCategoryTypes[] = $category_attribute_type;
		$arrayOfItemTypes .= "\narrayOfItemTypes[$itemTypesCount] = new ItemType(\"".$item_type_r['s_item_type']."\",\"".$category_attribute_type."\");";
		$itemTypeSelect .= "\n<option value=\"".$item_type_r['s_item_type']."\">".$item_type_r['s_item_type']." - ".$item_type_r['description'];
		$itemTypesCount++;

		// Get the very first item_type found, in case only one will be found!
		if($itemTypesCount==0)
			$firstItemType=$item_type_r['s_item_type'];
	}

	// Give us the whole s_attribute_type_lookup table, whoo baby...
	$arrayOfLookupValues = "";
	$arrayOfLookupValuesCount=0;

	$attresults = fetch_attribute_type_lookup_rs();
	while($attribute_type_r = mysql_fetch_array($attresults))
	{
		if(in_array($attribute_type_r['s_attribute_type'], $arrayOfCategoryTypes) && (!is_array($arrayOfUniqueCategories) || !in_array($attribute_type_r['value'], $arrayOfUniqueCategories)))
			$arrayOfUniqueCategories[$attribute_type_r['value']] = $attribute_type_r['display'];
																																					
		$arrayOfLookupValues .= "\narrayOfLookupValues[$arrayOfLookupValuesCount] = new LookupAttribute(\"".$attribute_type_r['s_attribute_type']."\",\"".$attribute_type_r['value']."\",\"".$attribute_type_r['display']."\");";
		$arrayOfLookupValuesCount++;
	}

	$buffer .= "\n\narrayOfLookupValues = new Array($arrayOfLookupValuesCount);";
	$buffer .= $arrayOfLookupValues;

	$buffer .= "\n\narrayOfAttributes = new Array($arrayOfAttributesCount);";
	$buffer .= $arrayOfAttributes;

	$buffer .= "\n\narrayOfItemTypes = new Array($itemTypesCount);";
	$buffer .= $arrayOfItemTypes;

	$arrayOfUniqueCategoryValues="";
	$arrayOfUniqueCatValuesCount=0;

	// Now sort all values into alphabetical order!
	asort($arrayOfUniqueCategories);
	reset($arrayOfUniqueCategories);
	while( list($value,$display) = each($arrayOfUniqueCategories))
	{
		$categorySelect .= "\n<option value=\"$value\">$display";
		$arrayOfUniqueCatValues .= "\narrayOfUniqueCatValues[$arrayOfUniqueCatValuesCount] = new LookupAttribute('',\"$value\",\"$display\");";
		$arrayOfUniqueCatValuesCount++;
	}

	$buffer .= "\n\narrayOfUniqueCatValues = new Array($arrayOfUniqueCatValuesCount);";
	$buffer .= $arrayOfUniqueCatValues;
	
	// Now wrap and return
	return "\n<script language=\"JavaScript\">\n<!-- // hide from stupid browsers\n".
				$buffer.
				"\n// -->\n</script>\n";
}

//
// Note the "----------- ALL -----------" display values is a 
// kludge to support dynamic lov's in netscape 4.  We need to
// ensure the size of the lov does not need to get any larger,
// so we set to the largest value it will ever get using the
// ----------- ALL -----------.  All the other lov's include
// this as well for uniformity.
//
if($CONFIG_VARS['site.enable']!==FALSE)
{
	session_start();
	if (is_opendb_valid_session())
	{
		if(is_valid_s_status_type($HTTP_VARS['s_status_type']))
			$s_status_type_search = TRUE;
		else
			$s_status_type_search = FALSE;
	
		$page_title = $LANG_VARS['item_search'];
		if($s_status_type_search)
		{
			$page_title = replace_lang_var('s_status_type_desc', 
									fetch_status_type_col($HTTP_VARS['s_status_type'], 'description'),
									$LANG_VARS['s_status_type_item_listing']);
		}
	
		echo _theme_header($page_title);
		echo("<h2>".$page_title."</h2>");
	
		// Include validation javascript here.
		echo(get_validation_javascript());
		echo(get_search_javascript());
		echo(get_search_javascript_arrays($itemTypesCount, $itemTypeSelect, $categorySelect, $attrTypeSelect));
		
		// Two levels of tables, so we can get the search fields surrounded by a table
		// with a border, while the search button is outside of this.
		echo("\n<table border=0 cellpadding=0 cellspacing=0>".
				"<tr><td>".
				"<table border=1 cellpadding=0 cellspacing=0><tr><td>".
					"<table border=0 cellpadding=1 cellspacing=1>");
					
		echo("\n<form name=\"search\" method=\"get\" action=\"listings.php\">");
		
		// global declaration of the datetimemask, to be used by all Date fields in search page.
		echo("\n<input type=hidden name=\"datetimemask\" value=\"".$CONFIG_VARS['search.datetime_mask']."\">");
		
		if($s_status_type_search!==TRUE)
		{
			// Indicate to listings.php that search.php initiated it.
			echo("\n<input type=hidden name=\"search_list\" value=\"y\">");
	
			// ------------------------
			// TITLE FIELD
			// ------------------------
			echo format_field(
				$LANG_VARS['title'], 
				NULL,
				"\n<input type=text size=50 name=\"title\">".
					"\n<br><input type=radio name=\"title_match\" value=\"word\">".$LANG_VARS['word_match']."&nbsp;&nbsp;".
					"\n<input type=radio name=\"title_match\" value=\"partial\" CHECKED>".$LANG_VARS['partial_match']."&nbsp;&nbsp;".
					"\n<input type=radio name=\"title_match\" value=\"exact\">".$LANG_VARS['exact_match']);
	
			// ------------------------
			// CATEGORY FIELD
			// ------------------------
			echo format_field(
				$LANG_VARS['category'], 
				NULL,
				"\n<select name=\"category\">".
					"\n<option value=\"\">-------------- ".$LANG_VARS['all']." --------------".
					$categorySelect.
					"\n</select>");
			
			// Lets display the field just like item_review.php
			$attribute_type_r = fetch_attribute_type_r("S_RATING");
			echo get_input_field("rating",
						$attribute_type_r['s_attribute_type'],
						$attribute_type_r['prompt'],
	   	               	$attribute_type_r['input_type'],
	   	               	"N", // Override - Not compulsory in search page.
	   	  	        	NULL,//value
						TRUE);
		}
			
		//spacer!
		echo("\n<tr><td colspan=2>&nbsp;</td></tr>");
		
		// ------------------------
		// S_ITEM_TYPE FIELD
		// ------------------------
		if($itemTypesCount>1)
		{
			echo format_field(
				$LANG_VARS['item_type'], 
				NULL,
		    	"\n<select name=\"s_item_type\" ".
					"\nonchange=\"populateList(this.options[this.options.selectedIndex].value, this.form.attribute_type, arrayOfAttributes, true, '------------- ".$LANG_VARS['all']." -------------', false);".
					"\nif(this.options[this.options.selectedIndex].value.length>0){populateList(get_category_type(this.options[this.options.selectedIndex].value, arrayOfItemTypes), this.form.category, arrayOfLookupValues, false, '------------- ".$LANG_VARS['all']." -------------', false);}".
					"else{populateList('', this.form.category, arrayOfUniqueCatValues, true, '------------- ".$LANG_VARS['all']." -------------', false);}\">".
					"\n<option value=\"\">-------------- ".$LANG_VARS['all']." --------------".
					$itemTypeSelect.
					"</select>");
		}
		
		if($s_status_type_search!==TRUE)
		{
			// ------------------------
			// ATTRIBUTE_TYPE FIELD
			// ------------------------
			echo format_field(
				$LANG_VARS['s_attribute_type'], 
				NULL,
				"\n<select name=\"attribute_type\" onChange=\"populateList(this.options[this.options.selectedIndex].value, this.form['lookup_attribute_val'], arrayOfLookupValues, false, '".$LANG_VARS['use_the_value_field']." ---->', true);\">".
					"\n<option value=\"\">------------- ".$LANG_VARS['all']." -------------".
					$attrTypeSelect.
					"\n</select>");
	
			 echo format_field(
				$LANG_VARS['s_attribute_type_lookup'],
				NULL,
				"\n<select name=\"lookup_attribute_val\" onChange=\"if(this.options[this.options.selectedIndex].value.length>0){this.form['attribute_val'].disabled=true;}else{this.form['attribute_val'].disabled=false;}\">".
					"\n<option value=\"\">".$LANG_VARS['use_the_value_field']." ---->".
					"\n</select>");
					
			 echo format_field(
				$LANG_VARS['attribute_val'], 
				NULL,
				"\n<input type=\"text\" name=\"attribute_val\" size=50 value=\"\">".
					"\n<br><input type=radio name=\"attr_match\" value=\"word\">".$LANG_VARS['word_match']."&nbsp;&nbsp;".
					"\n<input type=radio name=\"attr_match\" value=\"partial\" CHECKED>".$LANG_VARS['partial_match']."&nbsp;&nbsp;".
					"\n<input type=radio name=\"attr_match\" value=\"exact\">".$LANG_VARS['exact_match']);
			
			// ------------------------
			// UPDATE_ON FIELD
			// ------------------------
			echo format_field(
			$LANG_VARS['updated'], 
			NULL,
			"\n<select name=\"attr_update_on_days\" onChange=\"if(this.options[this.options.selectedIndex].value.length>0){this.form['attr_update_on'].disabled=true;}else{this.form['attr_update_on'].disabled=false;}\">".
				"\n<option value=\"\">".$LANG_VARS['specify_datetime']." ---->".
				"\n<option value=\"1\">".$LANG_VARS['one_day_ago'].
				"\n<option value=\"7\">".$LANG_VARS['one_week_ago'].
				"\n<option value=\"28\">".$LANG_VARS['one_month_ago'].
				"\n<option value=\"365\">".$LANG_VARS['one_year_ago'].
				"\n</select><br>".
					get_input_field("attr_update_on", NULL, NULL,"datetime(".$CONFIG_VARS['search.datetime_mask'].")","N",NULL,FALSE).
				"\n");
				
			//spacer!
			echo("\n<tr><td colspan=2>&nbsp;</td></tr>");
		}//if($s_status_type_search!==TRUE)
		
		// ------------------------
		// OWNER FIELD
		// ------------------------
		
		// Must pass on not_owner_id if specified.
		if(strlen($HTTP_VARS['not_owner_id'])>0)
		{
			echo("\n<input type=hidden name=\"not_owner_id\" value=\"".$HTTP_VARS['not_owner_id']."\">");
		}
		
		echo(
			format_field(
				$LANG_VARS['owner'], 
				NULL,
				"\n<select name=\"owner_id\">".
					"\n<option value=\"\">-------------- ".$LANG_VARS['all']." --------------".
					custom_select(
						'owner_id', 
						fetch_user_rs(get_owner_user_types_r()), 
						'%fullname% (%user_id%)',
						'NA',
						NULL,
						'user_id'
					).
					"\n</select>"
				)
			);
		
		if($s_status_type_search!==TRUE)
		{
	        // ------------------------
	        // Item Status
	        // ------------------------
			$lookup_results = fetch_status_type_rs(TRUE,TRUE,TRUE);
			
			// Only include Status type restriction, if more than once status type.
			if($lookup_results && mysql_num_rows($lookup_results)>1)
			{
				echo format_field(
					$LANG_VARS['s_status_type'],
					NULL,
					checkbox_grid('s_status_type',
								$lookup_results, 
								'%img%', // mask
								'3', // columns
								'', // border
								array())); // value
			}
			
			// ------------------------
			// Status Comment FIELD
			// ------------------------
			echo format_field(
				$LANG_VARS['status_comment'], 
				NULL,
				"\n<input type=text size=50 name=\"status_comment\">".
					"\n<br><input type=radio name=\"status_comment_match\" value=\"word\">".$LANG_VARS['word_match']."&nbsp;&nbsp;".
					"\n<input type=radio name=\"status_comment_match\" value=\"partial\" CHECKED>".$LANG_VARS['partial_match']."&nbsp;&nbsp;".
					"\n<input type=radio name=\"status_comment_match\" value=\"exact\">".$LANG_VARS['exact_match']);			
		}
		else// if(is_valid_s_status_type($HTTP_VARS['s_status_type']))
		{
			echo("\n<input type=hidden name=\"s_status_type\" value=\"".$HTTP_VARS['s_status_type']."\">");
		}
		
		if($CONFIG_VARS['item_input.linked_item_support'] !== FALSE)
	   	{
			echo format_field(
			    $LANG_VARS['linked_item(s)'],
				NULL,
			   	"\n<input type=radio name=\"linked_items\" value=\"include\"".($CONFIG_VARS['search.default_include_linked_items']!==FALSE?" CHECKED":"").">".$LANG_VARS['include']."&nbsp;&nbsp;".
	   				"<input type=radio name=\"linked_items\" value=\"exclude\"".($CONFIG_VARS['search.default_include_linked_items']===FALSE?" CHECKED":"").">".$LANG_VARS['exclude']);
		}
		
		// ------------------------
		// UPDATE_ON FIELD
		// ------------------------
		echo format_field(
			$LANG_VARS['updated'], 
			NULL,
			"\n<select name=\"update_on_days\" onChange=\"if(this.options[this.options.selectedIndex].value.length>0){this.form['update_on'].disabled=true;}else{this.form['update_on'].disabled=false;}\">".
				"\n<option value=\"\">".$LANG_VARS['specify_datetime']." ---->".
				"\n<option value=\"1\">".$LANG_VARS['one_day_ago'].
				"\n<option value=\"7\">".$LANG_VARS['one_week_ago'].
				"\n<option value=\"28\">".$LANG_VARS['one_month_ago'].
				"\n<option value=\"365\">".$LANG_VARS['one_year_ago'].
				"\n</select><br>".
					get_input_field("update_on", NULL, NULL,"datetime(".$CONFIG_VARS['search.datetime_mask'].")","N",NULL,FALSE).
				"\n");
	
		//spacer!
		echo("\n<tr><td colspan=2>&nbsp;</td></tr>");

		echo format_field(
			$LANG_VARS['order_by'], 
			NULL,
			"\n<select name=\"order_by\">".
				"\n<option value=\"title\" SELECTED>".$LANG_VARS['title'].
				"\n<option value=\"owner_id\">".$LANG_VARS['owner'].
				"\n<option value=\"category\">".$LANG_VARS['category'].
				"\n<option value=\"s_item_type\">".$LANG_VARS['item_type'].
				"\n<option value=\"s_status_type\">".$LANG_VARS['s_status_type'].
				"\n<option value=\"update_on\">".$LANG_VARS['update_date'].
				"\n</select><br>".
				"\n<input type=radio name=\"sortorder\" value=\"ASC\" CHECKED>".$LANG_VARS['asc']."&nbsp;".
				"\n<input type=radio name=\"sortorder\" value=\"DESC\">".$LANG_VARS['desc']);
		
		echo("\n</td></tr></table>".
			"</table></td></tr>");
		echo("<tr><td align=center>");
		echo("\n<br><input type=submit value=\"".$LANG_VARS['search_now']."\">");
		echo("\n</td></tr>");
		echo("</form>");
		echo("</table>");
	
		echo _theme_footer();
	}
	else
	{
		// invalid login, so login instead.
		include("./login.php");
	}
}//if($CONFIG_VARS['site.enable']!==FALSE)
else
{
	echo _theme_header($LANG_VARS['site_is_disabled'], FALSE);
	echo _theme_error($LANG_VARS['site_is_disabled']);
	echo _theme_footer();
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
