<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/user.php");
include_once("./functions/utils.php");
include_once("./functions/http.php");

/*
* 
*/
function is_site_public_access_enabled()
{
	global $CONFIG_VARS;
	global $HTTP_SESSION_VARS;
	
	return ($CONFIG_VARS['site.public_access.enable'] === TRUE && 
					strlen($CONFIG_VARS['site.public_access.user_id'])>0 && 
					$HTTP_SESSION_VARS['user_id'] === $CONFIG_VARS['site.public_access.user_id']);
}

/**
*/
function is_opendb_valid_session()
{
	// from config.php
	global $CONFIG_VARS;
	global $HTTP_SESSION_VARS;
	
	// If the site is currently disabled, no sessions can be considered valid.
	if($CONFIG_VARS['site.enable']!==FALSE)
	{
		// Public access to OpenDb for configured user.
		if(is_site_public_access_enabled())
		{
			// include/begin.inc.php already exported the $HTTP_SESSION_VARS['user_id']
			if(strlen($HTTP_SESSION_VARS['user_id'])>0 && is_user_active($HTTP_SESSION_VARS['user_id']))
			{
				return TRUE;
			}
			else
			{
				opendb_log("Invalid/Inactive 'public access' user encountered (user_id=".$CONFIG_VARS['site.public_access.user_id'].")");
				return FALSE;
			}
		}
		else if(is_not_empty_array($HTTP_SESSION_VARS) && isset($HTTP_SESSION_VARS['login_time']) && isset($HTTP_SESSION_VARS['last_access_time']) && isset($HTTP_SESSION_VARS['user_id']) && isset($HTTP_SESSION_VARS['hash_check']))
		{
			// A valid session as far as the variables go at least.
			if($CONFIG_VARS['site.security_hash'] == $HTTP_SESSION_VARS['hash_check'])
			{
				// idle_timeout is how long between requests a login session
				// can remain valid.  If login_timeout is set, then this controls
				// how long a session can remain active overall.
				$current_time = time();

				if (!is_numeric($CONFIG_VARS['site.login_timeout']) || (($current_time - $HTTP_SESSION_VARS['login_time']) < $CONFIG_VARS['site.login_timeout']) )
				{
					if ( !is_numeric($CONFIG_VARS['site.idle_timeout']) || (($current_time - $HTTP_SESSION_VARS['last_access_time']) < $CONFIG_VARS['site.idle_timeout']) )
					{
						if(is_user_active($HTTP_SESSION_VARS['user_id']))
						{
							// reset the time, as we are only interested in idle session tests.
							$HTTP_SESSION_VARS['last_access_time'] = $current_time;
							if(is_register_globals_enabled())
							{
								global $last_access_time;
								
								session_register("last_access_time");
								$last_access_time = $HTTP_SESSION_VARS['last_access_time'];
							}
							return TRUE;
						}
						else
						{
							opendb_log("Invalid/Inactive user encountered (user_id=".$HTTP_SESSION_VARS['user_id'].")");	
							return FALSE;
						}
					}
				}
			}
			else
			{
				opendb_log("Invalid security-hash login invalidated (user_id=".$HTTP_SESSION_VARS['user_id'].")");
				return FALSE;
			}
		}
	}

	//else
	return FALSE;
}
?>
