<?php
class Listing
{
	// Printable or not
	var $_mode = NULL;
	
	// Local reference to HTTP var array.
	var $_http_vars;
	var $_php_self;
	
	var $_items_per_page = NULL;
	var $_total_items = NULL;
	var $_page_no = NULL;
	var $_start_index = NULL;
	
	var $_no_rows_message = NULL;
	
	// A list of all help entries
	var $_help_entry_rs = NULL;
	var $_help_entry_added_r = NULL;
	
	var $_header_column_rs = NULL;
	
	// this is a temporary per row array
	var $_row_column_rs = NULL;
	
	var $_toggle = TRUE; // toggle row info
	var $_row = 0;
	
	// a cache for writeItemTypeImageColumn(...) method.
	var $_item_type_rs;
	
	// a parsed title cache for writeTitleColumn(...) method.
	var $_parsed_title_mask_rs = NULL;
	var $_parsed_mask_configuration_rs = NULL;
	
	function Listing($PHP_SELF, $HTTP_VARS, $mode=NULL)
	{
		global $CONFIG_VARS;
		global $LANG_VARS;

		$this->_php_self = $PHP_SELF;		
		$this->_http_vars = $HTTP_VARS;
		
		$this->_mode = $mode;
		if($this->_mode == 'printable')
		{
			$this->_page_no = 1;
			$this->_start_index = NULL;
			
			// unset even if specified in $HTTP_VARS
			$this->_items_per_page = NULL;
		}
		else
		{
			if(isset($HTTP_VARS['items_per_page']))
			{
				$this->_items_per_page = $HTTP_VARS['items_per_page'];
			}
			else
			{
				$this->_items_per_page = $CONFIG_VARS['listings.items_per_page'];
			}
			
			// initialise these, as they will most likely NOT be initialised via setTotalItems
			if(!is_numeric($this->_items_per_page))
			{
				$this->_page_no = 1;
				$this->_start_index = NULL;
			}
		}
		
		$this->_current_orderby = $this->_http_vars['order_by'];
		$this->_current_sortorder = $this->_http_vars['sortorder'];
		
		// initialise to default.
		$this->_no_rows_message = $LANG_VARS['no_matches_found'];
	}
	
	/*
	* Ignores more than the first call to this method for an instance of Listing.
	*/
	function setTotalItems($total_items)
	{
		$this->_total_items = $total_items;
		
		if(is_numeric($this->_total_items) && $this->_total_items > 0)
		{
			if(is_numeric($this->_items_per_page) && $this->_items_per_page > 0)
			{
				if(is_numeric($this->_http_vars['page_no']))
				{
					$this->_page_no = $this->_http_vars['page_no'];
				
					// We need to ensure that the $page_no is realistic for the number of items.
					$this->_start_index = ($this->_page_no - 1) * $this->_items_per_page;
					if($this->_start_index >= $this->_total_items)
					{
						$this->_page_no = floor($this->_total_items / $this->_items_per_page);
						if($this->_page_no>0)
						{
							$this->_start_index = ($this->_page_no-1) * $this->_items_per_page;
						}
						else
						{
							$this->_page_no = 1;
							$this->_start_index = 0;
						}
					}
				}
				else
				{
					$this->_page_no = 1;
					$this->_start_index = 0;
				}
			}
		}
	}
	
	/**
	* Returns $HTTP_VARS with any variables used for Listings functionality unset.
	*/
	function getHttpVars()
	{
		return $this->_http_vars;
	}
	
	/*
	* Message to display if No Rows are found.  The default message is $LANG_VARS['no_matches_found']
	*/
	function setNoRowsMessage($message)
	{
		$this->_no_rows_message = $message;
	}
	
	function getCurrentOrderBy()
	{
		return $this->_current_orderby;
	}
	
	function getCurrentSortOrder()
	{
		return $this->_current_sortorder;
	}
	
	/**
	* Make sure this has been called first:
	* 	setTotalItems($total_items)
	*/
	function getStartIndex()
	{
		return $this->_start_index;
	}
	
	/**
	* Make sure this has been called first:
	* 	setTotalItems($total_items)
	*/
	function getPageNo()
	{
		return $this->_page_no;
	}
	
	/**
	* Make sure this has been called first:
	* 	setTotalItems($total_items)
	*/
	function getTotalItemCount()
	{
		return $this->_total_items;
	}
	
	function getItemsPerPage()
	{
		return $this->_items_per_page;
	}
	
	function getNoOfColumns()
	{
		if(is_array($this->_header_column_rs))
			return count($this->_header_column_rs);
		else
			return 0;
	}
	
	function getNoOfRowColumns()
	{
		if(is_array($this->_row_column_rs))
			return count($this->_row_column_rs);
		else
			return 0;
	}
	
	/**
	* Total rows processed (not including header) as of this call.
	*/
	function getRowCount()
	{
		return $this->_row;
	}
	
	/**
	*/
	function addHelpEntry($help_text, $img=NULL, $id=NULL)
	{
		if($id === NULL || !is_array($this->_help_entry_added_r) || in_array($id, $this->_help_entry_added_r)!==TRUE)
		{
			$this->_help_entry_rs[] = array(img=>$img, text=>$help_text);
			$this->_help_entry_added_r[] = $id;
		}
	}
	
	function addHeaderColumn($title, $fieldname = NULL, $width = NULL)
	{
		if(is_numeric($width))
		{
			$this->_header_column_rs[] = 
				array(
					title=>$title,
					fieldname=>$fieldname,
					width=>$width); 
		}
		else if(preg_match("/([0-9]+)%/", $width, $regs))
		{
			$this->_header_column_rs[] = 
				array(
					title=>$title,
					fieldname=>$fieldname,
					width_percentage=>$regs[1]); 
		}
		else
		{
			$this->_header_column_rs[] = 
				array(
					title=>$title,
					fieldname=>$fieldname); 
		}
		
		if($this->_mode != 'printable' && $fieldname !== NULL)
		{
			global $LANG_VARS;
			
			$this->addHelpEntry($LANG_VARS['listing_column_header_sort_help'], NULL, 'listing_column_header_sort_help');
		}
	}
		
	function startRow()
	{
		// write header row first.
		if($this->getRowCount() == 0 && is_array($this->_header_column_rs))
		{
			if(method_exists($this, 'writeHeaderRowImpl'))
			{
				$this->writeHeaderRowImpl($this->_header_column_rs);
			}
		}
		$this->_row_column_rs = NULL;
	}
	
	function endRow()
	{
		// now process the $this->_header_column_rs
		if(method_exists($this, 'writeRowImpl'))
		{
			if(is_array($this->_row_column_rs))
			{
				$this->writeRowImpl($this->_row_column_rs);
				
				// toggle row info
				$this->_toggle = !$this->_toggle;
			}
		}
		$this->_row++;
	}
	
	/*
	* Do not call this function until the following methods have
	* been called:
	* 
	* These only if you want to do paging,
	*	setTotalItems($total_items)	
	*/
	function startListing($listing_title = NULL)
	{
		// A null Items Per Page means we will be generating the entire listing, no paging.
		if(!is_numeric($this->getItemsPerPage()))
		{
			// This may take a lot more time to generate
			@set_time_limit(600);
		}
		
		// because the startListing will often add a checkbox or other
		// header column, we have to handle this appropriately, where
		// the headers have already been written.
		$tmp_header_column_rs = NULL;
		if(is_array($this->_header_column_rs))
		{
			$tmp_header_column_rs = $this->_header_column_rs;
			$this->_header_column_rs = NULL;
		}
		
		// now process the $this->_header_column_rs
		if(method_exists($this, 'startListingImpl'))
		{
			$this->startListingImpl($listing_title);
		}
	
		// now reinstate the headers.		
		if(is_array($tmp_header_column_rs))
		{
			if(is_array($this->_header_column_rs))
			{
				for($i=0; $i<count($tmp_header_column_rs); $i++)
				{
					$this->_header_column_rs[] =& $tmp_header_column_rs[$i];
				}
			}
			else
			{
				$this->_header_column_rs =& $tmp_header_column_rs;
			}
		}
	}
	
	function endListing()
	{
		global $CONFIG_VARS;
		
		// in the case where no items were encountered.
		if($this->getRowCount() == 0 && is_array($this->_header_column_rs))
		{
			if(method_exists($this, 'writeHeaderRowImpl'))
			{
				$this->writeHeaderRowImpl($this->_header_column_rs);
			}
		}
		
		if($this->getRowCount() > 0)
		{
			// The initial values may not have been set properly, so lets double check them.		
			if(!is_numeric($this->_total_items) || $this->_total_items < $this->getRowCount())
			{
				$this->_total_items = $this->getRowCount();
			}
			
			if(!is_numeric($this->_items_per_page))
			{
				$vItemsPerPage = $this->_total_items;
			}
			else
			{
				$vItemsPerPage = $this->_items_per_page;
			}
		
			$first_item = (($this->_page_no - 1) * $vItemsPerPage) + 1;
			
			// Do some sanity checking!
			if($first_item > $this->_total_items)
			{
				$this->_page_no = 1;
				$first_item = 1;
			}

			$last_item = $this->_page_no * $vItemsPerPage;
		
			// Do some sanity checking!
			if($last_item > $this->_total_items)
			{
				$last_item = $this->_total_items;
			}
			
			if($first_item>1 || $last_item < $this->_total_items)// Only if more than one page.
			{
				$total_pages = ceil($this->_total_items / $vItemsPerPage);
				if($total_pages <= 10)
				{
					$start_page = 1;
					$end_page = $total_pages;
				}
				else if($this->_page_no <= 5)
				{
					$start_page = 1;
					$end_page = 10;
				}
				else if(($this->_page_no + 5) >= $total_pages)
				{
					$end_page = $total_pages;
					$start_page = $total_pages - 10;
				}
				else // $page_no>=5 && $total_pages < ($page_no+5)
				{
					$start_page = $this->_page_no - 5;
					$end_page = $this->_page_no + 5;
				}
			}
			
			if($CONFIG_VARS['listings.title_mask_macro_theme_img_help']!==FALSE)
			{
				$title_mask_elements = get_title_mask_macro_element_r('theme_img');
				if(is_array($title_mask_elements))
				{
					while(list($img,$prompt) = each($title_mask_elements))
					{
						$this->addHelpEntry($prompt, $img);
					}
				}
			}
			
			// now process the $this->_header_column_rs
			if(method_exists($this, 'endListingImpl'))
			{
				$this->endListingImpl($first_item, $last_item, $start_page, $end_page, $total_pages);
			}
		}
		else
		{
			$this->endListingImpl();
		}
	}
	
	function addUserNameColumn($user_id)
	{
		$this->_row_column_rs[] = array(
					column_type=>'username',
					user_id=>$user_id,
					fullname=>fetch_user_name($user_id));
	}
	
	function addThemeImageColumn($src, $alt=NULL, $title=NULL, $type=NULL, $align=NULL, $width=NULL, $height=NULL)
	{
		$this->_row_column_rs[] = array(
					column_type=>'theme_image',
					src=>$src,
					alt=>$alt,
					title=>$title,
					type=>$type,
					align=>$align,
					width=>$width,
					height=>$height);
	}
	
	function addItemTypeImageColumn($s_item_type, $is_linked_item = FALSE)
	{
		$this->_row_column_rs[] = 
			array(
				column_type=>'item_type_image',
				s_item_type=>$s_item_type,
				is_linked_item=>$is_linked_item);
	}
	
	/**
	* @param $item_r
	* @param $show_is_item_reviewed
	* @param $show_is_borrowed_or_returned
	*/
	function addTitleColumn($item_r, $show_is_item_reviewed = TRUE, $show_is_borrowed_or_returned = TRUE)
	{
		global $LANG_VARS;
		global $CONFIG_VARS;
		global $HTTP_SESSION_VARS;
		
		$is_item_reviewed = FALSE;
		
		$s_item_type = $item_r['s_item_type'];
		
		//In this case we want to test the real item_id even of a linked item.
		if($show_is_item_reviewed!==FALSE && is_item_reviewed($item_r['item_id']))
		{
			$is_item_reviewed = TRUE;
		}

		$is_borrowed_or_returned = FALSE;						
		// Check whether item has been borrowed or returned by the current user before.
		if($show_is_borrowed_or_returned!==FALSE && !is_numeric($item_r['parent_id']) && $CONFIG_VARS['listings.show_borrowed_or_returned'] !== FALSE)
		{
			// Do not even bother if user owns item - they cannot borrow their own item.
	 		if($item_r['owner_id'] != $HTTP_SESSION_VARS['user_id'])
			{
				if(is_item_borrowed_or_returned_by_user($item_r['item_id'], $item_r['instance_no'], $HTTP_SESSION_VARS['user_id']))
				{
					$is_borrowed_or_returned = TRUE;
				}
			}
		}
		
		$item_cover_image = NULL;
		if(($CONFIG_VARS['listings.allow_override_show_item_image']===FALSE && $CONFIG_VARS['listings.show_item_image']!==FALSE) ||
					$CONFIG_VARS['listings.allow_override_show_item_image']!==FALSE && (($CONFIG_VARS['listings.show_item_image']!==FALSE && 
					strlen($this->_http_vars['show_item_image'])==0) || $this->_http_vars['show_item_image'] == 'Y'))
		{
			// this does not actually cache anything!!!
			if(strlen($this->_item_type_rs[$s_item_type]['image_attribute_type'])===0)
			{
				$this->_item_type_rs[$s_item_type]['image_attribute_type'] = fetch_sfieldtype_item_attribute_type($s_item_type, 'IMAGE');
			}

			if(strlen($this->_item_type_rs[$s_item_type]['image_attribute_type'])>0)
			{
				$item_cover_image = fetch_attribute_val($item_r['item_id'], $this->_item_type_rs[$s_item_type]['image_attribute_type']);
				if(strlen($CONFIG_VARS['listings.no_image'])>0 && (strlen($item_cover_image)==0 || (!is_url_absolute($item_cover_image) && !file_exists($item_cover_image))))
				{ 
					$item_cover_image = _theme_image_src($CONFIG_VARS['listings.no_image']);
				}
			}
		}
		
		if(!isset($this->_parsed_mask_configuration_rs))
		{
			$this->_parsed_mask_configuration_rs = $CONFIG_VARS['listings.title_display_mask'];
		}
		
		// Expand title mask - this might cause problems where HTML code is included in the 
		// title mask, and this class is subclassed to generate (for instance) PDF
		$item_r['title'] = expand_type_title_mask($item_r, $this->_parsed_mask_configuration_rs, $this->_parsed_title_mask_rs);
		
		$this->_row_column_rs[] = 
			array(
				column_type=>'title', 
				item_record=>$item_r,
				item_cover_image=>$item_cover_image,
				is_item_reviewed=>$is_item_reviewed,
				is_borrowed_or_returned=>$is_borrowed_or_returned);
	}
	
	function addDisplayColumn($s_attribute_type, $prompt, $display_type, $value)
	{
		$this->_row_column_rs[] = 
			array(
				column_type=>'attribute_display_type', 
				attribute_type=>$s_attribute_type, 
				prompt=>$prompt,
				display_type=>$display_type,
				value=>$value);
	}
	
	function addActionColumn($action_links_rs)
	{
		$this->_row_column_rs[] = 
			array(
				column_type=>'action_links',
				action_links=>$action_links_rs);
	}
	
	function addColumn($value=NULL)
	{
		$this->_row_column_rs[] = 
			array(
				column_type=>'default',
				value=>$value);
	}
}
?>