<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./admin/s_item_type_group/functions.php");
include_once("./admin/s_attribute_type/functions.php");
include_once("./admin/s_attribute_type_lookup/functions.php");

include_once("./functions/site_plugin.php");
include_once("./functions/item_type.php");
include_once("./functions/item_type_group.php");

function display_s_item_type_insert_form($HTTP_VARS)
{
	global $CONFIG_VARS;
	
	// s_item_type
	echo get_input_field("s_item_type", NULL, "Item Type", "text(10,10)", "Y", $HTTP_VARS['s_item_type']);
	
	//description
	echo get_input_field("description", NULL, "Description", "text(30,60)", "Y", $HTTP_VARS['description']);
	
	//image
	echo get_input_field("image", NULL, "Image", "url(15,*,\"gif,jpg,png\",N)", "N", $HTTP_VARS['image']);
	
	echo("<tr><td colspan=2 class=\"prompt\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<i>- Field Type Attributes -</i></td></tr>");
	
	$lookup_results = fetch_sfieldtype_attribute_type_rs('TITLE');
	echo format_field("Title", NULL, 	
			custom_select("s_field_type[TITLE]", $lookup_results, "%s_attribute_type% - %description%", 1, is_array($HTTP_VARS['s_field_type'])?$HTTP_VARS['s_field_type']['TITLE']:NULL, "s_attribute_type").
			"&nbsp;<a href=\"javascript:popup('admin.php?type=s_item_type&op=help&inc_header=N&s_attribute_type='+document.forms['s_item_type']['s_field_type[TITLE]'].options[document.forms['s_item_type']['s_field_type[TITLE]'].options.selectedIndex].value,'400', '325')\">(?)</a>");

	$lookup_results = fetch_sfieldtype_attribute_type_rs('CATEGORY');
	echo format_field("Category", NULL, 	
			custom_select("s_field_type[CATEGORY]", $lookup_results, "%s_attribute_type% - %description%", 1, is_array($HTTP_VARS['s_field_type'])?$HTTP_VARS['s_field_type']['CATEGORY']:NULL, "s_attribute_type").
			"&nbsp;<a href=\"javascript:popup('admin.php?type=s_item_type&op=help&inc_header=N&s_attribute_type='+document.forms['s_item_type']['s_field_type[CATEGORY]'].options[document.forms['s_item_type']['s_field_type[CATEGORY]'].options.selectedIndex].value,'400', '325')\">(?)</a>");
	
	$lookup_results = fetch_sfieldtype_attribute_type_rs('STATUSTYPE');
	echo format_field("Status Type", NULL, 	
			custom_select("s_field_type[STATUSTYPE]", $lookup_results, "%s_attribute_type% - %description%", 1, is_array($HTTP_VARS['s_field_type'])?$HTTP_VARS['s_field_type']['STATUSTYPE']:NULL, "s_attribute_type").
			"&nbsp;<a href=\"javascript:popup('admin.php?type=s_item_type&op=help&inc_header=N&s_attribute_type='+document.forms['s_item_type']['s_field_type[STATUSTYPE]'].options[document.forms['s_item_type']['s_field_type[STATUSTYPE]'].options.selectedIndex].value,'400', '325')\">(?)</a>");

	$lookup_results = fetch_sfieldtype_attribute_type_rs('STATUSCMNT');
	echo format_field("Status Comment", NULL, 	
			custom_select("s_field_type[STATUSCMNT]", $lookup_results, "%s_attribute_type% - %description%", 1, is_array($HTTP_VARS['s_field_type'])?$HTTP_VARS['s_field_type']['STATUSCMNT']:NULL, "s_attribute_type").
			"&nbsp;<a href=\"javascript:popup('admin.php?type=s_item_type&op=help&inc_header=N&s_attribute_type='+document.forms['s_item_type']['s_field_type[STATUSCMNT]'].options[document.forms['s_item_type']['s_field_type[STATUSCMNT]'].options.selectedIndex].value,'400', '325')\">(?)</a>");
						
	if($CONFIG_VARS['borrow.enable']!==FALSE && $CONFIG_VARS['borrow.duration_support']!==FALSE)
	{
		$lookup_results = fetch_sfieldtype_attribute_type_rs('DURATION');
		echo format_field("Borrow Duration", NULL, 	
				custom_select("s_field_type[DURATION]", $lookup_results, "%s_attribute_type% - %description%", 1, is_array($HTTP_VARS['s_field_type'])?$HTTP_VARS['s_field_type']['DURATION']:NULL, "s_attribute_type").
				"&nbsp;<a href=\"javascript:popup('admin.php?type=s_item_type&op=help&inc_header=N&s_attribute_type='+document.forms['s_item_type']['s_field_type[DURATION]'].options[document.forms['s_item_type']['s_field_type[DURATION]'].options.selectedIndex].value,'400', '325')\">(?)</a>");			
	}			
}


/*
* Item Types main display.
*/
function display_s_item_type_row($item_type_r, $row)
{
	echo("\n<tr>");
	
	$errors = NULL;
	if(check_item_type_structure($item_type_r['s_item_type'], $errors))
		$class = "data";
	else
		$class = "error";
	
	// order_no
	echo("\n<td class=\"$class\" align=center>".get_input_field("order_no[$row]", NULL, NULL, "number(3)", "N", $item_type_r['order_no'], FALSE)."</td>");
	
	echo("\n<td class=\"$class\">".get_input_field("s_item_type[$row]", NULL, "Item Type", "readonly", "Y", $item_type_r['s_item_type'], FALSE).
		"<input type=hidden name=\"exists_ind[$row]\" value=\"Y\">".
		"</td>");
	
	//description
	echo("\n<td class=\"$class\">".get_input_field("description[$row]", NULL, NULL, "text(30,30)", "N", $item_type_r['description'], FALSE)."</td>");

	echo("<td class=\"$class\" align=center>");
	// Get the theme specific source of the image.
	if(strlen($item_type_r['image'])>0)
	{
		$src = _theme_image_src($item_type_r['image']);
	}
	if($src!==FALSE && strlen($src)>0)
		echo("<img src=\"$src\">");
	else
		echo("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
	echo("</td>");

	echo("\n<td class=\"$class\">".get_input_field("image[$row]", NULL, NULL, "url(15,*,\"gif,jpg,png\",N)", "N", $item_type_r['image'], FALSE)."</td>");

	echo("\n<td class=\"$class\">");
	echo("\n<input type=button onclick=\"document.forms['navigate'].s_item_type.value=this.form['s_item_type[$row]'].value; document.forms['navigate'].op.value='edit'; document.forms['navigate'].submit();\" value=\"Edit\">");
	echo("&nbsp;<input type=button onclick=\"document.forms['navigate'].s_item_type.value=this.form['s_item_type[$row]'].value; document.forms['navigate'].op.value='delete_type_confirm'; document.forms['navigate'].submit();\" value=\"Delete\">");
	
	if(is_not_empty_array($errors))
		echo("&nbsp;<a href=\"javascript:popup('admin.php?op=errmsg&title=".urlencode(urlencode("Item Type (".$item_type_r['s_item_type'].") Structural Defects"))."&error=".urlencode(urlencode(format_error_block($errors)))."','640', '480')\">[ERROR]</a>");
	else
		echo("\n<input type=button onclick=\"document.forms['sqlform'].s_item_type.value=this.form['s_item_type[$row]'].value; document.forms['sqlform'].op.value='sql'; document.forms['sqlform'].inc_theme.value='N'; document.forms['sqlform'].submit();\" value=\"SQL\">");
	echo("\n</td>");

	echo("</tr>");
}

// We do not want to build this more than once!
$s_attribute_type_list = NULL;

/*
* Specific item type - s_item_attribute_type block.
*/
function display_s_item_attribute_type_row($s_item_type, $s_item_attribute_type_r, $row, $exists_error_ind=FALSE)
{
	global $s_attribute_type_list;
	
	echo("<tr>");

	// Indicates this record is in error, and we need to make this clear.
	if($exists_error_ind)
		$class = "error";
	else
		$class = "data";
	
	// s_attribute_type
	if(is_not_empty_array($s_item_attribute_type_r) && $exists_error_ind==FALSE)
	{
		// order_no
		echo("<td class=\"$class\" align=center>");
		if(!is_s_item_attribute_type_deletable($s_item_type, $s_item_attribute_type_r['s_attribute_type'], $s_item_attribute_type_r['order_no']))
			echo(get_input_field("order_no[$row]", NULL, "Order No.", "readonly", "N", $s_item_attribute_type_r['order_no'], FALSE));
		else
			echo(get_input_field("order_no[$row]", NULL, "Order No.", "number(3)", "N", $s_item_attribute_type_r['order_no'], FALSE));
		echo("<input type=hidden name=\"old_order_no[$row]\" value=\"".$s_item_attribute_type_r['order_no']."\"></td>");
		
		// See if a s_field_type defined for this attribute type
		$attribute_type_r = fetch_s_attribute_type_r($s_item_attribute_type_r['s_attribute_type']);
		if(strlen($attribute_type_r['s_field_type'])>0)
			$value = $s_item_attribute_type_r['s_attribute_type']. " [".$attribute_type_r['s_field_type']."]";
		else
			$value = $s_item_attribute_type_r['s_attribute_type']; 
		
		echo("<td class=\"$class\">".
				format_field("Attribute Type",
						NULL,
						$value."<input type=hidden name=\"s_attribute_type[$row]\" value=\"".$s_item_attribute_type_r['s_attribute_type']."\">".
							"<input type=hidden name=\"exists_ind[$row]\" value=\"Y\">",FALSE).
			"</td>");
		
		echo("<td class=\"$class\"><a href=\"javascript:popup('admin.php?type=s_item_type&op=help&inc_header=N&s_attribute_type='+document.forms['s_item_attribute_type']['s_attribute_type[$row]'].value,'400', '325')\">(?)</a></td>");
	}
	else
	{
		// order_no
		echo("<td class=\"$class\" align=center>".
			($exists_error_ind?_theme_image("rs.gif", NULL, "Duplicate Attribute Type & Order No"):"").
			get_input_field("order_no[$row]", NULL, NULL, "number(3)", "N", $s_item_attribute_type_r['order_no'], FALSE)."</td>");

		if($s_attribute_type_list==null)
		{
			$sat_results = fetch_item_type_s_attribute_type_rs();
			while($attribute_type_r = mysql_fetch_array($sat_results, MYSQL_ASSOC))
			{
				$s_attribute_type_list[] = $attribute_type_r;
			}
			mysql_free_result($sat_results);
		}
		
		echo("<td class=\"$class\" align=center>".
			"<select name=\"s_attribute_type[$row]\">".
			"\n<option value=\"\">");
		reset($s_attribute_type_list);
		while(list(,$attribute_type_r) = each($s_attribute_type_list))
		{
			if(is_not_empty_array($s_item_attribute_type_r) && $s_item_attribute_type_r['s_attribute_type'] == $attribute_type_r['s_attribute_type'])
				echo("\n<option value=\"".$attribute_type_r['s_attribute_type']."\" SELECTED>".$attribute_type_r['s_attribute_type']);
			else
				echo("\n<option value=\"".$attribute_type_r['s_attribute_type']."\">".$attribute_type_r['s_attribute_type']);
			
			if(strlen($attribute_type_r['s_field_type'])>0)
				echo(" [".$attribute_type_r['s_field_type']."]");
		}
		echo("\n</select></td>");
		
		echo("<td class=\"$class\"><a href=\"javascript:popup('admin.php?type=s_item_type&op=help&inc_header=N&s_attribute_type='+document.forms['s_item_attribute_type']['s_attribute_type[$row]'].options[document.forms['s_item_attribute_type']['s_attribute_type[$row]'].options.selectedIndex].value,'400', '325')\">(?)</a></td>");
	}

	//prompt
	echo("<td class=\"$class\">".get_input_field("prompt[$row]", NULL, NULL, "text(15,30)", "N", $s_item_attribute_type_r['prompt'], FALSE)."</td>");
	
	echo("<td class=\"$class\" align=center>");
	if(!is_array($s_item_attribute_type_r) ||
				($attribute_type_r['s_field_type'] != 'STATUSTYPE' && 
				$attribute_type_r['s_field_type'] != 'STATUSCMNT' && 
				$attribute_type_r['s_field_type'] != 'DURATION' && 
				$attribute_type_r['s_field_type'] != 'TITLE' && 
				$attribute_type_r['s_field_type'] != 'ITEM_ID'))
	{
		echo(get_input_field("compulsory_ind[$row]", NULL, NULL, "simple_checkbox(".(strtoupper($s_item_attribute_type_r['compulsory_ind'])== "Y"?"CHECKED":"").")", "N", "Y", FALSE));
	}
	else
	{
		echo("&nbsp;");
	}	
	echo("</td>");
	
	echo("\n<td class=\"$class\">");
	if(is_not_empty_array($s_item_attribute_type_r))
	{
		echo("<input type=button onclick=\"".
				"document.forms['navigate'].s_item_type.value='".$s_item_type."';".
				"document.forms['navigate'].s_attribute_type.value='".$s_item_attribute_type_r['s_attribute_type']."';".
				"document.forms['navigate'].order_no.value='".$s_item_attribute_type_r['order_no']."'; ".
				"document.forms['navigate'].op.value='delete_confirm'; document.forms['navigate'].submit();\" value=\"Delete\">");
		
		if(!is_s_item_attribute_type_deletable($s_item_type, $s_item_attribute_type_r['s_attribute_type'], $s_item_attribute_type_r['order_no']))
		{
			echo("&nbsp;<input type=button onclick=\"".
				"document.forms['navigate'].s_item_type.value='".$s_item_type."';".
				"document.forms['navigate'].s_attribute_type.value='".$s_item_attribute_type_r['s_attribute_type']."';".
				"document.forms['navigate'].order_no.value='".$s_item_attribute_type_r['order_no']."'; ".
				"document.forms['navigate'].op.value='change_order_no'; document.forms['navigate'].submit();\" value=\"Change Order No.\">");
		}
	}
	echo("</td>");
	echo("</tr>");
}

/**
	Display a read-only version of the System Attribute type
	for reference.
*/
function display_s_attribute_type_record($s_attribute_type)
{
	$s_attribute_type_r = fetch_s_attribute_type_r($s_attribute_type);
	if($s_attribute_type_r!=FALSE)
	{
		echo("\n<h3 align=center>System Attribute Type<br>- ".$s_attribute_type." -</h3>");
		echo("<p align=center><table cellspacing=2 border=0>");
		echo format_field("Description", NULL, $s_attribute_type_r['description']);
		echo format_field("Prompt", NULL, $s_attribute_type_r['prompt']);
		echo format_field("Input type", NULL, $s_attribute_type_r['input_type']);
		echo format_field("Display type", NULL, $s_attribute_type_r['display_type']);
		echo format_field("Field type", NULL, $s_attribute_type_r['s_field_type']);
		echo format_field("Site type", NULL, $s_attribute_type_r['site_type']);
		echo("</table></p>");
	}
}

/**
* Generate a complete s_item_type script.
* 
* Data generated:
* 	s_item_type
* 	s_attribute_type's (Those not included in $_ATTRIBUTE_TYPES['core'])
* 	s_item_attribute_type's
* 	s_item_attribute_type_lookup (Those not included in $_ATTRIBUTE_TYPES['core'])
*/
function generate_s_item_type_sql($s_item_type)
{
	global $_CORE_ATTRIBUTE_TYPES;
	global $CONFIG_VARS;
	
	$CRLF = get_user_browser_crlf();
	
	$s_item_type_r = fetch_s_item_type_r($s_item_type);
	if($s_item_type_r !== FALSE)
	{
		$type_sql = $CRLF."#".
					$CRLF."# Item Type".
					$CRLF."#". 
					$CRLF."INSERT INTO s_item_type (s_item_type, description, image, order_no) VALUES ( '$s_item_type', '".addslashes($s_item_type_r['description'])."', '".addslashes($s_item_type_r['image'])."', '".$s_item_type_r['order_no']."');".
					$CRLF."";
		
		$attr_sql = $CRLF."#".
					$CRLF."# Attributes (non-core)".
					$CRLF."#";
		
		$item_attr_sql = $CRLF."#".
						$CRLF."# Item Attribute structure".
						$CRLF."#";
					
		$attr_lookup_sql = "";
		
		$delete_attr_list = "";
		$delete_lookup_list = "";
		
		$result = fetch_s_item_attribute_type_rs($s_item_type);
		if($result)
		{
			$attr_added = array();
			while($s_item_attribute_type_r = mysql_fetch_array($result, MYSQL_ASSOC))
			{
				// Ensure to also check that the attribute has not already been encountered, in case we have duplicates
				// in s_item_attribute_type structure (such as CDTRACK for instance)
				if( strlen($s_item_attribute_type_r['site_type'])==0 && // do not include any site type attributes 
						(!is_array($_CORE_ATTRIBUTE_TYPES) || 
							!in_array($s_item_attribute_type_r['s_attribute_type'], $_CORE_ATTRIBUTE_TYPES)) && 
						!in_array($s_item_attribute_type_r['s_attribute_type'], $attr_added))
				{
					// Add s_attribute_type, so we do not insert it twice.
					$attr_added[] = $s_item_attribute_type_r['s_attribute_type'];
					
					$s_attribute_type_r = fetch_s_attribute_type_r($s_item_attribute_type_r['s_attribute_type']);
					
					$attr_sql .= $CRLF."INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( '".$s_attribute_type_r['s_attribute_type']."', '".addslashes($s_attribute_type_r['description'])."', '".addslashes($s_attribute_type_r['prompt'])."', '".addslashes($s_attribute_type_r['input_type'])."', '".addslashes($s_attribute_type_r['display_type'])."', '".$s_attribute_type_r['s_field_type']."', '".$s_attribute_type_r['site_type']."');";
					
					$result2 = fetch_s_attribute_type_lookup_rs($s_item_attribute_type_r['s_attribute_type']);
					if($result2)
					{
						$attr_lookup_sql .= $CRLF."#".
											$CRLF."# Attribute Type Lookup (".$s_item_attribute_type_r['s_attribute_type'].")".
											$CRLF."#";
											
						while($s_attribute_type_lookup_r = mysql_fetch_array($result2, MYSQL_ASSOC))
						{
							$attr_lookup_sql .= $CRLF."INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( '".$s_item_attribute_type_r['s_attribute_type']."', '".$s_attribute_type_lookup_r['order_no']."', '".addslashes($s_attribute_type_lookup_r['value'])."', '".addslashes($s_attribute_type_lookup_r['display'])."', '".addslashes($s_attribute_type_lookup_r['img'])."', '".$s_attribute_type_lookup_r['checked_ind']."');";	
						}
						mysql_fetch_array($result2);
						
						$attr_lookup_sql .= $CRLF;

						if(strlen($delete_lookup_list)>0)
							$delete_lookup_list .= ", ";
						$delete_lookup_list .= "'".$s_item_attribute_type_r['s_attribute_type']."'";
					}

					if(strlen($delete_attr_list)>0)
						$delete_attr_list .= ", ";
					$delete_attr_list .= "'".$s_item_attribute_type_r['s_attribute_type']."'";
				}
				
				$item_attr_sql .= $CRLF."INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( '$s_item_type', '".$s_item_attribute_type_r['s_attribute_type']."', '".$s_item_attribute_type_r['order_no']."', '".$s_item_attribute_type_r['prompt']."', '".$s_item_attribute_type_r['compulsory_ind']."');";
			}
			mysql_fetch_array($result);
		}

		$sqlscript ="#########################################################".
					$CRLF."# OpenDb ".$CONFIG_VARS['site.version']." '$s_item_type' Item Type".
					$CRLF."#########################################################".
					$CRLF."".
					$CRLF."#".
					$CRLF."# Cleanup".
					$CRLF."#".
					$CRLF."DELETE FROM s_item_type WHERE s_item_type = '$s_item_type';".
					$CRLF."DELETE FROM s_item_attribute_type WHERE s_item_type = '$s_item_type';".
					(strlen($delete_attr_list)>0?$CRLF."DELETE FROM s_attribute_type WHERE s_attribute_type IN($delete_attr_list);":"").
					(strlen($delete_lookup_list)>0?$CRLF."DELETE FROM s_attribute_type_lookup WHERE s_attribute_type IN($delete_lookup_list);":"").
					$CRLF.
					$type_sql.
					$attr_sql.
					$CRLF.
					$item_attr_sql.
					$CRLF.
					$attr_lookup_sql;
					
		return $sqlscript;							
	}
	else
		return NULL;
}

/*
* Remove ALL records associated with an s_item_type, which includes:
* 	review
* 	borrowed_item
* 	item_attribute
* 	item_instance
* 	item
*/
function delete_sitemtype_items($s_item_type)
{
	global $HTTP_SESSION_VARS;
	
	$result = run_opendb_query("SELECT id as item_id FROM item WHERE s_item_type = '".$s_item_type."'");
	if($result && mysql_num_rows($result)>0)
	{
		while($item_r = mysql_fetch_array($result))
		{
			if(run_opendb_query("DELETE FROM review WHERE item_id = ".$item_r['item_id']) && mysql_affected_rows()>0)
			{
				opendb_log("User deleted system item type review records. (uid=".$HTTP_SESSION_VARS['user_id'].", s_item_type=$s_item_type, item_id=".$item_r['item_id'].")");
			}
			
			if(run_opendb_query("DELETE FROM borrowed_item WHERE item_id = ".$item_r['item_id']) && mysql_affected_rows()>0)
			{
				opendb_log("User deleted system item type borrowed_item records. (uid=".$HTTP_SESSION_VARS['user_id'].", s_item_type=$s_item_type, item_id=".$item_r['item_id'].")");
			}

			if(run_opendb_query("DELETE FROM item_attribute WHERE item_id = ".$item_r['item_id']) && mysql_affected_rows()>0)
			{
				opendb_log("User deleted system item type item_attribute records. (uid=".$HTTP_SESSION_VARS['user_id'].", s_item_type=$s_item_type, item_id=".$item_r['item_id'].")");
			}
			
			if(run_opendb_query("DELETE FROM item_instance WHERE item_id = ".$item_r['item_id']) && mysql_affected_rows()>0)
			{
				opendb_log("User deleted system item type item_instance records. (uid=".$HTTP_SESSION_VARS['user_id'].", s_item_type=$s_item_type, item_id=".$item_r['item_id'].")");
			}
			
			if(run_opendb_query("DELETE FROM item WHERE id = ".$item_r['item_id']) && mysql_affected_rows()>0)
			{
				opendb_log("User deleted system item type item records. (uid=".$HTTP_SESSION_VARS['user_id'].", s_item_type=$s_item_type, item_id=".$item_r['item_id'].")");
			}
		}
		mysql_free_result($result);
		
		return TRUE;
	}
	else // By returning false, we make it clear that no items were found.
	{
		return FALSE;
	}
}

if (is_opendb_valid_session())
{
	if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
	{
		if($HTTP_VARS['op'] == 'help')
		{
			if(is_exists_attribute_type($HTTP_VARS['s_attribute_type']))
			{
				echo _theme_header("Attribute Type Info", FALSE);
				display_s_attribute_type_record($HTTP_VARS['s_attribute_type']);
			}
			else
			{
				echo _theme_header("Attribute Type Info", FALSE);
				echo _theme_error("System Attribute Type not found");
			}
		}
		else if ($HTTP_VARS['op'] == 'sql' && is_exists_item_type($HTTP_VARS['s_item_type']))
		{
			header("Cache-control: no-store");
			header("Pragma: no-store");
			header("Expires: 0");
			header("Content-disposition: attachment; filename=".$HTTP_VARS['s_item_type'].".sql");
			header("Content-type: application/octet-stream");
			echo generate_s_item_type_sql($HTTP_VARS['s_item_type']);
		}
		else if($HTTP_VARS['op'] == 'delete_type_confirm') // This is initiated from the main s_item_type form.
		{
			$item_type_r = fetch_s_item_type_r($HTTP_VARS['s_item_type']);
			if($item_type_r!==FALSE)
			{
				if($HTTP_VARS['confirmed'] == 'false')
				{
					// do nothing.
				}
				else if($HTTP_VARS['confirmed'] != 'true')
				{
					echo("\n<h3>");
					if(strlen($item_type_r['image'])>0)
					{
						$src = _theme_image_src($item_type_r['image']);
						if($src!==FALSE && strlen($src)>0)
							echo("<img src=\"$src\">&nbsp;");
					}
					echo "Delete Item Type</h3>";
				
					$op_confirm_prompt = "";
					if(!is_s_item_type_deletable($HTTP_VARS['s_item_type']))
					{
						$op_confirm_prompt .= "<div class=\"error\">Dependant items exist for the ".$HTTP_VARS['s_item_type']." Item Type - These will also be deleted including all dependant records (review, borrowed_item, item_attribute, item_instance, item)</div><br>";
					}
					
					if(is_exists_item_type_item_type_group($HTTP_VARS['s_item_type']))
					{
						$op_confirm_prompt .= "<div class=\"error\">The ".$HTTP_VARS['s_item_type']." Item Type is referenced in at least one System Item Type Group record, this will also be deleted.</div><br>";
					}
					
					$op_confirm_prompt .= "Are you sure you want to delete Item Type \"".$HTTP_VARS['s_item_type']."\"?";
					
					echo get_op_confirm_form(
							$PHP_SELF, 
							$op_confirm_prompt,
							$HTTP_VARS);
				}
				else // $HTTP_VARS['confirmed'] == 'true'
				{
					// delete every record where s_item_type matches.
					delete_s_item_type_group(NULL, $HTTP_VARS['s_item_type']);

					// delete all items.
					delete_sitemtype_items($HTTP_VARS['s_item_type']);
									
					if(!is_exists_item_attribute_type($HTTP_VARS['s_item_type'], NULL) || 
							delete_s_item_attribute_type($HTTP_VARS['s_item_type'], NULL, NULL))
					{
							if(!delete_s_item_type($HTTP_VARS['s_item_type']))
								$errors[] = array('error'=>'Item Type "'.$HTTP_VARS['s_item_type'].'" not deleted','detail'=>mysql_error());
					}
					else
					{
						$errors[] = array('error'=>'Item Type "'.$HTTP_VARS['s_item_type'].'" Attributes not deleted','detail'=>mysql_error());
					}
				}
			}
		}
		else if($HTTP_VARS['op'] == 'insert_type')// Insert whole new item type
		{
			// All types are uppercase.
			$HTTP_VARS['s_item_type'] = strtoupper($HTTP_VARS['s_item_type']);
						
			// Get rid of all spaces, and illegal characters.
			$HTTP_VARS['s_item_type'] = preg_replace("/[\s|'|\\\\|\"]+/", "", trim(strip_tags($HTTP_VARS['s_item_type'])));

			if(strlen($HTTP_VARS['s_item_type'])>0)
			{
				if(!is_exists_item_type($HTTP_VARS['s_item_type']))//insert
				{
					// But a s_attribute_type must be supplied for s_field_type's
					// TITLE, STATUS, CATEGORY.   The DURATION is required if 
					// $CONFIG_VARS['borrow.enable'] == TRUE AND $CONFIG_VARS['borrow.duration_support'] == TRUE
					$missing_s_field_types = NULL;
					if(strlen($HTTP_VARS['s_field_type']['TITLE'])==0 || !is_exists_attribute_type($HTTP_VARS['s_field_type']['TITLE']))
						$missing_s_field_types[] = 'TITLE';
					if(strlen($HTTP_VARS['s_field_type']['STATUSCMNT'])==0 || !is_exists_attribute_type($HTTP_VARS['s_field_type']['STATUSCMNT']))
						$missing_s_field_types[] = 'STATUSCMNT';
					if(strlen($HTTP_VARS['s_field_type']['STATUSTYPE'])==0 || !is_exists_attribute_type($HTTP_VARS['s_field_type']['STATUSTYPE']))
						$missing_s_field_types[] = 'STATUSTYPE';
					if(strlen($HTTP_VARS['s_field_type']['CATEGORY'])==0 || !is_exists_attribute_type($HTTP_VARS['s_field_type']['CATEGORY']))
						$missing_s_field_types[] = 'CATEGORY';
					if($CONFIG_VARS['borrow.enable']!==FALSE && $CONFIG_VARS['borrow.duration_support']!==FALSE && (strlen($HTTP_VARS['s_field_type']['DURATION'])==0 || !is_exists_attribute_type($HTTP_VARS['s_field_type']['DURATION'])))
						$missing_s_field_types[] = 'DURATION';
					
					if(is_empty_array($missing_s_field_types))
					{
						if(insert_s_item_type($HTTP_VARS['s_item_type'], $HTTP_VARS['order_no'], $HTTP_VARS['description'], $HTTP_VARS['image']))
						{
							//Insert required system s_attribute_type's.
							insert_s_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_field_type']['TITLE'], '1', NULL, 'Y');
							insert_s_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_field_type']['CATEGORY'], '10', NULL, 'N');
							
							if($CONFIG_VARS['borrow.enable']!==FALSE && $CONFIG_VARS['borrow.duration_support']!==FALSE)
								insert_s_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_field_type']['DURATION'], '200', NULL, 'N');
								
							insert_s_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_field_type']['STATUSTYPE'], '254', NULL, 'N');
							insert_s_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_field_type']['STATUSCMNT'], '255', NULL, 'N');
							
							// Load the edit_types form now.
							$HTTP_VARS['op'] = 'edit_types';
						}
						else
						{
							$errors[] = array('error'=>'Item Type ('.$HTTP_VARS['s_item_type'].') not inserted.','detail'=>mysql_error());
						}
					}
					else
					{
						$errors[] = array('error'=>'The following Attribute <i>Field Type\'s</i> are missing.',
							'detail'=>$missing_s_field_types);
					}
				}
				else
				{
					$errors[] = array('error'=>'Item Type ('.$HTTP_VARS['s_item_type'].') already exists.','detail'=>'');
				}
			}
			else
			{
				$errors[] = array('error'=>'Item Type not specified.','detail'=>'');
			}
		}
		else if($HTTP_VARS['op'] == 'update_types') // This is initiated from the main s_item_type form.
		{
			if(is_not_empty_array($HTTP_VARS['s_item_type']))
			{
				for($i=0; $i<count($HTTP_VARS['s_item_type']); $i++)
				{
					if(is_exists_item_type($HTTP_VARS['s_item_type'][$i]))
					{
						if(!update_s_item_type($HTTP_VARS['s_item_type'][$i], $HTTP_VARS['order_no'][$i], $HTTP_VARS['description'][$i], $HTTP_VARS['image'][$i]))
						{
							$errors[] = array('error'=>'Item Type ('.$HTTP_VARS['s_item_type'][$i].') not updated','detail'=>mysql_error());
						}
					}
					else
					{
						$errors[] = array('error'=>'Item Type ('.$HTTP_VARS['s_item_type'][$i].') not found.', 'detail'=>'');
					}							
				}
			}
		}
		else if($HTTP_VARS['op'] == 'change_order_no')
		{
			$item_type_r = fetch_s_item_type_r($HTTP_VARS['s_item_type']);
			if($item_type_r!==FALSE)
			{
				$attribute_type_r = fetch_s_attribute_type_r($HTTP_VARS['s_attribute_type']);
				if($attribute_type_r!==FALSE)
				{
					if($HTTP_VARS['confirmed'] == 'false')
					{
						// return to edit form
						$HTTP_VARS['op'] = 'edit';
					}
					else if($HTTP_VARS['confirmed'] != 'true')
					{
						// Get the theme specific source of the image.
						echo("\n<h3>");
						if(strlen($item_type_r['image'])>0)
						{
							$src = _theme_image_src($item_type_r['image']);
							if($src!==FALSE && strlen($src)>0)
								echo("<img src=\"$src\">&nbsp;");
						}
					
						echo "Change Item Attribute Type Order No</h3>";
					
						$op_confirm_prompt = "";
						
						if(!is_s_item_attribute_type_deletable($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'], $HTTP_VARS['order_no']))
						{
							$op_confirm_prompt .= "<div class=\"error\">Dependant items attribute exist for the \"".$HTTP_VARS['s_attribute_type']."[".$HTTP_VARS['order_no']."]\" Item Attribute Type - these will be updated to reflect this change!</div><br>";
						}
						
						$op_confirm_prompt .= "Are you sure you want to update the Order No. for Item Attribute Type \"".$HTTP_VARS['s_attribute_type']."[".$HTTP_VARS['order_no']."]\"?";
						
						$field_rs[] = 
							array('prompt'=>"Attribute Type",
								'field'=>get_input_field("s_attribute_type", NULL, "Attribute Type", "readonly", "N", $HTTP_VARS['s_attribute_type'], FALSE));
								
						$field_rs[] = 
							array('prompt'=>"Old Order No",
								'field'=>get_input_field("old_order_no", NULL, "Old Order No.", "readonly", "N", $HTTP_VARS['order_no'], FALSE));
								
						$field_rs[] = 
							array('prompt'=>"New Order No",
								'field'=>get_input_field("order_no", NULL, "New Order No.", "number(3)", "N", $s_item_attribute_type_r['order_no'], FALSE));
						
						unset($HTTP_VARS['s_attribute_type']);
						unset($HTTP_VARS['order_no']);
						unset($HTTP_VARS['old_order_no']);
						
						echo "<table width=\"95%\"><tr><td>".
							format_confirm_form(
								$PHP_SELF, 
								$op_confirm_prompt,
								$field_rs,
								$HTTP_VARS).
							"</td></tr></table>";
					}
					else // $HTTP_VARS['confirmed'] == 'true'
					{
						if(is_s_item_attribute_type_with_order_no($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'], $HTTP_VARS['old_order_no']))
						{
							if(!is_s_item_attribute_type_with_order_no($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'], $HTTP_VARS['order_no']))
							{
								if(update_item_attribute_order_no($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'], $HTTP_VARS['old_order_no'], $HTTP_VARS['order_no']))
								{
									if(!update_s_item_attribute_type_order_no($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'], $HTTP_VARS['old_order_no'], $HTTP_VARS['order_no']))
										$errors[] = array('error'=>'Item Attribute Type "'.$HTTP_VARS['s_attribute_type'].'['.$HTTP_VARS['old_order_no'].']" order_no not updated.','detail'=>mysql_error());
								}
								else
								{
									$errors[] = array('error'=>'Item Attribute "'.$HTTP_VARS['s_attribute_type'].'['.$HTTP_VARS['old_order_no'].']" order_no\'s not updated.','detail'=>mysql_error());
								}
							}
							else
							{
								$errors[] = array('error'=>'Item Attribute Type "'.$HTTP_VARS['s_attribute_type'].'['.$HTTP_VARS['old_order_no'].']" order_no not updated.','detail'=>'Item attribute Type with new order_no exists');
							}
						}// do nothing here
						
						// return to edit form
						$HTTP_VARS['op'] = 'edit';
					}
				}
			}
		}
		else if($HTTP_VARS['op'] == 'delete_confirm')
		{
			$item_type_r = fetch_s_item_type_r($HTTP_VARS['s_item_type']);
			if($item_type_r!==FALSE)
			{
				$attribute_type_r = fetch_s_attribute_type_r($HTTP_VARS['s_attribute_type']);
				if($attribute_type_r!==FALSE)
				{
					if($HTTP_VARS['confirmed'] == 'false')
					{
						// return to edit form
						$HTTP_VARS['op'] = 'edit';
					}
					else
					{
						if($HTTP_VARS['confirmed'] != 'true')
						{
							// Get the theme specific source of the image.
							echo("\n<h3>");
							if(strlen($item_type_r['image'])>0)
							{
								$src = _theme_image_src($item_type_r['image']);
								if($src!==FALSE && strlen($src)>0)
									echo("<img src=\"$src\">&nbsp;");
							}
						
							echo "Delete Item Attribute Type</h3>";
							
							$op_confirm_prompt = "";
							
							if(!is_s_item_attribute_type_deletable($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'], $HTTP_VARS['order_no']))
							{
								$op_confirm_prompt .= "<div class=\"error\">Dependant items attribute exist for the \"".$HTTP_VARS['s_attribute_type']."[".$HTTP_VARS['order_no']."]\" Item Attribute Type - these will be deleted!</div><br>";
							}
							
							if($attribute_type_r['s_field_type'] == 'TITLE' || 
										$attribute_type_r['s_field_type'] == 'STATUSTYPE' || 
										$attribute_type_r['s_field_type'] == 'STATUSCMNT' || 
										$attribute_type_r['s_field_type'] == 'CATEGORY' ||
										($CONFIG_VARS['borrow.enable']!==FALSE && $CONFIG_VARS['borrow.duration_support']!==FALSE && 
												$attribute_type_r['s_field_type'] == 'DURATION'))
							{
								$op_confirm_prompt .= "<div class=\"error\">Item Attribute Type is a compulsory Field Type (".$attribute_type_r['s_field_type'].") - deleting this attribute will invalidate the ".$HTTP_VARS['s_item_type']." Item Type structure.</div><br>";
							}
							
							$op_confirm_prompt .= "Are you sure you want to delete Item Attribute Type \"".$HTTP_VARS['s_attribute_type']."[".$HTTP_VARS['order_no']."]\"?";
							
							echo get_op_confirm_form(
									$PHP_SELF, 
									$op_confirm_prompt,
									$HTTP_VARS);
						}
						else // $HTTP_VARS['confirmed'] == 'true'
						{
							if(is_s_item_attribute_type_with_order_no($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'], $HTTP_VARS['order_no']))
							{
								if(delete_item_attribute_order_no($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'], $HTTP_VARS['order_no']))
								{
									if(!delete_s_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'], $HTTP_VARS['order_no']))
										$errors[] = array('error'=>'Item Attribute Type "'.$HTTP_VARS['s_attribute_type'].'['.$HTTP_VARS['order_no'].']" not deleted.','detail'=>mysql_error());
								}
								else
								{
									$errors[] = array('error'=>'Item Attributes "'.$HTTP_VARS['s_attribute_type'].'['.$HTTP_VARS['order_no'].']" not deleted.','detail'=>mysql_error());
								}
							}//do nothing
							
							// return to edit form
							$HTTP_VARS['op'] = 'edit';
						}
					}
				}
			}
		}
		else if($HTTP_VARS['op'] == 'update') // This is initiated from the lower s_item_attribute_type form.
		{
			if(is_exists_item_type($HTTP_VARS['s_item_type']))
			{
				if(is_not_empty_array($HTTP_VARS['s_attribute_type']))
				{
					// Do delete operations here.
					for($i=0; $i<count($HTTP_VARS['s_attribute_type']); $i++)
					{
						//update or delete
						if($HTTP_VARS['exists_ind'][$i] == 'Y')
						{
							// The 'old_order_no' will often be the same as 'order_no' but for instances where
							// they are different this test will match both!
							if(is_exists_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'][$i], $HTTP_VARS['old_order_no'][$i]))
							{
								if($HTTP_VARS['order_no'][$i] != $HTTP_VARS['old_order_no'][$i])
								{
									// If order_no has changed.
									if(is_s_item_attribute_type_deletable($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'][$i], $HTTP_VARS['old_order_no'][$i]))
									{
										if($HTTP_VARS['order_no'][$i] != $HTTP_VARS['old_order_no'][$i])
										{
											$HTTP_VARS['exists_ind'][$i] = 'N';
										}
										
										// Delete old_order_no in both cases!
										if(!delete_s_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'][$i], $HTTP_VARS['old_order_no'][$i]))
										{
											$errors[] = array('error'=>'Item Attribute type ('.$HTTP_VARS['s_attribute_type'][$i].'['.$HTTP_VARS['old_order_no'][$i].']) not deleted','detail'=>mysql_error());
										}
									}
									else
									{
										$errors[] = array('error'=>'Item Attribute type ('.$HTTP_VARS['s_attribute_type'][$i].'['.$HTTP_VARS['old_order_no'][$i].']) not deleted','detail'=>'Dependant item attribute(s) with the same order_no exist.');
									}
								}
								else // 'old_order_no' IS THE SAME as 'order_no' here!
								{
									// At the moment we are not checking the order_no's for items with the same type.
									if(!update_s_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'][$i], $HTTP_VARS['order_no'][$i], $HTTP_VARS['prompt'][$i], $HTTP_VARS['compulsory_ind'][$i]))
									{
										$errors[] = array('error'=>'Item Attribute type ('.$HTTP_VARS['s_attribute_type'][$i].'['.$HTTP_VARS['old_order_no'][$i].']) not updated','detail'=>mysql_error());
									}
								}
							}//if(is_exists_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'][$i], $HTTP_VARS['old_order_no'][$i]))
							else
							{
								$errors[] = array('error'=>'Item Attribute type ('.$HTTP_VARS['s_attribute_type'][$i].'['.$HTTP_VARS['old_order_no'][$i].']) not found','detail'=>mysql_error());
							}
						}//if($HTTP_VARS['exists_ind'][$i] == 'Y')
					}//for($i=0; $i<count($HTTP_VARS['s_attribute_type']); $i++)

					// Now do the inserts.
					for($i=0; $i<count($HTTP_VARS['s_attribute_type']); $i++)
					{
						// Ignore elements that have no order_no or old_order_no specified.
						if($HTTP_VARS['exists_ind'][$i] != 'Y')
						{
							if(strlen($HTTP_VARS['s_attribute_type'][$i])>0)
							{
								if(is_numeric($HTTP_VARS['old_order_no'][$i]) || is_numeric($HTTP_VARS['order_no'][$i]))
								{
									if(!is_exists_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'][$i], $HTTP_VARS['order_no'][$i]))
									{
										if(!insert_s_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'][$i], $HTTP_VARS['order_no'][$i], $HTTP_VARS['prompt'][$i], $HTTP_VARS['compulsory_ind'][$i]))
										{
											$errors[] = array('error'=>'Item Attribute type ('.$HTTP_VARS['s_attribute_type'][$i].'['.$HTTP_VARS['old_order_no'][$i].']) not inserted','detail'=>mysql_error());
										}
									}
									else
									{
										// Cache any records that could not be inserted.
										$sait_already_exists[] = array('s_attribute_type'=>$HTTP_VARS['s_attribute_type'][$i],'order_no'=>$HTTP_VARS['order_no'][$i],'prompt'=>$HTTP_VARS['prompt'][$i], 'compulsory_ind'=>$HTTP_VARS['compulsory_ind'][$i]);
									}
								}
								else
								{
									$errors[] = array('error'=>'Item Attribute type ('.$HTTP_VARS['s_attribute_type'][$i].') not inserted','detail'=>'No order_no specified.');
								}
							}//if(strlen($HTTP_VARS['s_attribute_type'][$i])>0)
						}
					}
				}
			}
			else
			{
				$errors[] = array('error'=>'Item Type ('.$HTTP_VARS['s_item_type'].') not found', 'detail'=>'');
			}
		}

		// Reload edit page after an update.
		if($HTTP_VARS['op'] == 'edit' || $HTTP_VARS['op'] == 'update')
		{
			echo("<div class=\"footer\">[<a href=\"$PHP_SELF?type=s_item_type&op=edit_types\">Back to Item Type List</a>]</div>");
			
			$item_type_r = fetch_s_item_type_r($HTTP_VARS['s_item_type']);
			if($item_type_r!==FALSE)
			{
				echo get_validation_javascript();

				// Get the theme specific source of the image.
				echo("\n<h3>");
				if(strlen($item_type_r['image'])>0)
				{
					$src = _theme_image_src($item_type_r['image']);
					if($src!==FALSE && strlen($src)>0)
						echo("<img src=\"$src\">&nbsp;");
				}
				echo($item_type_r['s_item_type']." System Attributes</h3>");
				
				if(is_not_empty_array($errors))
					echo format_error_block($errors);
				
				$column_count = 6;
				
				echo("<form name=\"navigate\" action=\"$PHP_SELF\" method=\"get\">".
				"<input type=\"hidden\" name=\"type\" value=\"".$HTTP_VARS['type']."\">".
				"<input type=\"hidden\" name=\"op\" value=\"\">".
				"<input type=\"hidden\" name=\"s_item_type\" value=\"\">".
				"<input type=\"hidden\" name=\"s_attribute_type\" value=\"\">".
				"<input type=\"hidden\" name=\"order_no\" value=\"\">".
				"</form>");
				
				echo("\n<form name=\"s_item_attribute_type\" action=\"$PHP_SELF\" method=\"post\">");
				echo("<table cellspacing=2 border=0>");
				echo("<tr><td colspan=$column_count>");				
				echo("\n<input type=\"hidden\" name=\"op\" value=\"update\">".
					"\n<input type=\"hidden\" name=\"type\" value=\"".$HTTP_VARS['type']."\">".
					"\n<input type=\"hidden\" name=\"s_item_type\" value=\"".$HTTP_VARS['s_item_type']."\">".
					"</td></tr>");
				
				echo("<tr>"
					."<td class=\"navbar\">Order<br>No.</td>"
					."<td class=\"navbar\" colspan=2>Attribute Type [Field Type]</td>"
					."<td class=\"navbar\">Prompt</td>"
					."<td class=\"navbar\">Compulsory</td>"
					."<td class=\"navbar\">&nbsp;</td>"
					."</tr>");	
				
				$results = fetch_s_item_attribute_type_rs($HTTP_VARS['s_item_type']);
				if($results)
				{
					// value, display, img, checked_ind, order_no
					$row = 0;
					while($item_attribute_type_r = mysql_fetch_array($results, MYSQL_ASSOC))
					{
						display_s_item_attribute_type_row($HTTP_VARS['s_item_type'], $item_attribute_type_r, $row);
						$row++;
					}
					mysql_free_result($results);
				}
	
				// Now display records that could not be inserted.
				if(is_not_empty_array($sait_already_exists))
				{
					while(list(,$sait_r) = each($sait_already_exists))
					{
						display_s_item_attribute_type_row($HTTP_VARS['s_item_type'], $sait_r, $row, TRUE);
						$row++;
					}
				}

				if(is_numeric($HTTP_VARS['blank_rows']))
					$blank_rows = (int)$HTTP_VARS['blank_rows'];
				else
					$blank_rows = 5;

				for($i=$row; $i<$row+$blank_rows; $i++)
				{
					display_s_item_attribute_type_row($HTTP_VARS['s_item_type'], array(), $i);	
				}
			
				echo("<tr>");
				echo("<td colspan=1 align=center>".
					get_input_field("blank_rows", NULL, NULL, "value_select(\"1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20\",1)", "N", ifempty($HTTP_VARS['blank_rows'],"5"), FALSE, NULL, "this.form.submit();")
					."</td>");

				echo("<td colspan=".($column_count-1)." align=center>");
				echo("<input type=button value=\"Refresh\" onclick=\"this.form['op'].value='edit'; this.form.submit();\">&nbsp;<input type=button value=\"Update\" onclick=\"this.form['op'].value='update'; this.form.submit();\"></td>");
				echo("</tr>");
				
				echo("</form>");
				echo("</table>");

				// Only display if duplicates exist!
				if(is_not_empty_array($sait_already_exists))
				{
					$help_entries_rs[] = array('img'=>'rs.gif', 'text'=>'Duplicate Attribute Type & Order No');
					while(list(,$help_entries_r) = each($_FORM_HELP['siat']))
						$help_entries_rs[] = $help_entries_r;
					echo(format_help_block($help_entries_rs));
				}	
				else
					echo(format_help_block($_FORM_HELP['siat']));
			}
			else
			{
				echo format_error_block('Item Type ('.$HTTP_VARS['s_item_type'].') not found');
			}				
		}
		else if($HTTP_VARS['op'] == 'new_type' || $HTTP_VARS['op'] == 'insert_type')// Insert type form!
		{
			echo("<div class=\"footer\">[<a href=\"$PHP_SELF?type=s_item_type&op=edit_types\">Back to Item Type List</a>]</div>");
			echo get_validation_javascript();
				
			echo("\n<h3>New Item Type</h3>");
			
			if(is_not_empty_array($errors))
				echo format_error_block($errors);
				
			echo("\n<table cellspacing=2 border=0>");
			echo("\n<form name=\"s_item_type\" action=\"$PHP_SELF\" method=\"post\">");
	
			echo("\n<input type=\"hidden\" name=\"op\" value=\"insert_type\">");
			echo("\n<input type=\"hidden\" name=\"type\" value=\"".$HTTP_VARS['type']."\">");
				
			display_s_item_type_insert_form($HTTP_VARS['op']=='insert_type'?$HTTP_VARS:NULL);
			
			if($CONFIG_VARS['widgets.show_prompt_compulsory_ind']!==FALSE)
			{
				echo("\n<tr><td align=left nowrap>".
					format_help_block(array(array('img'=>'compulsory.gif', 'text'=>$LANG_VARS['compulsory_field']))).
					"</td><td>&nbsp;</td></tr>");
			}
					
			echo("\n<tr><td colspan=\"2\" align=center>");
			if($CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE)
			{
				echo("\n<input type=button value=\"Insert\" onclick=\"if(!checkForm(this.form)){return false;}else{this.form.submit();}\">");
			}
			else
			{
				echo("\n<input type=button value=\"Insert\" onclick=\"this.form.submit();\">");
			}
			echo("\n</td></tr>");

			echo("\n</form>");
			echo("\n</table>");
		}
		
		// There are specific operations where this form should be displayed.
		if(strlen($HTTP_VARS['op'])==0 || 
				(($HTTP_VARS['op'] == 'delete_sitem_type_items' && ($HTTP_VARS['confirmed'] == 'false' || $HTTP_VARS['confirmed'] == 'true'))) ||
				(($HTTP_VARS['op'] == 'delete_type_confirm' && ($HTTP_VARS['confirmed'] == 'false' || $HTTP_VARS['confirmed'] == 'true'))) || 
				$HTTP_VARS['op'] == 'edit_types' || 
				$HTTP_VARS['op'] == 'update_types')
		{
			echo get_validation_javascript();
			
			echo("<form name=\"navigate\" action=\"$PHP_SELF\" method=\"get\">".
				"<input type=\"hidden\" name=\"type\" value=\"".$HTTP_VARS['type']."\">".
				"<input type=\"hidden\" name=\"op\" value=\"\">".
				"<input type=\"hidden\" name=\"s_item_type\" value=\"\">".
				"<input type=\"hidden\" name=\"blank_rows\" value=\"5\">".
				"</form>");
				
			echo("<form name=\"sqlform\" action=\"$PHP_SELF\" method=\"get\">".
				"<input type=\"hidden\" name=\"type\" value=\"".$ADMIN_TYPE."\">".
				"<input type=\"hidden\" name=\"op\" value=\"\">".
				"<input type=\"hidden\" name=\"inc_theme\" value=\"\">".
				"<input type=\"hidden\" name=\"s_item_type\" value=\"\">".
				"</form>");
			
			if(is_not_empty_array($errors))
				echo format_error_block($errors);
				
			echo("<table cellspacing=2 border=0>");
			echo("\n<form name=\"s_item_type\" action=\"$PHP_SELF\" method=\"post\">");

			echo("\n<input type=\"hidden\" name=\"op\" value=\"update_types\">");
			echo("\n<input type=\"hidden\" name=\"type\" value=\"".$HTTP_VARS['type']."\">");
			
			echo("<tr>"
				."<td class=\"navbar\">Order</td>"
				."<td class=\"navbar\">Type</td>"
				."<td class=\"navbar\">Description</td>"
				."<td class=\"navbar\" colspan=2>Image</td>"
				."<td class=\"navbar\">&nbsp;</td>"
				."</tr>");	
			$column_count = 6;
			
			$results = fetch_s_item_type_rs();
			if($results)
			{
				// value, display, img, checked_ind, order_no
				$row = 0;
				while($item_type_r = mysql_fetch_array($results, MYSQL_ASSOC))
				{
					display_s_item_type_row($item_type_r, $row);
					$row++;
				}
				mysql_free_result($results);
			}

			echo("<tr>".
				"<td colspan=".($column_count)." align=center>".
				"<input type=button value=\"Refresh\" onclick=\"this.form['op'].value='edit_types'; this.form.submit();\">".
				"&nbsp;".
				"<input type=button value=\"Update\" onclick=\"this.form['op'].value='update_types'; this.form.submit();\">".
				"&nbsp;".
				"<input type=button value=\"New Item Type\" onclick=\"this.form['op'].value='new_type'; this.form.submit();\">".
				"</td>".
				"</tr>");

			echo("</form>");
			echo("</table>");
			
			echo(format_help_block($_FORM_HELP['sit']));
			
			$filelist = get_file_list('./patch/item_types/', 'sql');
			$sitelist = NULL;
			if(is_not_empty_array($filelist))
			{
				for($i=0; $i<count($filelist); $i++)
				{
					$sitelist[] = parse_file($filelist[$i]);
				}
				
				if(is_not_empty_array($sitelist))
				{
					echo("<div class=colortext>The following Item Type SQL definitions are available to be installed / reinstalled.</div>");
					echo get_popup_javascript();
					echo("<table border=0 width=50%>");
					echo("<tr>"
					."<td class=\"navbar\">Item Type*</td>"
					."<td class=\"navbar\">SQL File</td>"
					."<td class=\"navbar\">&nbsp;</td>"
					."<td class=\"navbar\">&nbsp;</td>"
					."</tr>");
						
					for($i=0; $i<count($sitelist); $i++)
					{
						if(!is_exists_item_type($sitelist[$i]['name'], FALSE))
							$install_text = "Install";
						else
							$install_text = "Reinstall";
							
						echo("<tr>".
							"<td align=center>".$sitelist[$i]['name']."</td>".
							"<td align=center>".$sitelist[$i]['name'].".".$sitelist[$i]['extension']."</td>".
							"<td><a href=\"javascript:popup('patch.php?from=item_types&type=optional&title=Item+Types&op=result&preview=true&standalone=Y&sqlfile=".$sitelist[$i]['name'].".".$sitelist[$i]['extension']."', 800, 600)\">Preview</a></td>".
							"<td><a href=\"javascript:popup('patch.php?from=item_types&type=optional&title=Item+Types&op=result&standalone=Y&sqlfile=".$sitelist[$i]['name'].".".$sitelist[$i]['extension']."', 800, 600)\">".$install_text."</a></td>".
							"</tr>");
					}
					echo("</table>");
					
					echo("<div class=footer>* Item Type name is a guess, based on the name of the SQL file itself, this may not be accurate.</div>");
				}
			}
		}			
	}
}
?>
