#
# Upgrade from 0.37
#

#
# Borrow Duration support is being improved to store total_duration instead of overdue_duration
# which can be calculated (total_duration - borrow_duration)
# 
ALTER TABLE borrowed_item ADD total_duration smallint(3) unsigned AFTER borrow_duration;

# Update statements necessary to convert over to new table structure...
UPDATE borrowed_item set total_duration = borrow_duration + overdue_duration, update_on = update_on WHERE borrow_duration IS NOT NULL AND overdue_duration IS NOT NULL;
UPDATE borrowed_item set total_duration = borrow_duration, update_on = update_on WHERE borrow_duration IS NOT NULL AND overdue_duration IS NULL;

ALTER TABLE borrowed_item DROP overdue_duration;

# Reduce s_attribute_type_lookup value column size
ALTER TABLE s_attribute_type_lookup CHANGE value value varchar(100) NOT NULL;

#
# Update all IMAGEURL item_attributes to include 'http://' prefix!
# This is required for the new support for locally stored Cover images.  We need to be able to check for 
# the existence of 'http://' at the start of IMAGEURL attribute_val, to work out whether they are relative
# or not.
#
UPDATE item_attribute SET attribute_val = CONCAT('http://',attribute_val) WHERE s_attribute_type = 'IMAGEURL' AND attribute_val NOT LIKE 'http://%' AND LENGTH(TRIM(attribute_val)) > 0;

#
# A default Duration of 'Undefined', so that for particular items you can disable borrow duration for particular items. 
#
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '0', '', 'Undefined', NULL, 'Y');

# This is here, because it was missing from 0.36 patch to 0.37 anyway!
# All the prompts here are the same as that defined in s_attribute_type for 'MOVIEGENRE'
update s_item_attribute_type set prompt = NULL
where s_attribute_type = 'MOVIEGENRE';

#
# For performance reasons you should explicity set the display_type of any attributes where no comparison
# to lookup values is required.
#
UPDATE s_attribute_type SET display_type = '%value%' WHERE s_attribute_type IN('ALT_TITLE','COMMENTS','MOVIE_PLOT','CDTRACK','CDTIME');

#
# List Link functionality
#
UPDATE s_attribute_type SET display_type = 'display(%value%, list-link)' where s_attribute_type IN('YEAR','VID_FORMAT','DVD_REGION');
UPDATE s_attribute_type SET display_type = 'display(%display%, list-link)' where s_attribute_type IN('VIDQUALITY','VHS_TYPE','DIVXVIDVER','DIVXAUDVER','DIVXQUALIT');
UPDATE s_attribute_type SET display_type = 'display(%img% %display%, list-link)' where s_attribute_type IN('AUDIO_LANG', 'SUBTITLES');

# Do it for Director as well in case there is dual directorship!
UPDATE s_attribute_type SET display_type = 'list(plain, " ", list-link)' where s_attribute_type IN('DIRECTOR','ACTORS','ARTIST');
# The display(%value%, list-link) widget does not work for attributes which have more than one %value%.
UPDATE s_attribute_type SET display_type = 'list(plain, " ", list-link)' where s_attribute_type IN('RATIO');
UPDATE s_attribute_type SET display_type = 'display(%img%, list-link)' where s_attribute_type  = 'AGE_RATING';
UPDATE s_attribute_type SET display_type = 'category(%display%, list-link)' where s_attribute_type IN('MOVIEGENRE','MUSICGENRE');

#
# Save Covers locally functionality.
#
UPDATE s_attribute_type SET input_type = 'upload_or_saveurl(50,*,"gif,jpg,png")', display_type = 'hidden' WHERE s_attribute_type = 'IMAGEURL';

#
# Used to display item.id in item_display.php script.
#
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, site_type) VALUES ( 'S_ITEM_ID', 'OpenDb Item ID', 'ID#', 'hidden', '%value%', NULL);

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);

# Amazon dummy attribute - may never be used to populate records, but will allow addition of links to particular items.
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, site_type) VALUES ( 'AMAZONASIN', 'Amazon Standard Item Number', 'Amazon ASIN', 'hidden', 'hidden', 'amazon');

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'AMAZONASIN', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'AMAZONASIN', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'AMAZONASIN', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'AMAZONASIN', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'AMAZONASIN', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'AMAZONASIN', '0', NULL, NULL, NULL);

