<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/**
	The mask will be used to parse the $timestamp and return
	a mysql timestamp, which can be used in a SQL statement.

	Note: THE MASK ELEMENTS ARE NOT THE SAME AS THOSE DEFINED FOR get_localised_timestamp(...)
*/
function get_timestamp_components($timestamp, $datetimemask)
{
	// In order for this to work, the $timestamp and $datetimemask must
	// match exactly.  If $timestamp length is smaller than $datetimemask,
	// then $datetimemask will be reset to the same length as $timestamp,
	// so that we can extract the proper information.
	if(strlen($timestamp) < strlen($datetimemask))
		$datetimemask = substr($datetimemask,0,strlen($timestamp));

	$maskcomp = array("YYYY","MM","DD","HH","MI","SS");
	// Now lets extract the various bits of the string.
	reset($maskcomp);
	while (list (,$mask) = each($maskcomp))
	{
		// Now get the actual value from the $timestamp.
		$index = strpos($datetimemask,$mask);
		if($index!==FALSE)
			$components[$mask] = substr($timestamp,$index,strlen($mask));
		else
		{
			$components[$mask]="";
			for($i=0; $i<strlen($mask);$i++)
				$components[$mask] .= "0";//Set to all zeros.		
		}			
	}
	return $components;
}

/**
	@param components is returned from get_timestamp_components
*/
function get_mysql_timestamp($components)
{
	// Format of timestamp is:
	// YYYY-MM-DD HH:MI:SS
	return $components['YYYY']."-".$components['MM']."-".$components['DD']." ".
			$components['HH'].":".$components['MI'].":".$components['SS'];
}

/**
 *	A Database independant mask of:
 *		Month - Month name
 * 		Mon - Abbreviated month, Initcap.
 * 		MON - Abreviated month UPPERCASE
 *		Day	- Weekday name
 *		DDth - Day of the month with English suffix (1st, 2nd, 3rd)
 *		DD - Days (01 - 31)
 *		MM - Months (01 -12)
 *		YYYY - Years
 *		HH24 - Hours (00 - 23)
 *		HH - Hours (01 - 12)
 *		MI - Minutes (00 - 59)
 *		SS - Seconds (00 - 59)
 *		AM/PM - Meridian indicator  (Will be replaced with the actual context meridian value!)
 *
 *	Accepts a mask and will convert to one that can be used in php date() function
 *
 *	Uses the postgresql formatting options, which in most cases are compatible
 *	with Oracle:
 *		http://www.postgresql.org/idocs/index.php?functions-formatting.html

 * Formats localised datetime.  Replaces Day/Month mask elements with actual values.
 *
 * @param   string   the current timestamp
 */
function get_localised_timestamp($format_mask, $timestamp = null)
{
	global $LANG_VARS;
	
	if($timestamp === null)
		$timestamp = time();
		
	$php_mask_conversion = 
		array("DDth"=>"jS",//Day of the month with English suffix (1st, 2nd, 3rd, etc.)
			"DD"=>"d",//Day of the month, numeric (00..31)
			"MM"=>"m",//Month, numeric (01..12)
			"YYYY"=>"Y",//Year, numeric, 4 digits
			"YY"=>"y",//Year, numeric, 2 digits
			"HH24"=>"H",//Hour (00..23)
			"HH"=>"h",//Hour (01..12)
			"MI"=>"i",//Minutes, numeric (00..59)
			"SS"=>"s",//Seconds (00..59)
			"AM"=>"a",//AM or PM
			"PM"=>"a"//AM or PM
		);

	// Now expand the mask with the test of the elements.
	reset($php_mask_conversion);
	while( list($key,$match) = each($php_mask_conversion))
		$format_mask = str_replace($key, date($match, $timestamp), $format_mask);

	// Replace the 'Mon' with the actual abbreviated 'Month' word for the $timestamp
	$month = (int)date('m', $timestamp)-1;
	$format_mask = str_replace('Month', $LANG_VARS['months_full'][$month], $format_mask);
	$format_mask = str_replace('Mon', $LANG_VARS['months_abbrev'][$month], $format_mask);
	$format_mask = str_replace('MON', strtoupper($LANG_VARS['months_abbrev'][$month]), $format_mask);

	// Replace the 'Day' with the actual 'Day' word for the $timestamp
	$day = (int)date('w', $timestamp);
	$format_mask = str_replace('Day', $LANG_VARS['days_full'][$day], $format_mask);

	return $format_mask;
}
?>
