<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


include_once("./functions/function.php");
include_once("./functions/fileutils.php");

function get_patch_file_list($from, $ext)
{
	return get_file_list("./patch/$from", $ext);
}

/**
 * A very _slightly_ modified version of this function from phpMyAdmin
 *
 * Note: This function is a little slow, but the benefit is, that you can correctly
 * process a sql file where statements are not necessarily formatted in a consistent manner!
 *
 * Removes comment lines and splits up large sql files into individual queries
 *
 * Last revision: September 23, 2001 - gandon
 *
 * @param   array    the splitted sql commands
 * @param   string   the sql commands
 *
 * @return  boolean  always true
 *
 * @access  public
 */
function split_sql_file($sql, &$pieces)
{
	// Quick hack to support end of file comments!
	$sql			= trim($sql)."\n";
    $sql_len		= strlen($sql);
    $char			= '';
    $string_start	= '';
    $in_string		= FALSE;

    for ($i = 0; $i < $sql_len; ++$i) {
        $char = $sql[$i];

        // We are in a string, check for not escaped end of strings except for
        // backquotes that can't be escaped
        if ($in_string) {
            for (;;) {
                $i         = strpos($sql, $string_start, $i);
                // No end of string found -> add the current substring to the
                // returned array
                if (!$i) {
                    $pieces[] = $sql;
                    return TRUE;
                }
                // Backquotes or no backslashes before quotes: it's indeed the
                // end of the string -> exit the loop
                else if ($string_start == '`' || $sql[$i-1] != '\\') {
                    $string_start      = '';
                    $in_string         = FALSE;
                    break;
                }
                // one or more Backslashes before the presumed end of string...
                else {
                    // ... first checks for escaped backslashes
                    $j                     = 2;
                    $escaped_backslash     = FALSE;
                    while ($i-$j > 0 && $sql[$i-$j] == '\\') {
                        $escaped_backslash = !$escaped_backslash;
                        $j++;
                    }
                    // ... if escaped backslashes: it's really the end of the
                    // string -> exit the loop
                    if ($escaped_backslash) {
                        $string_start  = '';
                        $in_string     = FALSE;
                        break;
                    }
                    // ... else loop
                    else {
                        $i++;
                    }
                } // end if...elseif...else
            } // end for
        } // end if (in string)

        // We are not in a string, first check for delimiter...
        else if ($char == ';') {
            // if delimiter found, add the parsed part to the returned array

            $pieces[]	= substr($sql, 0, $i);
            $sql        = ltrim(substr($sql, min($i + 1, $sql_len)));
            $sql_len    = strlen($sql);
            if ($sql_len) {
                $i      = -1;
            } else {
                // The submited statement(s) end(s) here
                return TRUE;
            }
        } // end else if (is delimiter)

        // ... then check for start of a string,...
        else if (($char == '"') || ($char == '\'') || ($char == '`')) {
            $in_string    = TRUE;
            $string_start = $char;
        } // end else if (is start of string)

        // ... for start of a comment (and remove this comment if found)...
        else if ($char == '#'
                 || ($char == ' ' && $i > 1 && $sql[$i-2] . $sql[$i-1] == '--')) {
			// starting position of the comment depends on the comment type
            $start_of_comment = (($sql[$i] == '#') ? $i : $i-2);
            // if no "\n" exists in the remaining string, checks for "\r"
            // (Mac eol style)
			$end_of_comment   = (strpos(' ' . $sql, "\012", $i+2))
                              ? strpos(' ' . $sql, "\012", $i+2)
                              : strpos(' ' . $sql, "\015", $i+2);

			if (!$end_of_comment) {
                // no eol found after '#', add the parsed part to the returned
                // array and exit
                $pieces[] = trim(substr($sql, 0, $i-1));
                return TRUE;
            } else {
                $sql     = substr($sql, 0, $start_of_comment)
                         . ltrim(substr($sql, $end_of_comment));
                $sql_len = strlen($sql);
                $i--;
            } // end if...else
        } // end else if (is comment)
    } // end for

    // add any rest to the returned array
    if (strlen($sql)>0 && ereg('[^[:space:]]+', $sql)) {
        $pieces[] = $sql;
    }

	// Return array of sql lines.
    return $pieces;
} // end of the 'split_sql_file()' function

//Stub for old functionality.
function exec_sql($sqltext, $do_prefix=TRUE){ exec_patch_sql($sqltext, $do_prefix);}
function exec_sql_file($sqltext, $do_prefix=TRUE){ exec_patch_sql_file($sqltext, $do_prefix);}
function print_sql_file($from, $filename){ echo_patch_sql_file($from, $filename);}

/**
	Evaluate each of the sql statements $sql.  The $sql will first be split up
	into individual statements for easier processing.
*/
function exec_patch_sql($sqltext, $do_prefix=TRUE)
{
	global $CONFIG_VARS;

	$queries = array();
	split_sql_file($sqltext, $queries);

	while (list(,$sql) = each($queries))
	{
		exec_patch_sql_statement($sql, $do_prefix);
	}

	echo( "<p><div class=\"success\">Done!</div></p>");
}

function exec_patch_sql_statement($sql, $do_prefix=TRUE)
{
	global $CONFIG_VARS;
	
	// Do it this way, so we can actually display the prefix SQL statement
	// in the output.
	if($do_prefix && strlen($CONFIG_VARS['db_server.table_prefix'])>0)
		$sql = parse_sql_statement($sql, $CONFIG_VARS['db_server.table_prefix']);

	// display query to screen
	echo("<div class=\"code\"><pre>".htmlspecialchars($sql).";</pre></div>\n");
		
	// evaluate query - We have already prefixed above, so no need to do again!
	$result = run_opendb_query($sql, FALSE);
	if($result)
	{
		echo( "<div class=\"upgrade_success\">SQL query evaluated successfully (".mysql_affected_rows()." Rows affected).</div>\n" );
		return TRUE;
	}
	else
	{
		$errno = mysql_errno();
		// Duplicate Entry!
		if($errno == 1062)
			echo( "<div class=\"upgrade_warning\">Row already exists.</div>\n" );
		else
			echo( "<div class=\"upgrade_failure\">SQL query evaluation failed. (".mysql_error().")</div>\n" );
			
		return FALSE;
	}
}

/**
	Loads the $filename from patch/$from/ directory and calls exec_sql($text) on the 
	contents.  This function and the exec_sql(...) one will display results of
	queries executed.
*/
function exec_patch_sql_file($from, $filename, $do_prefix=TRUE)
{
	$sqlfile = "./patch/$from/$filename";

	echo("<p class=\"querytitle\">Evaluating SQL queries for <i>$filename</i></p>");

	$errors = "";
	$sqltext = read_file_contents($sqlfile, $errors);
	if($sqltext===FALSE)
	{
		echo ("<div class=\"error\">Error loading $filename&nbsp;&nbsp;$errors</div>");
		return FALSE;
	}

	// evaulate the sql contents of this textfile
	exec_patch_sql($sqltext, $do_prefix);
}

/**
	Will display queries as they appear in the script, will
	not attempt to prefix, as this is only a print SQL
	operation.
*/
function echo_patch_sql_file($from, $filename)
{
	$sqlfile = "./patch/$from/$filename";

	echo("<p class=\"querytitle\">Printing SQL queries for <i>$filename</i></p>");

	$errors = "";
	$lines = @file($sqlfile);
	if(!$lines)
	{
		echo ("<div class=\"error\">Error loading $filename&nbsp;&nbsp;$errors</DIV>");
		return false;
	}

	while (list(,$line) = each($lines))
	{
		if(strlen(trim($line))===0)
			echo("<br>");
		else
		{
			if(strpos($line,"#") === 0)
				echo( "<div class=\"code\"><b>$line</b></div>\n" );
			else
			{
				echo( "<div class=\"code\">$line</div>");
			}
		}
	}
}

/**
	Check if a given table exists or not
*/
function check_table($table, $do_prefix=TRUE, $alt_db_server=NULL)
{
	// Only get one row, to save processing them.
	$query = "SELECT 'x' FROM $table LIMIT 0,1";
	
	// In this case the run_opendb_query() would return FALSE, if
    // table does not exist.
	$result = run_opendb_query($query, $do_prefix, $alt_db_server);
	if($result)	
	{
		mysql_free_result($result);

		// The table exists (Does not have to have any records!)
		return TRUE;
	}

	//else
	return FALSE;
}

/**
	Check if a table has any records.
*/
function count_table_records($table, $do_prefix=TRUE)
{
	$query = "SELECT count(*) as count FROM ".$table;
	$result = run_opendb_query($query, $do_prefix);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result);
		mysql_free_result($result);
		if ($found !== FALSE){
			return (int)$found['count'];// So that === will evaluate successfully!
		}
	}
	//else
	return FALSE;
}

/**
	count the number fields in table
*/
function count_fields($table, $do_prefix=TRUE)
{
	// does the table even exist?
	if(!check_table($table)) return -1;

	// lets lookup our table
	$query = "SELECT * FROM ".$table;
	$result = run_opendb_query($query, $do_prefix);

	// count fields (columns) in table
	$fields = mysql_num_fields($result);

	return $fields;
}

/**
	simple function to return substring prefix of string
*/
function excerpt($message, $length)
{
	if( $length<=0 ) $length = 20;

	// only show the first $length characters of msg	
	$text = substr($message, 0, $length);

 	// append eplisis if cut short	
	if( strlen($message)>$length ) $text = $text."...";
	
	return $text;
}
?>
