<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/**
* 	Note that this file/feature requires GD libraries installed on the php server
* 
* @param $sortorder 'asc' or 'desc'
* @param $chartType 'barchart' or 'piechart'
* @param $imgType 'gif', 'jpg', 'png'
* @param $chartOptions Array of options for chart, options include:
* 			striped=>[TRUE|FALSE]
* 			12oclock=>[TRUE|FALSE]
* 			threshold=>a number
*/
function build_and_send_graph($data, $sortorder, $chartType, $chartOptions, $graphCfg, $imgType)
{
	// process data
	$items = count($data);

	if($items > 0 && !empty($sortorder))
	{
		// Sort categories by popularity.

		// FIXME (jpell): I will be honest I have no idea how this sort function
		// works.  I have just swapped around the operators!
		function index_1_asc_sort($a, $b)
		{
			if ($a[1] == $b[1])
				return($a[0] < $b[0]);	// Alphabetic on category if equal percentages
			else
				return($a[1] > $b[1]);	// Forwards sort
		}

		function index_1_desc_sort($a, $b)
		{
			if ($a[1] == $b[1])
				return($a[0] > $b[0]);	// Alphabetic on category if equal percentages
			else
				return($a[1] < $b[1]);	// Backwards sort
		}

		if($sortorder == 'asc')
			usort($data, 'index_1_asc_sort');
		else if($sortorder == 'desc')
			usort($data, 'index_1_desc_sort');
	}

	// size of pie-chart (not counting text borders)
	$imgsize = $graphCfg['imgsize'];

	$fontsize = $graphCfg['fontsize'];
	$fontheight = imagefontheight($fontsize);

	// Create a new image
	$side_margin = round($imgsize * 2/3);

	$top_margin      = $fontheight+1;
	$xsize = $imgsize + 2*$side_margin;
	$ysize = $imgsize + 2*$top_margin;

	$im = ImageCreate($xsize, $ysize);

	// Allocate the colors for the image
	// believe it or not, but the first color allocated becomes the default background color for the generated image, unless explicitly
	// set using ImageFilledRectangle!
	$bgcolor 		= ImageColorAllocate($im, hexdec(substr($graphCfg['bgcolor'],0,2)), hexdec(substr($graphCfg['bgcolor'],2,2)), hexdec(substr($graphCfg['bgcolor'],4,2)));
	$text_color	 	= ImageColorAllocate($im, hexdec(substr($graphCfg['text'],0,2)), hexdec(substr($graphCfg['text'],2,2)), hexdec(substr($graphCfg['text'],4,2)));
	$captions_color	= ImageColorAllocate($im, hexdec(substr($graphCfg['captions'],0,2)), hexdec(substr($graphCfg['captions'],2,2)), hexdec(substr($graphCfg['captions'],4,2)));
	$lt_color	 	= ImageColorAllocate($im, hexdec(substr($graphCfg['lt_color'],0,2)), hexdec(substr($graphCfg['lt_color'],2,2)), hexdec(substr($graphCfg['lt_color'],4,2)));
	$dk_color	 	= ImageColorAllocate($im, hexdec(substr($graphCfg['dk_color'],0,2)), hexdec(substr($graphCfg['dk_color'],2,2)), hexdec(substr($graphCfg['dk_color'],4,2)));
	$lt_border 		= ImageColorAllocate($im, hexdec(substr($graphCfg['lt_border'],0,2)), hexdec(substr($graphCfg['lt_border'],2,2)), hexdec(substr($graphCfg['lt_border'],4,2)));
	$dk_border 		= ImageColorAllocate($im, hexdec(substr($graphCfg['dk_border'],0,2)), hexdec(substr($graphCfg['dk_border'],2,2)), hexdec(substr($graphCfg['dk_border'],4,2)));

	// Do this if you want your background image to show through:
	if($graphCfg['transparent'] === TRUE)
	{
		imagecolortransparent($im, $bgcolor);
	}

	// color background
	//ImageFilledRectangle($im, 0, 0, $xsize, $ysize, $bgcolor);

	// $items == 0 in small databases (no items, or all items have no
	// category).  To reproduce, add a CD that freedb classifies as "noise"
	// (Barbie's dance albums).	 "Noise" isn't one of OpenDb's MUSICGENREs.

	// This conditional looks a little odd.	 It skips a massive section if
	// there are no items to draw.
	if($chartType == 'barchart')
	{
		if($items>0)
		{
			$sidegap = 10;			// pixels.
			$topgap = $sidegap;

			// An iterative process to determine the best box width.
			// It will perform only one loop, unless you have so many items that
			// the box width is smaller than the font height.  Then it will
			// recompute with fewer items.
			$items++;			// We undo this on the next line.
			do {
				$items--;
				$boxwidth = round(($xsize - ($sidegap*2)) / ($items + 1));
				$gapwidth = round($boxwidth / 10);
				if ($gapwidth < 1) $gapwidth = 1;
				$boxwidth = floor(($xsize - ($sidegap*2) - ($gapwidth * ($items-1))) / $items);
				$totalwidth = $boxwidth * $items + $gapwidth * ($items-1);
			} while ($items && $boxwidth < $fontheight + 2);

			// centre it:
			$sidegap = ($xsize - $totalwidth) / 2;
	
			// Find the largest value, so that we can draw it filling the chart.
			// This puts more information in the chart when all the values are
			// low (e.g. DVD categories hovering around 10%).
			$maxdata = 0;
			for( $ix = 0; $ix < $items; $ix++ )
			{
				if ($maxdata < $data[$ix][1])
				{
					$maxdata = $data[$ix][1] + 1;
				}
			}

			for( $ix=0; $ix < $items; $ix++ )
			{
				//$height = $data[$ix][1] * ($ysize - $topgap*2) / 100;
				$height = $data[$ix][1] * ($ysize - $topgap*2) / $maxdata;

				$x1 = $sidegap + ($ix*$boxwidth) + ($ix*$gapwidth);

				// ImageLine($im, $x1, $ysize - $top_margin, $x1, $ysize - $top_margin - $height, $dk_border );
				ImageFilledRectangle($im,
					 $x1, $ysize - $topgap - $height,
					 $x1+$boxwidth, $ysize - $topgap,
					 $lt_color);

				// Highlight it from the top left, shadow on bottom and right.
				ImageLine($im, $x1, $ysize - $topgap - $height, $x1, $ysize - $topgap, $lt_border);
				ImageLine($im, $x1, $ysize - $topgap - $height, $x1+$boxwidth, $ysize - $topgap - $height, $lt_border);
				ImageLine($im, $x1+$boxwidth, $ysize - $topgap - $height, $x1+$boxwidth, $ysize - $topgap, $dk_border);
				ImageLine($im, $x1, $ysize - $topgap, $x1+$boxwidth, $ysize - $topgap, $dk_border);

				$text = $data[$ix][0]." ".round($data[$ix][1])."%"; // show percent
				ImageStringUp($im, $fontsize, $x1 + $boxwidth/2 - $fontheight/2, $ysize - $topgap - 3, $text, $text_color);
			}
		}
		else //if($items>0)
		{
			// Do nothing, which will produce an empty graph.
		}
	}//if($chartType == 'barchart')
	else
	{
		// A pie chart.
		if(is_numeric($chartOptions['threshold']))// minimum wedge percent to omit from caption
			$threshold = $chartOptions['threshold'];
		else
			$threshold = 3;

		$radius = round($imgsize/2);

		$originx = $radius+$side_margin;
		$originy = $radius+$top_margin;

		// draw a circle
		ImageArc($im, $originx, $originy, $radius*2, $radius*2, 0, 360, $dk_border);

		// fill circle with color
		ImageFill($im, $originx, $originy, $lt_color);

		// GD-2 version of the above two calls.	 Damn PHP.
		// ImageFilledArc($im, $originx, $originy, $radius*2, $radius*2, 0, 360, $dk_border, IMG_ARC_PIE);

		if($chartOptions['12oclock'] !== FALSE)
		{
			// draw a wedge
			$last_angle = deg2rad(-90);
			// Draw line at 0 degrees if we have more than one item.
			if ($items > 1)
			{
				ImageLine($im,
						$originx, $originy,
						$originx, $originy - $radius + 1,
						$dk_border );
			}
		}
		else
		{
			$last_angle = deg2rad(0);
			if ($items > 1)
			{
				ImageLine($im,
						$originx, $originy,
						$originx + $radius - 1, $originy,
						$dk_border );
			}
		}

		if($chartOptions['striped'] !== FALSE)
		{
			// Draw every other pie wedge a different colour.
			$striped = TRUE;
		}
	
		for( $ix=0; $ix < $items; $ix++ )
		{
			$angle = deg2rad(($data[$ix][1]*3.6))+$last_angle;

			$x2 = ($radius-1)*cos($angle) + $originx;
			$y2 = ($radius-1)*sin($angle) + $originy;

			if($ix != $items-1) // don't draw wedge-line for 100%
				ImageLine($im, $originx, $originy, $x2, $y2, $dk_border );
	
			$mid_angle = ($angle-$last_angle)/2;
		
			// Fill every other wedge with a different colour:
			if (($ix % 2) && $striped)
			{
				ImageFillToBorder($im,
							$radius*0.9*cos($mid_angle+$last_angle) + $originx,
							$radius*0.9*sin($mid_angle+$last_angle) + $originy,
							$dk_border,
							$dk_color);
			}
		
			if($data[$ix][1]>$threshold ) // caption if over $threshold
			{
				$x1 = ($radius/2)*cos($mid_angle+$last_angle) + $originx;
				$y1 = ($radius/2)*sin($mid_angle+$last_angle) + $originy;

				$x2 = $radius*cos($mid_angle+$last_angle) + $originx;
				$y2 = $radius*sin($mid_angle+$last_angle) + $originy;

				ImageArc( $im, $x1, $y1, $imgsize/25, $imgsize/25, 0, 360, $captions_color);  // display caption
				ImageLine($im, $x1, $y1, $x2, $y2, $captions_color);

				$text = $data[$ix][0]." ".round($data[$ix][1])."%"; // show percent
				if($x1 > $originx)
				{
					ImageLine($im, $x2, $y2, $x2+$side_margin, $y2, $captions_color); // caption on right side
					if ($y2 > $originy) // Bottom half
						ImageString($im, $fontsize, $x2, $y2, $text, $text_color);
					else
						// Should use font height here:
						ImageString($im, $fontsize, $x2, $y2-15, $text, $text_color);
				}
				else
				{
					ImageLine($im, $x2, $y2, $x2-$side_margin, $y2, $captions_color); // caption on left side
					if ($y2 > $originy) // Bottom half
						ImageString($im, $fontsize, $x2-$side_margin, $y2, $text, $text_color);
					else
					{
						// Should use font height here:
						ImageString($im, $fontsize, $x2-$side_margin, $y2 - 15, $text, $text_color);
					}
				}
			}
			$last_angle = $angle;
		}
	}

	header("Pragma: no-cache");
	header("Expires: 0");
				
	switch($imgType)
	{
		case 'jpeg':
		case 'jpg':
			Header("Content-Type: image/jpeg");
			ImageJPEG($im);
			break;

		case 'gif'://not all sites support GIF!
			Header("Content-Type: image/gif");
			ImageGIF($im);
			break;

		case 'png':
		default:
			Header("Content-Type: image/png");
			ImagePNG($im);// send image as PNG to browser
	}

	// destroy image when done
	ImageDestroy($im);
}
?>