<?php
include_once("./functions/listings.php");
include_once("./functions/utils.php");

/**
	Multiple select checkbox javascript here.

	Currently this function only works for single form pages.
*/
function get_navigation_javascript()
{
	return "<script language=\"JavaScript\">
		<!-- // hide from stupid browsers
		
		// Restrict listing to a particular letter.
		function restrictLetter(form, letter)
		{
			// Must reset page numbers for this operation
			form.page_no.value = '1';
			form.letter.value = letter;
			form.submit();
		}
		
		function toggleSubmit(form)
		{
			form.submit();
		}
		
		function doInternalOperation(form, operation)
		{
			form.op.value = operation;
			form.internal_link.value = 'true';
			form.submit();
		}
		
		function doOperation(form, script_uri, operation)
		{
			form.action = script_uri;
			form.op.value = operation;
			form.page_no.value = '';
			form.internal_link.value = '';
			form.submit();
		}
		
		// Restrict listing to a particular letter.
		function restrictSubmit(form)
		{
			// Must reset page numbers for this operation
			form.page_no.value = '1';
			form.submit();
		}
		
		// Modify sort order of items.
		function sortOrder(form, order_by, sortorder)
		{
			// Must reset page numbers for this operation
			form.page_no.value = '1';
			form.order_by.value = order_by;
			form.sortorder.value = sortorder;
			form.submit();
		}
		
		// Navigate to page function.
		function gotoPage(form, page_no)
		{
			form.page_no.value = page_no;
			form.submit();
		}
		// -->
		</script>";
}

/**
	Multiple select checkbox javascript here.
*/
function get_checked_javascript()
{
	return "<script language=\"JavaScript\">
		<!-- // hide from stupid browsers
		function doChecks(checked, form, cbname)
		{
			for (var i=0; i < form.length; i++)
			{
				if (form.elements[i].type.toLowerCase() == 'checkbox' && form.elements[i].name == cbname)
					form.elements[i].checked = checked;
			}
		}

		// At least one element must be checked.
		function isChecked(form, cbname)
		{
			for (var i=0; i < form.length; i++)
			{
				if (form.elements[i].type.toLowerCase() == 'checkbox' && form.elements[i].name == cbname && form.elements[i].checked)
					return true;
			}
			//else
			return false;
		}
		// -->
		</script>";
}

/**
	Will merge values of the arrays so that any values in $new_item_array are 
	added to $old_item_array if they are not found.  This function ignores the
	array keys, as they are assumed to be numeric.
*/
function process_array($old_item_array, $new_item_array)
{
	// Unless both are arrays there is nothing to do!
	if(is_not_empty_array($old_item_array) && is_not_empty_array($new_item_array))
	{
		reset($old_item_array);									
		while( list(,$value) = each($new_item_array))
		{
			if(!in_array($value, $old_item_array))
			{
				array_push($old_item_array, $value);
			}
		}
		return $old_item_array;
	}
	else if(is_not_empty_array($old_item_array))
	{
		return $old_item_array;								
	}
	else if(is_not_empty_array($new_item_array))
	{
		return $new_item_array;
	}
	else
		return NULL;
}

/**
	Assumes all arrays are indexed by integer and are not more
	than two dimensions deep.
	
	Will return a new $old_item_array, with any values removed, that are found in 
	$checked_item_array but not in $new_item_array.
*/
function remove_array_values($old_item_array, $new_item_array, $checked_item_array)
{
	// In order to work out what to remove from the $session_array, the $old_item_array
	// must exist.
	if(is_not_empty_array($session_array) && is_not_empty_array($checked_item_array))
	{
		$new_array = array();
	
		reset($old_item_array);
		while(list(,$value) = each($old_item_array))
		{
			// $value must exist in $old_item_array.  If $new_item_array is not an array, or the 
			// $value is not found, remove from $session_array
			if( !( in_array($value, $checked_item_array) && @!in_array($value, $new_item_array) ))
			{
				array_push($new_array, $value);
			}			
		}
		return $new_array;
	}
	else
		return $old_item_array;		
}

/*
* Any values found in $item_array, should be removed from $old_item_array
*/
function minus_array_values($old_item_array, $item_array)
{
	// In order to work out what to remove from the $session_array, the $old_item_array
	// must exist.
	if(is_not_empty_array($old_item_array) && is_not_empty_array($item_array))
	{
		$new_array = array();
	
		reset($old_item_array);
		while(list(,$value) = each($old_item_array))
		{
			if( !in_array($value, $item_array))
			{
				array_push($new_array, $value);
			}			
		}
		return $new_array;
	}
	else
		return $old_item_array;		
}

function convert_array_to_csv_list($array_list)
{
	$csvlist = "";

	if(is_array($array_list))
	{
		reset($array_list);
		while(list(,$value) = each($array_list))
		{
			if(strlen($csvlist)>0)
				$csvlist .= ",";
			$csvlist .= "$value";
		}
	}
	return $csvlist;
}

class Listing
{
	var $_mode = NULL;
	var $_items_per_page = 0;
	var $_page_no = 0;
	var $_start_index = 0;
	var $_total_items = 0;
	var $_toggle = TRUE;
	var $_rowclass = '';
	var $_check_box_name = NULL;
	var $_check_box_enable = FALSE;
	var $_check_box_count = 0;
	var $_no_rows_checked_msg = 0;
	
	var $_session_checked_count = 0;
	var $_checked_list_checked_count = 0;
	
	var $_no_of_columns = 0;
	
	var $_list_op_actions;
	var $_navigate_controls;
	
	var $_header_controls_form;
	var $_footer_controls_form;
	var $_listing_form;

	var $_checked_list;	
	var $_session_var_list;
	
	// keeps track of location in listing.
	var $_column = 0;
	var $_row = 0;
	
	var $_current_orderby;
	var $_current_sortorder;
	
	/*
	* @param $mode - 'printable' or not
	* 
	* @param $navigation_form_method - The method of navigation by which the form controls, footer
	* 		etc are managed.  The disadvantage of POST is that it often makes it difficult to
	* 		use the Browser BACK button directly.
	* 
	* 		'POST'	- All checked items are maintained between page requests,
	* 		and will all be passed to the final operation.  The functionality will not
	* 		work if the user navigates from the listing page and comes back.
	* 
	* 		'GET' - No state between pages.
	* 
	* 		NULL - Assumes the Listings object is being instantiated for some other reason besides
	* 		generating listing page.
	*/
	function Listing($mode=NULL, $navigation_form_method = NULL)
	{
		$this->_mode = $mode;
		
		if($navigation_form_method == 'POST')
		{
			// The Alpha list, item type, item group, etc restrictions
			$this->_header_controls_form = 
					array('name'=>'listings', 
						'method'=>'POST');
		
			// the actual listings themselves.
			$this->_footer_controls_form = 
					array('name'=>'listings', 
						'method'=>'POST');
		
			// The next/previous and page_no links
			$this->_listing_form = 
					array('name'=>'listings', 
						'method'=>'POST');
		}
		else if($navigation_form_method == 'GET')
		{
			// The Alpha list, item type, item group, etc restrictions
			$this->_header_controls_form = 
					array('name'=>'navigate', 
						'method'=>'GET');
		
			// the actual listings themselves.
			$this->_footer_controls_form = 
					array('name'=>'navigate', 
						'method'=>'GET');
		
			// The next/previous and page_no links
			$this->_listing_form = 
					array('name'=>'listings', 
						'method'=>'POST');
		}
	}
	
	function setTotalItems($total_items)
	{
		$this->_total_items = $total_items;
	}
	
	function setItemsPerPage($items_per_page)
	{
		$this->_items_per_page = $items_per_page;
	}
	
	/**
	* @param $enable - Whether to actually include a checkbox column
	* when generating the listings.
	*/
	function setCheckBoxColumn($name, $enable = FALSE, $no_rows_checked_msg = NULL)
	{
		global $LANG_VARS;
		
		$this->_check_box_name = $name;
		
		if(strlen($no_rows_checked_msg) > 0)
			$this->_no_rows_checked_msg = $no_rows_checked_msg;
		else
			$this->_no_rows_checked_msg = $LANG_VARS['no_items_checked'];
		
		if($enable !== FALSE)
			$this->_check_box_enable = TRUE;
		else
			$this->_check_box_enable = FALSE;
	}
	
	/*
	* Ensure the following functions have been called:
	* 	setCheckBoxColumn($name, $enable)
	* 
	* The $HTTP_VARS['checked_'.$this->_check_box_name.'_list'] should be reset to EMPTY
	* once the update operation is performed against the list of items.
	*/
	function setCheckedList($session_var_list, &$HTTP_VARS)
	{
		if($session_var_list !== NULL)
		{
			$this->_session_var_list = $session_var_list;
		}
		
		if(strlen(trim($HTTP_VARS['checked_'.$this->_check_box_name.'_list'])))
		{
			$this->_checked_list = explode(",", $HTTP_VARS['checked_'.$this->_check_box_name.'_list']);
			unset($HTTP_VARS['checked_'.$this->_check_box_name.'_list']);
		}
		
		if(is_array($HTTP_VARS['checked_'.$this->_check_box_name]))
		{
			reset($HTTP_VARS['checked_'.$this->_check_box_name]);
			while(list(,$value) = each($HTTP_VARS['checked_'.$this->_check_box_name]))
			{
				if( !is_array($HTTP_VARS[$this->_check_box_name]) || !in_array($value, $HTTP_VARS[$this->_check_box_name]) )
				{
					if( is_array($this->_checked_list) && ($key = array_search2($value, $this->_checked_list))!==FALSE )
					{
						// Remove element
						array_splice($this->_checked_list, $key, 1);
					}
				}
			}
			unset($HTTP_VARS['checked_'.$this->_check_box_name]);
		}
		
		if(is_array($HTTP_VARS[$this->_check_box_name]))
		{
			reset($HTTP_VARS[$this->_check_box_name]);
			while(list(,$value) = each($HTTP_VARS[$this->_check_box_name]))
			{
				if( (!is_array($this->_checked_list) || !in_array($value, $this->_checked_list)) )
				{
					$this->_checked_list[] = $value;
				}
			}
			unset($HTTP_VARS[$this->_check_box_name]);
		}
	}
	
	function resetCheckedList()
	{
		$this->_checked_list = NULL;
	}
	
	function isCheckBoxColumn()
	{
		return ($this->_mode != 'printable' && $this->_check_box_enable === TRUE && $this->_check_box_name !== NULL);
	}
	
	function addSelectControl($text, $fieldname, $results, $display_mask, $value=NULL, $valkey=NULL)
	{
		$this->_navigate_controls[] = array(
						'type'=>'select',
						'field'=>$fieldname,
						'block'=>"<select name=\"$fieldname\" class=\"footer\" onChange=\"restrictSubmit(this.form);\">".
									"\n<option value=\"\">- ".$text." -".
									custom_select($fieldname, 
											$results,
											$display_mask,
											'NA',
											$value,
											$valkey).
								"\n</select>");
	}
	
	/*
	* @param $toggle_options - Format should be
	* 				array('value'=>'display', 'value'=>'display')
	*/
	function addToggleControl($text, $fieldname, $value)
	{
		global $LANG_VARS;
		
		$this->_navigate_controls[] = array(
						'type'=>'toggle',
						'field'=>$fieldname,
						'block'=>"<table><tr><td align=center class=\"footer\">".
								$text.":</td></tr>".
								"<tr><td class=\"footer\" nowrap>".
									"<input type=radio class=\"footer\" name=\"$fieldname\" value=\"Y\" onclick=\"toggleSubmit(this.form); return true;\"".(strcasecmp($value, 'Y')===0?" CHECKED":"").">".$LANG_VARS['yes'].
									"&nbsp;".
									"<input type=radio class=\"footer\" name=\"$fieldname\" value=\"N\" onclick=\"toggleSubmit(this.form); return true;\"".(strcasecmp($value, 'N')===0?" CHECKED":"").">".$LANG_VARS['no'].
								"</td></tr></table>");
	}
	
	function addAlphaList($letter)
	{
		global $LANG_VARS;

		$buffer = "\n<i>".$LANG_VARS['alpha_listing']." </i>[&nbsp;";

		// There is an even better way to do this: foreach(range('A','Z') as $letter) -- not supported before 4.07
		foreach(array(1 => "#","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z") as $char)
		{
			if($letter == $char)
				$buffer .= "<u>$char</u>&nbsp;&nbsp;";//letter chosen does not have a link.
			else
			{
				$buffer .= "<a href=\"javascript:restrictLetter(document.forms['".$this->_header_controls_form['name']."'], '$char')\" class=\"alphalist\">$char</a>&nbsp;&nbsp;";
			}
		}
	
		$buffer .= "]&nbsp;";
	
		// So we can reset display to everything.
		if(strlen($letter)>0)
		{
			$buffer .= "<a href=\"javascript:restrictLetter(document.forms['".$this->_header_controls_form['name']."'], '')\" class=\"alphalist\">[".$LANG_VARS['all']."]</a>\n";
		}
	
		$this->_navigate_controls[] = array(
						'type'=>'alphalist',
						'field'=>'letter',
						'value'=>$letter,
						'block'=>$buffer);
	}
	
	/*
	* Do not call this function until the following methods have
	* been called:
	*	setTotalItems($total_items)
	* 	setItemsPerPage($items_per_page)
	*/
	function initListing($HTTP_VARS=NULL)
	{
		$this->_page_no = $HTTP_VARS['page_no'];
		
		// Set to default.
		if($this->_mode == 'printable')
		{
			$this->_page_no = 1;
			$this->_start_index = NULL;
		}
		else if(!is_numeric($this->_page_no))
		{
			$this->_page_no = 1;
			
			// If items per page not provided, assume we should be displaying all
			// items - for example a printable listing.
			if(is_numeric($this->_items_per_page))
				$this->_start_index = 0;
			else
				$this->_start_index = NULL;
		}
		else
		{
			// We need to ensure that the $page_no is realistic for the number of items.
			$this->_start_index = ($this->_page_no - 1) * $this->_items_per_page;
			if($this->_start_index >= $this->_total_items)
			{
				$this->_page_no = floor($this->_total_items / $this->_items_per_page);
				if($this->_page_no>0)
					$this->_start_index = ($this->_page_no-1) * $this->_items_per_page;
				else
				{
					$this->_page_no = 1;
					$this->_start_index = 0;
				}
			}
		}
		
		// A printable listing, may take a lot more time to generate, because
		// there is no per-page limit.
		if($this->_start_index == NULL)
			@set_time_limit(600);
	}
	
	/*
	* Do not call this function until the following methods have
	* been called:
	*	setTotalItems($total_items)
	* 	setItemsPerPage($items_per_page)
	* 	initListing($HTTP_VARS=NULL)
	* 	setCheckBoxColumn($name, $enable)	
	* 	setCheckedList($HTTP_VARS)
	* 	setRemoveFromSessionList($session_var_list, $HTTP_VARS)
	*	addSelectControl($text, $fieldname, $results, $display_mask, $value=NULL, $valkey=NULL)
	*	addToggleControl($text, $fieldname, $value)
	*	addAlphaList($letter)
	*/
	function startListing($PHP_SELF=NULL, $HTTP_VARS=NULL)
	{
		if($this->_mode != 'printable')
		{
			$this->_current_orderby = $HTTP_VARS['order_by'];
			$this->_current_sortorder = $HTTP_VARS['sortorder'];
		
			$this->_write(get_checked_javascript());
			$this->_write(get_navigation_javascript());
			
			$this->_write("\n<form action=\"$PHP_SELF\" name=\"".$this->_header_controls_form['name'].
							"\" method=\"".$this->_header_controls_form['method']."\">");
			
			$exclude_vars_r = array();
			
			if(is_not_empty_array($this->_navigate_controls))
			{
				reset($this->_navigate_controls);
				while(list(,$control) = each($this->_navigate_controls))
				{
					$exclude_vars_r[] = $control['field'];
					if($control['type'] == 'alphalist')//only one that does not use form fields
						$this->_write("\n<input type=hidden name=\"".$control['field']."\" value=\"".$control['value']."\">");
				}
					
				$this->_write("\n<table width=100% cellspacing=2 cellpadding=0 border=0>");
				$this->_write("\n<tr>");
		
				$type = NULL;
				reset($this->_navigate_controls);
				while(list(,$control) = each($this->_navigate_controls))
				{
					if($type != NULL && $control['type'] != $type)
						$this->_write("</td>");
					
					if($type != NULL && $control['type'] === $type)
						$this->_write("<br>\n");
					else
					{
						if($control['type'] == 'toggle')
							$this->_write("<td align=right class=\"footer\">");
						else if($control['type'] == 'alphalist')
							$this->_write("<td width=50% class=\"footer\">");
						else // if($control['type'] == 'select')
							$this->_write("<td class=\"footer\">");
					}
					
					$type = $control['type'];
					
					$this->_write($control['block']);
				}
				$this->_write("</td>\n</tr></table>");
			}
			
			if($this->_header_controls_form['name'] !== $this->_listing_form['name'])
			{
				$this->_write(
					get_url_fields(
						$HTTP_VARS,
						array( // required
							'page_no'=>$this->_page_no,
							'order_by'=>$HTTP_VARS['order_by'],
							'sortorder'=>$HTTP_VARS['sortorder'],
							'internal_link'=>'true'),
						array_merge(
							$exclude_vars_r,
							array( // exclude
								$this->_check_box_name, 
								'checked_'.$this->_check_box_name, 
								'checked_'.$this->_check_box_name.'_list')
							)
						));
						
				$this->_write("\n</form>");
			
				$this->_write("\n<form action=\"$PHP_SELF\" name=\"".$this->_listing_form['name'].
								"\" method=\"".$this->_listing_form['method']."\">");
			}
			
			$this->_write(
				get_url_fields(
					$HTTP_VARS, 
					array( // required
						'op'=>$HTTP_VARS['op'],
						'page_no'=>$this->_page_no,
						'order_by'=>$HTTP_VARS['order_by'],
						'sortorder'=>$HTTP_VARS['sortorder'],
						'internal_link'=>'true',
						'checked_'.$this->_check_box_name.'_list'=>convert_array_to_csv_list($this->_checked_list)),
					array_merge(
						$exclude_vars_r,
						array( //exclude
							$this->_check_box_name, 
							'checked_'.$this->_check_box_name)
						)
					));
			
			$this->_write("\n<table width=100% cellspacing=1 border=0>");
		}
		else
		{
			$this->_write("\n<table width=100% cellspacing=0 border=0><tr><td>".
						"<table width=100% cellspacing=0 border=1>");			
		}
	}
	
	/*
	* @param $isChecked_Test - If TRUE, will do logic to check if items are selected
	* 							in the listing.
	*/
	function addListOpAction($text, $script_uri, $operation, $isCheckedTest=TRUE)
	{
		$this->_list_op_actions[] = array('text'=>$text, 
										'script_uri'=>$script_uri,
										'operation'=>$operation,
										'isCheckedTest'=>$isCheckedTest);
	}
	
	/*
	* Ensure the following methods have been called:
 	* 	setCheckBoxColumn($name, $enable)
	*	setTotalItems($total_items)
	* 	setItemsPerPage($items_per_page)
	* 	initListing($HTTP_VARS)
	* 	startListing($PHP_SELF=NULL, $HTTP_VARS=NULL)
	* 
	* @param $no_records_message - Specify something else besides $LANG_VARS['no_matches_found']
	*/
	function endListing($no_records_message = NULL)
	{
		global $LANG_VARS;
		
		// The initial values may not have been set properly, so lets double check them.
		if($this->_items_per_page < $this->getRowCount())
			$this->setItemsPerPage($this->getRowCount());
		
		if($this->_total_items < $this->getRowCount())
			$this->setTotalItems($this->getRowCount());
	
		// Output navigation footer!
		$this->_writeFooter($no_records_message);
		
		if(is_not_empty_array($this->_list_op_actions))
		{
			$this->_write("\n<tr><td colspan=".$this->_no_of_columns." align=\"center\">");
			while(list(,$action_r) = each($this->_list_op_actions))
			{
				if(strlen($action_r['script_uri'])>0)
					$doOperationAction = "doOperation(this.form, '".$action_r['script_uri']."', '".$action_r['operation']."')";
				else
					$doOperationAction = "doInternalOperation(this.form, '".$action_r['operation']."')";
				
				if($action_r['isCheckedTest']!==FALSE)
					$this->_write("\n<input type=\"button\" onclick=\"if(!isChecked(this.form, '".$this->_check_box_name."[]')){alert('".$this->_no_rows_checked_msg."');}else{".$doOperationAction.";}\" value=\"".$action_r['text']."\">");
				else
					$this->_write("\n<input type=\"button\" onclick=\"".$doOperationAction.";\" value=\"".$action_r['text']."\">");
			}
			$this->_write("\n</td></tr>");
		}
	
		$this->_write("\n</table>");
		if($this->_mode != 'printable')
		{
			$this->_write("\n</form>");
		}
	}
		
	/*
	* Ensure the following functions have been called:
	* 	setCheckBoxColumn($name, $enable)
	*/
	function startHeaderRow()
	{
		$this->_write("\n<tr>");
		
		if($this->isCheckBoxColumn())
		{
			$this->_write("<td class=\"navbar\"><input type=checkbox onclick=\"doChecks(this.checked, this.form, '".$this->_check_box_name."[]');return true;\"></td>");
			$this->_no_of_columns++;
		}
	}
	
		
	/*
	* Ensure the following functions have been called:
	* 	startHeaderRow()
	*/
	function writeHeaderColumn($title, $fieldname=NULL, $colspan=1)
	{
		$this->_no_of_columns += $colspan;
		
		$this->_write("<td class=\"navbar\" ".($colspan>1?$colspan:1)." nowrap>");
		
		// At least one is NOT NULL
		if($this->_mode != 'printable' && $fieldname !== NULL)
		{
			// Pass the opposite of $sortorder to next instance, for the header links only.
			if(strlen($this->_current_sortorder)==0 || strcasecmp($this->_current_sortorder, "desc")===0)
				$sortorder = "ASC";
			else
				$sortorder = "DESC";

			// Only display the order image if current orderby matches.
			if($this->_current_orderby == $fieldname)
			{ 
				$href = "<a href=\"javascript:sortOrder(document.forms['".$this->_header_controls_form['name']."'], '".$fieldname."', '".$sortorder."');\" class=\"navbar\">".$title;

				if(strcasecmp($this->_current_sortorder, "asc")===0)
					$href .= "&nbsp;"._theme_image("asc_order.gif", NULL, NULL, "absmiddle");
				else if(strcasecmp($this->_current_sortorder, "desc")===0)
					$href .= "&nbsp;"._theme_image("desc_order.gif", NULL, NULL, "absmiddle");
				$href .= "</a>";
			}
			else
			{
				if(strlen($this->_current_sortorder)==0)
					$this->_current_sortorder = "ASC";

				// For new sort order columns, we want to sort by current sortorder instead.
				$href = "<a href=\"javascript:sortOrder(document.forms['".$this->_header_controls_form['name']."'], '".$fieldname."', '".$this->_current_sortorder."');\" class=\"navbar\">".$title."</a>";
			}
			$this->_write($href);
		}
		else
		{
			$this->_write($title);
		}	
		$this->_write("</td>");
	}
	
	/*
	* Ensure the following functions have been called:
	* 	startHeaderRow()
	*/
	function endHeaderRow()
	{
		$this->_write("\n</tr>");
	}
	
	function startRow()
	{
		$this->_write("\n<tr>");

		$this->_row++;
		$this->_column=0; // reset
		
		if($this->_toggle)
			$this->_rowclass = "top";
		else
			$this->_rowclass = "top2";
		$this->_toggle = !$this->_toggle;
	}
	
	/*
	* Ensure the following functions have been called:
	* 	startRow()
	*/
	function writeColumn($value=NULL, $action_links_rs=NULL)
	{
		global $LANG_VARS;
		
		$this->_column++;
		
		if(is_not_empty_array($action_links_rs))
		{
			$this->_write(
					format_action_links(
						$action_links_rs,
						"\n<td align=\"center\" class=\"".$this->_rowclass."\" %nowrap%><font class=\"smlink\">%field%</font></td>",
						$LANG_VARS['not_applicable'])
					);
		}
		else
		{			
			$this->_write("<td align=\"center\" class=\"".$this->_rowclass."\">");
		
			if($value !== NULL && $this->_column == 1 && $this->isCheckBoxColumn())
			{
				if(is_array($this->_session_var_list) && in_array($value, $this->_session_var_list))
				{
					$this->_write(_theme_image("gs.gif", NULL, $LANG_VARS['item_in_reserve_list'], "absmiddle")); // todo - work out a proper indicator!
					$this->_session_checked_count++;
				}
				else if(is_array($this->_checked_list) && in_array($value, $this->_checked_list))
				{
					$this->_write("<input type=hidden name=\"checked_".$this->_check_box_name."[]\" value=\"".$value."\">");
					$this->_write("<input type=checkbox name=\"".$this->_check_box_name."[]\" value=\"".$value."\" CHECKED>");
					$this->_checked_list_checked_count++;
					$this->_check_box_count++;
				}
				else
				{
					echo("<input type=checkbox name=\"".$this->_check_box_name."[]\" value=\"".$value."\">");
					$this->_check_box_count++;
				}
			}
			else
			{
				if(strlen($value)>0)
					$this->_write($value);
				else
					$this->_write('&nbsp;');
			}
		
			$this->_write("</td>");
		}			
	}
	
	/*
	* Ensure the following functions have been called:
	* 	startRow()
	*/
	function endRow()
	{
		$this->_write("\n</tr>");
	}
	
	// Should never call directly - always called from endListing()
	function _writeFooter($no_records_message = NULL)
	{
		global $LANG_VARS;
		
		if($this->_mode == 'printable')
			$this->_write("\n</table>");
		
		if($this->_row > 0)
		{
			$this->_write("\n<tr><td colspan=".$this->_no_of_columns.">");
			$this->_write("\n<table width=100% cellspacing=5 border=0>");

			$first_item = (($this->_page_no - 1) * $this->_items_per_page) + 1;

			// Do some sanity checking!
			if($first_item > $this->_total_items)
			{
				$this->_page_no = 1;
				$first_item = 1;
			}

			$last_item = $this->_page_no * $this->_items_per_page;
		
			// Ensure we do not go past total.
			if($last_item > $this->_total_items)
				$last_item = $this->_total_items;

			$this->_write("\n<tr><td align=left width=33% class=\"footer\">".
						replace_lang_vars(array('first_row'=>$first_item,'last_row'=>$last_item,'total'=>$this->_total_items), $LANG_VARS['page_listing_index']).
						"</td>");
			
			if($first_item>1 || $last_item < $this->_total_items)// Only if more than one page.
			{
				// Pages
				$this->_write("<td align=center width=33% class=\"footer\">".
						"\n[&nbsp;");
		
				$total_pages = ceil($this->_total_items / $this->_items_per_page);
				if($total_pages <= 10)
				{
					$start_page = 1;
					$end_page = $total_pages;
				}
				else if($this->_page_no <= 5)
				{
					$start_page = 1;
					$end_page = 10;
				}
				else if(($this->_page_no + 5) >= $total_pages)
				{
					$end_page = $total_pages;
					$start_page = $total_pages - 10;
				}
				else // $page_no>=5 && $total_pages < ($page_no+5)
				{
					$start_page = $this->_page_no - 5;
					$end_page = $this->_page_no + 5;
				}

				// Check if we need to supply << arrows.
				if($start_page > 1)
				{
					if($start_page > 10)
						$this->_write("<a href=\"javascript:gotoPage(document.forms['".$this->_footer_controls_form['name']."'], '".($start_page - 10)."');\" class=\"footer\">&lt;&lt;</a>&nbsp;");
					else
						$this->_write("<a href=\"javascript:gotoPage(document.forms['".$this->_footer_controls_form['name']."'], '1');\" class=\"footer\">&lt;&lt;</a>&nbsp;");
				}

				for($i=$start_page; $i<=$end_page; $i++)
				{
					if($i>$start_page)
						$this->_write(",&nbsp;");

					if($i == $this->_page_no)
						$this->_write("<u>$i</u>");
					else
						$this->_write("<a href=\"javascript:gotoPage(document.forms['".$this->_footer_controls_form['name']."'], '$i');\" class=\"footer\">".$i."</a>");
				}
	
				// If more than 10 pages to end.
				if($end_page < $total_pages)
				{
					$this->_write("&nbsp;<a href=\"javascript:gotoPage(document.forms['".$this->_footer_controls_form['name']."'], '".($end_page+1)."');\" class=\"footer\">&gt;&gt;</a>");
				}
	
				$this->_write("&nbsp;]".
					"\n</td>".
					"<td align=right width=33% class=\"footer\">");
	
				// A bit of a kludge, but it does work.
				if($this->_page_no>1)
					$this->_write("<a href=\"javascript:gotoPage(document.forms['".$this->_footer_controls_form['name']."'], '".($this->_page_no-1)."');\" class=\"footer\">"._theme_image("left.gif", "<=", NULL, "absmiddle")." ".$LANG_VARS['previous_page']."</a>");
				else
					$this->_write("&nbsp;");

				if($this->_page_no>1 && $this->_page_no < $total_pages)
				{
					$this->_write("&nbsp;/&nbsp;");
				}

				if($this->_page_no < $total_pages)
					$this->_write("<a href=\"javascript:gotoPage(document.forms['".$this->_footer_controls_form['name']."'], '".($this->_page_no+1)."');\" class=\"footer\">".$LANG_VARS['next_page']." "._theme_image("right.gif", "=>", NULL, "absmiddle")."</a>");
				else
					$this->_write("&nbsp;");
			
				$this->_write("</td>");			
			}
	
			$this->_write("</tr>".
					"</table>");
		}
		else
		{
			$this->_write("\n<tr><td align=\"center\" colspan=".$this->_no_of_columns.">");
			$this->_write("<div class=\"error\"><b>- ".ifempty($no_records_message, $LANG_VARS['no_matches_found'])." -</b></div>");
		}
		$this->_write("\n</td></tr>");
	}
	
	//
	// Getters
	//
	
	function getRowCSSClass()
	{
		return $this->_rowclass;
	}
	
	/**
	* Do not call this method BEFORE initListing() is called.
	*/
	function getStartIndex()
	{
		return $this->_start_index;
	}
	
	function getPageNo()
	{
		return $this->_page_no;
	}
	
	function getTotalItemCount()
	{
		return $this->_total_items;
	}
	
	/*
	* Do not call before:
	* 	setCheckedList($session_var_list, $HTTP_VARS)
	*/
	function getCheckedList()
	{
		return $this->_checked_list;
	}
	
	/*
	* Return calculated ItemsPerPage, based on the total_items count, and the specified start_index.  Will
	* adjust the returned value as required.
	*/
	function getItemsPerPage()
	{
		if ( ($this->_start_index + $this->_items_per_page) > $this->_total_items )
			return ($this->_total_items - $this->_start_index);
		else
			return $this->_items_per_page;
	}
	
	function getRowCount()
	{
		return $this->_row;
	}
	
	/*
	* Count of items CHECKED on current page, before page is generated, that are already
	* in the Checked List.
	* 
 	* Do not call before:
	* 	setCheckedList($session_var_list, $HTTP_VARS)
	* 	
	* 	And all rows must be written out, to get an accurate value.
	*/
	function getCheckedListPageCount()
	{
		return $this->_checked_list_checked_count;
	}
	
	/**
	* Returns number of rows on the current page which are
	* in the Session var.
	*/
	function getSessionCheckedCount()
	{
		return $this->_session_checked_count;
	}
	
	/*
	* Do not call before:
	* 	setCheckedList($session_var_list, $HTTP_VARS)
	*/
	function getCheckedListCount()
	{
		if(is_array($this->_checked_list))
			return count($this->_checked_list);
		else
			return 0;
	}
	
	function getCheckBoxColumn()
	{
		return $this->_check_box_name;
	}
	
	/*
	* Number of rows with checkboxes included, whether checked or not.
	*/
	function getCheckBoxCount()
	{
		return $this->_check_box_count;
	}
	
	function _write($s)
	{
		echo($s);
	}
}
?>