#!/bin/sh
# Build a source tarball for openchange

openchange_repos=https://svn.openchange.org/openchange
version=$( dpkg-parsechangelog -l`dirname $0`/changelog | sed -n 's/^Version: \(.*:\|\)//p' | sed 's/-[0-9.]\+ubuntu[0-9]\+$//' )

if test -z "$BRANCH"; then
	BRANCH="trunk"
else
	BRANCH="branches/$BRANCH"
fi

if echo $version | grep svn > /dev/null; then
	# SVN Snapshot
	revno=`echo $version | sed 's/^[0-9.]\+[+~]svn//'`
	svn export -r$revno $openchange_repos/$BRANCH openchange-$version

	cd openchange-$version && ./autogen.sh && cd ..
	tar cvz openchange-$version > openchange_$version.orig.tar.gz
	rm -rf openchange-$version
else
	uscan --upstream-version $version
fi
