// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _StepData_ReadWriteModule_HeaderFile
#define _StepData_ReadWriteModule_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_StepData_ReadWriteModule_HeaderFile
#include <Handle_StepData_ReadWriteModule.hxx>
#endif

#ifndef _Interface_ReaderModule_HeaderFile
#include <Interface_ReaderModule.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Interface_FileReaderData_HeaderFile
#include <Handle_Interface_FileReaderData.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Interface_Check_HeaderFile
#include <Handle_Interface_Check.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_StepData_StepReaderData_HeaderFile
#include <Handle_StepData_StepReaderData.hxx>
#endif
class Standard_DomainError;
class Interface_FileReaderData;
class TCollection_AsciiString;
class TColStd_SequenceOfAsciiString;
class Interface_Check;
class Standard_Transient;
class StepData_StepReaderData;
class StepData_StepWriter;


//! Defines basic File Access Module (Recognize, Read, Write) <br>
//!           That is : ReaderModule (Recognize & Read) + Write for <br>
//!           StepWriter (for a more centralized description) <br>
//!  Warning : A sub-class of ReadWriteModule, which belongs to a particular <br>
//!           Protocol, must use the same definition for Case Numbers (give <br>
//!           the same Value for a StepType defined as a String from a File <br>
//!           as the Protocol does for the corresponding Entity) <br>
class StepData_ReadWriteModule : public Interface_ReaderModule {

public:

  //! Translate the Type of record <num> in <data> to a positive <br>
//!           Case Number, or 0 if failed. <br>
//!           Works with a StepReaderData, in which the Type of an Entity <br>
//!           is defined as a String : Reads the RecordType <num> then calls <br>
//!           CaseNum (this type) <br>
//!  Warning : The methods CaseStep, StepType and Recognize, <br>
//!           must be in phase (triplets CaseNum-StepType-Type of Object) <br>
  Standard_EXPORT     Standard_Integer CaseNum(const Handle(Interface_FileReaderData)& data,const Standard_Integer num) const;
  //! Defines Case Numbers corresponding to the recognized Types <br>
//!           Called by CaseNum (data,num) above for a Simple Type Entity <br>
//!  Warning : CaseStep must give the same Value as Protocol does for the <br>
//!           Entity type which corresponds to this Type given as a String <br>
  Standard_EXPORT   virtual  Standard_Integer CaseStep(const TCollection_AsciiString& atype) const = 0;
  //! Same a above but for a Complex Type Entity ("Plex") <br>
//!           The provided Default recognizes nothing <br>
  Standard_EXPORT   virtual  Standard_Integer CaseStep(const TColStd_SequenceOfAsciiString& types) const;
  //! Returns True if the Case Number corresponds to a Complex Type <br>
//!           ("Plex"). Remember that all possible combinations must be <br>
//!           aknowledged to be processed <br>
//!           Default is False for all cases. For a Protocol which defines <br>
//!           possible Plexes, this method must be redefined. <br>
  Standard_EXPORT   virtual  Standard_Boolean IsComplex(const Standard_Integer CN) const;
  //! Function specific to STEP, which delivers the StepType as it <br>
//!           is recorded in and read from a File compliant with STEP. <br>
//!           This method is symmetric to the method CaseStep. <br>
//!           StepType can be different from Dynamic Type's name, but <br>
//!           belongs to the same class of Object. <br>
//!           Returns an empty String if <CN> is zero. <br>
//!  Warning : For a Complex Type Entity, returns an Empty String <br>
//!           (Complex Type must be managed by users) <br>
  Standard_EXPORT   virtual const TCollection_AsciiString& StepType(const Standard_Integer CN) const = 0;
  //! Function specific to STEP. Some STEP Types have a short form <br>
//!           This method can be redefined to fill it <br>
//!           By default, returns an empty string, which is then interpreted <br>
//!           to take normal form from StepType <br>
  Standard_EXPORT   virtual  TCollection_AsciiString ShortType(const Standard_Integer CN) const;
  //! Function specific to STEP, which delivers the list of types <br>
//!           which corresponds to a complex type. If <CN> is not for a <br>
//!           complex type, this method returns False. Else it returns True <br>
//!           and fills the list in alphabetic order. <br>
//!           The default returns False. To be redefined as required. <br>
  Standard_EXPORT   virtual  Standard_Boolean ComplexType(const Standard_Integer CN,TColStd_SequenceOfAsciiString& types) const;
  //! General Read Function, calls ReadStep <br>
  Standard_EXPORT     void Read(const Standard_Integer CN,const Handle(Interface_FileReaderData)& data,const Standard_Integer num,Handle(Interface_Check)& ach,const Handle(Standard_Transient)& ent) const;
  //! Specific Read Function. Works with StepReaderData <br>
  Standard_EXPORT   virtual  void ReadStep(const Standard_Integer CN,const Handle(StepData_StepReaderData)& data,const Standard_Integer num,Handle(Interface_Check)& ach,const Handle(Standard_Transient)& ent) const = 0;
  //! Write Function, switched by CaseNum <br>
  Standard_EXPORT   virtual  void WriteStep(const Standard_Integer CN,StepData_StepWriter& SW,const Handle(Standard_Transient)& ent) const = 0;




  DEFINE_STANDARD_RTTI(StepData_ReadWriteModule)

protected:




private: 




};





// other Inline functions and methods (like "C++: function call" methods)


#endif
