// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Interface_Category_HeaderFile
#define _Interface_Category_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Handle_Interface_GTool_HeaderFile
#include <Handle_Interface_GTool.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _Handle_Interface_Protocol_HeaderFile
#include <Handle_Interface_Protocol.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
class Interface_GTool;
class TColStd_HArray1OfInteger;
class Interface_Protocol;
class Standard_Transient;
class Interface_ShareTool;
class Interface_InterfaceModel;


//! This class manages categories <br>
//!           A category is defined by a name and a number, and can be <br>
//!           seen as a way of rough classification, i.e. less precise than <br>
//!           a cdl type. <br>
//!           Hence, it is possible to dispatch every entity in about <br>
//!           a dozen of categories, twenty is a reasonable maximum. <br>
//! <br>
//!           Basically, the system provides the following categories : <br>
//!           Shape (Geometry, BRep, CSG, Features, etc...) <br>
//!           Drawing (Drawing, Views, Annotations, Pictures, Scketches ...) <br>
//!           Structure (Component & Part, Groups & Patterns ...) <br>
//!           Description (Meta-Data : Relations, Properties, Product ...) <br>
//!           Auxiliary   (those which do not enter in the above list) <br>
//!             and some dedicated categories <br>
//!           FEA , Kinematics , Piping , etc... <br>
//!           plus Professional  for other dedicated non-classed categories <br>
//! <br>
//!           In addition, this class provides a way to compute then quickly <br>
//!           query category numbers for an entire model. <br>
//!           Values are just recorded as a list of numbers, control must <br>
//!           then be done in a wider context (which must provide a Graph) <br>
class Interface_Category  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Creates a Category, with no protocol yet <br>
  Standard_EXPORT   Interface_Category();
  //! Creates a Category with a given protocol <br>
  Standard_EXPORT   Interface_Category(const Handle(Interface_Protocol)& proto);
  //! Creates a Category with a given GTool <br>
  Standard_EXPORT   Interface_Category(const Handle(Interface_GTool)& gtool);
  //! Sets/Changes Protocol <br>
  Standard_EXPORT     void SetProtocol(const Handle(Interface_Protocol)& proto) ;
  //! Determines the Category Number for an entity in its context, <br>
//!           by using general service CategoryNumber <br>
  Standard_EXPORT     Standard_Integer CatNum(const Handle(Standard_Transient)& ent,const Interface_ShareTool& shares) ;
  //! Clears the recorded list of category numbers for a Model <br>
  Standard_EXPORT     void ClearNums() ;
  //! Computes the Category Number for each entity and records it, <br>
//!           in an array (ent.number -> category number) <br>
//!           Hence, it can be queried by the method Num. <br>
//!           The Model itself is not recorded, this method is intended to <br>
//!           be used in a wider context (which detains also a Graph, etc) <br>
  Standard_EXPORT     void Compute(const Handle(Interface_InterfaceModel)& model,const Interface_ShareTool& shares) ;
  //! Returns the category number recorded for an entity number <br>
//!           Returns 0 if out of range <br>
  Standard_EXPORT     Standard_Integer Num(const Standard_Integer nument) const;
  //! Records a new Category defined by its names, produces a number <br>
//!           New if not yet recorded <br>
  Standard_EXPORT   static  Standard_Integer AddCategory(const Standard_CString name) ;
  //! Returns the count of recorded categories <br>
  Standard_EXPORT   static  Standard_Integer NbCategories() ;
  //! Returns the name of a category, according to its number <br>
  Standard_EXPORT   static  Standard_CString Name(const Standard_Integer num) ;
  //! Returns the number of a category, according to its name <br>
  Standard_EXPORT   static  Standard_Integer Number(const Standard_CString name) ;
  //! Default initialisation <br>
//!           (protected against several calls : passes only once) <br>
  Standard_EXPORT   static  void Init() ;





protected:





private:



Handle_Interface_GTool thegtool;
Handle_TColStd_HArray1OfInteger thenum;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
