// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _HLRAlgo_EdgeStatus_HeaderFile
#define _HLRAlgo_EdgeStatus_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_ShortReal_HeaderFile
#include <Standard_ShortReal.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Intrv_Intervals_HeaderFile
#include <Intrv_Intervals.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Standard_OutOfRange;


//! This class describes the Hidden  Line status of an <br>
//!          Edge. It contains : <br>
//! <br>
//!            The Bounds of the Edge and their tolerances <br>
//! <br>
//!            Two flags indicating if the edge is full visible <br>
//!            or full hidden. <br>
class HLRAlgo_EdgeStatus  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
  Standard_EXPORT   HLRAlgo_EdgeStatus();
  //! Creates a  new  EdgeStatus.  Default visible.  The <br>
//!          Edge is   bounded by the  interval  <Start>, <End> <br>
//!          with the tolerances <TolStart>, <TolEnd>. <br>
  Standard_EXPORT   HLRAlgo_EdgeStatus(const Standard_Real Start,const Standard_ShortReal TolStart,const Standard_Real End,const Standard_ShortReal TolEnd);
  //! Initialize  an  EdgeStatus.  Default visible.  The <br>
//!          Edge is   bounded by the  interval  <Start>, <End> <br>
//!          with the tolerances <TolStart>, <TolEnd>. <br>
  Standard_EXPORT     void Initialize(const Standard_Real Start,const Standard_ShortReal TolStart,const Standard_Real End,const Standard_ShortReal TolEnd) ;
  
        void Bounds(Standard_Real& Start,Standard_ShortReal& TolStart,Standard_Real& End,Standard_ShortReal& TolEnd) const;
  
  Standard_EXPORT     Standard_Integer NbVisiblePart() const;
  
  Standard_EXPORT     void VisiblePart(const Standard_Integer Index,Standard_Real& Start,Standard_ShortReal& TolStart,Standard_Real& End,Standard_ShortReal& TolEnd) const;
  //! Hides  the  interval  <Start>,    <End>   with the <br>
//!          tolerances <TolStart>,  <TolEnd>. This interval is <br>
//!          subtracted from the visible  parts.  If the hidden <br>
//!          part is on ( or under ) the face the flag <OnFace> <br>
//!          is True ( or False ).  If the hidden  part is on ( <br>
//!          or  inside  ) the boundary  of  the  face the flag <br>
//!          <OnBoundary> is True ( or False ). <br>
  Standard_EXPORT     void Hide(const Standard_Real Start,const Standard_ShortReal TolStart,const Standard_Real End,const Standard_ShortReal TolEnd,const Standard_Boolean OnFace,const Standard_Boolean OnBoundary) ;
  //! Hide the whole Edge. <br>
        void HideAll() ;
  //! Show the whole Edge. <br>
        void ShowAll() ;
  
        Standard_Boolean AllHidden() const;
  
        void AllHidden(const Standard_Boolean B) ;
  
        Standard_Boolean AllVisible() const;
  
        void AllVisible(const Standard_Boolean B) ;





protected:





private:



Standard_Real myStart;
Standard_Real myEnd;
Standard_ShortReal myTolStart;
Standard_ShortReal myTolEnd;
Standard_Boolean myFlags;
Intrv_Intervals myVisibles;


};


#include <HLRAlgo_EdgeStatus.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
