// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Geom2d_Ellipse_HeaderFile
#define _Geom2d_Ellipse_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Geom2d_Ellipse_HeaderFile
#include <Handle_Geom2d_Ellipse.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Geom2d_Conic_HeaderFile
#include <Geom2d_Conic.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Geom2d_Geometry_HeaderFile
#include <Handle_Geom2d_Geometry.hxx>
#endif
class Standard_ConstructionError;
class Standard_RangeError;
class gp_Elips2d;
class gp_Ax2d;
class gp_Ax22d;
class gp_Pnt2d;
class gp_Vec2d;
class gp_Trsf2d;
class Geom2d_Geometry;


//!  Describes an ellipse in the plane (2D space). <br>
//! An ellipse is defined by its major and minor radii and, <br>
//! as with any conic curve, is positioned in the plane <br>
//! with a coordinate system (gp_Ax22d object) where: <br>
//! - the origin is the center of the ellipse, <br>
//! - the "X Direction" defines the major axis, and <br>
//! - the "Y Direction" defines the minor axis. <br>
//!   This coordinate system is the local coordinate system of the ellipse. <br>
//! The orientation (direct or indirect) of the local <br>
//! coordinate system gives an explicit orientation to the <br>
//! ellipse, determining the direction in which the <br>
//! parameter increases along the ellipse. <br>
//! The Geom2d_Ellipse ellipse is parameterized by an angle: <br>
//! P(U) = O + MajorRad*Cos(U)*XDir + MinorRad*Sin(U)*YDir <br>
//! where: <br>
//! - P is the point of parameter U, <br>
//! - O, XDir and YDir are respectively the origin, "X <br>
//!   Direction" and "Y Direction" of its local coordinate system, <br>
//! - MajorRad and MinorRad are the major and <br>
//!   minor radii of the ellipse. <br>
//! The "X Axis" of the local coordinate system therefore <br>
//! defines the origin of the parameter of the ellipse. <br>
//! An ellipse is a closed and periodic curve. The period <br>
//! is 2.*Pi and the parameter range is [ 0,2.*Pi [. <br>
//! See Also <br>
//! GCE2d_MakeEllipse which provides functions for <br>
//! more complex ellipse constructions <br>
//! gp_Ax22d <br>
//! gp_Elips2d for an equivalent, non-parameterized data structure <br>
class Geom2d_Ellipse : public Geom2d_Conic {

public:

  
//!  Creates an ellipse by conversion of the gp_Elips2d ellipse E. <br>
  Standard_EXPORT   Geom2d_Ellipse(const gp_Elips2d& E);
  //!  Creates an ellipse defined by its major and minor radii, <br>
//!   MajorRadius and MinorRadius, and positioned <br>
//!   in the plane by its major axis MajorAxis; the <br>
//!   center of the ellipse is the origin of MajorAxis <br>
//!   and the unit vector of MajorAxis is the "X <br>
//!   Direction" of the local coordinate system of the <br>
//!   ellipse; this coordinate system is direct if Sense <br>
//!   is true (default value) or indirect if Sense is false. <br>
//!  Warnings : <br>
//!  It is not forbidden to create an ellipse with MajorRadius = <br>
//!  MinorRadius. <br>
//! Exceptions <br>
//! Standard_ConstructionError if: <br>
//! - MajorRadius is less than MinorRadius, or <br>
//! - MinorRadius is less than 0. <br>
  Standard_EXPORT   Geom2d_Ellipse(const gp_Ax2d& MajorAxis,const Standard_Real MajorRadius,const Standard_Real MinorRadius,const Standard_Boolean Sense = Standard_True);
  //! Creates an ellipse defined by its major and minor radii, <br>
//!   MajorRadius and MinorRadius, where the <br>
//!   coordinate system Axis locates the ellipse and <br>
//!   defines its orientation in the plane such that: <br>
//!   - the center of the ellipse is the origin of Axis, <br>
//!   - the "X Direction" of Axis defines the major <br>
//!    axis of the ellipse, <br>
//!   - the "Y Direction" of Axis defines the minor <br>
//!    axis of the ellipse, <br>
//!   - the orientation of Axis (direct or indirect) <br>
//!    gives the orientation of the ellipse. <br>
//!  Warnings : <br>
//!  It is not forbidden to create an ellipse with MajorRadius = <br>
//!  MinorRadius. <br>
//! Exceptions <br>
//! Standard_ConstructionError if: <br>
//! - MajorRadius is less than MinorRadius, or <br>
//! - MinorRadius is less than 0. <br>
  Standard_EXPORT   Geom2d_Ellipse(const gp_Ax22d& Axis,const Standard_Real MajorRadius,const Standard_Real MinorRadius);
  //! Converts the gp_Elips2d ellipse E into this ellipse. <br>
  Standard_EXPORT     void SetElips2d(const gp_Elips2d& E) ;
  //! Assigns a value to the major radius of this ellipse. <br>
//! Exceptions <br>
//! Standard_ConstructionError if: <br>
//! - the major radius of this ellipse becomes less than <br>
//!   the minor radius, or <br>
//! - MinorRadius is less than 0. <br>
  Standard_EXPORT     void SetMajorRadius(const Standard_Real MajorRadius) ;
  //! Assigns a value to the minor radius of this ellipse. <br>
//! Exceptions <br>
//! Standard_ConstructionError if: <br>
//! - the major radius of this ellipse becomes less than <br>
//!   the minor radius, or <br>
//! - MinorRadius is less than 0. <br>
  Standard_EXPORT     void SetMinorRadius(const Standard_Real MinorRadius) ;
  //! Converts this ellipse into a gp_Elips2d ellipse. <br>
  Standard_EXPORT     gp_Elips2d Elips2d() const;
  //! Computes the parameter on the reversed ellipse for <br>
//! the point of parameter U on this ellipse. <br>
//! For an ellipse, the returned value is: 2.*Pi - U. <br>
  Standard_EXPORT     Standard_Real ReversedParameter(const Standard_Real U) const;
  //! Computes the directrices of this ellipse. <br>
//!  This directrix is the line normal to the XAxis of the ellipse <br>
//!  in the local plane (Z = 0) at a distance d = MajorRadius / e <br>
//!  from the center of the ellipse, where e is the eccentricity of <br>
//!  the ellipse. <br>
//!  This line is parallel to the "YAxis". The intersection point <br>
//!  between directrix1 and the "XAxis" is the "Location" point <br>
//!  of the directrix1. This point is on the positive side of <br>
//!  the "XAxis". <br>
//! Raises ConstructionError if Eccentricity = 0.0. (The ellipse degenerates <br>
//!  into a circle) <br>
  Standard_EXPORT     gp_Ax2d Directrix1() const;
  
//!  This line is obtained by the symmetrical transformation <br>
//!  of "Directrix1" with respect to the "YAxis" of the ellipse. <br>
//! Raises ConstructionError if Eccentricity = 0.0. (The ellipse degenerates into a <br>
//!  circle). <br>
  Standard_EXPORT     gp_Ax2d Directrix2() const;
  
//!  Returns the eccentricity of the ellipse  between 0.0 and 1.0 <br>
//!  If f is the distance between the center of the ellipse and <br>
//!  the Focus1 then the eccentricity e = f / MajorRadius. <br>
//!  Returns 0 if MajorRadius = 0 <br>
  Standard_EXPORT     Standard_Real Eccentricity() const;
  
//!  Computes the focal distance. The focal distance is the distance between the center <br>
//! and a focus of the ellipse. <br>
  Standard_EXPORT     Standard_Real Focal() const;
  
//!  Returns the first focus of the ellipse. This focus is on the <br>
//!  positive side of the "XAxis" of the ellipse. <br>
  Standard_EXPORT     gp_Pnt2d Focus1() const;
  
//!  Returns the second focus of the ellipse. This focus is on <br>
//!  the negative side of the "XAxis" of the ellipse. <br>
  Standard_EXPORT     gp_Pnt2d Focus2() const;
  //! Returns the major radius of this ellipse. <br>
  Standard_EXPORT     Standard_Real MajorRadius() const;
  //! Returns the minor radius of this ellipse. <br>
  Standard_EXPORT     Standard_Real MinorRadius() const;
  
//!   Computes the parameter of this ellipse. This value is <br>
//! given by the formula p = (1 - e * e) * MajorRadius where e is the eccentricity <br>
//!  of the ellipse. <br>
//!  Returns 0 if MajorRadius = 0 <br>
  Standard_EXPORT     Standard_Real Parameter() const;
  //! Returns the value of the first parameter of this <br>
//! ellipse. This is  0.0, which gives the start point of this ellipse. <br>
//! The start point and end point of an ellipse are coincident. <br>
  Standard_EXPORT     Standard_Real FirstParameter() const;
  //! Returns the value of the  last parameter of this <br>
//! ellipse. This is  2.*Pi, which gives the end point of this ellipse. <br>
//!  The start point and end point of an ellipse are coincident. <br>
  Standard_EXPORT     Standard_Real LastParameter() const;
  //! return True. <br>
  Standard_EXPORT     Standard_Boolean IsClosed() const;
  //! return True. <br>
  Standard_EXPORT     Standard_Boolean IsPeriodic() const;
  //! Returns in P the point of parameter U. <br>
//!  P = C + MajorRadius * Cos (U) * XDir + MinorRadius * Sin (U) * YDir <br>
//!  where C is the center of the ellipse , XDir the direction of <br>
//!  the "XAxis" and "YDir" the "YAxis" of the ellipse. <br>
  Standard_EXPORT     void D0(const Standard_Real U,gp_Pnt2d& P) const;
  
  Standard_EXPORT     void D1(const Standard_Real U,gp_Pnt2d& P,gp_Vec2d& V1) const;
  
//!  Returns the point P of parameter U. The vectors V1 and V2 <br>
//!  are the first and second derivatives at this point. <br>
  Standard_EXPORT     void D2(const Standard_Real U,gp_Pnt2d& P,gp_Vec2d& V1,gp_Vec2d& V2) const;
  
//!  Returns the point P of parameter U, the first second and <br>
//!  third derivatives V1 V2 and V3. <br>
  Standard_EXPORT     void D3(const Standard_Real U,gp_Pnt2d& P,gp_Vec2d& V1,gp_Vec2d& V2,gp_Vec2d& V3) const;
  //! For the point of parameter U of this ellipse, <br>
//! computes the vector corresponding to the Nth derivative. <br>
//! Exceptions Standard_RangeError if N is less than 1. <br>
  Standard_EXPORT     gp_Vec2d DN(const Standard_Real U,const Standard_Integer N) const;
  //! Applies the transformation T to this ellipse. <br>
  Standard_EXPORT     void Transform(const gp_Trsf2d& T) ;
  //! Creates a new object which is a copy of this ellipse. <br>
  Standard_EXPORT     Handle_Geom2d_Geometry Copy() const;




  DEFINE_STANDARD_RTTI(Geom2d_Ellipse)

protected:




private: 


Standard_Real majorRadius;
Standard_Real minorRadius;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
