// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Geom2d_AxisPlacement_HeaderFile
#define _Geom2d_AxisPlacement_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Geom2d_AxisPlacement_HeaderFile
#include <Handle_Geom2d_AxisPlacement.hxx>
#endif

#ifndef _gp_Ax2d_HeaderFile
#include <gp_Ax2d.hxx>
#endif
#ifndef _Geom2d_Geometry_HeaderFile
#include <Geom2d_Geometry.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Geom2d_Geometry_HeaderFile
#include <Handle_Geom2d_Geometry.hxx>
#endif
class gp_Ax2d;
class gp_Pnt2d;
class gp_Dir2d;
class gp_Trsf2d;
class Geom2d_Geometry;


//! Describes an axis in 2D space. <br>
//! An axis is defined by: <br>
//! - its origin, also termed the "Location point" of the axis, <br>
//! - its unit vector, termed the "Direction" of the axis. <br>
//! Note: Geom2d_AxisPlacement axes provide the <br>
//! same kind of "geometric" services as gp_Ax2d axes <br>
//! but have more complex data structures. The <br>
//! geometric objects provided by the Geom2d package <br>
//! use gp_Ax2d objects to include axes in their data <br>
//! structures, or to define an axis of symmetry or axis of rotation. <br>
//! Geom2d_AxisPlacement axes are used in a context <br>
//! where they can be shared by several objects <br>
//! contained inside a common data structure. <br>
class Geom2d_AxisPlacement : public Geom2d_Geometry {

public:

  //! Constructs an axis by conversion of the gp_Ax2d axis A. <br>
  Standard_EXPORT   Geom2d_AxisPlacement(const gp_Ax2d& A);
  //! Constructs an axis from a given origin P and unit vector V. <br>
  Standard_EXPORT   Geom2d_AxisPlacement(const gp_Pnt2d& P,const gp_Dir2d& V);
  
  Standard_EXPORT     void Reverse() ;
  //! Reverses the unit vector of this axis. <br>
//! Note: <br>
//! - Reverse assigns the result to this axis, while <br>
//! - Reversed creates a new one. <br>
  Standard_EXPORT     Handle_Geom2d_AxisPlacement Reversed() const;
  //! Changes the complete definition of the axis placement. <br>
  Standard_EXPORT     void SetAxis(const gp_Ax2d& A) ;
  
//!  Changes the "Direction" of the axis placement. <br>
  Standard_EXPORT     void SetDirection(const gp_Dir2d& V) ;
  
//!  Changes the "Location" point (origin) of the axis placement. <br>
  Standard_EXPORT     void SetLocation(const gp_Pnt2d& P) ;
  
//!  Computes the angle between the "Direction" of <br>
//!  two axis placement in radians. <br>
//! The result is comprised between -Pi and Pi. <br>
  Standard_EXPORT     Standard_Real Angle(const Handle(Geom2d_AxisPlacement)& Other) const;
  //! Converts this axis into a gp_Ax2d axis. <br>
  Standard_EXPORT     gp_Ax2d Ax2d() const;
  //! Returns the "Direction" of <me>. <br>
//! -C++: return const& <br>
  Standard_EXPORT     gp_Dir2d Direction() const;
  
//!  Returns the "Location" point (origin) of the axis placement. <br>
//! -C++: return const& <br>
  Standard_EXPORT     gp_Pnt2d Location() const;
  //! Applies the transformation T to this axis. <br>
  Standard_EXPORT     void Transform(const gp_Trsf2d& T) ;
  //! Creates a new object which is a copy of this axis. <br>
  Standard_EXPORT     Handle_Geom2d_Geometry Copy() const;




  DEFINE_STANDARD_RTTI(Geom2d_AxisPlacement)

protected:




private: 


gp_Ax2d axis;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
