// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BOP_SFSCorrector_HeaderFile
#define _BOP_SFSCorrector_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _BOP_PShellFaceSet_HeaderFile
#include <BOP_PShellFaceSet.hxx>
#endif
#ifndef _BOP_ShellFaceSet_HeaderFile
#include <BOP_ShellFaceSet.hxx>
#endif
#ifndef _BOP_ListOfConnexityBlock_HeaderFile
#include <BOP_ListOfConnexityBlock.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class BOP_ShellFaceSet;



//!  the algorithm is to change the Shell Faces Set (SFS)contents. <br>
//!  The NewSFS will contain only shells <br>
//!  instead of shells and faces. <br>
//! <br>
class BOP_SFSCorrector  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
//! Empty constructor; <br>
  Standard_EXPORT   BOP_SFSCorrector();
  
//! Modifier <br>
  Standard_EXPORT     void SetSFS(const BOP_ShellFaceSet& aSFS) ;
  
//! Performs the algorithm of  two  steps <br>
//! 1. Make conexity blocks (  DoConnexityBlocks()  ) <br>
//! 2. Make corrections     (  DoCorrections()  ) <br>
  Standard_EXPORT     void Do() ;
  
//! Selector <br>
  Standard_EXPORT     Standard_Boolean IsDone() const;
  
//! Selector <br>
//! - 1 - Nothing is done because only constructor has been called <br>
  Standard_EXPORT     Standard_Integer ErrorStatus() const;
  
//! Selector <br>
  Standard_EXPORT     BOP_ShellFaceSet& SFS() ;
  
//! Selector <br>
//! Returns the resulting SFS <br>
  Standard_EXPORT     BOP_ShellFaceSet& NewSFS() ;





protected:





private:

  
//! Internal Purpose <br>
  Standard_EXPORT     void DoConnexityBlocks() ;
  
//! Internal Purpose <br>
  Standard_EXPORT     void DoCorrections() ;


BOP_PShellFaceSet mySFS;
BOP_ShellFaceSet myNewSFS;
BOP_ListOfConnexityBlock myConnexityBlocks;
Standard_Boolean myIsDone;
Standard_Integer myErrorStatus;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
