// 2DGeomApp.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"

#include "2DGeomApp.h"

#include "OCC_MainFrame.h"
#include "OCC_2dChildFrame.h"
#include "2DGeomDoc.h"
#include "OCC_2dView.h"

/////////////////////////////////////////////////////////////////////////////
// C2DGeomApp construction

C2DGeomApp::C2DGeomApp()
{
	SampleName = "2DGeom";		//for about dialog
}

/////////////////////////////////////////////////////////////////////////////
// The one and only C2DGeomApp object

C2DGeomApp theApp;

/////////////////////////////////////////////////////////////////////////////
// C2DGeomApp initialization

BOOL C2DGeomApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CMultiDocTemplate* pDocTemplate;
	pDocTemplate = new CMultiDocTemplate(
		IDR_2DTYPE,
		RUNTIME_CLASS(C2DGeomDoc),
		RUNTIME_CLASS(OCC_2dChildFrame), 
		RUNTIME_CLASS(OCC_2dView));
	AddDocTemplate(pDocTemplate);

	// create main MDI Frame window
	OCC_MainFrame* pMainFrame = new OCC_MainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The main window has been initialized, so show and update it.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	return TRUE;
}
