// TopologyTriangulationDoc.cpp : implementation of the CTopologyTriangulationDoc class
//

#include "stdafx.h"

#include "TopologyTriangulationDoc.h"

#include "TopologyTriangulationApp.h"

#include "..\res\resource.h"

#include <AIS_ListOfInteractive.hxx>
#include <AIS_ListIteratorOfListOfInteractive.hxx>

/////////////////////////////////////////////////////////////////////////////
// CTopologyTriangulationDoc

IMPLEMENT_DYNCREATE(CTopologyTriangulationDoc, CDocument)

BEGIN_MESSAGE_MAP(CTopologyTriangulationDoc, OCC_3dBaseDoc)
	//{{AFX_MSG_MAP(CTopologyTriangulationDoc)
	ON_COMMAND(ID_TRIANGU, OnTriangu)
	ON_COMMAND(ID_Clear, OnClear)
	ON_COMMAND(ID_Visu, OnVisu)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTopologyTriangulationDoc construction/destruction

CTopologyTriangulationDoc::CTopologyTriangulationDoc()
{
}

CTopologyTriangulationDoc::~CTopologyTriangulationDoc()
{
}

/////////////////////////////////////////////////////////////////////////////
// CTopologyTriangulationDoc diagnostics

#ifdef _DEBUG
void CTopologyTriangulationDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CTopologyTriangulationDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

void CTopologyTriangulationDoc::OnTriangu() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	TopoDS_Shape theBox = BRepPrimAPI_MakeBox(200,60,60);
	TopoDS_Shape theSphere = BRepPrimAPI_MakeSphere(gp_Pnt(100,20,20),80);
	TopoDS_Shape ShapeFused = BRepAlgoAPI_Fuse(theSphere,theBox);
	BRepMesh::Mesh(ShapeFused,1);

	Handle (AIS_Shape)	aSection = new AIS_Shape(ShapeFused);
	myAISContext->SetDisplayMode(aSection,1);
	myAISContext->SetColor(aSection,Quantity_NOC_RED);
	myAISContext->SetMaterial(aSection,Graphic3d_NOM_GOLD);
	myAISContext->Display(aSection);

	Standard_Integer result(0);

	for (TopExp_Explorer ex(ShapeFused,TopAbs_FACE) ; ex.More(); ex.Next()) {
		TopoDS_Face F =TopoDS::Face(ex.Current());
		TopLoc_Location L;
		Handle (Poly_Triangulation) facing = BRep_Tool::Triangulation(F,L);
		result = result + facing->NbTriangles();
	}
	Fit();

 TCollection_AsciiString Message ("\
		\n\
TopoDS_Shape theBox = BRepPrimAPI_MakeBox(200,60,60);	\n\
TopoDS_Shape theSphere = BRepPrimAPI_MakeSphere(gp_Pnt(100,20,20),80);	\n\
	\n\
TopoDS_Shape ShapeFused = BRepBuilderAPI_Fuse(theSphere,theBox);	\n\
	\n\
BRepMesh::Mesh(ShapeFused,1);	\n\
	\n\
Standard_Integer result(0);	\n\
	\n\
for (TopExp_Explorer ex(ShapeFused,TopAbs_FACE) ; ex.More(); ex.Next()) {	\n\
	TopoDS_Face F =TopoDS::Face(ex.Current());	\n\
	TopLoc_Location L;	\n\
	Handle (Poly_Triangulation) facing = BRep_Tool::Triangulation(F,L);	\n\
	result = result + facing->NbTriangles();	\n\
} 	\n\
\n\
--- Number of created triangles ---\n");
	TCollection_AsciiString nombre(result);
	Message += nombre;
	Message +=("\
				  \n\
				\n");
	PocessTextInDialog("Compute the triangulation on a shape", Message);
}

void CTopologyTriangulationDoc::OnVisu() 
{

	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

TopoDS_Shape theBox = BRepPrimAPI_MakeBox(200,60,60);
TopoDS_Shape theSphere = BRepPrimAPI_MakeSphere(gp_Pnt(100,20,20),80);
TopoDS_Shape ShapeFused = BRepAlgoAPI_Fuse(theSphere,theBox);
BRepMesh::Mesh(ShapeFused,1);

Handle (AIS_Shape)	aSection = new AIS_Shape(ShapeFused);
myAISContext->SetDisplayMode(aSection,1);
myAISContext->SetColor(aSection,Quantity_NOC_RED);
myAISContext->SetMaterial(aSection,Graphic3d_NOM_GOLD);
myAISContext->SetTransparency(aSection,0.1);
myAISContext->Display(aSection);

BRep_Builder builder;
TopoDS_Compound Comp;
builder.MakeCompound(Comp);

for (TopExp_Explorer ex(ShapeFused,TopAbs_FACE) ; ex.More(); ex.Next()) {
  		
	TopoDS_Face F =TopoDS::Face(ex.Current());
    TopLoc_Location L;
	Handle (Poly_Triangulation) facing = BRep_Tool::Triangulation(F,L);
    TColgp_Array1OfPnt tab(1,(facing->NbNodes()));
	tab = facing->Nodes();
	Poly_Array1OfTriangle tri(1,facing->NbTriangles());
	tri = facing->Triangles();

	for (Standard_Integer i=1;i<=(facing->NbTriangles());i++) {
		Poly_Triangle trian = tri.Value(i);
		Standard_Integer index1,index2,index3,M,N;
		trian.Get(index1,index2,index3);
	
		for (Standard_Integer j=1;j<=3;j++) {
			switch (j) {
			case 1 :
				M = index1;
				N = index2;
			break;
			case 2 :
				N = index3;
			break;
			case 3 :
				M = index2;
			}
			
			BRepBuilderAPI_MakeEdge ME(tab.Value(M),tab.Value(N));
			if (ME.IsDone()) {
				builder.Add(Comp,ME.Edge());
			}
		}
	}
}
Handle (AIS_Shape)	atriangulation = new AIS_Shape(Comp);
myAISContext->SetDisplayMode(atriangulation,0);
myAISContext->SetColor(atriangulation,Quantity_NOC_WHITE);
myAISContext->Display(atriangulation);

Fit();

  TCollection_AsciiString Message ("\
		\n\
TopoDS_Shape theBox = BRepPrimAPI_MakeBox(200,60,60);	\n\
TopoDS_Shape theSphere = BRepPrimAPI_MakeSphere(gp_Pnt(100,20,20),80);	\n\
TopoDS_Shape ShapeFused = BRepAlgoAPI_Fuse(theSphere,theBox);	\n\
BRepMesh::Mesh(ShapeFused,1);	\n\
	\n\
BRep_Builder builder;	\n\
TopoDS_Compound Comp;	\n\
builder.MakeCompound(Comp);	\n\
	\n\
for (TopExp_Explorer ex(ShapeFused,TopAbs_FACE) ; ex.More(); ex.Next()) {	\n\
  			\n\
	TopoDS_Face F =TopoDS::Face(ex.Current());	\n\
	TopLoc_Location L;	\n\
	Handle (Poly_Triangulation) facing = BRep_Tool::Triangulation(F,L);	\n\
	TColgp_Array1OfPnt tab(1,(facing->NbNodes()));	\n\
	tab = facing->Nodes();	\n\
	Poly_Array1OfTriangle tri(1,facing->NbTriangles());	\n\
	tri = facing->Triangles();	\n\
	\n\
	for (Standard_Integer i=1;i<=(facing->NbTriangles());i++) {	\n\
		Poly_Triangle trian = tri.Value(i);	\n\
		Standard_Integer index1,index2,index3,M,N;	\n\
		trian.Get(index1,index2,index3);	\n\
		\n\
		for (Standard_Integer j=1;j<=3;j++) {	\n\
			switch (j) {	\n\
			case 1 :	\n\
				M = index1;	\n\
				N = index2;	\n\
			break;	\n\
			case 2 :	\n\
				N = index3;	\n\
			break;	\n\
			case 3 :	\n\
				M = index2;	\n\
			}	\n\
				\n\
			BRepBuilderAPI_MakeEdge ME(tab.Value(M),tab.Value(N));	\n\
			if (ME.IsDone()) {	\n\
				builder.Add(Comp,ME.Edge());	\n\
			}	\n\
		}	\n\
	}	\n\
}	\n\
	\n\
Warning : The visualisation of the mesh is not optimised.\n\
The shared edges between triangles are dispayed twice.\n\
The purpose here is only to show how to decode the data structure of triangulation.\n\
	\n");
  PocessTextInDialog("Visualize the triangulation on a shape", Message);

}




void CTopologyTriangulationDoc::OnClear() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

TopoDS_Shape theBox = BRepPrimAPI_MakeBox(200,60,60);
TopoDS_Shape theSphere = BRepPrimAPI_MakeSphere(gp_Pnt(100,20,20),80);
TopoDS_Shape ShapeFused = BRepAlgoAPI_Fuse(theSphere,theBox);
BRepMesh::Mesh(ShapeFused,1);


Handle (AIS_Shape)	aSection = new AIS_Shape(ShapeFused);
myAISContext->SetDisplayMode(aSection,1);
myAISContext->SetColor(aSection,Quantity_NOC_RED);
myAISContext->SetMaterial(aSection,Graphic3d_NOM_GOLD);
myAISContext->Display(aSection);

BRepTools::Clean(ShapeFused);

TCollection_AsciiString test;
if (!BRepTools::Triangulation(ShapeFused,1)) {
	test = ("In fact the triangulation has been removed\n");
}

Fit();
 TCollection_AsciiString Message ("\
		\n\
TopoDS_Shape theBox = BRepPrimAPI_MakeBox(200,60,60);	\n\
TopoDS_Shape theSphere = BRepPrimAPI_MakeSphere(gp_Pnt(100,20,20),80);	\n\
TopoDS_Shape ShapeFused = BRepAlgoAPI_Fuse(theSphere,theBox);	\n\
BRepMesh::Mesh(ShapeFused,1);	\n\
	\n\
BRepTools::Clean(ShapeFused);	\n\
	\n\
if (!BRepTools::Triangulation(ShapeFused,1)) {	\n\
	TCollection_AsciiString test(<In fact the triangulation has been removed>);	\n\
}	\n\
	\n\
	--- Result ---\n");

	Message += test;
	Message +=("\
				  \n\
				\n");

	PocessTextInDialog("Remove the triangulation", Message);

}