// File:	TopOpeBRep_VPointInter.cxx
// Created:	Wed Nov 10 18:56:49 1993
// Author:	Jean Yves LEBEY
//		<jyl@phobox>

#include <TopOpeBRep_VPointInter.ixx>

#include <Standard_DomainError.hxx>
#include <TopOpeBRepTool_ShapeTool.hxx>
#include <TopOpeBRep_FFTransitionTool.hxx>
#include <TopOpeBRepDS_Transition.hxx>
#include <TopoDS_Edge.hxx>
#include <TopoDS_Face.hxx>
#include <TopoDS.hxx>
#include <BRepAdaptor_HCurve2d.hxx>
#include <BRepTopAdaptor_HVertex.hxx>
#include <Adaptor3d_HVertex.hxx>
#include <Adaptor2d_HCurve2d.hxx>
#include <BRepAdaptor_Curve2d.hxx>
#include <TCollection_AsciiString.hxx>
#include <gp_Pnt2d.hxx>
#include <Precision.hxx>
#include <TopOpeBRep_define.hxx>

#ifdef DEB
Standard_IMPORT Standard_Boolean TopOpeBRepDS_GettraceDSFK(); 
static TCollection_AsciiString PRODINP("dinp ");
#endif

//=======================================================================
//function : VPointInter
//purpose  : 
//=======================================================================
TopOpeBRep_VPointInter::TopOpeBRep_VPointInter() :
       myPPOI(NULL),
       myShapeIndex(0),
       myState1(TopAbs_UNKNOWN),
       myState2(TopAbs_UNKNOWN),
       myKeep(Standard_False),
       myIndex(0),
       myS1(0),myS2(0)
{
}


//=======================================================================
//function : SetPoint
//purpose  : 
//=======================================================================
void TopOpeBRep_VPointInter::SetPoint(const IntPatch_ThePointOfIntersection& P)
{
  myPPOI = (IntPatch_ThePointOfIntersection*)&P;

  Standard_Boolean isOn1 = P.IsOnDomS1(); 
  Standard_Boolean isOn2 = P.IsOnDomS2();
  if (isOn1 && isOn2) myShapeIndex = 3;
  else if (isOn2)     myShapeIndex = 2;
  else if (isOn1)     myShapeIndex = 1;
  else                myShapeIndex = 0;
}

//=======================================================================
//function : SetShapes
//purpose  : 
//=======================================================================
void TopOpeBRep_VPointInter::SetShapes(const Standard_Integer I1,const Standard_Integer I2)
{
  myS1 = I1;
  myS2 = I2;
}

//=======================================================================
//function : GetShapes
//purpose  : 
//=======================================================================
void TopOpeBRep_VPointInter::GetShapes(Standard_Integer& I1,Standard_Integer& I2) const 
{
  I1 = myS1;
  I2 = myS2;
}

//=======================================================================
//function : TransitionOnS1
//purpose  : 
//=======================================================================
IntSurf_Transition  TopOpeBRep_VPointInter::TransitionOnS1() const
{
  return myPPOI->TransitionOnS1();
}

//=======================================================================
//function : TransitionOnS2
//purpose  : 
//=======================================================================
IntSurf_Transition  TopOpeBRep_VPointInter::TransitionOnS2() const
{
  return myPPOI->TransitionOnS2();
}

//=======================================================================
//function : TransitionLineArc1
//purpose  : 
//=======================================================================
IntSurf_Transition  TopOpeBRep_VPointInter::TransitionLineArc1() const
{
  return myPPOI->TransitionLineArc1();
}

//=======================================================================
//function : TransitionLineArc2
//purpose  : 
//=======================================================================
IntSurf_Transition  TopOpeBRep_VPointInter::TransitionLineArc2() const
{
  return myPPOI->TransitionLineArc2();
}

//=======================================================================
//function : IsOnDomS1
//purpose  : 
//=======================================================================
Standard_Boolean  TopOpeBRep_VPointInter::IsOnDomS1() const
{
  Standard_Boolean b = myPPOI->IsOnDomS1();
  return b;
}

//=======================================================================
//function : IsOnDomS2
//purpose  : 
//=======================================================================
Standard_Boolean  TopOpeBRep_VPointInter::IsOnDomS2() const
{
  Standard_Boolean b = myPPOI->IsOnDomS2();
  return b;
}

//=======================================================================
//function : ParametersOnS1
//purpose  : 
//=======================================================================
void  TopOpeBRep_VPointInter::ParametersOnS1(Standard_Real& u, Standard_Real& v) const
{
  myPPOI->ParametersOnS1(u,v);
}

//=======================================================================
//function : ParametersOnS2
//purpose  : 
//=======================================================================
void  TopOpeBRep_VPointInter::ParametersOnS2(Standard_Real& u, Standard_Real& v) const
{
  myPPOI->ParametersOnS2(u,v);
}

//=======================================================================
//function : Value
//purpose  : 
//=======================================================================
const gp_Pnt&  TopOpeBRep_VPointInter::Value() const
{
  return myPPOI->Value();
}

//=======================================================================
//function : Tolerance
//purpose  : 
//=======================================================================
Standard_Real  TopOpeBRep_VPointInter::Tolerance() const
{
  return myPPOI->Tolerance();
}

//=======================================================================
//function : ArcOnS1
//purpose  : 
//=======================================================================
const TopoDS_Shape&  TopOpeBRep_VPointInter::ArcOnS1() const
{
  const Handle(Adaptor2d_HCurve2d)& HAHC2 = myPPOI->ArcOnS1();
  const BRepAdaptor_Curve2d& BRAC2P = *((BRepAdaptor_Curve2d*)&(HAHC2->Curve2d()));
  const TopoDS_Shape& S = BRAC2P.Edge();
  return S;
}

//=======================================================================
//function : ArcOnS2
//purpose  : 
//=======================================================================
const TopoDS_Shape&  TopOpeBRep_VPointInter::ArcOnS2() const
{
  const Handle(Adaptor2d_HCurve2d)& HAHC2 = myPPOI->ArcOnS2();
  const BRepAdaptor_Curve2d& BRAC2P = *((BRepAdaptor_Curve2d*)&(HAHC2->Curve2d()));
  const TopoDS_Shape& S = BRAC2P.Edge();
  return S;
}

//=======================================================================
//function : ParameterOnLine
//purpose  : 
//=======================================================================
Standard_Real  TopOpeBRep_VPointInter::ParameterOnLine() const
{
  return myPPOI->ParameterOnLine();
}

//=======================================================================
//function : ParameterOnArc1
//purpose  : 
//=======================================================================
Standard_Real  TopOpeBRep_VPointInter::ParameterOnArc1() const
{
  return myPPOI->ParameterOnArc1();
}

//=======================================================================
//function : ParameterOnArc2
//purpose  : 
//=======================================================================
Standard_Real  TopOpeBRep_VPointInter::ParameterOnArc2() const
{
  return myPPOI->ParameterOnArc2();
}

//=======================================================================
//function : IsVertexOnS1
//purpose  : 
//=======================================================================
Standard_Boolean TopOpeBRep_VPointInter::IsVertexOnS1() const 
{
  Standard_Boolean b = myPPOI->IsVertexOnS1();;
  return b;
}

//=======================================================================
//function : VertexOnS1
//purpose  : 
//=======================================================================
const TopoDS_Shape& TopOpeBRep_VPointInter::VertexOnS1() const 
{
  Standard_Boolean b = myPPOI->IsVertexOnS1();
  if ( !b ) { Standard_DomainError::Raise(); }

  const Handle(BRepTopAdaptor_HVertex)* HBRTAHV = (Handle(BRepTopAdaptor_HVertex)*)&(myPPOI->VertexOnS1());
  const TopoDS_Shape& S = (*HBRTAHV)->Vertex();
  return S;
}

//=======================================================================
//function : IsVertexOnS2
//purpose  : 
//=======================================================================
Standard_Boolean TopOpeBRep_VPointInter::IsVertexOnS2() const 
{
  Standard_Boolean b = myPPOI->IsVertexOnS2();
  return b;
}

//=======================================================================
//function : VertexOnS2
//purpose  : 
//=======================================================================
const TopoDS_Shape& TopOpeBRep_VPointInter::VertexOnS2() const 
{
  Standard_Boolean b = myPPOI->IsVertexOnS2();
  if ( !b ) { Standard_DomainError::Raise(); }

  const Handle(BRepTopAdaptor_HVertex)* HBRTAHV = (Handle(BRepTopAdaptor_HVertex)*)&(myPPOI->VertexOnS2());
  const TopoDS_Shape& S = (*HBRTAHV)->Vertex();
  return S;
}

//=======================================================================
//function : IsMultiple
//purpose  : 
//=======================================================================
Standard_Boolean TopOpeBRep_VPointInter::IsMultiple() const 
{
  Standard_Boolean b = myPPOI->IsMultiple();
  return b;
}

//=======================================================================
//function : IsInternal
//purpose  : 
//=======================================================================
Standard_Boolean  TopOpeBRep_VPointInter::IsInternal()const
{
  return Standard_False;
}

//=======================================================================
//function : State
//purpose  : 
//=======================================================================
void TopOpeBRep_VPointInter::State(const TopAbs_State S,const Standard_Integer I)
{
  if      (I == 1) myState1 = S;
  else if (I == 2) myState2 = S;
  else Standard_DomainError::Raise("VPointInter");
  UpdateKeep();
}

//=======================================================================
//function : State
//purpose  : 
//=======================================================================
TopAbs_State TopOpeBRep_VPointInter::State(const Standard_Integer I) const
{
  if      (I == 1) return myState1;
  else if (I == 2) return myState2;
  else { Standard_DomainError::Raise("VPointInter"); return TopAbs_UNKNOWN; }
}

//=======================================================================
//function : EdgeON
//purpose  : 
//=======================================================================
void TopOpeBRep_VPointInter::EdgeON(const TopoDS_Shape& Eon,const Standard_Real Par,const Standard_Integer I)
{
  if      (I == 1) {
    myEdgeON1 = Eon;
    myEdgeONPar1 = Par;
  }
  else if (I == 2) {
    myEdgeON2 = Eon;
    myEdgeONPar2 = Par;
  }
}

//=======================================================================
//function : EdgeON
//purpose  : 
//=======================================================================
const TopoDS_Shape& TopOpeBRep_VPointInter::EdgeON(const Standard_Integer I) const
{
  if      (I == 1) return myEdgeON1;
  else if (I == 2) return myEdgeON2;
  else Standard_DomainError::Raise("VPointInter"); 

  return myNullShape;
}

//=======================================================================
//function : EdgeONParameter
//purpose  : 
//=======================================================================
Standard_Real TopOpeBRep_VPointInter::EdgeONParameter(const Standard_Integer I) const
{
  if      (I == 1) return myEdgeONPar1;
  else if (I == 2) return myEdgeONPar2;
  else Standard_DomainError::Raise("VPointInter"); 
  return 0.;
}

//=======================================================================
//function : ShapeIndex
//purpose  : 
//=======================================================================
Standard_Integer TopOpeBRep_VPointInter::ShapeIndex() const
{
  return myShapeIndex;
}

//=======================================================================
//function : ShapeIndex
//purpose  : 
//=======================================================================
void TopOpeBRep_VPointInter::ShapeIndex(const Standard_Integer I)
{
  myShapeIndex = I;
}

//=======================================================================
//function : Edge
//purpose  : 
//=======================================================================
const TopoDS_Shape& TopOpeBRep_VPointInter::Edge(const Standard_Integer I) const
{
  if      (I == 1 && IsOnDomS1() ) return ArcOnS1(); 
  else if (I == 2 && IsOnDomS2() ) return ArcOnS2(); 

  return myNullShape;
}

//=======================================================================
//function : EdgeParameter
//purpose  : 
//=======================================================================
Standard_Real TopOpeBRep_VPointInter::EdgeParameter(const Standard_Integer I) const
{
  if      (I == 1 && IsOnDomS1() ) return ParameterOnArc1();
  else if (I == 2 && IsOnDomS2() ) return ParameterOnArc2();
  return 0.;
}

//=======================================================================
//function : EdgeParameter
//purpose  : 
//=======================================================================
gp_Pnt2d TopOpeBRep_VPointInter::SurfaceParameters(const Standard_Integer I) const
{ 
  Standard_Real u = 0., v = 0.;
  //if      (I == 1 && IsOnDomS1() ) ParametersOnS1(u,v);
  //else if (I == 2 && IsOnDomS1() ) ParametersOnS2(u,v);
  if      (I == 1 ) ParametersOnS1(u,v);
  else if (I == 2 ) ParametersOnS2(u,v);
  gp_Pnt2d p2d(u,v);
  return p2d;
}

//=======================================================================
//function : IsVertex
//purpose  : 
//=======================================================================
Standard_Boolean TopOpeBRep_VPointInter::IsVertex(const Standard_Integer I) const
{
  if      ( I == 0 )                   return Standard_False;
  if      ( I == 1 && IsVertexOnS1() ) return Standard_True;
  else if ( I == 2 && IsVertexOnS2() ) return Standard_True;
  return Standard_False;
}

//=======================================================================
//function : Vertex
//purpose  : 
//=======================================================================
const TopoDS_Shape& TopOpeBRep_VPointInter::Vertex(const Standard_Integer I) const
{
  if      ( I == 1 && IsVertexOnS1() ) return VertexOnS1();
  else if ( I == 2 && IsVertexOnS2() ) return VertexOnS2();
  return myNullShape;
}

//=======================================================================
//function : UpdateKeep
//purpose  :
//=======================================================================
void TopOpeBRep_VPointInter::UpdateKeep() 
{
#define M_SINON(s) (((s) == TopAbs_IN) || ((s) == TopAbs_ON))
  
  TopAbs_State pos1 = State(1);
  TopAbs_State pos2 = State(2);

  Standard_Integer SI = ShapeIndex();

#ifdef DEB
  Standard_Boolean condition; 
#else
  Standard_Boolean condition=Standard_False; 
#endif
  if      (SI == 1) condition = M_SINON(pos2);
  else if (SI == 2) condition = M_SINON(pos1);
  else if (SI == 0) condition = M_SINON(pos1) && M_SINON(pos2);
  else if (SI == 3) condition = M_SINON(pos1) && M_SINON(pos2);
  // NYI : SI == 3 --> le VP devrait toujours etre Keep() (par definition)
  
  myKeep = condition;
}

//=======================================================================
//function : Keep
//purpose  :
//=======================================================================
Standard_Boolean TopOpeBRep_VPointInter::Keep() const
{
  return myKeep;
}

//=======================================================================
//function : ChangeKeep
//purpose  :
//=======================================================================
void TopOpeBRep_VPointInter::ChangeKeep(const Standard_Boolean keep) 
{
  myKeep = keep;
}

//=======================================================================
//function : Index
//purpose  : trace
//=======================================================================
void TopOpeBRep_VPointInter::Index(const Standard_Integer I)
{
  myIndex = I;
}

//=======================================================================
//function : Index
//purpose  : trace
//=======================================================================
Standard_Integer TopOpeBRep_VPointInter::Index() const
{
  return myIndex;
}

//=======================================================================
//function : EqualpP
//purpose  : returns <True> if the 3d points and the parameters of the
//           VPoints are same.
//=======================================================================
Standard_Boolean TopOpeBRep_VPointInter::EqualpP(const TopOpeBRep_VPointInter& VP) const
{
  Standard_Real p1 = ParameterOnLine();
  Standard_Real p2 = VP.ParameterOnLine();      
  Standard_Boolean pequal = fabs(p1-p2) < Precision::PConfusion();
  gp_Pnt P1 = Value(); gp_Pnt P2 = VP.Value();
  Standard_Real Ptol1 = Tolerance(), Ptol2 = VP.Tolerance();
  Standard_Real Ptol = (Ptol1 > Ptol2) ? Ptol1 : Ptol2;
  Standard_Boolean Pequal = P1.IsEqual(P2,Ptol);
  Standard_Boolean pPequal = ( pequal && Pequal );
  return pPequal;  
}

//=======================================================================
//function : 
//purpose  : 
//=======================================================================
Standard_Boolean TopOpeBRep_VPointInter::ParonE(const TopoDS_Edge& E,Standard_Real& par) const
{
  Standard_Boolean found = Standard_False;
  if (IsOnDomS1()) { 
    if(E.IsSame(ArcOnS1())) found = Standard_True;
    if (found) {par = ParameterOnArc1(); return found;}
  }
  if (IsOnDomS2()) { 
    if(E.IsSame(ArcOnS2())) found = Standard_True;
    if (found) {par = ParameterOnArc2(); return found;}
  }

  for (Standard_Integer i = 1; i <= 2; i++) {
    if (State(i) != TopAbs_ON) continue;
    if (EdgeON(i).IsSame(E)) {
      par = EdgeONParameter(i); 
      return Standard_True;
    }
  }
  return found;
}

//=======================================================================
//function : DumpEdge
//purpose  : 
//=======================================================================
Standard_OStream& TopOpeBRep_VPointInter::Dump(const Standard_Integer I,const TopoDS_Face& F,Standard_OStream& OS) const
{
  const TopoDS_Edge& E = TopoDS::Edge(Edge(I)); 
#ifdef DEB
  Standard_Real Epar =
#endif
             EdgeParameter(I); 
#ifdef DEB
  TopAbs_Orientation O =
#endif
           E.Orientation();
#ifdef DEB
  Standard_Boolean closingedge = 
#endif
                    TopOpeBRepTool_ShapeTool::Closed(E,F);

#ifdef DEB
  if (closingedge) OS<<"on closing edge "; else OS<<"on edge "; TopAbs::Print(O,cout);
  cout<<" of "<<I<<" : par : "<<Epar<<endl;
  TopOpeBRepDS_Transition T = TopOpeBRep_FFTransitionTool::ProcessLineTransition(*this,I,O);
  OS<<"line transition ";
  if (closingedge) OS<<"on closing edge "; else OS<<"on edge "; TopAbs::Print(O,cout);
  OS<<" of "<<I<<" : "; T.Dump(OS);OS<<endl;
#endif
  
  return OS;
}

//=======================================================================
//function : Dump
//purpose  : 
//=======================================================================
Standard_OStream& TopOpeBRep_VPointInter::Dump(const TopoDS_Face& FF1,const TopoDS_Face& FF2,Standard_OStream& OS) const
{
#ifdef DEB
  const TopoDS_Face& F1 =
#endif
                  TopoDS::Face(FF1);
#ifdef DEB
  const TopoDS_Face& F2 =
#endif
                  TopoDS::Face(FF2);

#ifdef DEB
  OS<<"VP "<<myIndex<<" on "<<myShapeIndex<<" :";
  Standard_Real Cpar = ParameterOnLine(); OS<<" on curve : "<<Cpar; 
  if (!myKeep) OS<<" NOT kept";
  OS<<endl;
  const gp_Pnt& P = Value(); 
  OS<<PRODINP<<"P"<<myIndex<<" "; OS<<P.X()<<" "<<P.Y()<<" "<<P.Z();
  OS<<"; #draw"<<endl;
   
  if (TopOpeBRepDS_GettraceDSFK()) { Standard_Real u,v;
    ParametersOnS1(u,v); OS<<"u1,v1 : "<<u<<" "<<v; OS<<"   ";
    ParametersOnS2(u,v); OS<<"u2,v2 : "<<u<<" "<<v; OS<<endl;
  }
  
  if (IsVertexOnS1()) { OS<<"is vertex of 1"<<endl; }
  if (IsVertexOnS2()) { OS<<"is vertex of 2"<<endl; }
  if (IsMultiple())   { OS<<"is multiple"<<endl; }
  if (IsInternal())   { OS<<"is internal"<<endl; }

  if      (myShapeIndex == 1) { 
    Dump(1,F1,OS); 
  }
  else if (myShapeIndex == 2) { 
    Dump(2,F2,OS); 
  }
  else if (myShapeIndex == 3) { 
    Dump(1,F1,OS);
    Dump(2,F2,OS); 
  }

#endif

  return OS;
}

//=======================================================================
//function : PThePointOfIntersectionDummy
//purpose  : 
//=======================================================================
TopOpeBRep_PThePointOfIntersection TopOpeBRep_VPointInter::PThePointOfIntersectionDummy() const
{
  return myPPOI;
}
