// File:	StepToGeom_MakeLine.cxx
// Created:	Fri Jul  2 17:51:47 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>
// sln 22.10.2001. CTS23496: Line is not created if direction have not been succesfully created (StepToGeom_MakeLine(...) function)

#include <StepToGeom_MakeLine.ixx>
#include <StepGeom_Line.hxx>
#include <StepGeom_Vector.hxx>
#include <StepGeom_CartesianPoint.hxx>
#include <StepToGeom_MakeVectorWithMagnitude.hxx>
#include <StepToGeom_MakeCartesianPoint.hxx>
#include <Geom_CartesianPoint.hxx>
#include <Geom_Line.hxx>
#include <Geom_VectorWithMagnitude.hxx>
#include <gp_Pnt.hxx>
#include <gp_Vec.hxx>
#include <gp_Dir.hxx>
#include <StdFail_NotDone.hxx>

//=============================================================================
// Creation d' une Line de Geom a partir d' une Line de Step
//=============================================================================

StepToGeom_MakeLine::StepToGeom_MakeLine
  ( const Handle(StepGeom_Line)& L)
{
  Handle(StepGeom_CartesianPoint) P;
  Handle(Geom_CartesianPoint)         P1;
  gp_Pnt                              P2; 
  Handle(StepGeom_Vector)         V;
  Handle(Geom_VectorWithMagnitude)    V1;
  gp_Vec                              V2;

  P  = L->Pnt();
  StepToGeom_MakeCartesianPoint MkPoint(P);
  P1 = MkPoint.Value();
  P2 = P1->Pnt();
  V  = L->Dir();
  StepToGeom_MakeVectorWithMagnitude MkVector(V);
  // sln 22.10.2001. CTS23496: Line is not created if direction have not been succesfully created 
  if(!MkVector.IsDone()) {
    done = Standard_False;
    return;
  }
  V1 = MkVector.Value();
  V2 = V1->Vec();
  theLine = new Geom_Line(P2, gp_Dir(V2));
  done = Standard_True;
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_Line) &
      StepToGeom_MakeLine::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theLine;
}
