// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TPrsStd_DriverTable_HeaderFile
#define _TPrsStd_DriverTable_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_TPrsStd_DriverTable_HeaderFile
#include <Handle_TPrsStd_DriverTable.hxx>
#endif

#ifndef _TPrsStd_DataMapOfGUIDDriver_HeaderFile
#include <TPrsStd_DataMapOfGUIDDriver.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_TPrsStd_Driver_HeaderFile
#include <Handle_TPrsStd_Driver.hxx>
#endif
class Standard_GUID;
class TPrsStd_Driver;


//!   This class is   a  container to record  (AddDriver) <br>
//!          binding between  GUID and  TPrsStd_Driver. <br>
//! You create a new instance of TPrsStd_Driver <br>
//! and use the method AddDriver to load it into the driver table. the method <br>
class TPrsStd_DriverTable : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Returns the static table. <br>
//!          If it does not exist, creates it and fills it with standard drivers. <br>
Standard_EXPORT static  Handle_TPrsStd_DriverTable Get() ;

//! Default constructor <br>
Standard_EXPORT TPrsStd_DriverTable();

//! Fills the table with standard drivers <br>
Standard_EXPORT   void InitStandardDrivers() ;

//! Returns true if the driver has been added successfully to the driver table. <br>
Standard_EXPORT   Standard_Boolean AddDriver(const Standard_GUID& guid,const Handle(TPrsStd_Driver)& driver) ;

//! Returns true if the driver was found. <br>
Standard_EXPORT   Standard_Boolean FindDriver(const Standard_GUID& guid,Handle(TPrsStd_Driver)& driver) const;


//! Removes a driver with the given GUID. <br>
//!      Returns true if the driver has been removed successfully. <br>
Standard_EXPORT   Standard_Boolean RemoveDriver(const Standard_GUID& guid) ;

//! Removes all drivers. Returns <br>
//! true if the driver has been removed successfully. <br>
//! If this method is used, the InitStandardDrivers method should be <br>
//! called to fill the table with standard drivers. <br>
Standard_EXPORT   void Clear() ;
//Standard_EXPORT ~TPrsStd_DriverTable();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TPrsStd_DataMapOfGUIDDriver myDrivers;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
