// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TDF_ChildIterator_HeaderFile
#define _TDF_ChildIterator_HeaderFile

#ifndef _TDF_LabelNodePtr_HeaderFile
#include <TDF_LabelNodePtr.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TDF_Label_HeaderFile
#include <TDF_Label.hxx>
#endif
class TDF_Label;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Iterates on the children of a label, at the first <br>
//!          level only. It is possible to ask the iterator to <br>
//!          explore all the sub label levels of the given one, <br>
//!          with the option "allLevels". <br>
class TDF_ChildIterator  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an empty iterator  object to <br>
//!  explore the children of a label. <br>
Standard_EXPORT TDF_ChildIterator();

//! Constructs the iterator object defined by <br>
//!  the label aLabel.  Iterates on the children of the given label. If <br>
//!          <allLevels> option is set to true, it explores not <br>
//!          only the first, but all the sub label levels. <br>
Standard_EXPORT TDF_ChildIterator(const TDF_Label& aLabel,const Standard_Boolean allLevels = Standard_False);

//! Initializes the iteration on the children of the <br>
//!          given label. <br>
//! If <allLevels> option is set to true, <br>
//!          it explores not only the first, but all the sub <br>
//!          label levels. <br>
//!  If allLevels is false, only the first level of <br>
//!  child labels is explored. <br>
//!  In the example below, the label is iterated <br>
//!  using Initialize, More and Next and its <br>
//!  child labels dumped using TDF_Tool::Entry. <br>
//!  Example <br>
//!  void DumpChildren(const <br>
//!  TDF_Label& aLabel) <br>
//!  { <br>
//!  TDF_ChildIterator it; <br>
//!  TCollection_AsciiString es; <br>
//!  for <br>
//!  (it.Initialize(aLabel,Standard_True); <br>
//!  it.More(); it.Next()){ <br>
//!  TDF_Tool::Entry(it.Value(),es); <br>
//!  cout << as.ToCString() << endl; <br>
//!  } <br>
//!  } <br>
Standard_EXPORT   void Initialize(const TDF_Label& aLabel,const Standard_Boolean allLevels = Standard_False) ;
//! Returns true if a current label is found in the <br>
//!  iteration process. <br>
//! <br>
  Standard_Boolean More() const;

//! Move the  current  iteration  to the next Item. <br>
Standard_EXPORT   void Next() ;

//! Moves this iteration to the next brother <br>
//!  label. A brother label is one with the same <br>
//!  father as an initial label. <br>
//!  Use this function when the non-empty <br>
//!  constructor or Initialize has allLevels set to <br>
//!  true. The result is that the iteration does not <br>
//!  explore the children of the current label. <br>
//!          This method is interesting only with <br>
//!          "allLevels" behavior, because it avoids to explore <br>
//!          the current label children. <br>
Standard_EXPORT   void NextBrother() ;
//! Returns the current label; or, if there is <br>
//!          none, a null label. <br>
//! <br>
 const TDF_Label Value() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TDF_LabelNodePtr myNode;
Standard_Integer myFirstLevel;


};


#include <TDF_ChildIterator.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
