// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeFix_FreeBounds_HeaderFile
#define _ShapeFix_FreeBounds_HeaderFile

#ifndef _TopoDS_Compound_HeaderFile
#include <TopoDS_Compound.hxx>
#endif
#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class TopoDS_Shape;
class TopoDS_Compound;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class is intended to output free bounds of the shape <br>
//!          (free bounds are the wires consisting of edges referenced by the <br>
//!          only face). <br>
//!          For building free bounds it uses ShapeAnalysis_FreeBounds class. <br>
//!          This class complements it with the feature to reduce the number <br>
//!          of open wires. <br>
//!          This reduction is performed with help of connecting several <br>
//!          adjacent open wires one to another what can lead to: <br>
//!          1. making an open wire with greater length out of several <br>
//!             open wires <br>
//!          2. making closed wire out of several open wires <br>
class ShapeFix_FreeBounds  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Empty constructor <br>
Standard_EXPORT ShapeFix_FreeBounds();

//! Builds forecasting free bounds of the <shape> and connects <br>
//!          open wires with tolerance <closetoler>. <br>
//!          <shape> should be a compound of faces. <br>
//!          Tolerance <closetoler> should be greater than tolerance <br>
//!          <sewtoler> used for initializing sewing analyzer, otherwise <br>
//!          connection of open wires is not performed. <br>
Standard_EXPORT ShapeFix_FreeBounds(const TopoDS_Shape& shape,const Standard_Real sewtoler,const Standard_Real closetoler,const Standard_Boolean splitclosed,const Standard_Boolean splitopen);

//! Builds actual free bounds of the <shape> and connects <br>
//!          open wires with tolerance <closetoler>. <br>
//!          <shape> should be a compound of shells. <br>
Standard_EXPORT ShapeFix_FreeBounds(const TopoDS_Shape& shape,const Standard_Real closetoler,const Standard_Boolean splitclosed,const Standard_Boolean splitopen);
//! Returns compound of closed wires out of free edges. <br>
 const TopoDS_Compound& GetClosedWires() const;
//! Returns compound of open wires out of free edges. <br>
 const TopoDS_Compound& GetOpenWires() const;
//! Returns modified source shape. <br>
 const TopoDS_Shape& GetShape() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Standard_Boolean Perform() ;


 // Fields PRIVATE
 //
TopoDS_Compound myWires;
TopoDS_Compound myEdges;
TopoDS_Shape myShape;
Standard_Boolean myShared;
Standard_Real mySewToler;
Standard_Real myCloseToler;
Standard_Boolean mySplitClosed;
Standard_Boolean mySplitOpen;


};


#include <ShapeFix_FreeBounds.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
